/*
 * Decompiled with CFR 0.152.
 */
import common.Config;
import common.Log;
import common.Spacecraft;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import telemServer.ServerConfig;
import telemStream.StreamProcess;

@Deprecated
public class FoxStream {
    public static String version = "Version 0.08 - 16 Feb 2020";
    public static int port = 41043;
    static int sequence = 0;
    static int poolSize = 16;
    static final String usage = "FoxStream user database [-v]\n-v - Version Information\n";

    public static void main(String[] args) throws IOException {
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("--help")) {
                System.out.println(usage);
                System.exit(0);
            } else if (args[0].equalsIgnoreCase("-v") || args[0].equalsIgnoreCase("-version")) {
                System.out.println("AMSAT Fox Stream. Version " + version);
                System.exit(0);
            } else {
                System.out.println(usage);
                System.exit(1);
            }
        } else if (args.length != 2) {
            System.out.println(usage);
            System.exit(1);
        }
        String u = args[0];
        String db = args[1];
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String p = in.readLine();
        if (p == null || p.isEmpty()) {
            System.out.println("Missing password");
            System.exit(2);
        }
        Config.logging = true;
        Log.init("FoxStream");
        Log.showGuiDialogs = false;
        Log.setStdoutEcho(false);
        Log.println("Starting FoxStream: " + version);
        Log.println("Listening on port: " + port);
        Config.currentDir = System.getProperty("user.dir");
        Config.spacecraftDir = String.valueOf(System.getProperty("user.dir")) + File.separator + Spacecraft.SPACECRAFT_DIR;
        Config.serverInit();
        ServerConfig.init();
        ServerSocket serverSocket = null;
        boolean listening = true;
        ExecutorService pool = null;
        try {
            serverSocket = new ServerSocket(port);
            pool = Executors.newFixedThreadPool(poolSize);
        }
        catch (IOException e) {
            Log.println("Could not listen on port: " + port);
            Log.alert("FATAL: Could not listen on port: " + port);
        }
        int retries = 0;
        int RETRY_LIMIT = 10;
        while (listening) {
            try {
                Log.println("Waiting for connection ...");
                pool.execute(new StreamProcess(u, p, db, serverSocket.accept()));
                retries = 0;
            }
            catch (SocketTimeoutException s) {
                Log.println("Socket timed out! - trying to continue\t");
                ++retries;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
                Log.println("Socket Error: waiting to see if we recover: " + e.getMessage());
                ++retries;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (retries != RETRY_LIMIT) continue;
            Log.println("Max Socket Retries hit: Terminating Server");
            listening = false;
        }
        try {
            serverSocket.close();
            pool.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
    }
}

