/*
 * Decompiled with CFR 0.152.
 */
package FuncubeDecoder;

import FuncubeDecoder.FECDecoder;
import common.Log;
import decoder.BitStream;
import decoder.Decoder;

public class FUNcubeBitStream
extends BitStream {
    private static final long serialVersionUID = 1L;
    private static final int FEC_BITS_SIZE = 5200;
    private static final int FEC_BLOCK_SIZE = 256;
    private static final int SYNC_VECTOR_SIZE = 65;
    private static final byte[] SYNC_VECTOR = new byte[]{1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, 1, 1, 1, -1, 1, 1, 1, 1, -1, -1, 1, -1, 1, 1, -1, -1, 1, -1, -1, 1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, 1, -1, -1, 1, 1, -1, -1, -1, 1, -1, 1, 1, 1, -1, 1, -1, 1, 1, -1, 1, 1, -1, -1, -1};

    public FUNcubeBitStream(int initialSize, Decoder decoder) {
        super(initialSize, decoder, 5200);
        this.SYNC_WORD_DISTANCE = 5200;
        this.PURGE_THRESHOLD = 26000;
    }

    public boolean checkSyncVector() {
        boolean found = false;
        if (this.size() < 5200) {
            return false;
        }
        int start = this.size() - 5200;
        int corr = 0;
        int i = start;
        while (i < 65) {
            byte b = (byte)(this.get(i * 80) != false ? 1 : -1);
            corr += b * SYNC_VECTOR[i];
            ++i;
        }
        System.out.println("CORR: " + corr);
        if (corr > 45) {
            Log.println("FOUND THE SYNC VECTOR!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            byte[] rawFrame = new byte[5200];
            byte[] rawBits = new byte[5200];
            byte[] decoded = new byte[256];
            int n = 0;
            while (n < 5200) {
                rawFrame[n] = (byte)(rawBits[n] == 1 ? 192 : 64);
                ++n;
            }
            FECDecoder fecDecoder = new FECDecoder();
            int err = fecDecoder.FECDecode(rawFrame, decoded);
            Log.println("FEC SAID: " + err);
        }
        return found;
    }
}

