/*
 * Decompiled with CFR 0.152.
 */
package FuncubeDecoder;

import FuncubeDecoder.FECDecoder;
import FuncubeDecoder.FUNcubeBitStream;
import FuncubeDecoder.FUNcubeFrame;
import common.Config;
import common.Log;
import decoder.Decoder;
import decoder.SourceAudio;
import filter.AGCFilter;

public class FUNcubeDecoder
extends Decoder {
    public static final int BITS_PER_SECOND_1200 = 1200;
    private int[] lastDataValue;
    private int clockOffset = 0;
    private double[] cosTab;
    private double[] sinTab;
    protected FUNcubeBitStream bitStream = null;
    private double vcoPhase = 0.0;
    private static final double RX_CARRIER_FREQ = 1200.0;
    private static final int SINCOS_SIZE = 256;
    private static final int DOWN_SAMPLE_FILTER_SIZE = 27;
    private static final double[] dsFilter = new double[]{-6.103515625E-4, -1.220703125E-4, 0.00238037109375, 0.00616455078125, 0.00732421875, 7.62939453125E-4, -0.0146484375, -0.0311279296875, -0.032257080078125, -0.001617431640625, 0.06463623046875, 0.150238037109375, 0.22314453125, 0.2518310546875, 0.22314453125, 0.150238037109375, 0.06463623046875, -0.001617431640625, -0.032257080078125, -0.0311279296875, -0.0146484375, 7.62939453125E-4, 0.00732421875, 0.00616455078125, 0.00238037109375, -1.220703125E-4, -6.103515625E-4};
    private static final int MATCHED_FILTER_SIZE = 65;
    private static final double[] dmFilter = new double[]{-0.010113068856298923, -0.008697514422237873, -0.0038246093317866325, 0.0033563764300197363, 0.010723702609539032, 0.01577909290790558, 0.01645941101014614, 0.011921390891075134, 0.003031522501260042, -0.007648819126188755, -0.01645941101014614, -0.01971842721104622, -0.015010922215878963, -0.002308246f, 0.01547123771160841, 0.03274235874414444, 0.04244931f, 0.03799404576420784, 0.01547123771160841, -0.0243702f, -0.07503201067447662, -0.12448340654373169, -0.15685003995895386, -0.15537488460540771, -0.10610329359769821, -0.0015013786032795906, 0.15685003995895386, 0.3572048246860504, 0.5786381363868713, 0.794022798538208, 0.9744923114776611, 1.094525f, 1.136611819267273, 1.094525f, 0.9744923114776611, 0.794022798538208, 0.5786381363868713, 0.3572048246860504, 0.15685003995895386, -0.0015013786032795906, -0.10610329359769821, -0.15537488460540771, -0.15685003995895386, -0.12448340654373169, -0.07503201067447662, -0.0243702f, 0.01547123771160841, 0.03799404576420784, 0.04244931f, 0.03274235874414444, 0.01547123771160841, -0.002308246f, -0.015010922215878963, -0.01971842721104622, -0.01645941101014614, -0.007648819126188755, 0.003031522501260042, 0.011921390891075134, 0.01645941101014614, 0.01577909290790558, 0.010723702609539032, 0.0033563764300197363, -0.0038246093317866325, -0.008697514422237873, -0.010113068856298923, -0.010113068856298923, -0.008697514422237873, -0.0038246093317866325, 0.0033563764300197363, 0.010723702609539032, 0.01577909290790558, 0.01645941101014614, 0.011921390891075134, 0.003031522501260042, -0.007648819126188755, -0.01645941101014614, -0.01971842721104622, -0.015010922215878963, -0.002308246f, 0.01547123771160841, 0.03274235874414444, 0.04244931f, 0.03799404576420784, 0.01547123771160841, -0.0243702f, -0.07503201067447662, -0.12448340654373169, -0.15685003995895386, -0.15537488460540771, -0.10610329359769821, -0.0015013786032795906, 0.15685003995895386, 0.3572048246860504, 0.5786381363868713, 0.794022798538208, 0.9744923114776611, 1.094525f, 1.136611819267273, 1.094525f, 0.9744923114776611, 0.794022798538208, 0.5786381363868713, 0.3572048246860504, 0.15685003995895386, -0.0015013786032795906, -0.10610329359769821, -0.15537488460540771, -0.15685003995895386, -0.12448340654373169, -0.07503201067447662, -0.0243702f, 0.01547123771160841, 0.03799404576420784, 0.04244931f, 0.03274235874414444, 0.01547123771160841, -0.002308246f, -0.015010922215878963, -0.01971842721104622, -0.01645941101014614, -0.007648819126188755, 0.003031522501260042, 0.011921390891075134, 0.01645941101014614, 0.01577909290790558, 0.010723702609539032, 0.0033563764300197363, -0.0038246093317866325, -0.008697514422237873, -0.010113068856298923};
    private static final int SYNC_VECTOR_SIZE = 65;
    private static final byte[] SYNC_VECTOR = new byte[]{1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, 1, 1, 1, -1, 1, 1, 1, 1, -1, -1, 1, -1, 1, 1, -1, -1, 1, -1, -1, 1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, 1, -1, -1, 1, 1, -1, -1, -1, 1, -1, 1, 1, 1, -1, 1, -1, 1, 1, -1, 1, 1, -1, -1, -1};
    private static final int FEC_BITS_SIZE = 5200;
    private static final int FEC_BLOCK_SIZE = 256;
    private static final int DOWN_SAMPLE_RATE = 9600;
    private static final int BIT_RATE = 1200;
    private static final int SAMPLES_PER_BIT = 8;
    private static final double VCO_PHASE_INC = 0.7853981633974483;
    private static final double BIT_SMOOTH1 = 0.005;
    private static final double BIT_SMOOTH2 = 0.00125;
    private static final double BIT_PHASE_INC = 1.0416666666666667E-4;
    private static final double BIT_TIME = 8.333333333333334E-4;
    private boolean decodeOK = false;
    private byte[] decoded = new byte[256];
    private FECDecoder decoder = new FECDecoder();
    private int dmErrBits;
    private double energy1;
    private double energy2;
    private double[][] dsBuf = new double[27][2];
    private int dsPos = 26;
    private int dsCnt = 0;
    private double HOWARD_FUDGE_FACTOR = 29491.2;
    private double[][] dmBuf = new double[65][2];
    private int dmPos = 64;
    private double[] dmEnergy = new double[10];
    private int dmBitPos = 0;
    private int dmPeakPos = 0;
    private int dmNewPeak = 0;
    private int dmCorr = 0;
    private int dmMaxCorr = 0;
    private double dmEnergyOut = 1.0;
    private int[] dmHalfTable;
    private double dmBitPhase;
    private double[] dmLastIQ;
    private byte[] dmFECCorr;
    private byte[] dmFECBits;

    public FUNcubeDecoder(SourceAudio as, int chan) {
        super("1200bps BPSK", as, chan, null);
        int[] nArray = new int[8];
        nArray[0] = 4;
        nArray[1] = 5;
        nArray[2] = 6;
        nArray[3] = 7;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 3;
        this.dmHalfTable = nArray;
        this.dmBitPhase = 0.0;
        this.dmLastIQ = new double[2];
        this.dmFECCorr = new byte[5200];
        this.dmFECBits = new byte[5200];
        this.init();
    }

    @Override
    protected void init() {
        Log.println("Initializing 1200bps BPSK decoder: ");
        this.bitStream = new FUNcubeBitStream(500000, this);
        this.BITS_PER_SECOND = 1200;
        this.SAMPLE_WINDOW_LENGTH = 10;
        this.bucketSize = this.currentSampleRate / this.BITS_PER_SECOND;
        this.BUFFER_SIZE = this.bytesPerSample * this.SAMPLE_WINDOW_LENGTH * this.bucketSize;
        this.SAMPLE_WIDTH = this.bucketSize * this.SAMPLE_WIDTH_PERCENT / 100;
        if (this.SAMPLE_WIDTH < 1) {
            this.SAMPLE_WIDTH = 1;
        }
        this.CLOCK_TOLERANCE = this.bucketSize / 2;
        this.CLOCK_REOVERY_ZERO_THRESHOLD = 20;
        this.initWindowData();
        this.lastDataValue = new int[this.bucketSize];
        this.filter = new AGCFilter(this.audioSource.audioFormat, this.BUFFER_SIZE);
        this.filter.init(this.currentSampleRate, 0.0, 0);
        this.cosTab = new double[256];
        this.sinTab = new double[256];
        int n = 0;
        while (n < 256) {
            this.cosTab[n] = Math.cos((double)n * 2.0 * Math.PI / 256.0);
            this.sinTab[n] = Math.sin((double)n * 2.0 * Math.PI / 256.0);
            ++n;
        }
    }

    @Override
    protected void resetWindowData() {
        super.resetWindowData();
    }

    protected void sampleBucketsVCO() {
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            ++this.sampleNumber;
            double sampleSum = 0.0;
            int samples = 0;
            int s = 0;
            while (s < this.bucketSize) {
                double product;
                this.vcoPhase += 0.7853981633974483;
                if (this.vcoPhase > Math.PI * 2) {
                    this.vcoPhase -= Math.PI * 2;
                }
                sampleSum = product = (double)this.dataValues[i][s] * this.sinTab[(int)(this.vcoPhase * 256.0 / (Math.PI * 2)) % 256];
                this.eyeData.setData(i, s, (int)product);
                ++samples;
                ++s;
            }
            if (sampleSum > 0.0) {
                this.middleSample[i] = true;
                this.eyeData.setHigh((int)sampleSum / samples);
            } else {
                this.middleSample[i] = false;
                this.eyeData.setLow((int)sampleSum / samples);
            }
            this.bitStream.addBit(this.middleSample[i]);
            System.out.println("Bit: " + i + " " + this.middleSample[i]);
            this.bitStream.checkSyncVector();
            ++i;
        }
        this.clockOffset = 0;
    }

    @Override
    protected void sampleBuckets() {
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            int s = 0;
            while (s < this.bucketSize) {
                this.RxDownSample((double)this.dataValues[i][s] / 32768.0, (double)this.dataValues[i][s] / 32768.0);
                ++s;
            }
            ++i;
        }
    }

    protected void sampleBuckets1BitDelay() {
        long avgClockOffset = 0L;
        double maxBitEnergy = 0.0;
        int maxBitEnergyIdx = 0;
        int sumMaxBitEnergyIdx = 0;
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            ++this.sampleNumber;
            long sampleSum = 0L;
            int samples = 0;
            maxBitEnergyIdx = 0;
            int clockSample1 = 0;
            int clockSample2 = 0;
            int clockSample3 = 0;
            int s = 0;
            while (s < this.bucketSize) {
                double energy = this.dataValues[i][s] * this.dataValues[i][s];
                if (energy > maxBitEnergy) {
                    maxBitEnergy = energy;
                    maxBitEnergyIdx = s;
                }
                if (i == 0) {
                    sampleSum += (long)(this.dataValues[i][s] * this.lastDataValue[s]);
                    this.eyeData.setData(i, s, this.dataValues[i][s] * this.lastDataValue[s]);
                } else {
                    sampleSum += (long)(this.dataValues[i][s] * this.dataValues[i - 1][s]);
                    this.eyeData.setData(i, s, this.dataValues[i][s] * this.dataValues[i - 1][s]);
                    if (i == this.SAMPLE_WINDOW_LENGTH - 1) {
                        this.lastDataValue[s] = this.dataValues[i][s];
                    }
                }
                ++samples;
                ++s;
            }
            sumMaxBitEnergyIdx += maxBitEnergyIdx;
            if (i == 0) {
                clockSample1 = this.dataValues[i][this.bucketSize / 2] * this.lastDataValue[this.bucketSize / 2];
                clockSample3 = this.dataValues[i + 1][this.bucketSize / 2] * this.dataValues[i][this.bucketSize / 2];
                clockSample2 = this.dataValues[i][this.bucketSize - 1] * this.lastDataValue[this.bucketSize - 1];
            } else if (i < this.SAMPLE_WINDOW_LENGTH - 1) {
                clockSample1 = this.dataValues[i][this.bucketSize / 2] * this.dataValues[i - 1][this.bucketSize / 2];
                clockSample3 = this.dataValues[i + 1][this.bucketSize / 2] * this.dataValues[i][this.bucketSize / 2];
                clockSample2 = this.dataValues[i][this.bucketSize - 1] * this.dataValues[i - 1][this.bucketSize - 1];
            }
            int clockError = (clockSample3 - clockSample1) * clockSample2;
            avgClockOffset += (long)clockError;
            if (sampleSum >= 0L) {
                this.middleSample[i] = true;
                this.eyeData.setHigh((int)sampleSum / samples);
            } else {
                this.middleSample[i] = false;
                this.eyeData.setLow((int)sampleSum / samples);
            }
            this.bitStream.addBit(this.middleSample[i]);
            this.bitStream.checkSyncVector();
            ++i;
        }
        int avgMaxBitEnergyIdx = sumMaxBitEnergyIdx / this.SAMPLE_WINDOW_LENGTH;
        avgClockOffset /= (long)(this.SAMPLE_WINDOW_LENGTH - 1);
        this.clockOffset = avgMaxBitEnergyIdx > this.bucketSize / 4 ? 1 : 0;
    }

    @Override
    protected int recoverClockOffset() {
        return this.clockOffset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected double[] recoverClock(int factor) {
        if (this.clockOffset > 0) {
            int nBytesRead;
            double[] clockData = new double[this.clockOffset];
            if (Config.debugClock) {
                Log.println("Advancing clock " + this.clockOffset + " samples");
            }
            if ((nBytesRead = this.read(clockData)) == this.clockOffset * this.bytesPerSample) return clockData;
            if (!Config.debugClock) return null;
            Log.println("ERROR: Could not advance clock");
            return null;
        } else {
            if (!Config.debugClock) return null;
            Log.println("PSK CLOCK STABLE");
            return null;
        }
    }

    @Override
    protected void processBitsWindow() {
    }

    private void RxDownSample(double i, double q) {
        this.dsBuf[this.dsPos][0] = i;
        this.dsBuf[this.dsPos][1] = q;
        if (++this.dsCnt >= this.currentSampleRate / 9600) {
            double fi = 0.0;
            double fq = 0.0;
            int n = 0;
            while (n < 27) {
                int dsi = (n + this.dsPos) % 27;
                fi += this.dsBuf[dsi][0] * dsFilter[n];
                fq += this.dsBuf[dsi][1] * dsFilter[n];
                ++n;
            }
            this.dsCnt = 0;
            this.RxDemodulate(fi * this.HOWARD_FUDGE_FACTOR, fq * this.HOWARD_FUDGE_FACTOR);
        }
        --this.dsPos;
        if (this.dsPos < 0) {
            this.dsPos = 26;
        }
    }

    private void RxDemodulate(double i, double q) {
        this.vcoPhase += 0.7853981633974483;
        if (this.vcoPhase > Math.PI * 2) {
            this.vcoPhase -= Math.PI * 2;
        }
        this.dmBuf[this.dmPos][0] = i * this.cosTab[(int)(this.vcoPhase * 256.0 / (Math.PI * 2)) % 256];
        this.dmBuf[this.dmPos][1] = q * this.sinTab[(int)(this.vcoPhase * 256.0 / (Math.PI * 2)) % 256];
        double fi = 0.0;
        double fq = 0.0;
        int n = 0;
        while (n < 65) {
            int dmi = 65 - this.dmPos + n;
            fi += this.dmBuf[n][0] * dmFilter[dmi];
            fq += this.dmBuf[n][1] * dmFilter[dmi];
            ++n;
        }
        --this.dmPos;
        if (this.dmPos < 0) {
            this.dmPos = 64;
        }
        this.energy1 = fi * fi + fq * fq;
        this.dmEnergy[this.dmBitPos] = this.dmEnergy[this.dmBitPos] * 0.995 + this.energy1 * 0.005;
        if (this.dmBitPos == this.dmPeakPos) {
            this.dmEnergyOut = this.dmEnergyOut * 0.99875 + this.energy1 * 0.00125;
            double di = -(this.dmLastIQ[0] * fi + this.dmLastIQ[1] * fq);
            double dq = this.dmLastIQ[0] * fq - this.dmLastIQ[1] * fi;
            this.dmLastIQ[0] = fi;
            this.dmLastIQ[1] = fq;
            this.energy2 = Math.sqrt(di * di + dq * dq);
            if (this.energy2 > 100.0) {
                boolean bit = di < 0.0;
                System.arraycopy(this.dmFECCorr, 1, this.dmFECCorr, 0, this.dmFECCorr.length - 1);
                this.dmFECCorr[this.dmFECCorr.length - 1] = (byte)(bit ? 1 : -1);
                this.dmCorr = 0;
                int n2 = 0;
                while (n2 < 65) {
                    this.dmCorr += this.dmFECCorr[n2 * 80] * SYNC_VECTOR[n2];
                    ++n2;
                }
                if (this.dmCorr >= 45) {
                    Log.println("FOUND SYNC VECTOR!!!!!!!!!!!!!!!!");
                    n2 = 0;
                    while (n2 < 5200) {
                        this.dmFECBits[n2] = (byte)(this.dmFECCorr[n2] == 1 ? 192 : 64);
                        ++n2;
                    }
                    this.dmErrBits = this.decoder.FECDecode(this.dmFECBits, this.decoded);
                    this.dmMaxCorr = 0;
                    this.decodeOK = this.dmErrBits >= 0;
                    Log.println("FEC DECODE: " + this.decodeOK);
                    if (this.decodeOK) {
                        FUNcubeFrame fcf = new FUNcubeFrame();
                        fcf.addRawFrame(this.decoded);
                        Log.println(fcf.toString());
                        if (Config.storePayloads) {
                            Config.payloadStore.add(fcf.header.id, 0L, 0, fcf.rtPayload);
                        }
                    }
                }
                if (this.dmCorr > this.dmMaxCorr) {
                    this.dmMaxCorr = this.dmCorr;
                }
            }
        }
        if (this.dmBitPos == this.dmHalfTable[this.dmPeakPos]) {
            this.dmPeakPos = this.dmNewPeak;
        }
        this.dmBitPos = (this.dmBitPos + 1) % 8;
        this.dmBitPhase += 1.0416666666666667E-4;
        if (this.dmBitPhase >= 8.333333333333334E-4) {
            this.dmBitPhase -= 8.333333333333334E-4;
            this.dmBitPos = 0;
            double eMax = -1.0E10;
            int n3 = 0;
            while (n3 < 8) {
                if (this.dmEnergy[n3] > eMax) {
                    this.dmNewPeak = n3;
                    eMax = this.dmEnergy[n3];
                }
                ++n3;
            }
        }
    }
}

