/*
 * Decompiled with CFR 0.152.
 */
package com.pretty_tools.dde.client;

import com.pretty_tools.dde.ClipboardFormat;
import com.pretty_tools.dde.DDEException;
import com.pretty_tools.dde.client.DDEClientEventListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DDEClientConversation {
    private static final Logger logger = Logger.getLogger(DDEClientConversation.class.getName());
    private static final int DEFAULT_TIMEOUT = 2000;
    private volatile DDEClientEventListener eventListener;
    private ExecutorService executorService;
    private String service;
    private String topic;
    private int timeout = 2000;
    private int textFormat = ClipboardFormat.CF_TEXT.getNativeCode();
    private volatile long nativeDDEClientConversation;

    public synchronized void connect(String service, String topic) throws DDEException {
        if (this.nativeDDEClientConversation != 0L) {
            throw new DDEException("Already connected.");
        }
        this.executorService = Executors.newSingleThreadExecutor();
        this.nativeConnect(service, topic);
        this.service = service;
        this.topic = topic;
    }

    public synchronized void disconnect() throws DDEException {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        if (this.nativeDDEClientConversation != 0L) {
            this.nativeDisconnect();
        }
        this.service = null;
        this.topic = null;
    }

    public synchronized void execute(String command) throws DDEException {
        this.checkConversation();
        this.nativeExecute(command);
    }

    public synchronized void execute(byte[] command) throws DDEException {
        this.checkConversation();
        this.nativeExecute(command);
    }

    public synchronized void poke(String item, String data) throws DDEException {
        this.checkConversation();
        this.nativePoke(item, data);
    }

    public void poke(String item, byte[] data, ClipboardFormat clipboardFormat) throws DDEException {
        this.poke(item, data, clipboardFormat.getNativeCode());
    }

    public synchronized void poke(String item, byte[] data, int wFmt) throws DDEException {
        this.checkConversation();
        this.nativePoke(item, data, wFmt);
    }

    public synchronized String request(String item) throws DDEException {
        this.checkConversation();
        return this.nativeRequest(item);
    }

    public synchronized void startAdvice(String item) throws DDEException {
        this.checkConversation();
        this.nativeStartAdvice(item);
    }

    public synchronized void stopAdvice(String item) throws DDEException {
        this.checkConversation();
        this.nativeStopAdvice(item);
    }

    public String getService() {
        return this.service;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Timeout should be bigger than zero");
        }
        if (this.nativeDDEClientConversation != 0L) {
            throw new IllegalStateException("You cannot change timeout after connect was established");
        }
        this.timeout = timeout;
    }

    public ClipboardFormat getTextFormat() {
        return ClipboardFormat.valueOf(this.textFormat);
    }

    public void setTextFormat(ClipboardFormat textFormat) {
        if (textFormat != ClipboardFormat.CF_TEXT && textFormat != ClipboardFormat.CF_UNICODETEXT) {
            throw new IllegalArgumentException("Format should be CF_TEXT or CF_UNICODETEXT");
        }
        if (this.nativeDDEClientConversation != 0L) {
            throw new IllegalStateException("You cannot change timeout after connect was established");
        }
        this.textFormat = textFormat.getNativeCode();
    }

    public DDEClientEventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(DDEClientEventListener eventListener) {
        this.eventListener = eventListener;
    }

    private void checkConversation() throws DDEException {
        if (this.nativeDDEClientConversation == 0L) {
            throw new DDEException("Not connected to server.");
        }
    }

    private void fireEventOnDisconnect() {
        try {
            final long nativeDDEClientWhenDisconnectHappens = this.nativeDDEClientConversation;
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DDEClientEventListener listener = DDEClientConversation.this.getEventListener();
                        if (listener != null) {
                            listener.onDisconnect();
                        }
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, t.toString(), t);
                    }
                    try {
                        DDEClientConversation t = DDEClientConversation.this;
                        synchronized (t) {
                            if (nativeDDEClientWhenDisconnectHappens == DDEClientConversation.this.nativeDDEClientConversation && DDEClientConversation.this.nativeDDEClientConversation != 0L) {
                                DDEClientConversation.this.disconnect();
                            }
                        }
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, t.toString(), t);
                    }
                }
            });
        }
        catch (Throwable thr) {
            logger.log(Level.SEVERE, thr.toString(), thr);
        }
    }

    private void fireEventOnAdvData(final String topic, final String item, final String data) {
        if (this.getEventListener() == null) {
            return;
        }
        try {
            this.executorService.submit(new Runnable(){

                public void run() {
                    try {
                        DDEClientEventListener listener = DDEClientConversation.this.getEventListener();
                        if (listener != null) {
                            listener.onItemChanged(topic, item, data);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.toString(), e);
                    }
                }
            });
        }
        catch (Throwable thr) {
            logger.log(Level.SEVERE, thr.toString(), thr);
        }
    }

    private synchronized native void nativeConnect(String var1, String var2) throws UnsatisfiedLinkError, DDEException;

    private synchronized native void nativeDisconnect() throws UnsatisfiedLinkError, DDEException;

    private synchronized native void nativeExecute(String var1) throws UnsatisfiedLinkError, DDEException;

    private synchronized native void nativeExecute(byte[] var1) throws UnsatisfiedLinkError, DDEException;

    private synchronized native void nativePoke(String var1, String var2) throws UnsatisfiedLinkError, DDEException;

    private synchronized native void nativePoke(String var1, byte[] var2, int var3) throws UnsatisfiedLinkError, DDEException;

    private synchronized native String nativeRequest(String var1) throws UnsatisfiedLinkError, DDEException;

    private synchronized native void nativeStartAdvice(String var1) throws UnsatisfiedLinkError, DDEException;

    private synchronized native void nativeStopAdvice(String var1) throws UnsatisfiedLinkError, DDEException;

    static {
        if ("64".equals(System.getProperty("sun.arch.data.model"))) {
            System.loadLibrary("JavaDDEx64");
        } else {
            System.loadLibrary("JavaDDE");
        }
    }
}

