/*
 * Decompiled with CFR 0.152.
 */
package com.pretty_tools.dde.server;

import com.pretty_tools.dde.DDEException;
import java.util.logging.Logger;

public abstract class DDEServer {
    private static final Logger logger = Logger.getLogger(DDEServer.class.getName());
    private final String service;
    private volatile long nativeDDEServer;

    protected DDEServer(String service) {
        this.service = service;
    }

    public synchronized void start() throws DDEException {
        if (this.nativeDDEServer != 0L) {
            throw new DDEException("Already started.");
        }
        this.nativeStart(this.service);
    }

    public synchronized void stop() throws DDEException {
        if (this.nativeDDEServer != 0L) {
            this.nativeStop();
        }
    }

    public synchronized void notifyClients(String topic, String item) throws DDEException {
        this.checkState();
        this.nativeNotifyClients(topic, item);
    }

    protected boolean isTopicSupported(String topic) {
        return true;
    }

    protected boolean isItemSupported(String topic, String item, int uFmt) {
        return this.isTopicSupported(topic);
    }

    protected boolean onExecute(String command) {
        return false;
    }

    protected boolean onPoke(String topic, String item, String data) {
        return false;
    }

    protected boolean onPoke(String topic, String item, byte[] data, int uFmt) {
        return false;
    }

    protected String onRequest(String topic, String item) {
        return null;
    }

    protected byte[] onRequest(String topic, String item, int uFmt) {
        return null;
    }

    private void checkState() throws DDEException {
        if (this.nativeDDEServer == 0L) {
            throw new DDEException("Server was not started.");
        }
    }

    private synchronized native void nativeStart(String var1) throws UnsatisfiedLinkError, DDEException;

    private synchronized native void nativeStop() throws UnsatisfiedLinkError, DDEException;

    private synchronized native void nativeNotifyClients(String var1, String var2) throws UnsatisfiedLinkError, DDEException;

    static {
        if ("64".equals(System.getProperty("sun.arch.data.model"))) {
            System.loadLibrary("JavaDDEx64");
        } else {
            System.loadLibrary("JavaDDE");
        }
    }
}

