/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Location;
import common.Log;
import common.PassManager;
import common.SatelliteManager;
import common.Sequence;
import common.UpdateManager;
import decoder.SourceIQ;
import gui.MainWindow;
import gui.ProgressPanel;
import gui.SettingsFrame;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import measure.SatPc32DDE;
import telemetry.FoxPayloadStore;
import telemetry.PayloadStore;
import telemetry.RawFrameQueue;
import telemetry.RawPayloadQueue;
import telemetry.RawQueue;
import uk.me.g4dpz.satellite.GroundStationPosition;

public class Config {
    public static Properties properties;
    public static String currentDir;
    public static String spacecraftDir;
    public static String editorSpacecraftDir;
    public static MainWindow mainWindow;
    static UpdateManager updateManager;
    static Thread updateManagerThread;
    public static SatPc32DDE satPC;
    public static boolean logDirFromPassedParam;
    public static ProgressPanel fileProgress;
    public static String VERSION_NUM;
    public static String VERSION;
    public static String propertiesFileName;
    public static final String WINDOWS = "win";
    public static final String MACOS = "mac";
    public static final String LINUX = "lin";
    public static final String RASPBERRY_PI = "pi";
    public static final Color AMSAT_BLUE;
    public static final Color AMSAT_RED;
    public static final Color PURPLE;
    public static final Color AMSAT_GREEN;
    public static final Color GRAPH1;
    public static final Color GRAPH2;
    public static final Color GRAPH3;
    public static final Color GRAPH4;
    public static final Color GRAPH5;
    public static final Color GRAPH6;
    public static final Color GRAPH7;
    public static final Color GRAPH8;
    public static final Color GRAPH9;
    public static final Color GRAPH10;
    public static final Color GRAPH11;
    public static final Color GRAPH12;
    public static SatelliteManager satManager;
    static Thread satManagerThread;
    public static PassManager passManager;
    static Thread passManagerThread;
    public static FoxPayloadStore payloadStore;
    static Thread payloadStoreThread;
    public static RawQueue rawFrameQueue;
    static Thread rawFrameQueueThread;
    public static RawQueue rawPayloadQueue;
    static Thread rawPayloadQueueThread;
    public static double filterFrequency;
    public static Sequence sequence;
    public static GroundStationPosition GROUND_STATION;
    public static final String NONE = "NONE";
    public static int wavSampleRate;
    public static int scSampleRate;
    public static final String NO_SOUND_CARD_SELECTED = "NONE";
    public static final String DEFAULT_CALLSIGN = "NONE";
    public static final String DEFAULT_STATION = "NONE";
    public static final String DEFAULT_ALTITUDE = "0";
    public static final String DEFAULT_LATITUDE = "0.0";
    public static final String DEFAULT_LONGITUDE = "0.0";
    public static final String DEFAULT_LOCATOR = "XX00xx";
    public static String soundCard;
    public static String audioSink;
    public static int playbackSampleRate;
    public static boolean flipReceivedBits;
    public static boolean flipReceivedBits2;
    public static boolean recoverClock;
    public static boolean writeDebugWavFile;
    public static boolean debugValues;
    public static boolean decoderPaused;
    public static boolean decoderPlay;
    public static int windowsProcessed;
    public static int windowStartBit;
    public static boolean debugPerformance;
    public static boolean debugClock;
    public static boolean debugBits;
    public static boolean debugFrames;
    public static boolean debugFieldValues;
    public static boolean debugCameraFrames;
    public static boolean debugBytes;
    public static boolean debugAudioGlitches;
    public static boolean debugAudioLevels;
    public static boolean debugSignalFinder;
    public static int DEBUG_COUNT;
    public static boolean filterData;
    public static int filterIterations;
    public static int filterLength;
    public static boolean useRSfec;
    public static boolean squelchAudio;
    public static boolean useAGC;
    public static boolean useRSerasures;
    public static boolean realTimePlaybackOfFile;
    public static int useFilterNumber;
    public static boolean useLeftStereoChannel;
    public static String format;
    public static boolean iq;
    public static boolean eliminateDC;
    public static boolean viewFilteredAudio;
    public static boolean monitorFilteredAudio;
    public static boolean monitorAudio;
    public static boolean filterOutputAudio;
    public static boolean logging;
    public static boolean FIRST_RUN;
    public static boolean useDDEforAzEl;
    public static boolean useDDEforFreq;
    public static String osName;
    public static String OS;
    public static int ftpPeriod;
    public static String callsign;
    public static String latitude;
    public static String longitude;
    public static String maidenhead;
    public static String stationDetails;
    public static String altitude;
    public static boolean ftpFiles;
    public static int serverTxPeriod;
    public static int serverRetryWaitPeriod;
    public static boolean uploadToServer;
    public static String primaryServer;
    public static String secondaryServer;
    public static String webSiteUrl;
    public static boolean sendToBothServers;
    public static int udpPort;
    public static int tcpPort;
    public static int serverPort;
    public static int serverProtocol;
    public static int windowHeight;
    public static int windowWidth;
    public static int windowX;
    public static int windowY;
    public static int windowFcHeight;
    public static int windowFcWidth;
    public static double fcdFrequency;
    public static final int DEFAULT_FROM_BIN = 0;
    public static final int DEFAULT_TO_BIN;
    public static int fromBin;
    public static int toBin;
    public static String windowCurrentDirectory;
    public static String csvCurrentDirectory;
    public static String logFileDirectory;
    public static String homeDirectory;
    public static String serverFileDirectory;
    public static boolean displayRawValues;
    public static boolean showLatestImage;
    public static boolean displayRawRadData;
    public static boolean displayUTCtime;
    public static boolean applyBlackmanWindow;
    public static boolean useLimiter;
    public static boolean showIF;
    public static boolean findSignal;
    public static boolean storePayloads;
    public static int displayModuleFontSize;
    public static int graphAxisFontSize;
    public static boolean useNativeFileChooser;
    public static boolean showSNR;
    public static double SCAN_SIGNAL_THRESHOLD;
    public static double ANALYZE_SNR_THRESHOLD;
    public static double BIT_SNR_THRESHOLD;
    public static String newVersionUrl;
    public static String newServerParamsUrl;
    public static String t0UrlPath;
    public static String t0UrlFile;
    public static boolean downloadT0FromServer;
    public static boolean debugHerciFrames;
    public static boolean swapIQ;
    public static boolean generateSecondaryPayloads;
    public static boolean startButtonPressed;
    public static int splitPaneHeight;
    public static boolean showFilters;
    public static int afSampleRate;
    public static int totalFrames;
    public static boolean debugRS;
    public static boolean foxTelemCalcsPosition;
    public static boolean whenAboveHorizon;
    public static boolean insertMissingBits;
    public static boolean firstRun106;
    public static boolean saveFcdParams;
    public static boolean showAudioOptions;
    public static boolean showSatOptions;
    public static boolean showSourceOptions;
    public static boolean useCostas;
    public static boolean showEye;
    public static boolean showPhasor;
    public static double selectedFrequency;
    public static boolean foxTelemCalcsDoppler;
    public static boolean showFFT;
    public static boolean debugCalcDopplerContinually;
    public static boolean splitCanPackets;
    public static boolean retuneCenterFrequency;
    public static boolean debugSegs;
    public static int timeUntilTableSegOffloaded;
    public static boolean turboWavFilePlayback;
    public static boolean debugDDE;
    public static int newResetCheckThreshold;
    public static int newResetCheckUptimeMax;
    public static boolean use12kHzIfForBPSK;
    public static boolean calculateBPSKCrc;
    public static String python;
    public static String payloadHeaderGenScript;
    public static boolean ignoreSpacecraftLoadErrors;
    public static boolean storeRawByteFrames;

    static {
        currentDir = "";
        spacecraftDir = "";
        editorSpacecraftDir = "";
        satPC = null;
        logDirFromPassedParam = false;
        VERSION_NUM = "1.13j";
        VERSION = String.valueOf(VERSION_NUM) + " - 19 Jul 2025";
        propertiesFileName = "FoxTelem.properties";
        AMSAT_BLUE = new Color(0, 0, 116);
        AMSAT_RED = new Color(224, 0, 0);
        PURPLE = new Color(123, 6, 130);
        AMSAT_GREEN = new Color(0, 102, 0);
        GRAPH1 = new Color(205, 103, 1);
        GRAPH2 = new Color(0, 103, 0);
        GRAPH3 = new Color(255, 51, 0);
        GRAPH4 = new Color(102, 204, 51);
        GRAPH5 = new Color(153, 0, 0);
        GRAPH6 = new Color(51, 51, 102);
        GRAPH7 = new Color(153, 102, 0);
        GRAPH8 = new Color(102, 102, 204);
        GRAPH9 = new Color(0, 51, 153);
        GRAPH10 = new Color(255, 255, 255);
        GRAPH11 = new Color(153, 153, 255);
        GRAPH12 = new Color(255, 204, 0);
        filterFrequency = 200.0;
        GROUND_STATION = null;
        wavSampleRate = 48000;
        scSampleRate = 48000;
        soundCard = "NONE";
        audioSink = "NONE";
        playbackSampleRate = 48000;
        flipReceivedBits = false;
        flipReceivedBits2 = false;
        recoverClock = true;
        writeDebugWavFile = false;
        debugValues = false;
        decoderPaused = false;
        decoderPlay = false;
        windowsProcessed = 0;
        windowStartBit = 0;
        debugPerformance = false;
        debugClock = false;
        debugBits = false;
        debugFrames = false;
        debugFieldValues = false;
        debugCameraFrames = false;
        debugBytes = false;
        debugAudioGlitches = false;
        debugAudioLevels = false;
        debugSignalFinder = false;
        DEBUG_COUNT = -1;
        filterData = true;
        filterIterations = 1;
        filterLength = 512;
        useRSfec = true;
        squelchAudio = true;
        useAGC = true;
        useRSerasures = true;
        realTimePlaybackOfFile = false;
        useFilterNumber = 0;
        useLeftStereoChannel = true;
        format = "FSK 200bps (Fox1)";
        iq = false;
        eliminateDC = true;
        viewFilteredAudio = true;
        monitorFilteredAudio = false;
        monitorAudio = true;
        filterOutputAudio = true;
        logging = false;
        FIRST_RUN = true;
        useDDEforAzEl = false;
        useDDEforFreq = false;
        osName = "Unknown OS";
        OS = WINDOWS;
        ftpPeriod = 60;
        callsign = "NONE";
        latitude = "0.0";
        longitude = "0.0";
        maidenhead = DEFAULT_LOCATOR;
        stationDetails = "NONE";
        altitude = DEFAULT_ALTITUDE;
        ftpFiles = false;
        serverTxPeriod = 5;
        serverRetryWaitPeriod = 10;
        uploadToServer = false;
        primaryServer = "tlm.amsat.org";
        secondaryServer = "tlm.amsat.org";
        webSiteUrl = "https://www.amsat.org/tlm";
        sendToBothServers = false;
        udpPort = 41041;
        serverPort = tcpPort = 41042;
        serverProtocol = 0;
        windowHeight = 750;
        windowWidth = 850;
        windowX = 100;
        windowY = 100;
        windowFcHeight = 600;
        windowFcWidth = 600;
        fcdFrequency = 145930.0;
        DEFAULT_TO_BIN = SourceIQ.FFT_SAMPLES;
        fromBin = 0;
        toBin = DEFAULT_TO_BIN;
        windowCurrentDirectory = "";
        csvCurrentDirectory = "";
        logFileDirectory = "";
        homeDirectory = "";
        serverFileDirectory = "";
        displayRawValues = false;
        showLatestImage = false;
        displayRawRadData = false;
        displayUTCtime = true;
        applyBlackmanWindow = false;
        useLimiter = false;
        showIF = false;
        findSignal = false;
        storePayloads = true;
        displayModuleFontSize = 12;
        graphAxisFontSize = 12;
        useNativeFileChooser = false;
        showSNR = true;
        SCAN_SIGNAL_THRESHOLD = 12.0;
        ANALYZE_SNR_THRESHOLD = 2.5;
        BIT_SNR_THRESHOLD = 1.8;
        newVersionUrl = "https://www.amsat.org/tlm/ops/version.txt";
        newServerParamsUrl = "https://www.amsat.org/tlm/ops/server.txt";
        t0UrlPath = "/ops/";
        t0UrlFile = "T0.txt";
        downloadT0FromServer = true;
        debugHerciFrames = false;
        swapIQ = false;
        generateSecondaryPayloads = false;
        startButtonPressed = false;
        splitPaneHeight = 200;
        showFilters = false;
        afSampleRate = 48000;
        totalFrames = 0;
        debugRS = false;
        foxTelemCalcsPosition = false;
        whenAboveHorizon = false;
        insertMissingBits = true;
        firstRun106 = false;
        saveFcdParams = true;
        showAudioOptions = true;
        showSatOptions = true;
        showSourceOptions = true;
        useCostas = false;
        showEye = true;
        showPhasor = true;
        foxTelemCalcsDoppler = false;
        showFFT = true;
        debugCalcDopplerContinually = false;
        splitCanPackets = true;
        retuneCenterFrequency = false;
        debugSegs = false;
        timeUntilTableSegOffloaded = 60000;
        turboWavFilePlayback = false;
        debugDDE = false;
        newResetCheckThreshold = 60;
        newResetCheckUptimeMax = 15000;
        use12kHzIfForBPSK = false;
        calculateBPSKCrc = true;
        python = "";
        payloadHeaderGenScript = "gen_header.py";
        ignoreSpacecraftLoadErrors = false;
        storeRawByteFrames = false;
    }

    public static boolean setup(String propertiesFileName) {
        Config.propertiesFileName = propertiesFileName;
        File aFile = new File(String.valueOf(homeDirectory) + File.separator + propertiesFileName);
        return !aFile.exists();
    }

    public static void setHome() {
        File aFile = new File(homeDirectory);
        if (!aFile.isDirectory()) {
            aFile.mkdir();
        }
        if (!aFile.isDirectory()) {
            Log.errorDialog("ERROR", "ERROR can't create the directory: " + aFile.getAbsolutePath() + "\nFoxTelem needs to save the program settings.  The directory is either not accessible or not writable\n");
        }
        Log.println("Set Home to: " + homeDirectory);
    }

    public static void basicInit() {
        Config.initSequence();
        osName = System.getProperty("os.name").toLowerCase();
        Config.setOs();
        satManager = new SatelliteManager();
        GROUND_STATION = new GroundStationPosition(0.0, 0.0, 0.0);
    }

    public static void serverInit() {
        Config.basicInit();
        updateManager = new UpdateManager(true);
        updateManagerThread = new Thread(updateManager);
        updateManagerThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        updateManagerThread.start();
    }

    public static void storeGroundStation() {
        int h = 0;
        try {
            if (altitude.equalsIgnoreCase("NONE")) {
                altitude = DEFAULT_ALTITUDE;
                h = 0;
            } else {
                h = Integer.parseInt(altitude);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (!(SettingsFrame.validLatLong(MainWindow.frame, latitude, longitude) || maidenhead.equalsIgnoreCase(DEFAULT_LOCATOR) || maidenhead.equals(""))) {
                Location l = new Location(maidenhead);
                latitude = Float.toString(l.latitude);
                longitude = Float.toString(l.longitude);
            }
            float lat = Float.parseFloat(latitude);
            float lon = Float.parseFloat(longitude);
            GROUND_STATION = new GroundStationPosition(lat, lon, h);
        }
        catch (NumberFormatException e) {
            GROUND_STATION = new GroundStationPosition(0.0, 0.0, 0.0);
        }
    }

    public static void minInit(String setLogFileDir) {
        properties = new Properties();
        Config.load();
        if (setLogFileDir != null) {
            logFileDirectory = setLogFileDir;
            logDirFromPassedParam = true;
        }
        osName = System.getProperty("os.name").toLowerCase();
        Config.setOs();
    }

    public static void init(String setLogFileDir) {
        Config.minInit(setLogFileDir);
        Config.initSequence();
        Config.storeGroundStation();
        Config.initSatelliteManager();
        Config.initPayloadStore();
        Config.initPassManager();
        Config.initServerQueue();
        if (firstRun106) {
            SCAN_SIGNAL_THRESHOLD = 14.0;
            ANALYZE_SNR_THRESHOLD = 2.5;
            firstRun106 = false;
            Log.infoDialog("First run of 1.06", "This is the first time you are running version 1.06 of FoxTelem.  The Find Signal algorithm\nhas been updated and the default values for Peak, SNR and Bit SNR have been set to new default values.\nYou can adjust these again to any value you want, but peak should now be set slightly higher and the\nSignal To Noise measure slightly lower.  The Eye (bit) Signal To Noise has remained the same\n");
        }
    }

    public static String getLogFileDirectory() {
        String toFileName = "";
        if (!logFileDirectory.equalsIgnoreCase("")) {
            toFileName = String.valueOf(logFileDirectory) + File.separator;
        }
        return toFileName;
    }

    public static int getVersionMajor() {
        return Config.parseVersionMajor(VERSION_NUM);
    }

    public static int parseVersionMajor(String ver) {
        String[] version = ver.split("\\.");
        return Integer.parseInt(version[0]);
    }

    public static int getVersionMinor() {
        return Config.parseVersionMinor(VERSION_NUM);
    }

    public static int parseVersionMinor(String ver) {
        String[] version = ver.split("\\.");
        String[] min_version = version[1].split("[a-z]");
        String min = min_version[0].replaceAll("\\D", "");
        return Integer.parseInt(min);
    }

    public static String getVersionPoint() {
        return Config.parseVersionPoint(VERSION_NUM);
    }

    public static String parseVersionPoint(String ver) {
        String version = ver.substring(ver.length() - 1, ver.length());
        if (version.matches("[0-9]+")) {
            return null;
        }
        return version;
    }

    public static void initSatelliteManager() {
        if (satManager != null) {
            satManager.stop();
        }
        satManager = new SatelliteManager();
        satManagerThread = new Thread(satManager);
        satManagerThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        satManagerThread.start();
    }

    public static void initPassManager() {
        passManager = new PassManager();
        passManagerThread = new Thread(passManager);
        passManagerThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        passManagerThread.start();
    }

    public static void initPayloadStore() {
        payloadStore = new PayloadStore();
        payloadStoreThread = new Thread(payloadStore);
        payloadStoreThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        payloadStoreThread.start();
    }

    public static void initSequence() {
        try {
            sequence = new Sequence();
        }
        catch (IOException e) {
            Log.errorDialog("ERROR", "Could not create the Server Sequence, uploading to server not possible.\n" + e.getMessage());
            e.printStackTrace(Log.getWriter());
        }
    }

    public static void initServerQueue() {
        if (rawFrameQueueThread != null) {
            rawFrameQueue.stopProcessing();
        }
        rawFrameQueue = new RawFrameQueue();
        rawFrameQueueThread = new Thread(rawFrameQueue);
        rawFrameQueueThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        rawFrameQueueThread.start();
        if (rawPayloadQueueThread != null) {
            rawPayloadQueue.stopProcessing();
        }
        rawPayloadQueue = new RawPayloadQueue();
        rawPayloadQueueThread = new Thread(rawPayloadQueue);
        rawPayloadQueueThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        rawPayloadQueueThread.start();
    }

    private static void setOs() {
        OS = osName.indexOf(WINDOWS) >= 0 ? WINDOWS : (osName.indexOf(MACOS) >= 0 ? MACOS : LINUX);
        if (Config.isLinuxOs()) {
            useNativeFileChooser = false;
            File file = new File("/etc", "os-release");
            BufferedReader bufferedReader = null;
            try {
                try {
                    String string;
                    FileInputStream fis = new FileInputStream(file);
                    bufferedReader = new BufferedReader(new InputStreamReader(fis));
                    while ((string = bufferedReader.readLine()) != null) {
                        if (!string.toLowerCase().contains("raspbian") || !string.toLowerCase().contains("name")) continue;
                        OS = RASPBERRY_PI;
                        Log.println("Raspberry Pi Detected");
                    }
                }
                catch (Exception e) {
                    Log.println("Linux but not Raspberry Pi");
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isWindowsOs() {
        return OS == WINDOWS;
    }

    public static boolean isLinuxOs() {
        return OS == LINUX || OS == RASPBERRY_PI;
    }

    public static boolean isRasperryPi() {
        return OS == RASPBERRY_PI;
    }

    public static boolean isMacOs() {
        return OS == MACOS;
    }

    public static void saveGraphParam(String sat, int plotType, int payloadType, String fieldName, String key, String value) {
        properties.setProperty("Graph" + sat + plotType + payloadType + fieldName + key, value);
    }

    public static String loadGraphValue(String sat, int plotType, int payloadType, String fieldName, String key) {
        return properties.getProperty("Graph" + sat + plotType + payloadType + fieldName + key);
    }

    public static void saveGraphIntParam(String sat, int plotType, int payloadType, String fieldName, String key, int value) {
        properties.setProperty("Graph" + sat + plotType + payloadType + fieldName + key, Integer.toString(value));
    }

    public static void saveGraphLongParam(String sat, int plotType, int payloadType, String fieldName, String key, long value) {
        properties.setProperty("Graph" + sat + plotType + payloadType + fieldName + key, Long.toString(value));
    }

    public static void saveGraphBooleanParam(String sat, int plotType, int payloadType, String fieldName, String key, boolean value) {
        properties.setProperty("Graph" + sat + plotType + payloadType + fieldName + key, Boolean.toString(value));
    }

    public static int loadGraphIntValue(String sat, int plotType, int payloadType, String fieldName, String key) {
        try {
            return Integer.parseInt(properties.getProperty("Graph" + sat + plotType + payloadType + fieldName + key));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long loadGraphLongValue(String sat, int plotType, int payloadType, String fieldName, String key) {
        try {
            return Long.parseLong(properties.getProperty("Graph" + sat + plotType + payloadType + fieldName + key));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static boolean loadGraphBooleanValue(String sat, int plotType, int payloadType, String fieldName, String key) {
        try {
            return Boolean.parseBoolean(properties.getProperty("Graph" + sat + plotType + payloadType + fieldName + key));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static void save() {
        properties.setProperty("recoverClock", Boolean.toString(recoverClock));
        properties.setProperty("flipReceivedBits", Boolean.toString(flipReceivedBits));
        properties.setProperty("filterData", Boolean.toString(filterData));
        properties.setProperty("filterIterations", Integer.toString(filterIterations));
        properties.setProperty("filterLength", Integer.toString(filterLength));
        properties.setProperty("filterFrequency", Double.toString(filterFrequency));
        properties.setProperty("debugBits", Boolean.toString(debugBits));
        properties.setProperty("debugFrames", Boolean.toString(debugFrames));
        properties.setProperty("debugFieldValues", Boolean.toString(debugFieldValues));
        properties.setProperty("debugCameraFrames", Boolean.toString(debugCameraFrames));
        properties.setProperty("debugValues", Boolean.toString(debugValues));
        properties.setProperty("debugPerformance", Boolean.toString(debugPerformance));
        properties.setProperty("debugClock", Boolean.toString(debugClock));
        properties.setProperty("debugBytes", Boolean.toString(debugBytes));
        properties.setProperty("debugAudioGlitches", Boolean.toString(debugAudioGlitches));
        properties.setProperty("DEBUG_COUNT", Integer.toString(DEBUG_COUNT));
        properties.setProperty("writeDebugWavFile", Boolean.toString(writeDebugWavFile));
        properties.setProperty("useRSfec", Boolean.toString(useRSfec));
        properties.setProperty("squelchAudio", Boolean.toString(squelchAudio));
        properties.setProperty("useAGC", Boolean.toString(useAGC));
        properties.setProperty("useRSerasures", Boolean.toString(useRSerasures));
        properties.setProperty("realTimePlaybackOfFile", Boolean.toString(realTimePlaybackOfFile));
        properties.setProperty("useFilterNumber", Integer.toString(useFilterNumber));
        properties.setProperty("useLeftStereoChannel", Boolean.toString(useLeftStereoChannel));
        properties.setProperty("iq", Boolean.toString(iq));
        properties.setProperty("eliminateDC", Boolean.toString(eliminateDC));
        properties.setProperty("viewFilteredAudio", Boolean.toString(viewFilteredAudio));
        properties.setProperty("monitorFilteredAudio", Boolean.toString(monitorFilteredAudio));
        properties.setProperty("monitorAudio", Boolean.toString(monitorAudio));
        properties.setProperty("filterOutputAudio", Boolean.toString(filterOutputAudio));
        properties.setProperty("logging", Boolean.toString(logging));
        properties.setProperty("FIRST_RUN", Boolean.toString(FIRST_RUN));
        properties.setProperty("useDDEforAzEl", Boolean.toString(useDDEforAzEl));
        properties.setProperty("useDDEforFreq", Boolean.toString(useDDEforFreq));
        properties.setProperty("wavSampleRate", Integer.toString(wavSampleRate));
        properties.setProperty("scSampleRate", Integer.toString(scSampleRate));
        properties.setProperty("playbackSampleRate", Integer.toString(playbackSampleRate));
        properties.setProperty("soundCard", soundCard);
        properties.setProperty("audioSink", audioSink);
        properties.setProperty("ftpPeriod", Integer.toString(ftpPeriod));
        properties.setProperty("callsign", callsign);
        properties.setProperty("stationDetails", stationDetails);
        properties.setProperty("altitude", altitude);
        properties.setProperty("latitude", latitude);
        properties.setProperty("longitude", longitude);
        properties.setProperty("maidenhead", maidenhead);
        properties.setProperty("ftpFiles", Boolean.toString(ftpFiles));
        properties.setProperty("uploadToServer", Boolean.toString(uploadToServer));
        properties.setProperty("primaryServer", primaryServer);
        properties.setProperty("secondaryServer", secondaryServer);
        properties.setProperty("windowHeight", Integer.toString(windowHeight));
        properties.setProperty("windowWidth", Integer.toString(windowWidth));
        properties.setProperty("windowX", Integer.toString(windowX));
        properties.setProperty("windowY", Integer.toString(windowY));
        properties.setProperty("fcdFrequency", Double.toString(fcdFrequency));
        properties.setProperty("windowCurrentDirectory", windowCurrentDirectory);
        properties.setProperty("csvCurrentDirectory", csvCurrentDirectory);
        properties.setProperty("logFileDirectory", logFileDirectory);
        properties.setProperty("windowFcHeight", Integer.toString(windowFcHeight));
        properties.setProperty("windowFcWidth", Integer.toString(windowFcWidth));
        properties.setProperty("displayRawValues", Boolean.toString(displayRawValues));
        properties.setProperty("showLatestImage", Boolean.toString(showLatestImage));
        properties.setProperty("displayRawRadData", Boolean.toString(displayRawRadData));
        properties.setProperty("displayUTCtime", Boolean.toString(displayUTCtime));
        properties.setProperty("storePayloads", Boolean.toString(storePayloads));
        properties.setProperty("findSignal", Boolean.toString(findSignal));
        properties.setProperty("displayModuleFontSize", Integer.toString(displayModuleFontSize));
        properties.setProperty("graphAxisFontSize", Integer.toString(graphAxisFontSize));
        properties.setProperty("useNativeFileChooser", Boolean.toString(useNativeFileChooser));
        properties.setProperty("debugSignalFinder", Boolean.toString(debugSignalFinder));
        properties.setProperty("serverProtocol", Integer.toString(serverProtocol));
        properties.setProperty("serverPort", Integer.toString(serverPort));
        properties.setProperty("showSNR", Boolean.toString(showSNR));
        properties.setProperty("SCAN_SIGNAL_THRESHOLD", Double.toString(SCAN_SIGNAL_THRESHOLD));
        properties.setProperty("ANALYZE_SNR_THRESHOLD", Double.toString(ANALYZE_SNR_THRESHOLD));
        properties.setProperty("BIT_SNR_THRESHOLD", Double.toString(BIT_SNR_THRESHOLD));
        properties.setProperty("newServerParamsUrl", newServerParamsUrl);
        properties.setProperty("sendToBothServers", Boolean.toString(sendToBothServers));
        properties.setProperty("downloadT0FromServer", Boolean.toString(downloadT0FromServer));
        properties.setProperty("serverFileDirectory", serverFileDirectory);
        properties.setProperty("webSiteUrl", webSiteUrl);
        properties.setProperty("debugHerciFrames", Boolean.toString(debugHerciFrames));
        properties.setProperty("flipReceivedBits2", Boolean.toString(flipReceivedBits2));
        properties.setProperty("swapIQ", Boolean.toString(swapIQ));
        properties.setProperty("startButtonPressed", Boolean.toString(startButtonPressed));
        properties.setProperty("splitPaneHeight", Integer.toString(splitPaneHeight));
        properties.setProperty("showFilters", Boolean.toString(showFilters));
        properties.setProperty("afSampleRate", Integer.toString(afSampleRate));
        properties.setProperty("foxTelemCalcsPosition", Boolean.toString(foxTelemCalcsPosition));
        properties.setProperty("whenAboveHorizon", Boolean.toString(whenAboveHorizon));
        properties.setProperty("insertMissingBits", Boolean.toString(insertMissingBits));
        properties.setProperty("firstRun106", Boolean.toString(firstRun106));
        properties.setProperty("saveFcdParams", Boolean.toString(saveFcdParams));
        properties.setProperty("generateSecondaryPayloads", Boolean.toString(generateSecondaryPayloads));
        properties.setProperty("showAudioOptions", Boolean.toString(showAudioOptions));
        properties.setProperty("showSourceOptions", Boolean.toString(showSourceOptions));
        properties.setProperty("showSatOptions", Boolean.toString(showSatOptions));
        properties.setProperty("showEye", Boolean.toString(showEye));
        properties.setProperty("showPhasor", Boolean.toString(showPhasor));
        properties.setProperty("selectedFrequency", Double.toString(selectedFrequency));
        properties.setProperty("foxTelemCalcsDoppler", Boolean.toString(foxTelemCalcsDoppler));
        properties.setProperty("showFFT", Boolean.toString(showFFT));
        properties.setProperty("debugCalcDopplerContinually", Boolean.toString(debugCalcDopplerContinually));
        properties.setProperty("retuneCenterFrequency", Boolean.toString(retuneCenterFrequency));
        properties.setProperty("debugSegs", Boolean.toString(debugSegs));
        properties.setProperty("timeUntilTableSegOffloaded", Integer.toString(timeUntilTableSegOffloaded));
        properties.setProperty("turboWavFilePlayback", Boolean.toString(turboWavFilePlayback));
        properties.setProperty("newResetCheckThreshold", Integer.toString(newResetCheckThreshold));
        properties.setProperty("newResetCheckUptimeMax", Integer.toString(newResetCheckUptimeMax));
        properties.setProperty("useCostas", Boolean.toString(useCostas));
        properties.setProperty("format", format);
        properties.setProperty("use12kHzIfForBPSK", Boolean.toString(use12kHzIfForBPSK));
        properties.setProperty("calculateBPSKCrc", Boolean.toString(calculateBPSKCrc));
        properties.setProperty("debugRS", Boolean.toString(debugRS));
        properties.setProperty("debugAudioLevels", Boolean.toString(debugAudioLevels));
        properties.setProperty("editorSpacecraftDir", editorSpacecraftDir);
        properties.setProperty("python", python);
        properties.setProperty("payloadHeaderGenScript", payloadHeaderGenScript);
        properties.setProperty("storeRawByteFrames", Boolean.toString(storeRawByteFrames));
        Config.store();
    }

    private static void store() {
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(homeDirectory) + File.separator + propertiesFileName);
            properties.store(fos, "Fox 1 Telemetry Decoder Properties");
            fos.close();
        }
        catch (FileNotFoundException e1) {
            Log.errorDialog("ERROR", "Could not write properties file. Check permissions on directory or on the file\n" + homeDirectory + File.separator + propertiesFileName);
            e1.printStackTrace(Log.getWriter());
        }
        catch (IOException e1) {
            Log.errorDialog("ERROR", "Error writing properties file");
            e1.printStackTrace(Log.getWriter());
        }
    }

    public static void load() {
        try {
            FileInputStream fis = new FileInputStream(String.valueOf(homeDirectory) + File.separator + propertiesFileName);
            properties.load(fis);
            fis.close();
        }
        catch (IOException e) {
            Config.save();
        }
        try {
            recoverClock = Boolean.parseBoolean(Config.getProperty("recoverClock"));
            flipReceivedBits = Boolean.parseBoolean(Config.getProperty("flipReceivedBits"));
            filterData = Boolean.parseBoolean(Config.getProperty("filterData"));
            filterIterations = Integer.parseInt(Config.getProperty("filterIterations"));
            filterLength = Integer.parseInt(Config.getProperty("filterLength"));
            filterFrequency = Double.parseDouble(Config.getProperty("filterFrequency"));
            debugBits = Boolean.parseBoolean(Config.getProperty("debugBits"));
            debugFrames = Boolean.parseBoolean(Config.getProperty("debugFrames"));
            debugFieldValues = Boolean.parseBoolean(Config.getProperty("debugFieldValues"));
            debugCameraFrames = Boolean.parseBoolean(Config.getProperty("debugCameraFrames"));
            debugValues = Boolean.parseBoolean(Config.getProperty("debugValues"));
            debugPerformance = Boolean.parseBoolean(Config.getProperty("debugPerformance"));
            debugClock = Boolean.parseBoolean(Config.getProperty("debugClock"));
            debugBytes = Boolean.parseBoolean(Config.getProperty("debugBytes"));
            debugAudioGlitches = Boolean.parseBoolean(Config.getProperty("debugAudioGlitches"));
            DEBUG_COUNT = Integer.parseInt(Config.getProperty("DEBUG_COUNT"));
            writeDebugWavFile = Boolean.parseBoolean(Config.getProperty("writeDebugWavFile"));
            useRSfec = Boolean.parseBoolean(Config.getProperty("useRSfec"));
            squelchAudio = Boolean.parseBoolean(Config.getProperty("squelchAudio"));
            useAGC = Boolean.parseBoolean(Config.getProperty("useAGC"));
            useRSerasures = Boolean.parseBoolean(Config.getProperty("useRSerasures"));
            realTimePlaybackOfFile = Boolean.parseBoolean(Config.getProperty("realTimePlaybackOfFile"));
            useLeftStereoChannel = Boolean.parseBoolean(Config.getProperty("useLeftStereoChannel"));
            iq = Boolean.parseBoolean(Config.getProperty("iq"));
            eliminateDC = Boolean.parseBoolean(Config.getProperty("eliminateDC"));
            viewFilteredAudio = Boolean.parseBoolean(Config.getProperty("viewFilteredAudio"));
            monitorFilteredAudio = Boolean.parseBoolean(Config.getProperty("monitorFilteredAudio"));
            monitorAudio = Boolean.parseBoolean(Config.getProperty("monitorAudio"));
            filterOutputAudio = Boolean.parseBoolean(Config.getProperty("filterOutputAudio"));
            logging = Boolean.parseBoolean(Config.getProperty("logging"));
            FIRST_RUN = Boolean.parseBoolean(Config.getProperty("FIRST_RUN"));
            useDDEforAzEl = Boolean.parseBoolean(Config.getProperty("useDDEforAzEl"));
            useDDEforFreq = Boolean.parseBoolean(Config.getProperty("useDDEforFreq"));
            useFilterNumber = Integer.parseInt(Config.getProperty("useFilterNumber"));
            wavSampleRate = Integer.parseInt(Config.getProperty("wavSampleRate"));
            scSampleRate = Integer.parseInt(Config.getProperty("scSampleRate"));
            playbackSampleRate = Integer.parseInt(Config.getProperty("playbackSampleRate"));
            soundCard = Config.getProperty("soundCard");
            if (soundCard == null) {
                soundCard = "NONE";
            }
            if ((audioSink = Config.getProperty("audioSink")) == null) {
                audioSink = "NONE";
            }
            ftpPeriod = Integer.parseInt(Config.getProperty("ftpPeriod"));
            callsign = Config.getProperty("callsign");
            stationDetails = Config.getProperty("stationDetails");
            altitude = Config.getProperty("altitude");
            if (altitude.equalsIgnoreCase("NONE")) {
                altitude = DEFAULT_ALTITUDE;
            }
            latitude = Config.getProperty("latitude");
            longitude = Config.getProperty("longitude");
            maidenhead = Config.getProperty("maidenhead");
            ftpFiles = Boolean.parseBoolean(Config.getProperty("ftpFiles"));
            uploadToServer = Boolean.parseBoolean(Config.getProperty("uploadToServer"));
            primaryServer = Config.getProperty("primaryServer");
            secondaryServer = Config.getProperty("secondaryServer");
            windowHeight = Integer.parseInt(Config.getProperty("windowHeight"));
            windowWidth = Integer.parseInt(Config.getProperty("windowWidth"));
            windowX = Integer.parseInt(Config.getProperty("windowX"));
            windowY = Integer.parseInt(Config.getProperty("windowY"));
            fcdFrequency = Double.parseDouble(Config.getProperty("fcdFrequency"));
            windowCurrentDirectory = Config.getProperty("windowCurrentDirectory");
            if (windowCurrentDirectory == null) {
                windowCurrentDirectory = "";
            }
            if ((csvCurrentDirectory = Config.getProperty("csvCurrentDirectory")) == null) {
                csvCurrentDirectory = "";
            }
            if ((logFileDirectory = Config.getProperty("logFileDirectory")) == null) {
                logFileDirectory = "";
            }
            if (homeDirectory == null) {
                homeDirectory = "";
            }
            windowFcHeight = Integer.parseInt(Config.getProperty("windowFcHeight"));
            windowFcWidth = Integer.parseInt(Config.getProperty("windowFcWidth"));
            displayRawValues = Boolean.parseBoolean(Config.getProperty("displayRawValues"));
            showLatestImage = Boolean.parseBoolean(Config.getProperty("showLatestImage"));
            displayRawRadData = Boolean.parseBoolean(Config.getProperty("displayRawRadData"));
            displayUTCtime = Boolean.parseBoolean(Config.getProperty("displayUTCtime"));
            storePayloads = Boolean.parseBoolean(Config.getProperty("storePayloads"));
            findSignal = Boolean.parseBoolean(Config.getProperty("findSignal"));
            displayModuleFontSize = Integer.parseInt(Config.getProperty("displayModuleFontSize"));
            graphAxisFontSize = Integer.parseInt(Config.getProperty("graphAxisFontSize"));
            useNativeFileChooser = Boolean.parseBoolean(Config.getProperty("useNativeFileChooser"));
            debugSignalFinder = Boolean.parseBoolean(Config.getProperty("debugSignalFinder"));
            serverProtocol = Integer.parseInt(Config.getProperty("serverProtocol"));
            serverPort = Integer.parseInt(Config.getProperty("serverPort"));
            showSNR = Boolean.parseBoolean(Config.getProperty("showSNR"));
            SCAN_SIGNAL_THRESHOLD = Double.parseDouble(Config.getProperty("SCAN_SIGNAL_THRESHOLD"));
            ANALYZE_SNR_THRESHOLD = Double.parseDouble(Config.getProperty("ANALYZE_SNR_THRESHOLD"));
            BIT_SNR_THRESHOLD = Double.parseDouble(Config.getProperty("BIT_SNR_THRESHOLD"));
            newServerParamsUrl = Config.getProperty("newServerParamsUrl");
            sendToBothServers = Boolean.parseBoolean(Config.getProperty("sendToBothServers"));
            downloadT0FromServer = Boolean.parseBoolean(Config.getProperty("downloadT0FromServer"));
            serverFileDirectory = Config.getProperty("serverFileDirectory");
            if (serverFileDirectory == null) {
                serverFileDirectory = "";
            }
            if ((webSiteUrl = Config.getProperty("webSiteUrl")) == null) {
                webSiteUrl = "";
            }
            debugHerciFrames = Boolean.parseBoolean(Config.getProperty("debugHerciFrames"));
            flipReceivedBits2 = Boolean.parseBoolean(Config.getProperty("flipReceivedBits2"));
            swapIQ = Boolean.parseBoolean(Config.getProperty("swapIQ"));
            startButtonPressed = Boolean.parseBoolean(Config.getProperty("startButtonPressed"));
            splitPaneHeight = Integer.parseInt(Config.getProperty("splitPaneHeight"));
            showFilters = Boolean.parseBoolean(Config.getProperty("showFilters"));
            afSampleRate = Integer.parseInt(Config.getProperty("afSampleRate"));
            foxTelemCalcsPosition = Boolean.parseBoolean(Config.getProperty("foxTelemCalcsPosition"));
            whenAboveHorizon = Boolean.parseBoolean(Config.getProperty("whenAboveHorizon"));
            insertMissingBits = Boolean.parseBoolean(Config.getProperty("insertMissingBits"));
            firstRun106 = Boolean.parseBoolean(Config.getProperty("firstRun106"));
            saveFcdParams = Boolean.parseBoolean(Config.getProperty("saveFcdParams"));
            generateSecondaryPayloads = Boolean.parseBoolean(Config.getProperty("generateSecondaryPayloads"));
            showAudioOptions = Boolean.parseBoolean(Config.getProperty("showAudioOptions"));
            showSatOptions = Boolean.parseBoolean(Config.getProperty("showSatOptions"));
            showSourceOptions = Boolean.parseBoolean(Config.getProperty("showSourceOptions"));
            showEye = Boolean.parseBoolean(Config.getProperty("showEye"));
            showPhasor = Boolean.parseBoolean(Config.getProperty("showPhasor"));
            selectedFrequency = Double.parseDouble(Config.getProperty("selectedFrequency"));
            foxTelemCalcsDoppler = Boolean.parseBoolean(Config.getProperty("foxTelemCalcsDoppler"));
            showFFT = Boolean.parseBoolean(Config.getProperty("showFFT"));
            debugCalcDopplerContinually = Boolean.parseBoolean(Config.getProperty("debugCalcDopplerContinually"));
            retuneCenterFrequency = Boolean.parseBoolean(Config.getProperty("retuneCenterFrequency"));
            debugSegs = Boolean.parseBoolean(Config.getProperty("debugSegs"));
            timeUntilTableSegOffloaded = Integer.parseInt(Config.getProperty("timeUntilTableSegOffloaded"));
            turboWavFilePlayback = Boolean.parseBoolean(Config.getProperty("turboWavFilePlayback"));
            newResetCheckThreshold = Integer.parseInt(Config.getProperty("newResetCheckThreshold"));
            newResetCheckUptimeMax = Integer.parseInt(Config.getProperty("newResetCheckUptimeMax"));
            useCostas = Boolean.parseBoolean(Config.getProperty("useCostas"));
            format = Config.getProperty("format");
            use12kHzIfForBPSK = Boolean.parseBoolean(Config.getProperty("use12kHzIfForBPSK"));
            calculateBPSKCrc = Boolean.parseBoolean(Config.getProperty("calculateBPSKCrc"));
            debugRS = Boolean.parseBoolean(Config.getProperty("debugRS"));
            debugAudioLevels = Boolean.parseBoolean(Config.getProperty("debugAudioLevels"));
            editorSpacecraftDir = Config.getProperty("editorSpacecraftDir");
            python = Config.getProperty("python");
            payloadHeaderGenScript = Config.getProperty("payloadHeaderGenScript");
            storeRawByteFrames = Boolean.parseBoolean(Config.getProperty("storeRawByteFrames"));
        }
        catch (NumberFormatException nf) {
            Config.catchException();
        }
        catch (NullPointerException nf) {
            Config.catchException();
        }
    }

    private static String getProperty(String key) {
        String value = properties.getProperty(key);
        if (value == null) {
            throw new NullPointerException();
        }
        return value;
    }

    private static void catchException() {
        Log.println("Error Loading " + homeDirectory + File.separator + propertiesFileName + "\n" + "If this is a new release then the format has probablly been extended.\n" + "A new properties file has been created");
        Config.save();
        Log.println("Created new properties file.");
    }
}

