/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Config;
import gui.MainWindow;
import gui.SourceTab;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JOptionPane;

public class Log {
    private static boolean echoToStdout = true;
    static PrintWriter output = null;
    public static final DateFormat fileDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final DateFormat logDateName = new SimpleDateFormat("yyyyMMdd");
    public static SourceTab logPanel;
    public static String logFile;
    public static Thread.UncaughtExceptionHandler uncaughtExHandler;
    public static boolean showGuiDialogs;
    public static boolean alertsAreFatal;

    static {
        logFile = "FoxTelemDecoder";
        showGuiDialogs = true;
        alertsAreFatal = true;
    }

    public static void init(String logFile) {
        Log.logFile = Log.rollLog(logFile);
        if (Config.logging) {
            try {
                File aFile;
                if (!Config.logFileDirectory.equalsIgnoreCase("")) {
                    Log.logFile = String.valueOf(Config.logFileDirectory) + File.separator + Log.logFile;
                }
                if (!(aFile = new File(Log.logFile)).exists()) {
                    aFile.createNewFile();
                }
                output = new PrintWriter(new FileWriter(aFile, true));
            }
            catch (IOException e) {
                System.err.println("FATAL ERROR: Cannot write log file: FoxTelemDecoder.log\nPerhaps the disk is full or the directory is not writable:\n" + Config.logFileDirectory);
                e.printStackTrace();
                Log.errorDialog("FATAL ERROR", "Cannot write log file: FoxTelemDecoder.log\nPerhaps the disk is full or the directory is not writable:\n" + Config.logFileDirectory + "\n\n" + "You can reset FoxTelem by deleting the settings file (might want to back it up first):\n" + Config.homeDirectory + File.separator + "FoxTelem.properties");
                System.exit(1);
            }
        }
        uncaughtExHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                String stacktrace = Log.makeShortTrace(ex.getStackTrace());
                Log.errorDialog("SERIOUS ERROR", "Uncaught exception.  You probablly need to restart FoxTelem:\n" + ex + "\n" + stacktrace);
                if (!showGuiDialogs) {
                    Log.alert("Uncaught exception.  Need to clear the ALERT and restart the server:\n" + stacktrace);
                }
            }
        };
    }

    public static String makeShortTrace(StackTraceElement[] elements) {
        String stacktrace = "";
        int limit = 13;
        int i = 0;
        while (i < limit && i < elements.length) {
            stacktrace = String.valueOf(stacktrace) + elements[i] + "\n";
            ++i;
        }
        if (elements.length > limit) {
            stacktrace = String.valueOf(stacktrace) + " ... " + (elements.length - limit) + " items not shown .... ";
        }
        return stacktrace;
    }

    public static String rollLog(String logFile) {
        Date today = Calendar.getInstance().getTime();
        logDateName.setTimeZone(TimeZone.getTimeZone("UTC"));
        String reportDate = logDateName.format(today);
        return String.valueOf(logFile) + reportDate + ".log";
    }

    public static void alert(String message) {
        block4: {
            try {
                Log.println("ALERT: " + message);
                String alertFile = String.valueOf(logFile) + ".ALERT";
                File aFile = new File(alertFile);
                if (!aFile.exists()) {
                    aFile.createNewFile();
                }
                PrintWriter out = new PrintWriter(new FileWriter(aFile, true));
                out.write(String.valueOf(Log.fileDateStamp()) + message + System.getProperty("line.separator"));
                out.flush();
                out.close();
                if (alertsAreFatal) {
                    System.exit(9);
                }
            }
            catch (Exception e) {
                System.err.println("FATAL ERROR: Cannot write log file: FoxTelemDecoder.log\nPerhaps the disk is full or the directory is not writable:\n" + Config.logFileDirectory);
                e.printStackTrace();
                Log.errorDialog("FATAL ERROR", "Cannot write log file: FoxTelemDecoder.log\nPerhaps the disk is full or the directory is not writable:\n" + Config.logFileDirectory + "\n\n" + "You can reset FoxTelem by deleting the settings file (might want to back it up first):\n" + Config.homeDirectory + File.separator + "FoxTelem.properties");
                if (!alertsAreFatal) break block4;
                System.exit(1);
            }
        }
    }

    public static boolean getLogging() {
        return Config.logging;
    }

    public static void setLogging(boolean on) {
        Config.logging = on;
    }

    public static void setStdoutEcho(boolean on) {
        echoToStdout = on;
    }

    public static PrintWriter getWriter() {
        if (output != null) {
            return output;
        }
        return new PrintWriter(System.err);
    }

    public static void setGUILog(SourceTab panel) {
        logPanel = panel;
    }

    public static void print(String s) {
        if (Config.logging) {
            if (output == null) {
                Log.init(logFile);
            }
            output.write(s);
            if (logPanel != null) {
                logPanel.log(s);
            }
            Log.flush();
        }
        if (echoToStdout) {
            System.out.print(s);
        }
    }

    public static void println(String s) {
        if (Config.logging) {
            if (output == null) {
                Log.init("FoxTelemDecoder");
            }
            output.write(String.valueOf(Log.fileDateStamp()) + s + System.getProperty("line.separator"));
            if (logPanel != null) {
                logPanel.log(s);
            }
            Log.flush();
        }
        if (echoToStdout) {
            System.out.println(s);
        }
    }

    public static int optionYNdialog(String title, String message) {
        if (!showGuiDialogs) {
            return 1;
        }
        Object[] options = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(MainWindow.frame, message.toString(), title, 0, 3, null, options, options[1]);
        return n;
    }

    public static void errorDialog(String title, String message) {
        Log.dialog(title, message, 0);
    }

    public static void infoDialog(String title, String message) {
        Log.dialog(title, message, 1);
    }

    private static void dialog(String title, String message, int type) {
        try {
            if (showGuiDialogs) {
                JOptionPane.showMessageDialog(MainWindow.frame, message.toString(), title, type);
            } else {
                Log.println(String.valueOf(title) + " " + message.toString());
            }
        }
        catch (Exception e) {
            System.err.println("FATAL ERROR: Cannot show dialog: " + title + "\n" + message + "\n");
            System.exit(1);
        }
    }

    public static String fileDateStamp() {
        Date today = Calendar.getInstance().getTime();
        fileDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String reportDate = String.valueOf(fileDateFormat.format(today)) + ": ";
        return reportDate;
    }

    public static void flush() {
        if (Config.logging && output != null) {
            output.flush();
        }
    }

    public static void close() {
        if (Config.logging && output != null) {
            output.close();
        }
    }
}

