/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Log;
import common.PerfTimer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Performance {
    public static int bindCalls = 0;
    public static float bindAverage = 0.0f;
    public static int bindFrames = 0;
    private static boolean timing = false;
    private static HashMap<String, Integer> bindFreq = new HashMap();
    private static ArrayList<PerfTimer> timers = new ArrayList(64);

    public static void setEnabled(boolean t) {
        timing = t;
    }

    public static void bind(String s) {
        if (!timing) {
            return;
        }
        ++bindCalls;
        if (bindFreq.containsKey(s)) {
            int current = bindFreq.get(s);
            bindFreq.put(s, current + 1);
        } else {
            bindFreq.put(s, 1);
        }
    }

    public static void bindEndFrame() {
        if (!timing) {
            return;
        }
        bindAverage = bindCalls / ++bindFrames;
    }

    public static void startTimer(String s) {
        if (!timing) {
            return;
        }
        PerfTimer pt = null;
        int i = 0;
        while (i < timers.size()) {
            if (Performance.timers.get((int)i).timer == s) {
                pt = timers.get(i);
                break;
            }
            ++i;
        }
        if (pt == null) {
            timers.add(new PerfTimer(s));
        } else {
            pt.resetStartTime();
        }
    }

    public static void endTimer(String s) {
        if (!timing) {
            return;
        }
        PerfTimer pt = null;
        int i = 0;
        while (i < timers.size()) {
            if (Performance.timers.get((int)i).timer == s) {
                pt = timers.get(i);
                break;
            }
            ++i;
        }
        if (pt == null) {
            Log.println("ERROR: Not a valid timer: " + s);
            return;
        }
        pt.updateTimer();
    }

    public static void printResults() {
        if (!timing) {
            return;
        }
        long totalTime = 0L;
        int i = 0;
        while (i < timers.size()) {
            totalTime += Performance.timers.get((int)i).result.longValue();
            ++i;
        }
        Log.println("Total time: " + totalTime);
        i = 0;
        while (i < timers.size()) {
            String name = Performance.timers.get((int)i).timer;
            Long time = Performance.timers.get((int)i).result;
            double seconds = (double)time.longValue() / 1.0E9;
            double percent = (double)time.longValue() / (double)totalTime;
            Log.println(String.valueOf(name) + ": " + seconds + " - " + percent * 100.0);
            ++i;
        }
        if (bindFrames > 0) {
            Log.println("Binds: " + bindCalls);
            Log.println("Frames: " + bindFrames);
            Log.println("Binds Per Frame: " + bindAverage);
            for (Map.Entry<String, Integer> entry : bindFreq.entrySet()) {
                String key = entry.getKey();
                Integer v = entry.getValue();
                Log.println(String.valueOf(key) + ": " + v / bindFrames + " per frame");
            }
        }
    }
}

