/*
 * Decompiled with CFR 0.152.
 */
package common;

import FuncubeDecoder.FUNcubeSpacecraft;
import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import gui.ProgressPanel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import predict.FoxTLE;
import predict.PositionCalcException;
import predict.SortedTleList;
import telemetry.BitArrayLayout;
import telemetry.Format.TelemFormat;
import telemetry.LayoutLoadException;
import telemetry.SatPayloadStore;
import telemetry.frames.FrameLayout;

public class SatelliteManager
implements Runnable {
    public static final String AMSAT_NASA_ALL = "http://www.amsat.org/amsat/ftp/keps/current/nasabare.txt";
    public boolean updated = true;
    public static final long RECENT_TIME = 3600000L;
    public ArrayList<Spacecraft> spacecraftList = new ArrayList();
    public ArrayList<TelemFormat> telemFormats = new ArrayList();
    boolean running = true;
    boolean done = false;

    public SatelliteManager() {
        this.init();
        if (Config.foxTelemCalcsPosition) {
            this.fetchTLEFile();
        }
    }

    public void init() {
        File masterFolder = new File(Config.spacecraftDir);
        this.loadFormats(masterFolder);
        File folder = this.getFolder(masterFolder);
        this.loadSats(masterFolder, folder);
    }

    private void copyDatFiles(File masterFolder, File folder) {
        int i;
        File[] listOfFiles = masterFolder.listFiles();
        boolean haveDatFiles = false;
        File[] targetFiles = folder.listFiles();
        if (targetFiles != null) {
            i = 0;
            while (i < targetFiles.length) {
                if (targetFiles[i].isFile() && targetFiles[i].getName().endsWith(".dat")) {
                    haveDatFiles = true;
                }
                ++i;
            }
        }
        haveDatFiles = true;
        if (listOfFiles != null) {
            i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile() && listOfFiles[i].getName().endsWith(".MASTER")) {
                    Log.println("Checking spacecraft file: " + listOfFiles[i].getName());
                    String targetName = listOfFiles[i].getName().replace(".MASTER", ".dat");
                    File targetFile = new File(folder + File.separator + targetName);
                    if (!targetFile.exists()) {
                        int n;
                        if (!haveDatFiles && (n = Log.optionYNdialog("Hit yes to install or No to skip?", "Install: " + targetName + "\n\nDo you want to install the spacecraft file:\n" + targetFile)) == 0) {
                            Log.println("Copying spacecraft file: " + listOfFiles[i].getName() + " to " + targetFile.getName());
                            try {
                                try {
                                    Spacecraft satellite = new Spacecraft(this, listOfFiles[i], targetFile);
                                    satellite.save();
                                }
                                catch (LayoutLoadException e) {
                                    Log.errorDialog("ERROR Loading Spacecraft File", "Could not load spacecraft file " + targetFile + "\n" + e);
                                    e.printStackTrace(Log.getWriter());
                                }
                            }
                            catch (IOException e) {
                                Log.errorDialog("ERROR", "Can't copy spacecraft file: " + listOfFiles[i].getName() + " to " + targetFile.getName() + "\n" + e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    } else if (targetFile.lastModified() < listOfFiles[i].lastModified()) {
                        Log.println("Copying spacecraft file: " + listOfFiles[i].getName() + " to " + targetFile.getName());
                        try {
                            try {
                                Spacecraft satellite = new Spacecraft(this, listOfFiles[i], targetFile);
                                try {
                                    SatPayloadStore.remove(targetFile.getAbsolutePath());
                                }
                                catch (IOException e) {
                                    Log.errorDialog("ERROR removing existing File", "\nCould not overwrite the existing spacecraft file\n" + e.getMessage());
                                    e.printStackTrace(Log.getWriter());
                                }
                                satellite.save();
                            }
                            catch (LayoutLoadException e) {
                                e.printStackTrace(Log.getWriter());
                            }
                        }
                        catch (IOException e) {
                            Log.errorDialog("ERROR", "Can't copy spacecraft file: " + listOfFiles[i].getName() + " to " + targetFile.getName() + "\n" + e.getMessage());
                            e.printStackTrace();
                        }
                    } else {
                        Log.println("Leaving existing spacecraft file: " + targetFile.getName());
                    }
                }
                ++i;
            }
        }
    }

    private File getFolder(File masterFolder) {
        File folder = new File(String.valueOf(Config.getLogFileDirectory()) + Spacecraft.SPACECRAFT_DIR);
        if (!folder.isDirectory()) {
            folder.mkdir();
        }
        if (!folder.isDirectory()) {
            Log.errorDialog("ERROR", "ERROR can't create the directory: " + folder.getAbsolutePath() + "\nFoxTelem needs to save the spacecraft settings in your logfile directroy.  It is either not accessible or not writable\n");
        }
        this.copyDatFiles(masterFolder, folder);
        Log.println("Set Logfile Spacecraft directory to: " + folder);
        return folder;
    }

    private void loadFormats(File masterFolder) {
        File[] listOfFiles = masterFolder.listFiles();
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile() && listOfFiles[i].getName().endsWith(".format")) {
                    Log.println("Loading format from: " + listOfFiles[i].getName());
                    try {
                        TelemFormat format = new TelemFormat(listOfFiles[i].getAbsolutePath());
                        this.telemFormats.add(format);
                    }
                    catch (LayoutLoadException e) {
                        Log.errorDialog("ERROR loading telem format " + listOfFiles[i].getAbsolutePath(), String.valueOf(e.getMessage()) + "\nThis format will not be loaded");
                        e.printStackTrace(Log.getWriter());
                    }
                }
                ++i;
            }
        }
    }

    private void loadSats(File masterFolder, File folder) {
        File[] listOfFiles = folder.listFiles();
        Pattern pattern = Pattern.compile("AO-73");
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile() && listOfFiles[i].getName().endsWith(".dat")) {
                    Log.println("Loading spacecraft from: " + listOfFiles[i].getName());
                    String masterFile = listOfFiles[i].getName().replace(".dat", ".MASTER");
                    File masterFileName = new File(String.valueOf(masterFolder.getAbsolutePath()) + File.separator + masterFile);
                    Spacecraft satellite = null;
                    try {
                        int sources;
                        Matcher matcher = pattern.matcher(listOfFiles[i].getName());
                        satellite = matcher.find() ? new FUNcubeSpacecraft(this, masterFileName, listOfFiles[i]) : new Spacecraft(this, masterFileName, listOfFiles[i]);
                        int frameLayouts = satellite.numberOfFrameLayouts;
                        if (frameLayouts > 0) {
                            Log.println("Frame Layouts: " + frameLayouts);
                            int k = 0;
                            while (k < frameLayouts) {
                                Log.println(" : " + satellite.frameLayout[k].name);
                                Log.println(" : " + satellite.frameLayout[k].getNumberOfPayloads() + " payloads");
                                Log.println("");
                                ++k;
                            }
                        }
                        if ((sources = satellite.numberOfSources) > 0) {
                            Log.println("Sources: " + sources);
                            int k = 0;
                            while (k < sources) {
                                Log.println(satellite.sourceName[k]);
                                if (satellite.sourceFormat != null && satellite.sourceFormat[k] != null) {
                                    Log.println(" : " + satellite.sourceFormat[k].name);
                                    Log.println(" - frame length: " + satellite.sourceFormat[k].getFrameLength());
                                    Log.println(" - data length: " + satellite.sourceFormat[k].getInt("data_length"));
                                    Log.println(" - header length: " + satellite.sourceFormat[k].getInt("header_length"));
                                    Log.println(" - trailer length: " + satellite.sourceFormat[k].getTrailerLength());
                                    Log.println(" - rs words: " + satellite.sourceFormat[k].getInt("rs_words"));
                                    Log.println(" - padding: ");
                                    int[] padding = satellite.sourceFormat[k].getPaddingArray();
                                    int p = 0;
                                    while (p < padding.length) {
                                        Log.print(" " + padding[p]);
                                        ++p;
                                    }
                                    Log.println("");
                                }
                                ++k;
                            }
                        }
                    }
                    catch (FileNotFoundException e) {
                        Log.errorDialog("ERROR processing " + listOfFiles[i].getName(), String.valueOf(e.getMessage()) + "\n\nIf this is an old Enginnering Model file that ends in _em, then try " + "removing it from the spacecrat menu\n" + "(even though it will not be shown in the list) and then re-add the Flight Model.\n" + "This satellite will not be loaded");
                        e.printStackTrace(Log.getWriter());
                        satellite = null;
                    }
                    catch (LayoutLoadException e) {
                        Log.errorDialog("ERROR processing " + listOfFiles[i].getName(), String.valueOf(e.getMessage()) + "\n\nIf this is an old Enginnering Model file that ends in _em, then try " + "removing it from the spacecrat menu\n" + "(even though it will not be shown in the list) and then re-add the Flight Model.\n" + "This satellite will not be loaded");
                        e.printStackTrace(Log.getWriter());
                        satellite = null;
                    }
                    catch (IOException e) {
                        Log.errorDialog("IO ERROR processing " + listOfFiles[i].getName(), String.valueOf(e.getMessage()) + "\nThis satellite will not be loaded");
                        e.printStackTrace(Log.getWriter());
                    }
                    if (satellite != null) {
                        if (this.getSpacecraft(satellite.foxId) != null) {
                            Log.errorDialog("WARNING", "Can not load two satellites with the same Fox ID.  Skipping file\n" + listOfFiles[i].getName());
                        } else {
                            this.spacecraftList.add(satellite);
                        }
                    }
                }
                ++i;
            }
        }
        Collections.sort(this.spacecraftList);
    }

    public BitArrayLayout getLayoutByName(int sat, String name) {
        if (!this.validFoxId(sat)) {
            return null;
        }
        Spacecraft sc = this.getSpacecraft(sat);
        if (sc != null) {
            return sc.getLayoutByName(name);
        }
        return null;
    }

    public BitArrayLayout getLayoutByCanId(int sat, int id) {
        if (!this.validFoxId(sat)) {
            return null;
        }
        Spacecraft sc = this.getSpacecraft(sat);
        if (sc != null) {
            return sc.getLayoutByCanId(id);
        }
        return null;
    }

    public FrameLayout getFrameLayout(int sat, int type) {
        if (!this.validFoxId(sat)) {
            return null;
        }
        Spacecraft sc = this.getSpacecraft(sat);
        if (sc != null && sc.frameLayout != null) {
            if (type >= sc.frameLayout.length) {
                return null;
            }
            return sc.frameLayout[type];
        }
        return null;
    }

    public BitArrayLayout getMeasurementLayout(int sat) {
        if (!this.validFoxId(sat)) {
            return null;
        }
        Spacecraft sc = this.getSpacecraft(sat);
        if (sc != null) {
            return sc.measurementLayout;
        }
        return null;
    }

    public BitArrayLayout getPassMeasurementLayout(int sat) {
        if (!this.validFoxId(sat)) {
            return null;
        }
        Spacecraft sc = this.getSpacecraft(sat);
        if (sc != null) {
            return sc.passMeasurementLayout;
        }
        return null;
    }

    public ArrayList<Spacecraft> getSpacecraftList() {
        return this.spacecraftList;
    }

    public int getNumberOfSpacecraft() {
        return this.spacecraftList.size();
    }

    public boolean hasCamera(int sat) {
        if (!this.validFoxId(sat)) {
            return false;
        }
        Spacecraft s = this.getSpacecraft(sat);
        return s.hasCamera();
    }

    public boolean hasHerci(int sat) {
        if (!this.validFoxId(sat)) {
            return false;
        }
        Spacecraft s = this.getSpacecraft(sat);
        return s.hasHerci();
    }

    public boolean haveSpacecraftDisplayName(String name) {
        int i = 0;
        while (i < this.spacecraftList.size()) {
            if (this.spacecraftList.get((int)i).user_display_name.equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getFormats() {
        Object[] data = new String[this.telemFormats.size()];
        int i = 0;
        while (i < this.telemFormats.size()) {
            data[i] = this.telemFormats.get((int)i).name;
            ++i;
        }
        Arrays.sort(data);
        return data;
    }

    public TelemFormat getFormatByName(String name) {
        int i = 0;
        while (i < this.telemFormats.size()) {
            if (this.telemFormats.get((int)i).name.equalsIgnoreCase(name)) {
                return this.telemFormats.get(i);
            }
            ++i;
        }
        return null;
    }

    public TelemFormat getFormatBySource(String name) {
        int s = 0;
        while (s < this.spacecraftList.size()) {
            Spacecraft fox = this.spacecraftList.get(s);
            int i = 0;
            while (i < fox.sourceName.length) {
                if (fox.sourceName[i].equalsIgnoreCase(name)) {
                    return this.getFormatByName(fox.sourceFormatName[i]);
                }
                ++i;
            }
            ++s;
        }
        return null;
    }

    public TelemFormat getFormatBySource(int sat, String name) {
        Spacecraft fox = this.getSpacecraft(sat);
        int i = 0;
        while (i < fox.sourceName.length) {
            if (fox.sourceName[i].equalsIgnoreCase(name)) {
                return this.getFormatByName(fox.sourceFormatName[i]);
            }
            ++i;
        }
        return null;
    }

    public TelemFormat getFormatByFrameLength(int len) {
        int i = 0;
        while (i < this.telemFormats.size()) {
            if (this.telemFormats.get(i).getFrameLength() == len) {
                return this.telemFormats.get(i);
            }
            ++i;
        }
        return null;
    }

    public Spacecraft getSpacecraftByDisplayName(String name) {
        int i = 0;
        while (i < this.spacecraftList.size()) {
            if (this.spacecraftList.get((int)i).user_display_name.equalsIgnoreCase(name)) {
                return this.spacecraftList.get(i);
            }
            ++i;
        }
        return null;
    }

    public Spacecraft getSpacecraftByKepsName(String name) {
        int i = 0;
        while (i < this.spacecraftList.size()) {
            if (this.spacecraftList.get((int)i).user_keps_name.equalsIgnoreCase(name)) {
                return this.spacecraftList.get(i);
            }
            ++i;
        }
        return null;
    }

    public Spacecraft getSpacecraft(int sat) {
        int i = 0;
        while (i < this.spacecraftList.size()) {
            if (this.spacecraftList.get((int)i).foxId == sat) {
                return this.spacecraftList.get(i);
            }
            ++i;
        }
        return null;
    }

    public boolean validFoxId(int id) {
        return id > 0 && id <= 256;
    }

    public void loadTLEFile() {
        String file = String.valueOf(Spacecraft.SPACECRAFT_DIR) + File.separator + "nasabare.txt";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            file = String.valueOf(Config.logFileDirectory) + File.separator + Spacecraft.SPACECRAFT_DIR + File.separator + "nasabare.txt";
        }
        Log.println("Loading TLE file: " + file);
        try {
            this.parseTleFile(file);
        }
        catch (IOException e) {
            Log.println("... Could not read Keps file: " + file);
        }
    }

    /*
     * Loose catch block
     */
    public void fetchTLEFile() {
        block41: {
            Log.println("Checking for new Keps");
            String urlString = AMSAT_NASA_ALL;
            String file = String.valueOf(Spacecraft.SPACECRAFT_DIR) + File.separator + "nasabare.txt";
            String filetmp = String.valueOf(file) + ".tmp";
            if (!Config.logFileDirectory.equalsIgnoreCase("")) {
                file = String.valueOf(Config.logFileDirectory) + File.separator + Spacecraft.SPACECRAFT_DIR + File.separator + "nasabare.txt";
                filetmp = String.valueOf(file) + ".tmp";
            }
            File f1 = new File(filetmp);
            File f2 = new File(file);
            String msg = "Downloading new keps ...                 ";
            ProgressPanel initProgress = null;
            if (Log.showGuiDialogs) {
                initProgress = new ProgressPanel(MainWindow.frame, msg, false);
                initProgress.setVisible(true);
            }
            Log.println("Downloading new keps ..");
            FileOutputStream fos = null;
            Channel rbc = null;
            try {
                try {
                    URL website = new URL(urlString);
                    HttpURLConnection httpCon = (HttpURLConnection)website.openConnection();
                    httpCon.setReadTimeout(1000);
                    httpCon.disconnect();
                    Log.println(" ... open RBC ..");
                    rbc = Channels.newChannel(website.openStream());
                    Log.println(" ... open output file .." + filetmp);
                    fos = new FileOutputStream(filetmp);
                    Log.println(" ... getting file ..");
                    fos.getChannel().transferFrom((ReadableByteChannel)rbc, 0L, Long.MAX_VALUE);
                    Log.println(" ... closing outpt stream ..");
                    fos.close();
                    Log.println(" ... closing input stream ..");
                    rbc.close();
                    File tmp = new File(filetmp);
                    if (!tmp.exists()) break block41;
                    Log.println(" ... parsing file ..");
                    this.parseTleFile(filetmp);
                    Log.println(" ... remove and rename ..");
                    if (!file.equalsIgnoreCase(filetmp)) {
                        SatPayloadStore.remove(file);
                        SatPayloadStore.copyFile(f1, f2);
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (!file.equalsIgnoreCase(filetmp)) {
                        SatPayloadStore.remove(String.valueOf(file) + ".tmp");
                    }
                }
                catch (MalformedURLException e) {
                    Log.println("Invalid location for Keps file: " + file);
                    try {
                        SatPayloadStore.remove(String.valueOf(file) + ".tmp");
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    if (Log.showGuiDialogs) {
                        initProgress.updateProgress(100);
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        if (rbc != null) {
                            rbc.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                catch (IOException e) {
                    block42: {
                        Log.println("Could not write Keps file: " + file);
                        try {
                            SatPayloadStore.remove(String.valueOf(file) + ".tmp");
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        if (!Log.showGuiDialogs) break block42;
                        initProgress.updateProgress(100);
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        if (rbc != null) {
                            rbc.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                catch (IndexOutOfBoundsException e) {
                    block43: {
                        Log.println("Keps file is corrupt: " + file);
                        try {
                            SatPayloadStore.remove(String.valueOf(file) + ".tmp");
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        if (!Log.showGuiDialogs) break block43;
                        initProgress.updateProgress(100);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        if (rbc != null) {
                            rbc.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (Log.showGuiDialogs) {
                    initProgress.updateProgress(100);
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    if (rbc != null) {
                        rbc.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private SortedTleList parseTleFile(String filename) throws IOException {
        File f = new File(filename);
        try (FileInputStream is = new FileInputStream(f);){
            SortedTleList tles = FoxTLE.importFoxSat(is);
            ((InputStream)is).close();
            for (FoxTLE ftle : tles) {
                String name = ftle.getName();
                Spacecraft spacecraft = this.getSpacecraftByKepsName(name);
                if (spacecraft == null) continue;
                Log.println("Stored TLE for: " + name);
                spacecraft.addTLE(ftle);
            }
            SortedTleList sortedTleList = tles;
            return sortedTleList;
        }
    }

    public void stop() {
        this.running = false;
        while (!this.done) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!Config.foxTelemCalcsPosition) continue;
            int s = 0;
            while (s < this.spacecraftList.size()) {
                Spacecraft sat = this.spacecraftList.get(s);
                if (sat.user_track && Config.GROUND_STATION != null) {
                    if (Config.GROUND_STATION.getLatitude() == 0.0 && Config.GROUND_STATION.getLongitude() == 0.0) {
                        sat.user_track = false;
                        sat.save();
                        Log.errorDialog("MISSING GROUND STATION", "FoxTelem is configured to calculate the spacecraft position, but your ground station\nis not defined.  Go to the settings tab and setup the ground station position or turn of calculation of the spacecraft position.\nTracking will be disabled for " + sat.user_display_name + ".");
                        sat.satPos = null;
                    } else {
                        try {
                            sat.calcualteCurrentPosition();
                        }
                        catch (PositionCalcException e) {
                            sat.satPos = null;
                        }
                    }
                }
                ++s;
            }
        }
        this.done = true;
    }
}

