/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import decoder.FoxBitStream;
import decoder.FoxDecoder;
import decoder.LookupException;

public class Code8b10b {
    public static final int NOT_FRAME = 250;
    public static final int FRAME = 773;
    public static final int[][] Encode_8b10b = new int[][]{{628, 468, 724, 1819, 852, 1691, 1435, 1931, 916, 1627, 1371, 1867, 1243, 1739, 1483, 372, 436, 1595, 1339, 1835, 1211, 1707, 1451, 932, 820, 1643, 1387, 868, 1259, 740, 484, 692, 1657, 1497, 1753, 793, 1881, 665, 409, 905, 1945, 601, 345, 841, 217, 713, 457, 1401, 1465, 569, 313, 809, 185, 681, 425, 1961, 1849, 617, 361, 1897, 233, 1769, 1513, 1721, 1653, 1493, 1749, 789, 1877, 661, 405, 901, 1941, 597, 341, 837, 213, 709, 453, 1397, 1461, 565, 309, 805, 181, 677, 421, 1957, 1845, 613, 357, 1893, 229, 1765, 1509, 1717, 1651, 1491, 1747, 796, 1875, 668, 412, 908, 1939, 604, 348, 844, 220, 716, 460, 1395, 1459, 572, 316, 812, 188, 684, 428, 1955, 1843, 620, 364, 1891, 236, 1763, 1507, 1715, 626, 466, 722, 1821, 850, 1693, 1437, 1933, 914, 1629, 1373, 1869, 1245, 1741, 1485, 370, 434, 1597, 1341, 1837, 1213, 1709, 1453, 930, 818, 1645, 1389, 866, 1261, 738, 482, 690, 1658, 1498, 1754, 794, 1882, 666, 410, 906, 1946, 602, 346, 842, 218, 714, 458, 1402, 1466, 570, 314, 810, 186, 682, 426, 1962, 1850, 618, 362, 1898, 234, 1770, 1514, 1722, 1654, 1494, 1750, 790, 1878, 662, 406, 902, 1942, 598, 342, 838, 214, 710, 454, 1398, 1462, 566, 310, 806, 182, 678, 422, 1958, 1846, 614, 358, 1894, 230, 1766, 1510, 1718, 625, 465, 721, 1822, 849, 1694, 1438, 1934, 913, 1630, 1374, 1870, 1246, 1742, 1486, 369, 433, 1591, 1335, 1838, 1207, 1710, 1454, 929, 817, 1646, 1390, 865, 1262, 737, 481, 689}, {1419, 1579, 1323, 788, 1195, 660, 404, 116, 1131, 596, 340, 836, 212, 708, 452, 1675, 1611, 564, 308, 804, 180, 676, 420, 1115, 1227, 612, 356, 1179, 228, 1307, 1563, 1355, 393, 553, 297, 1817, 169, 1689, 1433, 1145, 105, 1625, 1369, 1865, 1241, 1737, 1481, 649, 585, 1593, 1337, 1833, 1209, 1705, 1449, 89, 201, 1641, 1385, 153, 1257, 281, 537, 329, 389, 549, 293, 1813, 165, 1685, 1429, 1141, 101, 1621, 1365, 1861, 1237, 1733, 1477, 645, 581, 1589, 1333, 1829, 1205, 1701, 1445, 85, 197, 1637, 1381, 149, 1253, 277, 533, 325, 396, 556, 300, 1811, 172, 1683, 1427, 1139, 108, 1619, 1363, 1859, 1235, 1731, 1475, 652, 588, 1587, 1331, 1827, 1203, 1699, 1443, 92, 204, 1635, 1379, 156, 1251, 284, 540, 332, 1421, 1581, 1325, 786, 1197, 658, 402, 114, 1133, 594, 338, 834, 210, 706, 450, 1677, 1613, 562, 306, 802, 178, 674, 418, 1117, 1229, 610, 354, 1181, 226, 1309, 1565, 1357, 394, 554, 298, 1818, 170, 1690, 1434, 1146, 106, 1626, 1370, 1866, 1242, 1738, 1482, 650, 586, 1594, 1338, 1834, 1210, 1706, 1450, 90, 202, 1642, 1386, 154, 1258, 282, 538, 330, 390, 550, 294, 1814, 166, 1686, 1430, 1142, 102, 1622, 1366, 1862, 1238, 1734, 1478, 646, 582, 1590, 1334, 1830, 1206, 1702, 1446, 86, 198, 1638, 1382, 150, 1254, 278, 534, 326, 1422, 1582, 1326, 785, 1198, 657, 401, 113, 1134, 593, 337, 840, 209, 712, 456, 1678, 1614, 561, 305, 801, 177, 673, 417, 1118, 1230, 609, 353, 1182, 225, 1310, 1566, 1358}};

    public static byte decode(int word, boolean flip) throws LookupException {
        if (flip) {
            word = ~word & 0x3FF;
        }
        int rd = 0;
        while (rd < 2) {
            int i = 0;
            while (i < 256) {
                int testValue = Encode_8b10b[rd][i];
                if ((testValue & 0x3FF) == word) {
                    return (byte)i;
                }
                ++i;
            }
            ++rd;
        }
        throw new LookupException();
    }

    public static void printAll10bwords() {
        int rd = 0;
        while (rd < 2) {
            System.out.println("************* RD: " + rd + " **************");
            int i = 0;
            while (i < 256) {
                int testValue = Encode_8b10b[rd][i];
                System.out.print(String.valueOf(FoxDecoder.hex(testValue)) + ": ");
                int nextRd = Code8b10b.getNextRd(testValue, false);
                boolean[] bit10b = FoxBitStream.intToBin10(testValue &= 0x3FF);
                int j = 0;
                while (j < bit10b.length) {
                    if (bit10b[j]) {
                        System.out.print("1 ");
                    } else {
                        System.out.print("0 ");
                    }
                    ++j;
                }
                System.out.println(" Next rd: " + nextRd);
                ++i;
            }
            ++rd;
        }
    }

    public static boolean[] encode(int word) {
        int word10b = Encode_8b10b[0][word];
        return FoxBitStream.intToBin10(word10b);
    }

    public static int getNextRd(int word, boolean flip) {
        if (flip) {
            word = ~word & 0x3FF;
        }
        int rd = 0;
        while (rd < 2) {
            int i = 0;
            while (i < 256) {
                int testValue = Encode_8b10b[rd][i];
                if ((testValue & 0x3FF) == word) {
                    int state = testValue >> 10 & 1;
                    return state;
                }
                ++i;
            }
            ++rd;
        }
        return -99;
    }

    public static int getRdSense10b(int word, boolean flip) {
        if (flip) {
            word = ~word & 0x3FF;
        }
        int rd = 0;
        while (rd < 2) {
            int i = 0;
            while (i < 256) {
                int testValue = Encode_8b10b[rd][i];
                if ((testValue & 0x3FF) == word) {
                    return rd;
                }
                ++i;
            }
            ++rd;
        }
        return -99;
    }
}

