/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Config;
import common.Log;
import common.Performance;
import common.Spacecraft;
import decoder.EyeData;
import decoder.Fox9600bpsDecoder;
import decoder.FoxBPSK.FoxBPSKCostasDecoder;
import decoder.FoxBPSK.FoxBPSKDecoder;
import decoder.FoxBPSK.FoxBPSKDotProdDecoder;
import decoder.FoxBitStream;
import decoder.SinkAudio;
import decoder.SourceAudio;
import decoder.SourceIQ;
import filter.Filter;
import gui.MainWindow;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JOptionPane;
import measure.RtMeasurement;
import predict.PositionCalcException;
import telemetry.Format.TelemFormat;
import telemetry.FramePart;
import telemetry.frames.Frame;
import uk.me.g4dpz.satellite.SatPos;

public abstract class Decoder
implements Runnable {
    public String name = "";
    public TelemFormat telemFormat;
    protected SourceAudio audioSource;
    protected Thread audioReadThread;
    int audioChannel = 0;
    protected int BITS_PER_SECOND = 0;
    public boolean flipReceivedBits;
    private boolean bigEndian = false;
    private int bitsPerSample = 16;
    protected int bytesPerSample = 4;
    private int channels = 2;
    boolean stereo;
    public static final int MONO = 1;
    public static final int STEREO = 2;
    protected int currentSampleRate = 48000;
    protected int bucketSize = 0;
    protected int SAMPLE_WINDOW_LENGTH = 70;
    protected int SAMPLE_WIDTH_PERCENT = 10;
    protected int SAMPLE_WIDTH = 0;
    protected int CLOCK_TOLERANCE = 10;
    protected int CLOCK_REOVERY_ZERO_THRESHOLD = 20;
    public static final int MAX_VOLUME = 32000;
    public static final int MIN_VOLUME = 600;
    protected int BUFFER_SIZE = 0;
    protected double[] abBufferDouble;
    protected double[] abBufferDoubleFiltered;
    protected boolean dataFresh = false;
    protected int[][] dataValues = null;
    public EyeData eyeData;
    private int[] maxValue = null;
    private int[] minValue = null;
    private int[] firstZero = null;
    private int[] secondZero = null;
    public boolean[] middleSample = null;
    protected FoxBitStream bitStream = null;
    protected int averageMax;
    protected int averageMin;
    protected int zeroValue;
    protected int sampleNumber = 0;
    protected int framesDecoded = 0;
    private boolean squelch = true;
    private boolean tooLoud = false;
    private boolean clockLocked = false;
    private boolean processing = true;
    private boolean done = true;
    protected Filter filter = null;
    public Filter monitorFilter = null;
    private SinkAudio sink = null;
    private boolean monitorAudio = false;
    public Frame decodedFrame = null;
    int debugWindowCount = 0;

    public Decoder(String n, SourceAudio as, int chan, TelemFormat telemFormat) {
        this.name = n;
        this.audioSource = as;
        this.audioChannel = chan;
        AudioFormat audioFormat = as.getAudioFormat();
        this.currentSampleRate = (int)audioFormat.getSampleRate();
        this.bitsPerSample = audioFormat.getSampleSizeInBits();
        this.bigEndian = audioFormat.isBigEndian();
        this.channels = audioFormat.getChannels();
        this.bytesPerSample = audioFormat.getFrameSize();
        this.telemFormat = telemFormat;
        this.init();
    }

    public AudioFormat getAudioFormat() {
        return this.audioSource.getAudioFormat();
    }

    public int getCurrentSampleRate() {
        return this.currentSampleRate;
    }

    public int getFramesDecoded() {
        return this.framesDecoded;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public int getSampleWindowLength() {
        return this.SAMPLE_WINDOW_LENGTH;
    }

    protected abstract void init();

    protected abstract void sampleBuckets();

    protected abstract int recoverClockOffset();

    protected abstract void processBitsWindow();

    public Filter getFilter() {
        return this.filter;
    }

    public boolean getBigEndian() {
        return this.bigEndian;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    protected void initWindowData() {
        this.dataValues = new int[this.SAMPLE_WINDOW_LENGTH][];
        this.maxValue = new int[this.SAMPLE_WINDOW_LENGTH];
        this.minValue = new int[this.SAMPLE_WINDOW_LENGTH];
        this.firstZero = new int[this.SAMPLE_WINDOW_LENGTH];
        this.secondZero = new int[this.SAMPLE_WINDOW_LENGTH];
        this.middleSample = new boolean[this.SAMPLE_WINDOW_LENGTH];
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            this.dataValues[i] = new int[this.bucketSize];
            ++i;
        }
        this.eyeData = new EyeData(this.SAMPLE_WINDOW_LENGTH, this.bucketSize);
    }

    protected void resetWindowData() {
        int j = 0;
        while (j < this.SAMPLE_WINDOW_LENGTH) {
            int i = 0;
            while (i < this.bucketSize) {
                this.dataValues[j][i] = 0;
                ++i;
            }
            this.maxValue[j] = 0;
            this.minValue[j] = 0;
            this.firstZero[j] = 0;
            this.secondZero[j] = 0;
            this.middleSample[j] = false;
            ++j;
        }
    }

    public void stopProcessing() {
        this.cleanup();
        this.processing = false;
        Log.println("DECODER STOPPING");
    }

    public boolean isDone() {
        return this.done;
    }

    protected void startAudioThread() {
        if (this.audioChannel == 0 || this.audioSource instanceof SourceIQ) {
            if (this.audioReadThread != null) {
                this.audioSource.stop("Decoder:startAudioThread");
            }
            this.audioReadThread = new Thread(this.audioSource);
            this.audioReadThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
            this.audioReadThread.start();
        }
    }

    public boolean toggleAudioMonitor(SinkAudio s, boolean monitorFiltered, int position) throws LineUnavailableException {
        this.sink = s;
        Config.monitorFilteredAudio = monitorFiltered;
        boolean bl = this.monitorAudio = !this.monitorAudio;
        if (!this.monitorAudio) {
            if (this.sink != null) {
                this.sink.closeOutput();
            }
            this.sink = null;
        } else if (this.sink != null) {
            this.sink.setDevice(position);
        }
        return this.monitorAudio;
    }

    public void stopAudioMonitor() throws LineUnavailableException {
        if (this.sink != null) {
            if (this.monitorAudio) {
                this.monitorAudio = false;
            }
            this.sink.flush();
            this.sink.closeOutput();
        }
        this.sink = null;
    }

    public void setMonitorAudio(SinkAudio s, boolean m, int position) throws IllegalArgumentException, LineUnavailableException {
        if (this.sink == null) {
            this.sink = s;
            this.monitorAudio = m;
            if (this.monitorAudio) {
                this.sink.setDevice(position);
            }
        } else {
            this.sink = s;
            this.monitorAudio = m;
            if (!this.monitorAudio) {
                this.sink.flush();
                this.sink.closeOutput();
                this.sink = null;
            }
        }
    }

    public int getAudioBufferSize() {
        return this.audioSource.getAudioBufferSize();
    }

    public int getAudioBufferCapacity() {
        return this.audioSource.getAudioBufferCapacity();
    }

    public double[] getAudioData() {
        if (!this.dataFresh) {
            return null;
        }
        this.dataFresh = false;
        return this.abBufferDouble;
    }

    public double[] getFilteredData() {
        if (!this.dataFresh) {
            return null;
        }
        this.dataFresh = false;
        return this.abBufferDoubleFiltered;
    }

    public int getZeroValue() {
        return this.zeroValue;
    }

    public EyeData getEyeData() {
        if (this.eyeData != null && this.eyeData.isFresh()) {
            this.eyeData.setFreshData(false);
            return this.eyeData;
        }
        return null;
    }

    public boolean isSoundCardDecoder() {
        return false;
    }

    public boolean isSoundWavDecoder() {
        return false;
    }

    @Override
    public void run() {
        Log.println("DECODER Start");
        Thread.currentThread().setName("Decoder");
        try {
            this.process();
        }
        catch (UnsupportedAudioFileException e) {
            JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "ERROR", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "ERROR", 0);
        }
        catch (NullPointerException e) {
            String stacktrace = Log.makeShortTrace(e.getStackTrace());
            Log.errorDialog("FATAL ERROR IN DECODER", "Uncaught null exception." + e.getMessage() + "\nYou probablly need to restart FoxTelem:\n" + stacktrace);
        }
        catch (Exception e) {
            String stacktrace = Log.makeShortTrace(e.getStackTrace());
            Log.errorDialog("UNEXPECTED ERROR IN DECODER", "Uncaught exception." + e + "\nYou probablly need to restart FoxTelem:\n" + stacktrace);
        }
        Log.println("DECODER Exit");
    }

    protected int read(double[] abData) {
        int nBytesRead = 0;
        nBytesRead = this.audioSource.read(abData, this.audioChannel);
        return nBytesRead;
    }

    protected void rewind(int amount) {
        this.audioSource.rewind(amount, this.audioChannel);
    }

    public void process() throws UnsupportedAudioFileException, IOException {
        Log.println("Decoder using sample rate: " + this.currentSampleRate);
        Log.println("Decoder using bucketSize: " + this.bucketSize);
        Log.println("Decoder using SAMPLE_WIDTH: " + this.SAMPLE_WIDTH);
        Log.println("Decoder using BUFFER_SIZE: " + this.BUFFER_SIZE);
        Log.println("Decoder using BITS_PER_SECOND: " + this.BITS_PER_SECOND);
        Log.println("Decoder CHANNELS: " + this.channels);
        this.stereo = true;
        if (this.audioSource.audioFormat.getChannels() == 1) {
            this.stereo = false;
        }
        int nBytesRead = 0;
        this.abBufferDouble = new double[this.BUFFER_SIZE];
        this.abBufferDoubleFiltered = new double[this.BUFFER_SIZE];
        if (Config.filterData) {
            Log.println("FILTER: " + this.filter.toString());
        }
        Log.println("BUFFER: " + this.BUFFER_SIZE);
        this.startAudioThread();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        while (nBytesRead != -1 && this.processing && !this.audioSource.isDone()) {
            double[] clockAdvance;
            Performance.startTimer("Setup");
            this.resetWindowData();
            Performance.endTimer("Setup");
            if (nBytesRead >= 0) {
                double[] buffer2;
                Performance.startTimer("Read");
                nBytesRead = this.read(this.abBufferDouble);
                if (this.monitorAudio && !this.squelch && !(this instanceof FoxBPSKDotProdDecoder) && !Config.monitorFilteredAudio && this.sink != null) {
                    try {
                        buffer2 = this.abBufferDouble;
                        if (this instanceof FoxBPSKCostasDecoder) {
                            buffer2 = Arrays.copyOfRange(this.abBufferDouble, 0, this.abBufferDouble.length);
                        }
                        this.sink.write(buffer2);
                    }
                    catch (Exception buffer2) {
                        // empty catch block
                    }
                }
                if (Config.debugBytes && nBytesRead != this.abBufferDouble.length) {
                    Log.println("ERROR: COULD NOT READ FULL BUFFER");
                }
                Performance.endTimer("Read");
                Performance.startTimer("Filter");
                if (Config.filterData) {
                    this.filter.filter(this.abBufferDouble, this.abBufferDoubleFiltered);
                } else {
                    this.abBufferDoubleFiltered = this.abBufferDouble;
                }
                Performance.endTimer("Filter");
                Performance.startTimer("Monitor");
                if (this.monitorAudio && !this.squelch && (this instanceof FoxBPSKDotProdDecoder || Config.monitorFilteredAudio) && this.sink != null) {
                    try {
                        buffer2 = this.abBufferDoubleFiltered;
                        if (this instanceof FoxBPSKDotProdDecoder) {
                            buffer2 = Arrays.copyOfRange(this.abBufferDoubleFiltered, 0, ((FoxBPSKDotProdDecoder)this).samples_processed);
                        }
                        this.sink.write(buffer2);
                    }
                    catch (Exception buffer3) {
                        // empty catch block
                    }
                }
                Performance.endTimer("Monitor");
                Performance.startTimer("Bucket");
                this.bucketData(this.abBufferDoubleFiltered);
                Performance.endTimer("Bucket");
            }
            Config.windowStartBit = (int)(this.bitStream.getStartOfWindowBit() + 1L);
            Performance.startTimer("Sample");
            this.sampleBuckets();
            Performance.endTimer("Sample");
            Performance.startTimer("ClockSync");
            if (!this.clockLocked && (clockAdvance = this.recoverClock(1)) != null && Config.recoverClock) {
                this.rebucketData(this.abBufferDoubleFiltered, clockAdvance);
            }
            this.eyeData.calcAverages();
            if (this.monitorAudio && Config.squelchAudio) {
                if (this.eyeData.bitSNR < Config.BIT_SNR_THRESHOLD) {
                    if (!this.squelch) {
                        Log.println("No telemetry, squelched ...");
                        if (this.sink != null) {
                            this.sink.flush();
                        }
                    }
                    this.squelch = true;
                } else {
                    if (this.squelch) {
                        Log.println("Attempting to decode ...");
                    }
                    this.squelch = false;
                }
            } else {
                this.squelch = false;
            }
            this.dataFresh = true;
            this.eyeData.setFreshData(true);
            Performance.endTimer("ClockSync");
            Performance.startTimer("BitsWindow");
            this.processBitsWindow();
            Performance.endTimer("BitsWindow");
            if (!Config.debugValues) continue;
            if (!Config.decoderPlay) {
                while (Config.decoderPaused && !Config.decoderPlay) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            Config.decoderPaused = true;
            ++Config.windowsProcessed;
        }
        if (this.sink != null) {
            this.sink.closeOutput();
        }
        Log.println("Frames Decoded: " + this.framesDecoded);
        this.cleanup();
        this.done = true;
        Performance.printResults();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double[] recoverClock(int factor) {
        int transitionPoint = 0;
        transitionPoint = this.recoverClockOffset();
        if (transitionPoint > this.bucketSize / this.CLOCK_TOLERANCE && transitionPoint < this.bucketSize - this.bucketSize / this.CLOCK_TOLERANCE) {
            int nBytesRead;
            int clockAdvance = transitionPoint - this.bucketSize / this.CLOCK_TOLERANCE;
            double[] clockData = new double[clockAdvance * factor];
            if (Config.debugClock) {
                Log.println("Advancing clock " + clockAdvance / this.bytesPerSample + " samples");
            }
            if ((nBytesRead = this.read(clockData)) == clockAdvance * factor) return clockData;
            if (!Config.debugClock) return null;
            Log.println("ERROR: Could not advance clock");
            return null;
        } else {
            if (!Config.debugClock) return null;
            Log.println("CLOCK STABLE");
            return null;
        }
    }

    protected void rebucketData(double[] abData, double[] clippedData) {
        this.appendClippedData(abData, clippedData);
        this.resetWindowData();
        this.bucketData(abData);
        this.sampleNumber -= this.SAMPLE_WINDOW_LENGTH;
        this.sampleBuckets();
    }

    protected void appendClippedData(double[] data, double[] clippedData) {
        int i = clippedData.length;
        while (i < data.length) {
            data[i - clippedData.length] = data[i];
            ++i;
        }
        i = 0;
        while (i < clippedData.length) {
            data[data.length - clippedData.length + i] = clippedData[i];
            ++i;
        }
    }

    public void cleanup() {
        if (this.audioSource != null) {
            this.audioSource.stop("Decoder:cleanup");
            while (!this.audioSource.isDone()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void bucketData(double[] abData) {
        int k = 0;
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            this.minValue[i] = 65536;
            int j = 0;
            while (j < this.bucketSize) {
                int value;
                this.dataValues[i][j] = value = (int)(abData[k] * 32768.0);
                if (!(this instanceof FoxBPSKDecoder || this instanceof FoxBPSKCostasDecoder || this instanceof FoxBPSKDotProdDecoder)) {
                    this.eyeData.setData(i, j, value);
                }
                if (value > this.maxValue[i]) {
                    this.maxValue[i] = value;
                }
                if (value < this.minValue[i]) {
                    this.minValue[i] = value;
                }
                ++k;
                ++j;
            }
            this.averageMax += this.maxValue[i];
            this.averageMin += this.minValue[i];
            ++i;
        }
        this.averageMax /= this.SAMPLE_WINDOW_LENGTH;
        this.averageMin /= this.SAMPLE_WINDOW_LENGTH;
        this.zeroValue = (this.averageMax + this.averageMin) / 2;
        if (this.averageMax > 32000) {
            if (!this.tooLoud) {
                Log.println("Input too loud ..." + this.averageMax);
            }
            this.tooLoud = true;
        } else {
            this.tooLoud = false;
        }
    }

    protected void addMeasurements(int id, int resets, long uptime, Frame frame, int lastErrorsNumber, int lastErasureNumber) {
        String satName2;
        if (Config.passManager.isNewPass()) {
            Log.println("Setting reset/uptime for new pass");
            Config.passManager.setStartResetUptime(id, resets, uptime);
        } else {
            Config.passManager.setLastResetUptime(id, resets, uptime);
        }
        RtMeasurement rtMeasurement = new RtMeasurement(id, resets, uptime, -1);
        rtMeasurement.setBitSNR(this.eyeData.bitSNR);
        rtMeasurement.setErrors(lastErrorsNumber);
        rtMeasurement.setErasures(lastErasureNumber);
        Spacecraft sat = Config.satManager.getSpacecraft(id);
        SatPos pos = null;
        if (Config.useDDEforAzEl) {
            if (Config.satPC != null && (satName2 = Config.satPC.getSatellite()) != null && satName2.equalsIgnoreCase(sat.user_keps_name)) {
                rtMeasurement.setAzimuth(Config.satPC.getAzimuth());
                rtMeasurement.setElevation(Config.satPC.getElevation());
            }
        } else if (Config.foxTelemCalcsPosition && Config.GROUND_STATION != null && (Config.GROUND_STATION.getLatitude() != 0.0 || Config.GROUND_STATION.getLongitude() != 0.0)) {
            sat = Config.satManager.getSpacecraft(id);
            try {
                pos = sat.getCurrentPosition();
                if (Config.debugFrames) {
                    Log.println("Fox at: " + resets + ":" + uptime + " - " + FramePart.latRadToDeg(pos.getLatitude()) + " : " + FramePart.lonRadToDeg(pos.getLongitude()));
                }
            }
            catch (PositionCalcException satName2) {
                // empty catch block
            }
            if (pos != null) {
                rtMeasurement.setAzimuth(FramePart.radToDeg(pos.getAzimuth()));
                rtMeasurement.setElevation(FramePart.radToDeg(pos.getElevation()));
            }
        }
        if (this.audioSource instanceof SourceIQ) {
            double freq = ((SourceIQ)this.audioSource).getTunedFrequency();
            double sig = ((SourceIQ)this.audioSource).rfData.getAvg(0);
            double rfSnr = ((SourceIQ)this.audioSource).rfData.rfSNRInFilterWidth;
            rtMeasurement.setCarrierFrequency((long)freq);
            rtMeasurement.setRfPower(sig);
            rtMeasurement.setRfSNR(rfSnr);
        } else if (Config.useDDEforFreq && Config.satPC != null && (satName2 = Config.satPC.getSatellite()) != null && satName2.equalsIgnoreCase(sat.user_keps_name)) {
            rtMeasurement.setCarrierFrequency(Config.satPC.getDownlinkFrequency());
        }
        Config.payloadStore.add(id, rtMeasurement);
        frame.setMeasurement(rtMeasurement);
    }

    protected void printBucketsValues() {
        int m = 0;
        while (m < 2) {
            System.out.println(-40000);
            ++m;
        }
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            int step = 10;
            int middle = 120;
            if (this instanceof Fox9600bpsDecoder) {
                step = 1;
                middle = 3;
            }
            if (this instanceof FoxBPSKDecoder) {
                step = 4;
                middle = 9999;
            }
            int j = 0;
            while (j < this.bucketSize) {
                if (j == middle) {
                    if (this.middleSample[i]) {
                        System.out.println(35000);
                    } else {
                        System.out.println(-35000);
                    }
                }
                System.out.println(String.valueOf(this.dataValues[i][j]) + " ");
                j += step;
            }
            ++i;
        }
    }

    public static void printBytes(byte[] b) {
        int i = 0;
        while (i < b.length) {
            System.out.print(String.valueOf(b[i]) + " ");
            ++i;
        }
    }

    public static void printBytesAndChars(byte[] b) {
        int i = 0;
        while (i < b.length) {
            char c = (char)b[i];
            System.out.print(String.valueOf(b[i]) + " " + c + " ");
            ++i;
        }
    }

    public static int littleEndian4(byte[] b) {
        byte b1 = b[0];
        byte b2 = b[1];
        byte b3 = b[2];
        byte b4 = b[3];
        int value = (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | (b1 & 0xFF) << 0;
        return value;
    }

    public static int bigEndian4(byte[] b) {
        byte b1 = b[0];
        byte b2 = b[1];
        byte b3 = b[2];
        byte b4 = b[3];
        int value = (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | (b4 & 0xFF) << 0;
        return value;
    }

    public static byte[] bigEndian4(int in) {
        byte[] b = new byte[]{(byte)(in >> 24 & 0xFF), (byte)(in >> 16 & 0xFF), (byte)(in >> 8 & 0xFF), (byte)(in >> 0 & 0xFF)};
        return b;
    }

    public static byte[] bigEndian8(long in) {
        byte[] b = new byte[]{(byte)(in >> 56 & 0xFFL), (byte)(in >> 48 & 0xFFL), (byte)(in >> 40 & 0xFFL), (byte)(in >> 32 & 0xFFL), (byte)(in >> 24 & 0xFFL), (byte)(in >> 16 & 0xFFL), (byte)(in >> 8 & 0xFFL), (byte)(in >> 0 & 0xFFL)};
        return b;
    }

    public static byte[] bigEndian4(long in) {
        byte[] b = new byte[]{(byte)(in >> 24 & 0xFFL), (byte)(in >> 16 & 0xFFL), (byte)(in >> 8 & 0xFFL), (byte)(in >> 0 & 0xFFL)};
        return b;
    }

    public static int oldlittleEndian2(byte[] b, int bitsPerSample) {
        byte b2 = b[1];
        byte b1 = b[0];
        int value = (b2 & 0xFF) << 8 | (b1 & 0xFF) << 0;
        if (value > Short.MAX_VALUE) {
            value += -65536;
        }
        return value;
    }

    public static int littleEndian2(byte[] b, int bitsPerSample) {
        byte b2 = b[1];
        byte b1 = b[0];
        int value = (b2 & 0xFF) << 8 | (b1 & 0xFF) << 0;
        if ((double)value > Math.pow(2.0, bitsPerSample - 1) - 1.0) {
            value = (int)(-1.0 * Math.pow(2.0, bitsPerSample) + (double)value);
        }
        return value;
    }

    public static int bigEndian2(byte[] b, int bitsPerSample) {
        byte b2 = b[0];
        byte b1 = b[1];
        int value = (b2 & 0xFF) << 8 | (b1 & 0xFF) << 0;
        if (value > (2 ^ bitsPerSample - 1 - 1)) {
            value = -(2 ^ bitsPerSample) + value;
        }
        return value;
    }

    public static int littleEndian2unsigned(byte[] b) {
        byte b1 = b[0];
        byte b2 = b[1];
        int value = (b2 & 0xFF) << 8 | (b1 & 0xFF) << 0;
        return value;
    }

    public static String dec(int n) {
        return String.format("%4s", Integer.toString(n)).replace(' ', '0');
    }

    public static String dec(long n) {
        return String.format("%6s", Long.toString(n)).replace(' ', '0');
    }

    public static String hex(long n) {
        return String.format("0x%5s", Long.toHexString(n)).replace(' ', '0');
    }

    public static String hex(int n) {
        return String.format("0x%2s", Integer.toHexString(n)).replace(' ', '0');
    }

    public static String hex(byte n) {
        int i = 0xFF & n;
        return String.format("0x%2s", Integer.toHexString(i)).replace(' ', '0');
    }

    public static String plainhex(byte n) {
        int i = 0xFF & n;
        return Decoder.plainhex(i);
    }

    public static String plainhex(int n) {
        return String.format("%2s", Integer.toHexString(n)).replace(' ', '0');
    }

    public static long getTimeNano() {
        long l = System.nanoTime();
        return l;
    }
}

