/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Config;

public class FmDemodulator {
    protected double[] i = new double[3];
    protected double[] q = new double[3];
    double lastPhase = 0.0;
    double gain = 0.5;
    double limiti;
    double limitq;

    public FmDemodulator() {
        this.i[0] = 0.1f;
        this.q[0] = 0.1f;
        this.i[1] = 0.1f;
        this.q[1] = 0.1f;
        this.i[2] = 0.1f;
        this.q[2] = 0.1f;
    }

    public double demodulateAM(double in, double qn) {
        double mag = Math.sqrt(in * in + qn * qn);
        return mag;
    }

    public double atanDemodulate(double in, double qn) {
        double angle = 0.0;
        double I = in * this.i[0] - qn * -this.q[0];
        double Q = qn * this.i[0] + in * -this.q[0];
        this.i[0] = in;
        this.q[0] = qn;
        if (I == 0.0) {
            I = 1.0E-20f;
        }
        double denominator = 1.0 / I;
        angle = Math.atan(Q * denominator);
        if (I < 0.0 && Q < 0.0) {
            angle -= Math.PI;
        }
        if (I < 0.0 && Q >= 0.0) {
            angle += Math.PI;
        }
        return angle * this.gain;
    }

    public double demodulate(double fftData, double fftData2) {
        if (Config.useLimiter) {
            this.limiter(fftData, fftData2);
        }
        this.i[0] = this.i[1];
        this.q[0] = this.q[1];
        this.i[1] = this.i[2];
        this.q[1] = this.q[2];
        if (Config.useLimiter) {
            this.i[2] = this.limiti;
            this.q[2] = this.limitq;
        } else {
            this.i[2] = fftData;
            this.q[2] = fftData2;
        }
        double gain = 0.5;
        double num = this.i[1] * (this.q[2] - this.q[0]) - this.q[1] * (this.i[2] - this.i[0]);
        double den = this.i[1] * this.i[1] + this.q[1] * this.q[1];
        double deltafreq = gain * (num / den);
        if (Double.isNaN(deltafreq)) {
            deltafreq = 0.0;
        }
        return deltafreq;
    }

    private void limiter(double i, double q) {
        double f = Math.atan2(q, i);
        this.limiti = Math.cos(f);
        this.limitq = Math.sin(f);
    }
}

