/*
 * Decompiled with CFR 0.152.
 */
package decoder.FoxBPSK;

import common.Config;
import common.Log;
import common.Performance;
import common.Spacecraft;
import decoder.Decoder;
import decoder.FoxBPSK.FormatBitStream;
import decoder.SourceAudio;
import gui.MainWindow;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import telemetry.Format.FormatFrame;
import telemetry.Format.FormatHeader;
import telemetry.Format.TelemFormat;
import telemetry.frames.Frame;

public abstract class FoxBPSKDecoder
extends Decoder {
    public FoxBPSKDecoder(String n, SourceAudio as, int chan, TelemFormat telemFormat) {
        super(n, as, chan, telemFormat);
        this.bitStream = new FormatBitStream(this, telemFormat, true);
    }

    public abstract double[] getBasebandData();

    public abstract double[] getBasebandQData();

    public abstract double[] getPhasorData();

    @Override
    public int recoverClockOffset() {
        return 0;
    }

    @Override
    protected double[] recoverClock(int factor) {
        return null;
    }

    @Override
    protected void processBitsWindow() {
        Performance.startTimer("findSync");
        ArrayList<Frame> frames = this.bitStream.findFrames(this.SAMPLE_WINDOW_LENGTH);
        Performance.endTimer("findSync");
        if (frames != null) {
            this.processPossibleFrame(frames);
        }
    }

    protected void processPossibleFrame(ArrayList<Frame> frames) {
        Spacecraft sat = null;
        for (Frame decodedFrame : frames) {
            if (decodedFrame != null && !decodedFrame.corrupt) {
                Performance.startTimer("Store");
                this.eyeData.lastErasureCount = decodedFrame.rsErasures;
                this.eyeData.lastErrorsCount = decodedFrame.rsErrors;
                if (Config.storePayloads) {
                    FormatFrame hsf = (FormatFrame)decodedFrame;
                    FormatHeader header = hsf.getHeader();
                    sat = Config.satManager.getSpacecraft(header.id);
                    int newReset = sat.getCurrentReset(header.resets, header.uptime);
                    hsf.savePayloads(Config.payloadStore, sat.hasModeInHeader, newReset);
                    this.addMeasurements(header.id, newReset, header.uptime, decodedFrame, decodedFrame.rsErrors, decodedFrame.rsErasures);
                }
                ++Config.totalFrames;
                if (Config.storeRawByteFrames) {
                    try {
                        decodedFrame.saveBytes();
                    }
                    catch (IOException e) {
                        e.printStackTrace(Log.getWriter());
                    }
                }
                if (Config.uploadToServer) {
                    try {
                        Config.rawFrameQueue.add(decodedFrame);
                    }
                    catch (IOException e) {
                        e.printStackTrace(Log.getWriter());
                    }
                }
                if (sat != null && sat.sendToLocalServer()) {
                    try {
                        Config.rawPayloadQueue.add(decodedFrame);
                    }
                    catch (IOException e) {
                        e.printStackTrace(Log.getWriter());
                    }
                }
                ++this.framesDecoded;
                if (MainWindow.frame != null) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                MainWindow.setTotalDecodes();
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        e1.printStackTrace(Log.getWriter());
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace(Log.getWriter());
                    }
                }
                Performance.endTimer("Store");
                continue;
            }
            if (!Config.debugBits) continue;
            Log.println("SYNC marker found but frame not decoded\n");
        }
    }
}

