/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Log;
import decoder.DataMeasure;
import decoder.SourceIQ;

public class RfData
extends DataMeasure {
    public static final int PEAK_SIGNAL_IN_FILTER_WIDTH = 0;
    public static final int BIN_OF_PEAK_SIGNAL_IN_FILTER_WIDTH = 1;
    public static final int NOISE_OUTSIDE_FILTER_WIDTH = 2;
    public static final int AVGSIG_IN_FILTER_WIDTH = 3;
    public static final int STRONGEST_SIGNAL_IN_SAT_BAND = 4;
    public static final int BIN_OF_STRONGEST_SIGNAL_IN_SAT_BAND = 5;
    public double rfSNRInFilterWidth;
    public double rfStrongestSigSNRInSatBand;
    double binBandwidth;
    SourceIQ iqSource;

    public RfData(SourceIQ iq) {
        this.AVERAGE_PERIOD = 100L;
        this.MEASURES = 6;
        this.iqSource = iq;
        this.init();
    }

    public int getBinOfPeakSignalInFilterWidth() {
        return (int)this.getAvg(1);
    }

    public int getBinOfStrongestSignalInSatBand() {
        return (int)this.getAvg(5);
    }

    public long getFrequencyOfPeakSignalInFilterWidth() {
        return this.iqSource.getFrequencyFromBin(this.getBinOfPeakSignalInFilterWidth());
    }

    public long getFrequencyOfStrongestSignalInSatBand() {
        return this.iqSource.getFrequencyFromBin(this.getBinOfStrongestSignalInSatBand());
    }

    @Override
    public void run() {
        Thread.currentThread().setName("RfData");
        while (this.running) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Log.println(e.getMessage());
            }
            if (!this.readyToAverage()) continue;
            this.runAverage();
            this.calcAverages();
        }
    }

    @Override
    public void stopProcessing() {
        this.running = false;
        Log.println("RfData STOPPING");
    }

    private void calcAverages() {
        double n;
        double p;
        if (this.getAvg(3) != 0.0 && this.getAvg(2) != 0.0) {
            p = this.getAvg(3);
            n = this.getAvg(2);
            if (p < 10.0 && p > -150.0 && n < 10.0 && n > -150.0 && p > n) {
                this.rfSNRInFilterWidth = p - n;
            }
        }
        if (this.getAvg(4) != 0.0 && this.getAvg(2) != 0.0) {
            p = this.getAvg(4);
            n = this.getAvg(2);
            if (p < 10.0 && p > -150.0 && n < 10.0 && n > -150.0 && p > n) {
                this.rfStrongestSigSNRInSatBand = p - n;
            }
        }
    }

    public void setPeakSignalInFilterWidth(double p, int b, double sig, double n) {
        this.setValue(0, p);
        this.setValue(1, b);
        this.setValue(3, sig);
        this.setValue(2, n);
    }

    public void setStrongestSignal(double sig, int b) {
        this.setValue(4, sig);
        this.setValue(5, b);
    }
}

