/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Config;
import common.Log;
import decoder.Decoder;
import decoder.FoxBitStream;
import decoder.LookupException;
import fec.RsCodeWord;
import java.util.Date;
import telemetry.frames.FrameProcessException;
import telemetry.frames.SlowSpeedFrame;

public class SlowSpeedBitStream
extends FoxBitStream {
    public static int SLOW_SPEED_SYNC_WORD_DISTANCE = 970;

    public SlowSpeedBitStream(Decoder dec, int wordLength, int syncWordLength, int bitRate) {
        super(SLOW_SPEED_SYNC_WORD_DISTANCE * 5, dec, SLOW_SPEED_SYNC_WORD_DISTANCE, wordLength, syncWordLength, 1000.0 / (double)bitRate);
        this.PURGE_THRESHOLD = this.SYNC_WORD_DISTANCE * 3;
        SYNC_WORD_BIT_TOLERANCE = 10;
    }

    @Override
    public SlowSpeedFrame decodeFrame(int start, int end, int missedBits, int repairPosition, Date timeOfStartSync) {
        boolean insertedMissedBits = false;
        byte[] rawFrame = new byte[SlowSpeedFrame.getMaxBytes()];
        int[] erasurePositions = new int[SlowSpeedFrame.getMaxBytes()];
        int numberOfErasures = 0;
        if (rawFrame.length != this.SYNC_WORD_DISTANCE / 10 - 1) {
            Log.println("ERROR: Frame length " + rawFrame.length + " bytes is different to SYNC word distance " + (this.SYNC_WORD_DISTANCE / 10 - 1));
        }
        int f = 0;
        int j = start;
        while (j < end - this.SYNC_WORD_LENGTH) {
            if (Config.insertMissingBits && !insertedMissedBits && missedBits > 0 && j >= repairPosition) {
                if (Config.debugFrames) {
                    Log.println("INSERTED " + missedBits + " missed bits at " + repairPosition);
                    Log.println("RS Codeword byte: " + f);
                }
                j -= missedBits;
                insertedMissedBits = true;
            }
            int b8 = -1;
            if (numberOfErasures < 15) {
                try {
                    b8 = this.processWord(j);
                }
                catch (LookupException e) {
                    if (Config.useRSerasures) {
                        erasurePositions[numberOfErasures] = f;
                        ++numberOfErasures;
                    }
                }
            } else {
                if (Config.debugFrames) {
                    Log.println(".. abandonded, too many erasures");
                }
                return null;
            }
            rawFrame[f++] = b8;
            j += 10;
        }
        if (numberOfErasures < 15) {
            RsCodeWord rs = new RsCodeWord(rawFrame, 159);
            if (Config.useRSfec) {
                if (Config.useRSerasures) {
                    rs.setErasurePositions(erasurePositions, numberOfErasures);
                }
                rawFrame = rs.decode();
            }
            if (rs.validDecode()) {
                SlowSpeedFrame slowSpeedFrame = new SlowSpeedFrame();
                slowSpeedFrame.setStpDate(timeOfStartSync);
                try {
                    slowSpeedFrame.addRawFrame(rawFrame);
                    slowSpeedFrame.rsErrors = rs.getNumberOfCorrections();
                    slowSpeedFrame.rsErasures = numberOfErasures;
                }
                catch (FrameProcessException e) {
                    Log.println(".. rejected frame: " + e);
                    return null;
                }
                return slowSpeedFrame;
            }
            if (Config.debugFrames) {
                Log.println(".. abandonded, failed RS decode");
            }
            return null;
        }
        Log.println("FAIL: " + numberOfErasures + " exceeds max erasures: " + 15);
        return null;
    }
}

