/*
 * Decompiled with CFR 0.152.
 */
package device;

import common.Log;
import device.DeviceException;
import device.ThreadPoolManager;
import device.TunerClass;
import device.TunerController;
import device.TunerType;
import device.airspy.AirspyDevice;
import device.fcd.FCD1TunerController;
import device.fcd.FCD2TunerController;
import device.rtl.E4KTunerController;
import device.rtl.R820TTunerController;
import device.rtl.RTL2832TunerController;
import java.util.ArrayList;
import javax.usb.UsbException;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;

public class TunerManager {
    ArrayList<String> deviceNames;
    ArrayList<TunerController> tunerControllerList;
    private ThreadPoolManager mThreadPoolManager = new ThreadPoolManager();

    public void dispose() {
        LibUsb.exit(null);
    }

    public TunerController findDevice(short vendor, short product, RTL2832TunerController.SampleRate sampleRate) throws UsbException, DeviceException {
        DeviceList deviceList = new DeviceList();
        int result = LibUsb.init(null);
        if (result != 0) {
            Log.println("unable to initialize libusb [" + LibUsb.errorName(result) + "]");
        } else {
            Log.println("LibUSB API Version: " + LibUsb.getApiVersion());
            Log.println("LibUSB Version: " + LibUsb.getVersion());
            result = LibUsb.getDeviceList(null, deviceList);
            if (result < 0) {
                Log.println("unable to get device list from libusb [" + result + " / " + LibUsb.errorName(result) + "]");
            } else {
                Log.println("discovered [" + result + "] attached USB devices");
            }
        }
        for (Device device : deviceList) {
            DeviceDescriptor descriptor;
            result = LibUsb.getDeviceDescriptor(device, descriptor = new DeviceDescriptor());
            if (result != 0) {
                Log.println("unable to read device descriptor [" + LibUsb.errorName(result) + "]");
                continue;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("usb device [");
            sb.append(String.format("%04X", descriptor.idVendor()));
            sb.append(":");
            sb.append(String.valueOf(String.format("%04X", descriptor.idProduct())) + "]");
            Log.println(sb.toString());
            Log.println(device.toString());
            if (descriptor.idVendor() != vendor || descriptor.idProduct() != product) continue;
            Log.println("FOUND DEVICE!");
            TunerController dev = this.initTuner(device, descriptor, sampleRate);
            if (dev == null) continue;
            LibUsb.freeDeviceList(deviceList, true);
            return dev;
        }
        LibUsb.freeDeviceList(deviceList, true);
        return null;
    }

    public TunerController DEPRECIATED_getTunerControllerById(int id) {
        return this.tunerControllerList.get(id);
    }

    private TunerController initTuner(Device device, DeviceDescriptor descriptor, RTL2832TunerController.SampleRate sampleRate) throws UsbException, DeviceException {
        if (device != null && descriptor != null) {
            TunerClass tunerClass = TunerClass.valueOf(descriptor.idVendor(), descriptor.idProduct());
            switch (tunerClass) {
                case AIRSPY: {
                    return this.initAirspyTuner(device, descriptor);
                }
                case ETTUS_USRP_B100: 
                case FUNCUBE_DONGLE_PRO: {
                    return this.initFuncubeProTuner(device, descriptor);
                }
                case FUNCUBE_DONGLE_PRO_PLUS: {
                    return this.initFuncubeProPlusTuner(device, descriptor);
                }
                case GENERIC_2832: 
                case GENERIC_2838: 
                case COMPRO_VIDEOMATE_U620F: 
                case COMPRO_VIDEOMATE_U650F: 
                case COMPRO_VIDEOMATE_U680F: 
                case DEXATEK_LOGILINK_VG002A: 
                case DEXATEK_DIGIVOX_MINI_II_REV3: 
                case DEXATEK_5217_DVBT: 
                case GIGABYTE_GTU7300: 
                case GTEK_T803: 
                case HACKRF_ONE: 
                case RAD1O: 
                case LIFEVIEW_LV5T_DELUXE: 
                case MYGICA_TD312: 
                case PEAK_102569AGPK: 
                case PROLECTRIX_DV107669: 
                case SVEON_STV20: 
                case TERRATEC_CINERGY_T_REV1: 
                case TERRATEC_CINERGY_T_REV3: 
                case TERRATEC_NOXON_REV1_B3: 
                case TERRATEC_NOXON_REV1_B4: 
                case TERRATEC_NOXON_REV1_B7: 
                case TERRATEC_NOXON_REV1_C6: 
                case TERRATEC_NOXON_REV2: 
                case TERRATEC_T_STICK_PLUS: 
                case TWINTECH_UT40: 
                case ZAAPA_ZTMINDVBZP: {
                    return this.initRTL2832Tuner(tunerClass, device, descriptor, sampleRate);
                }
            }
        }
        return null;
    }

    private TunerController initAirspyTuner(Device device, DeviceDescriptor descriptor) throws UsbException {
        try {
            ThreadPoolManager mThreadPoolManager = new ThreadPoolManager();
            AirspyDevice airspyController = new AirspyDevice(device, mThreadPoolManager);
            airspyController.init();
            return airspyController;
        }
        catch (DeviceException se) {
            Log.println("Couldn't construct Airspy controller/tuner.  It is probablly in use");
            return null;
        }
    }

    private FCD1TunerController initFuncubeProTuner(Device device, DeviceDescriptor descriptor) {
        try {
            FCD1TunerController controller = new FCD1TunerController(device, descriptor);
            controller.init();
            return controller;
        }
        catch (DeviceException se) {
            Log.println("error constructing tuner: " + se);
            return null;
        }
    }

    private FCD2TunerController initFuncubeProPlusTuner(Device device, DeviceDescriptor descriptor) throws DeviceException {
        FCD2TunerController controller = new FCD2TunerController(device, descriptor);
        controller.init();
        return controller;
    }

    private TunerController initRTL2832Tuner(TunerClass tunerClass, Device device, DeviceDescriptor deviceDescriptor, RTL2832TunerController.SampleRate sampleRate) {
        String reason = "NOT LOADED";
        TunerType tunerType = tunerClass.getTunerType();
        if (tunerType == TunerType.RTL2832_VARIOUS) {
            try {
                tunerType = RTL2832TunerController.identifyTunerType(device);
            }
            catch (DeviceException e) {
                Log.println("couldn't determine RTL2832 tuner type: " + e);
                tunerType = TunerType.UNKNOWN;
            }
        }
        switch (tunerType) {
            case ELONICS_E4000: {
                try {
                    E4KTunerController controller = new E4KTunerController(device, deviceDescriptor, this.mThreadPoolManager);
                    controller.init(sampleRate);
                    return controller;
                }
                catch (DeviceException se) {
                    Log.println("error constructing tuner: " + se);
                    return null;
                }
            }
            case RAFAELMICRO_R820T: {
                try {
                    R820TTunerController controller = new R820TTunerController(device, deviceDescriptor, this.mThreadPoolManager);
                    controller.init(sampleRate);
                    return controller;
                }
                catch (DeviceException se) {
                    Log.println("error constructing tuner: " + se);
                    return null;
                }
            }
        }
        reason = "SDRTRunk doesn't currently support RTL2832 Dongle with [" + tunerType.toString() + "] tuner for tuner class[" + tunerClass.toString() + "]";
        Log.println("error constructing tuner: " + reason);
        return null;
    }

    public class TunerInitStatus {
        private TunerController mTuner;
        private String mInfo;

        public TunerInitStatus(TunerController tuner, String info) {
            this.mTuner = tuner;
            this.mInfo = info;
        }

        public TunerController getTuner() {
            return this.mTuner;
        }

        public String getInfo() {
            return this.mInfo;
        }

        public boolean isLoaded() {
            return this.mTuner != null;
        }
    }
}

