/*
 * Decompiled with CFR 0.152.
 */
package device.fcd;

import common.Log;
import device.DeviceException;
import device.TunerController;
import device.fcd.FCD1TunerController;
import device.fcd.FCDCommand;
import device.fcd.FCDModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.usb.UsbClaimException;
import javax.usb.UsbException;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public abstract class FCDTunerController
extends TunerController {
    public static final double USABLE_BANDWIDTH_PERCENT = 1.0;
    public static final int DC_SPIKE_AVOID_BUFFER = 5000;
    public static final byte FCD_INTERFACE = 2;
    public static final byte FCD_ENDPOINT_IN = -126;
    public static final byte FCD_ENDPOINT_OUT = 2;
    private Device mDevice;
    private DeviceDescriptor mDeviceDescriptor;
    private DeviceHandle mDeviceHandle;
    private FCDConfiguration mConfiguration = new FCDConfiguration();

    public FCDTunerController(String name, Device device, DeviceDescriptor descriptor, int sampleRate, long minTunableFrequency, long maxTunableFrequency) throws DeviceException {
        super(name, minTunableFrequency, maxTunableFrequency);
        this.SAMPLE_RATE = sampleRate;
        this.mDevice = device;
        this.mDeviceDescriptor = descriptor;
    }

    public void setMixerGain(boolean enabled) throws DeviceException {
        try {
            this.send(FCDCommand.APP_SET_MIXER_GAIN, enabled ? 1 : 0);
        }
        catch (Exception e) {
            Log.println("error while setting Mixer Gain: " + e.getMessage());
            throw e;
        }
    }

    public boolean getMixerGain() throws DeviceException {
        try {
            ByteBuffer buffer = this.send(FCDCommand.APP_GET_MIXER_GAIN);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte ret = buffer.get(2);
            return ret > 0;
        }
        catch (Exception e) {
            Log.println("error while getting Mixer Gain: " + e.getMessage());
            throw e;
        }
    }

    @Override
    public boolean isConnected() {
        return this.mDevice != null;
    }

    public void init() throws DeviceException {
        this.mDeviceHandle = new DeviceHandle();
        int result = LibUsb.open(this.mDevice, this.mDeviceHandle);
        if (result != 0) {
            throw new DeviceException("libusb couldn't open funcube usb device [" + LibUsb.errorName(result) + "]");
        }
        this.claimInterface();
    }

    public void dispose() {
        if (this.mDeviceHandle != null) {
            try {
                LibUsb.close(this.mDeviceHandle);
            }
            catch (Exception e) {
                Log.errorDialog("error while closing device handle", e.getMessage());
            }
            this.mDeviceHandle = null;
        }
        this.mDeviceDescriptor = null;
        this.mDevice = null;
    }

    @Override
    public abstract int getCurrentSampleRate() throws DeviceException;

    public String getUSBAddress() {
        if (this.mDevice != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Bus:");
            int bus = LibUsb.getBusNumber(this.mDevice);
            sb.append(bus);
            sb.append(" Port:");
            int port = LibUsb.getPortNumber(this.mDevice);
            sb.append(port);
            return sb.toString();
        }
        return "UNKNOWN";
    }

    public String getUSBID() {
        if (this.mDeviceDescriptor != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%04X", this.mDeviceDescriptor.idVendor() & 0xFFFF));
            sb.append(":");
            sb.append(String.format("%04X", this.mDeviceDescriptor.idProduct() & 0xFFFF));
            return sb.toString();
        }
        return "UNKNOWN";
    }

    public String getUSBSpeed() {
        if (this.mDevice != null) {
            int speed = LibUsb.getDeviceSpeed(this.mDevice);
            switch (speed) {
                case 0: {
                    return "1.1 LOW";
                }
                case 1: {
                    return "1.1 FULL";
                }
                case 2: {
                    return "2.0 HIGH";
                }
                case 3: {
                    return "3.0 SUPER";
                }
            }
        }
        return "UNKNOWN";
    }

    public void setFCDMode(Mode mode) throws UsbException, UsbClaimException {
        ByteBuffer response = null;
        switch (mode) {
            case APPLICATION: {
                response = this.send(FCDCommand.BL_QUERY);
                break;
            }
            case BOOTLOADER: {
                response = this.send(FCDCommand.APP_RESET);
                break;
            }
        }
        if (response != null) {
            this.mConfiguration.set(response);
        } else {
            this.mConfiguration.setModeUnknown();
        }
    }

    @Override
    public int setFrequency(long frequency) throws DeviceException {
        try {
            this.send(FCDCommand.APP_SET_FREQUENCY_HZ, frequency);
        }
        catch (Exception e) {
            Log.println("Couldn't set FCD Local Oscillator Frequency [" + frequency + "]" + e.getMessage());
            throw e;
        }
        return 0;
    }

    public long getTunedFrequency() throws DeviceException {
        try {
            ByteBuffer buffer = this.send(FCDCommand.APP_GET_FREQUENCY_HZ);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return buffer.getInt(2) & 0xFFFFFFFF;
        }
        catch (Exception e) {
            Log.println("FCDTunerController - couldn't get LO frequency" + e.getMessage());
            throw e;
        }
    }

    public FCDConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    private void claimInterface() throws DeviceException {
        if (this.mDeviceHandle != null) {
            int result = LibUsb.kernelDriverActive(this.mDeviceHandle, 2);
            if (result == 1 && (result = LibUsb.detachKernelDriver(this.mDeviceHandle, 2)) != 0) {
                Log.errorDialog("ERROR", "failed attempt to detach kernel driver [" + LibUsb.errorName(result) + "]");
            }
            if ((result = LibUsb.claimInterface(this.mDeviceHandle, 2)) != 0) {
                throw new DeviceException("couldn't claim usb interface [" + LibUsb.errorName(result) + "]");
            }
        } else {
            throw new DeviceException("couldn't claim usb hid interface - no device handle");
        }
    }

    private void write(ByteBuffer buffer) throws LibUsbException {
        if (this.mDeviceHandle != null) {
            IntBuffer transferred = IntBuffer.allocate(1);
            int result = LibUsb.interruptTransfer(this.mDeviceHandle, (byte)2, buffer, transferred, 500L);
            if (result != 0) {
                throw new LibUsbException("error writing byte buffer", result);
            }
        } else {
            throw new LibUsbException("device handle is null", -4);
        }
    }

    private void write(FCDCommand command) throws LibUsbException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(64);
        buffer.put(0, command.getCommand());
        buffer.put(1, (byte)0);
        this.write(buffer);
    }

    private void log(String label, ByteBuffer buffer) {
        StringBuilder sb = new StringBuilder();
        sb.append(label);
        sb.append(" ");
        sb.append(buffer.get(0));
        sb.append(" | ");
        int x = 0;
        while (x < 64) {
            sb.append(String.format("%02X", buffer.get(x) & 0xFF));
            sb.append(" ");
            ++x;
        }
        Log.println(sb.toString());
    }

    private void write(FCDCommand command, long argument) throws LibUsbException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(64);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(0, command.getCommand());
        buffer.putLong(1, argument);
        this.write(buffer);
    }

    private ByteBuffer read() throws LibUsbException {
        if (this.mDeviceHandle != null) {
            IntBuffer transferred;
            ByteBuffer buffer = ByteBuffer.allocateDirect(64);
            int result = LibUsb.interruptTransfer(this.mDeviceHandle, (byte)-126, buffer, transferred = IntBuffer.allocate(1), 500L);
            if (result != 0) {
                throw new LibUsbException("error reading byte buffer", result);
            }
            if (transferred.get(0) != buffer.capacity()) {
                throw new LibUsbException("received bytes [" + transferred.get(0) + "] didn't match expected " + "length [" + buffer.capacity() + "]", result);
            }
            return buffer;
        }
        throw new LibUsbException("device handle is null", -4);
    }

    protected void send(FCDCommand command, long argument) throws LibUsbException {
        this.write(command, argument);
        this.read();
    }

    protected ByteBuffer send(FCDCommand command) throws LibUsbException {
        this.write(command);
        return this.read();
    }

    @Override
    public void cleanup() throws IOException, DeviceException {
    }

    public class FCDConfiguration {
        private String mConfig = null;
        private Mode mMode = Mode.UNKNOWN;

        private void setModeUnknown() {
            this.mConfig = null;
            this.mMode = Mode.UNKNOWN;
        }

        public void set(ByteBuffer buffer) {
            if (buffer.capacity() == 64) {
                byte[] data = new byte[64];
                int x = 0;
                while (x < 64) {
                    data[x] = buffer.get(x);
                    ++x;
                }
                this.mConfig = new String(data);
                this.mMode = Mode.getMode(this.mConfig);
            } else {
                this.mConfig = null;
                this.mMode = Mode.ERROR;
            }
        }

        public Mode getMode() {
            return this.mMode;
        }

        public FCDModel getModel() {
            FCDModel retVal = FCDModel.FUNCUBE_UNKNOWN;
            switch (this.mMode) {
                case APPLICATION: {
                    retVal = FCDModel.getFCD(this.mConfig.substring(15, 22));
                    break;
                }
            }
            return retVal;
        }

        public FCD1TunerController.Block getBandBlocking() {
            FCD1TunerController.Block retVal = FCD1TunerController.Block.UNKNOWN;
            switch (this.mMode) {
                case APPLICATION: {
                    retVal = FCD1TunerController.Block.getBlock(this.mConfig.substring(23, 33).trim());
                    break;
                }
            }
            return retVal;
        }

        public String getFirmware() {
            String retVal = null;
            switch (this.mMode) {
                case APPLICATION: {
                    retVal = this.mConfig.substring(9, 14);
                    break;
                }
            }
            return retVal;
        }

        public String toString() {
            return this.getModel().getLabel();
        }
    }

    public static enum Mode {
        APPLICATION,
        BOOTLOADER,
        ERROR,
        UNKNOWN;


        public static Mode getMode(String config) {
            Mode retVal = UNKNOWN;
            if (config == null) {
                retVal = ERROR;
            } else if (config.length() >= 8) {
                String mode = config.substring(2, 8).trim();
                if (mode.equalsIgnoreCase("FCDAPP")) {
                    retVal = APPLICATION;
                } else if (mode.equalsIgnoreCase("FCDBL")) {
                    retVal = BOOTLOADER;
                }
            }
            return retVal;
        }
    }
}

