/*
 * Decompiled with CFR 0.152.
 */
package device.rtl;

import common.Log;
import device.DeviceException;
import device.DevicePanel;
import device.ThreadPoolManager;
import device.TunerType;
import device.rtl.RTL2832TunerController;
import device.rtl.RTLPanelE4K;
import java.io.IOException;
import java.util.Arrays;
import javax.usb.UsbException;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class E4KTunerController
extends RTL2832TunerController {
    public static final long MIN_FREQUENCY = 52000L;
    public static final long MAX_FREQUENCY = 2200000L;
    public static final double USABLE_BANDWIDTH_PERCENT = 0.95;
    public static final int DC_SPIKE_AVOID_BUFFER = 15000;
    public static final long E4K_PLL_Y = 65536L;
    public static final byte MASTER1_RESET = 1;
    public static final byte MASTER1_NORM_STBY = 2;
    public static final byte MASTER1_POR_DET = 4;
    public static final byte SYNTH1_PLL_LOCK = 1;
    public static final byte SYNTH1_BAND_SHIF = 1;
    public static final byte SYNTH7_3PHASE_EN = 8;
    public static final byte SYNTH8_VCOCAL_UPD = 4;
    public static final byte FILT3_MASK = 32;
    public static final byte FILT3_ENABLE = 0;
    public static final byte FILT3_DISABLE = 32;
    public static final byte MIXER_FILTER_MASK = -16;
    public static final byte IF_CHANNEL_FILTER_MASK = 31;
    public static final byte IF_RC_FILTER_MASK = 15;
    public static final byte AGC1_LIN_MODE = 16;
    public static final byte AGC1_LNA_UPDATE = 32;
    public static final byte AGC1_LNA_G_LOW = 64;
    public static final byte AGC1_LNA_G_HIGH = -128;
    public static final byte AGC1_MOD_MASK = 15;
    public static final byte GAIN1_MOD_MASK = 15;
    public static final byte IF_GAIN_MODE_SWITCHING_MASK = 1;
    public static final byte AGC6_LNA_CAL_REQ = 16;
    public static final byte AGC7_MIXER_GAIN_MASK = 1;
    public static final byte AGC7_MIX_GAIN_MANUAL = 0;
    public static final byte AGC7_MIX_GAIN_AUTO = 1;
    public static final byte AGC7_GAIN_STEP_5DB = 32;
    public static final byte AGC8_SENS_LIN_AUTO = 1;
    public static final byte AGC11_LNA_GAIN_ENH = 1;
    public static final byte ENH_GAIN_MOD_MASK = 7;
    public static final byte MIXER_GAIN_MASK = 1;
    public static final byte DC1_CAL_REQ = 1;
    public static final byte DC5_I_LUT_EN = 1;
    public static final byte DC5_Q_LUT_EN = 2;
    public static final byte DC5_RANGE_DETECTOR_ENABLED_MASK = 4;
    public static final byte DC5_RANGE_DETECTOR_ENABLED = 4;
    public static final byte DC5_RANGE_EN = 8;
    public static final byte DC5_RANGE_DETECTOR_DISABLED_MASK = 3;
    public static final byte DC5_RANGE_DETECTOR_DISABLED = 0;
    public static final byte DC5_TIMEVAR_EN = 16;
    public static final byte CLKOUT_DISABLE = -106;
    public static final byte CHFCALIB_CMD = 1;

    public E4KTunerController(Device device, DeviceDescriptor deviceDescriptor, ThreadPoolManager threadPoolManager) throws DeviceException {
        super(device, deviceDescriptor, threadPoolManager, 52000L, 2200000L, 15000, 0.95);
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.ELONICS_E4000;
    }

    @Override
    public void init(RTL2832TunerController.SampleRate sampleRate) throws DeviceException {
        this.mDeviceHandle = new DeviceHandle();
        int result = LibUsb.open(this.mDevice, this.mDeviceHandle);
        if (result != 0) {
            this.mDeviceHandle = null;
            throw new DeviceException("libusb couldn't open RTL2832 usb device [" + LibUsb.errorName(result) + "]");
        }
        E4KTunerController.claimInterface(this.mDeviceHandle);
        byte[] eeprom = null;
        try {
            eeprom = this.readEEPROM(this.mDeviceHandle, (short)0, 256);
        }
        catch (Exception e) {
            Log.println("error while reading the EEPROM device descriptor:" + e);
        }
        try {
            this.mDescriptor = new RTL2832TunerController.Descriptor(eeprom);
            if (eeprom == null) {
                Log.println("eeprom byte array was null - constructed empty descriptor object");
            }
        }
        catch (Exception e) {
            Log.println("error while constructing device descriptor using descriptor byte array " + (eeprom == null ? "[null]" : String.valueOf(Arrays.toString(eeprom)) + ": ") + e);
        }
        try {
            E4KTunerController.writeRegister(this.mDeviceHandle, RTL2832TunerController.Block.USB, RTL2832TunerController.Address.USB_SYSCTL.getAddress(), 9, 1);
            E4KTunerController.initBaseband(this.mDeviceHandle);
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, true);
            boolean i2CRepeaterControl = false;
            this.initTuner(i2CRepeaterControl);
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, false);
            try {
                this.setSampleRate(sampleRate);
            }
            catch (Exception e) {
                throw new DeviceException("RTL2832 Tuner Controller - couldn't set default sample rate: " + e);
            }
        }
        catch (UsbException e) {
            e.printStackTrace();
            throw new DeviceException("E4K Tuner Controller - error during init():" + e);
        }
    }

    @Override
    public void setSampleRateFilters(int bandwidth) throws DeviceException {
        boolean i2CRepeaterEnabled = this.isI2CRepeaterEnabled();
        if (!i2CRepeaterEnabled) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, true);
        }
        boolean controlI2CRepeater = false;
        MixerFilter mixer = MixerFilter.getFilter(bandwidth);
        this.setMixerFilter(mixer, controlI2CRepeater);
        ChannelFilter channel = ChannelFilter.getFilter(bandwidth);
        this.setChannelFilter(channel, controlI2CRepeater);
        RCFilter rc = RCFilter.getFilter(bandwidth);
        this.setRCFilter(rc, controlI2CRepeater);
        if (!i2CRepeaterEnabled) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, false);
        }
    }

    public long getTunedFrequency() throws DeviceException {
        try {
            boolean i2CRepeaterEnabled = this.isI2CRepeaterEnabled();
            if (!i2CRepeaterEnabled) {
                E4KTunerController.enableI2CRepeater(this.mDeviceHandle, true);
            }
            boolean controlI2CRepeater = false;
            byte z = (byte)this.readE4KRegister(Register.SYNTH3, controlI2CRepeater);
            int xHigh = this.readE4KRegister(Register.SYNTH4, controlI2CRepeater);
            int xLow = this.readE4KRegister(Register.SYNTH5, controlI2CRepeater);
            int x = Integer.rotateLeft(xHigh, 8) | xLow;
            int pllSetting = this.readE4KRegister(Register.SYNTH7, controlI2CRepeater);
            PLL pll = PLL.fromSetting(pllSetting);
            if (!i2CRepeaterEnabled) {
                E4KTunerController.enableI2CRepeater(this.mDeviceHandle, false);
            }
            return this.calculateActualFrequency(pll, z, x);
        }
        catch (LibUsbException e) {
            Log.println("E4K tuner controller - couldn't get tuned frequency:" + e);
            throw e;
        }
    }

    public void setTunedFrequency(long frequency) throws DeviceException {
        int remainder;
        int x;
        byte z;
        PLL pll = PLL.fromFrequency(frequency);
        long actualFrequency = this.calculateActualFrequency(pll, z = (byte)(frequency / (long)pll.getScaledOscillator()), x = (int)((double)(remainder = (int)(frequency - (long)((z & 0xFF) * pll.getScaledOscillator()))) / (double)pll.getScaledOscillator() * 65536.0));
        if (actualFrequency < 52000000L) {
            actualFrequency = this.calculateActualFrequency(pll, z, ++x);
        }
        try {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, true);
            boolean controlI2CRepeater = false;
            this.writeE4KRegister(Register.SYNTH7, pll.getIndex(), controlI2CRepeater);
            this.writeE4KRegister(Register.SYNTH3, z, controlI2CRepeater);
            this.writeE4KRegister(Register.SYNTH4, (byte)(x & 0xFF), controlI2CRepeater);
            this.writeE4KRegister(Register.SYNTH5, (byte)(Integer.rotateRight(x, 8) & 0xFF), controlI2CRepeater);
            this.setBand(actualFrequency, controlI2CRepeater);
            this.setRFFilter(actualFrequency, controlI2CRepeater);
            int lock = this.readE4KRegister(Register.SYNTH1, controlI2CRepeater);
            if ((lock & 1) != 1) {
                throw new DeviceException("E4K tuner controller - couldn't achieve PLL lock for frequency [" + actualFrequency + "] lock value [" + lock + "]");
            }
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, false);
        }
        catch (UsbException e) {
            throw new DeviceException("E4K tuner controller - error tuning frequency [" + frequency + "]: " + e);
        }
    }

    private long calculateActualFrequency(PLL pll, byte z, int x) {
        long whole = pll.getScaledOscillator() * (z & 0xFF);
        int fractional = (int)((double)pll.getScaledOscillator() * ((double)x / 65536.0));
        return whole + (long)fractional;
    }

    @Override
    public void initTuner(boolean controlI2CRepeater) throws UsbException {
        if (controlI2CRepeater) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, true);
        }
        boolean i2CRepeaterControl = false;
        this.readE4KRegister(Register.DUMMY, i2CRepeaterControl);
        this.writeE4KRegister(Register.MASTER1, (byte)7, i2CRepeaterControl);
        this.writeE4KRegister(Register.CLK_INP, (byte)0, i2CRepeaterControl);
        this.writeE4KRegister(Register.REF_CLK, (byte)0, i2CRepeaterControl);
        this.writeE4KRegister(Register.CLKOUT_PWDN, (byte)-106, i2CRepeaterControl);
        this.magicInit(i2CRepeaterControl);
        this.writeE4KRegister(Register.AGC4, (byte)16, i2CRepeaterControl);
        this.writeE4KRegister(Register.AGC5, (byte)4, i2CRepeaterControl);
        this.writeE4KRegister(Register.AGC6, (byte)26, i2CRepeaterControl);
        this.writeMaskedE4KRegister(Register.AGC1, (byte)15, AGCMode.SERIAL.getValue(), false);
        this.writeMaskedE4KRegister(Register.AGC7, (byte)1, (byte)0, false);
        this.setLNAGain(E4KLNAGain.AUTOMATIC, i2CRepeaterControl);
        this.setMixerGain(E4KMixerGain.AUTOMATIC, i2CRepeaterControl);
        this.setEnhanceGain(E4KEnhanceGain.AUTOMATIC, i2CRepeaterControl);
        this.setIFStage1Gain(IFStage1Gain.GAIN_PLUS6, i2CRepeaterControl);
        this.setIFStage2Gain(IFStage2Gain.GAIN_PLUS0, i2CRepeaterControl);
        this.setIFStage3Gain(IFStage3Gain.GAIN_PLUS0, i2CRepeaterControl);
        this.setIFStage4Gain(IFStage4Gain.GAIN_PLUS0, i2CRepeaterControl);
        this.setIFStage5Gain(IFStage5Gain.GAIN_PLUS9, i2CRepeaterControl);
        this.setIFStage6Gain(IFStage6Gain.GAIN_PLUS9, i2CRepeaterControl);
        this.setMixerFilter(MixerFilter.BW_1M9, i2CRepeaterControl);
        this.setRCFilter(RCFilter.BW_1M0, i2CRepeaterControl);
        this.setChannelFilter(ChannelFilter.BW_2M15, i2CRepeaterControl);
        this.setChannelFilterEnabled(true, i2CRepeaterControl);
        this.writeMaskedE4KRegister(Register.DC5, (byte)3, (byte)0, i2CRepeaterControl);
        this.writeMaskedE4KRegister(Register.DCTIME1, (byte)3, (byte)0, i2CRepeaterControl);
        this.writeMaskedE4KRegister(Register.DCTIME2, (byte)3, (byte)0, i2CRepeaterControl);
        if (controlI2CRepeater) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, false);
        }
    }

    private void generateDCOffsetTables(boolean controlI2CRepeater) throws UsbException {
        boolean i2CRepeaterControl = false;
        if (controlI2CRepeater) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, true);
        }
        IFStage1Gain stage1 = this.getIFStage1Gain(i2CRepeaterControl);
        IFStage2Gain stage2 = this.getIFStage2Gain(i2CRepeaterControl);
        IFStage3Gain stage3 = this.getIFStage3Gain(i2CRepeaterControl);
        IFStage4Gain stage4 = this.getIFStage4Gain(i2CRepeaterControl);
        IFStage5Gain stage5 = this.getIFStage5Gain(i2CRepeaterControl);
        IFStage6Gain stage6 = this.getIFStage6Gain(i2CRepeaterControl);
        E4KMixerGain mixerGain = this.getMixerGain(i2CRepeaterControl);
        this.setMixerGain(mixerGain, i2CRepeaterControl);
        E4KLNAGain lnaGain = this.getLNAGain(i2CRepeaterControl);
        this.setLNAGain(lnaGain, i2CRepeaterControl);
        this.setIFStage2Gain(IFStage2Gain.GAIN_PLUS9, i2CRepeaterControl);
        this.setIFStage3Gain(IFStage3Gain.GAIN_PLUS9, i2CRepeaterControl);
        this.setIFStage4Gain(IFStage4Gain.GAIN_PLUS2B, i2CRepeaterControl);
        this.setIFStage5Gain(IFStage5Gain.GAIN_PLUS15D, i2CRepeaterControl);
        this.setIFStage6Gain(IFStage6Gain.GAIN_PLUS15D, i2CRepeaterControl);
        DCGainCombination[] dCGainCombinationArray = DCGainCombination.values();
        int n = dCGainCombinationArray.length;
        int n2 = 0;
        while (n2 < n) {
            DCGainCombination combo = dCGainCombinationArray[n2];
            this.setMixerGain(combo.getMixerGain(), i2CRepeaterControl);
            this.setIFStage1Gain(combo.getIFStage1Gain(), i2CRepeaterControl);
            this.setDCRangeDetectorEnabled(true, i2CRepeaterControl);
            this.writeE4KRegister(Register.DC1, (byte)1, i2CRepeaterControl);
            byte offsetI = (byte)(this.readE4KRegister(Register.DC2, i2CRepeaterControl) & 0x3F);
            byte offsetQ = (byte)(this.readE4KRegister(Register.DC3, i2CRepeaterControl) & 0x3F);
            byte range = (byte)this.readE4KRegister(Register.DC4, i2CRepeaterControl);
            byte rangeI = (byte)(range & 3);
            byte rangeQ = (byte)(range >> 4 & 3);
            this.writeE4KRegister(combo.getIRegister(), (byte)(offsetI | rangeI << 6), i2CRepeaterControl);
            this.writeE4KRegister(combo.getQRegister(), (byte)(offsetQ | rangeQ << 6), i2CRepeaterControl);
            ++n2;
        }
        if (controlI2CRepeater) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, false);
        }
    }

    public void setDCRangeDetectorEnabled(boolean enabled, boolean controlI2CRepeater) throws UsbException {
        if (enabled) {
            this.writeMaskedE4KRegister(Register.DC5, (byte)4, (byte)4, controlI2CRepeater);
        } else {
            this.writeMaskedE4KRegister(Register.DC5, (byte)3, (byte)0, controlI2CRepeater);
        }
    }

    public void setLNAGain(E4KLNAGain gain, boolean controlI2CRepeater) throws UsbException {
        if (controlI2CRepeater) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, true);
        }
        if (gain == E4KLNAGain.AUTOMATIC) {
            this.writeMaskedE4KRegister(Register.AGC1, (byte)15, AGCMode.IF_SERIAL_LNA_AUTON.getValue(), false);
        } else {
            this.writeMaskedE4KRegister(Register.AGC1, (byte)15, AGCMode.SERIAL.getValue(), false);
            this.writeMaskedE4KRegister(E4KLNAGain.getRegister(), E4KLNAGain.getMask(), gain.getValue(), false);
        }
        if (controlI2CRepeater) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, false);
        }
    }

    public E4KLNAGain getLNAGain(boolean controlI2CRepeater) throws UsbException {
        return E4KLNAGain.fromRegisterValue(this.readE4KRegister(E4KLNAGain.getRegister(), controlI2CRepeater));
    }

    public void setEnhanceGain(E4KEnhanceGain gain, boolean controlI2CRepeater) throws UsbException {
        this.writeMaskedE4KRegister(E4KEnhanceGain.getRegister(), E4KEnhanceGain.getMask(), gain.getValue(), controlI2CRepeater);
    }

    public E4KEnhanceGain getEnhanceGain(boolean controlI2CRepeater) throws UsbException {
        return E4KEnhanceGain.fromRegisterValue(this.readE4KRegister(E4KEnhanceGain.getRegister(), controlI2CRepeater));
    }

    public void setMixerGain(E4KMixerGain gain, boolean controlI2CRepeater) throws UsbException {
        if (controlI2CRepeater) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, true);
        }
        boolean localI2CRepeaterControl = false;
        if (gain == E4KMixerGain.AUTOMATIC) {
            this.writeMaskedE4KRegister(Register.AGC7, (byte)1, (byte)1, localI2CRepeaterControl);
        } else {
            this.writeMaskedE4KRegister(Register.AGC7, (byte)1, (byte)0, localI2CRepeaterControl);
            this.writeMaskedE4KRegister(E4KMixerGain.getRegister(), E4KMixerGain.getMask(), gain.getValue(), localI2CRepeaterControl);
        }
        if (controlI2CRepeater) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, false);
        }
    }

    public E4KMixerGain getMixerGain(boolean controlI2CRepeater) throws UsbException {
        byte autoOrManual = this.readMaskedE4KRegister(Register.AGC7, (byte)1, controlI2CRepeater);
        if (autoOrManual == 1) {
            return E4KMixerGain.AUTOMATIC;
        }
        int register = this.readE4KRegister(E4KMixerGain.getRegister(), controlI2CRepeater);
        return E4KMixerGain.fromRegisterValue(register);
    }

    public void setIFStage1Gain(IFStage1Gain gain, boolean controlI2CRepeater) throws UsbException {
        this.writeMaskedE4KRegister(IFStage1Gain.getRegister(), IFStage1Gain.getMask(), gain.getValue(), controlI2CRepeater);
    }

    public IFStage1Gain getIFStage1Gain(boolean controlI2CRepeater) throws UsbException {
        return IFStage1Gain.fromRegisterValue(this.readE4KRegister(IFStage1Gain.getRegister(), controlI2CRepeater));
    }

    public void setIFStage2Gain(IFStage2Gain gain, boolean controlI2CRepeater) throws UsbException {
        this.writeMaskedE4KRegister(IFStage2Gain.getRegister(), IFStage2Gain.getMask(), gain.getValue(), controlI2CRepeater);
    }

    public IFStage2Gain getIFStage2Gain(boolean controlI2CRepeater) throws UsbException {
        return IFStage2Gain.fromRegisterValue(this.readE4KRegister(IFStage2Gain.getRegister(), controlI2CRepeater));
    }

    public void setIFStage3Gain(IFStage3Gain gain, boolean controlI2CRepeater) throws UsbException {
        this.writeMaskedE4KRegister(IFStage3Gain.getRegister(), IFStage3Gain.getMask(), gain.getValue(), controlI2CRepeater);
    }

    public IFStage3Gain getIFStage3Gain(boolean controlI2CRepeater) throws UsbException {
        return IFStage3Gain.fromRegisterValue(this.readE4KRegister(IFStage3Gain.getRegister(), controlI2CRepeater));
    }

    public void setIFStage4Gain(IFStage4Gain gain, boolean controlI2CRepeater) throws UsbException {
        this.writeMaskedE4KRegister(IFStage4Gain.getRegister(), IFStage4Gain.getMask(), gain.getValue(), controlI2CRepeater);
    }

    public IFStage4Gain getIFStage4Gain(boolean controlI2CRepeater) throws UsbException {
        return IFStage4Gain.fromRegisterValue(this.readE4KRegister(IFStage4Gain.getRegister(), controlI2CRepeater));
    }

    public void setIFStage5Gain(IFStage5Gain gain, boolean controlI2CRepeater) throws UsbException {
        this.writeMaskedE4KRegister(IFStage5Gain.getRegister(), IFStage5Gain.getMask(), gain.getValue(), controlI2CRepeater);
    }

    public IFStage5Gain getIFStage5Gain(boolean controlI2CRepeater) throws UsbException {
        return IFStage5Gain.fromRegisterValue(this.readE4KRegister(IFStage5Gain.getRegister(), controlI2CRepeater));
    }

    public void setIFStage6Gain(IFStage6Gain gain, boolean controlI2CRepeater) throws UsbException {
        this.writeMaskedE4KRegister(IFStage6Gain.getRegister(), IFStage6Gain.getMask(), gain.getValue(), controlI2CRepeater);
    }

    public IFStage6Gain getIFStage6Gain(boolean controlI2CRepeater) throws UsbException {
        return IFStage6Gain.fromRegisterValue(this.readE4KRegister(IFStage6Gain.getRegister(), controlI2CRepeater));
    }

    public void setMixerFilter(MixerFilter filter, boolean controlI2CRepeater) throws LibUsbException {
        this.writeMaskedE4KRegister(MixerFilter.getRegister(), MixerFilter.getMask(), filter.getValue(), controlI2CRepeater);
    }

    public MixerFilter getMixerFilter(boolean controlI2CRepeater) throws UsbException {
        int value = this.readE4KRegister(MixerFilter.getRegister(), controlI2CRepeater);
        return MixerFilter.fromRegisterValue(value);
    }

    public void setRCFilter(RCFilter filter, boolean controlI2CRepeater) throws LibUsbException {
        this.writeMaskedE4KRegister(RCFilter.getRegister(), RCFilter.getMask(), filter.getValue(), controlI2CRepeater);
    }

    public RCFilter getRCFilter(boolean controlI2CRepeater) throws UsbException {
        int value = this.readE4KRegister(RCFilter.getRegister(), controlI2CRepeater);
        return RCFilter.fromRegisterValue(value);
    }

    public void setChannelFilter(ChannelFilter filter, boolean controlI2CRepeater) throws LibUsbException {
        this.writeMaskedE4KRegister(ChannelFilter.getRegister(), ChannelFilter.getMask(), filter.getValue(), controlI2CRepeater);
    }

    public ChannelFilter getChannelFilter(boolean controlI2CRepeater) throws UsbException {
        int value = this.readE4KRegister(ChannelFilter.getRegister(), controlI2CRepeater);
        return ChannelFilter.fromRegisterValue(value);
    }

    public void setChannelFilterEnabled(boolean enabled, boolean controlI2CRepeater) throws UsbException {
        if (enabled) {
            this.writeMaskedE4KRegister(Register.FILT3, (byte)32, (byte)0, controlI2CRepeater);
        } else {
            this.writeMaskedE4KRegister(Register.FILT3, (byte)32, (byte)32, controlI2CRepeater);
        }
    }

    public void setBand(long frequency, boolean controlI2CRepeater) throws UsbException {
        if (controlI2CRepeater) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, true);
        }
        Band band = Band.fromFrequency(frequency);
        switch (band) {
            case VHF2: 
            case VHF3: 
            case UHF: {
                this.writeE4KRegister(Register.BIAS, (byte)3, false);
                break;
            }
            default: {
                this.writeE4KRegister(Register.BIAS, (byte)0, false);
            }
        }
        this.writeMaskedE4KRegister(Register.SYNTH1, Band.getMask(), (byte)0, false);
        this.writeMaskedE4KRegister(Register.SYNTH1, Band.getMask(), band.getValue(), false);
        if (controlI2CRepeater) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, false);
        }
    }

    private void setRFFilter(long frequency, boolean controlI2CRepeater) throws UsbException {
        RFFilter filter = RFFilter.fromFrequency(frequency);
        this.writeMaskedE4KRegister(Register.FILT1, RFFilter.getMask(), filter.getValue(), controlI2CRepeater);
    }

    public void setGain(E4KGain gain, boolean controlI2CRepeater) throws UsbException {
        if (gain != E4KGain.MANUAL) {
            if (controlI2CRepeater) {
                E4KTunerController.enableI2CRepeater(this.mDeviceHandle, true);
            }
            boolean i2CRepeaterControl = false;
            this.setLNAGain(gain.getLNAGain(), i2CRepeaterControl);
            this.setMixerGain(gain.getMixerGain(), i2CRepeaterControl);
            this.setEnhanceGain(gain.getEnhanceGain(), i2CRepeaterControl);
            if (controlI2CRepeater) {
                E4KTunerController.enableI2CRepeater(this.mDeviceHandle, false);
            }
        }
    }

    private void magicInit(boolean controlI2CRepeater) throws UsbException {
        if (controlI2CRepeater) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, true);
        }
        this.writeE4KRegister(Register.MAGIC_1, (byte)1, false);
        this.writeE4KRegister(Register.MAGIC_2, (byte)-2, false);
        this.writeE4KRegister(Register.MAGIC_3, (byte)0, false);
        this.writeE4KRegister(Register.MAGIC_4, (byte)80, false);
        this.writeE4KRegister(Register.MAGIC_5, (byte)32, false);
        this.writeE4KRegister(Register.MAGIC_6, (byte)1, false);
        this.writeE4KRegister(Register.MAGIC_7, (byte)127, false);
        this.writeE4KRegister(Register.MAGIC_8, (byte)7, false);
        if (controlI2CRepeater) {
            E4KTunerController.enableI2CRepeater(this.mDeviceHandle, false);
        }
    }

    private byte readMaskedE4KRegister(Register register, byte mask, boolean controlI2CRepeater) throws UsbException {
        int temp = this.readE4KRegister(register, controlI2CRepeater);
        return (byte)(temp & mask);
    }

    private void writeMaskedE4KRegister(Register register, byte mask, byte value, boolean controlI2CRepeater) throws LibUsbException {
        int temp = this.readE4KRegister(register, controlI2CRepeater);
        if ((byte)(temp & mask) != value) {
            this.writeE4KRegister(register, (byte)(temp & ~mask | value & mask), controlI2CRepeater);
            this.readE4KRegister(register, controlI2CRepeater);
        }
    }

    private int readE4KRegister(Register register, boolean controlI2CRepeater) throws LibUsbException {
        return E4KTunerController.readI2CRegister(this.mDeviceHandle, Register.I2C_REGISTER.getValue(), register.getValue(), controlI2CRepeater);
    }

    private void writeE4KRegister(Register register, byte value, boolean controlI2CRepeater) throws LibUsbException {
        this.writeI2CRegister(this.mDeviceHandle, Register.I2C_REGISTER.getValue(), register.getValue(), value, controlI2CRepeater);
    }

    @Override
    public int setFrequency(long freq) throws DeviceException {
        this.setTunedFrequency(freq);
        return 0;
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public DevicePanel getDevicePanel() throws IOException, DeviceException {
        return new RTLPanelE4K();
    }

    public static enum AGCMode {
        SERIAL(0),
        IF_PWM_LNA_SERIAL(1),
        IF_PWM_LNA_AUTONL(2),
        IF_PWM_LNA_SUPERV(3),
        IF_SERIAL_LNA_PWM(4),
        IF_PWM_LNA_PWM(5),
        IF_DIG_LNA_SERIAL(6),
        IF_DIG_LNA_AUTON(7),
        IF_DIG_LNA_SUPERV(8),
        IF_SERIAL_LNA_AUTON(9),
        IF_SERIAL_LNA_SUPERV(10);

        private byte mValue;

        private AGCMode(byte value) {
            this.mValue = value;
        }

        public byte getValue() {
            return this.mValue;
        }
    }

    public static enum Band {
        VHF2(0),
        VHF3(2),
        UHF(4),
        L(6);

        private int mValue;

        private Band(int value) {
            this.mValue = value;
        }

        public static byte getMask() {
            return 6;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.toString();
        }

        public static Band fromFrequency(long frequency) {
            if (frequency < 140000000L) {
                return VHF2;
            }
            if (frequency < 350000000L) {
                return VHF3;
            }
            if (frequency < 1135000000L) {
                return UHF;
            }
            return L;
        }
    }

    public static enum ChannelFilter {
        BW_5M50(0, 5500000, 5400000, 28800000, "5.50 MHz"),
        BW_5M30(1, 5300000, 5150000, 5400000, "5.30 MHz"),
        BW_5M00(2, 5000000, 4900000, 5150000, "5.00 MHz"),
        BW_4M80(3, 4800000, 4700000, 4900000, "4.80 MHz"),
        BW_4M60(4, 4600000, 4500000, 4700000, "4.60 MHz"),
        BW_4M40(5, 4400000, 4350000, 4500000, "4.40 MHz"),
        BW_4M30(6, 4300000, 4200000, 4350000, "4.30 MHz"),
        BW_4M10(7, 4100000, 4000000, 4200000, "4.10 MHz"),
        BW_3M90(8, 3900000, 3850000, 4000000, "3.90 MHz"),
        BW_3M80(9, 3800000, 3750000, 3850000, "3.80 MHz"),
        BW_3M70(10, 3700000, 3650000, 3750000, "3.70 MHz"),
        BW_3M60(11, 3600000, 3500000, 3650000, "3.60 MHz"),
        BW_3M40(12, 3400000, 3350000, 3500000, "3.40 MHz"),
        BW_3M30(13, 3300000, 3250000, 3350000, "3.30 MHz"),
        BW_3M20(14, 3200000, 3150000, 3250000, "3.20 MHz"),
        BW_3M10(15, 3100000, 3050000, 3150000, "3.10 MHz"),
        BW_3M00(16, 3000000, 2975000, 3050000, "3.00 MHz"),
        BW_2M95(17, 2950000, 2925000, 2975000, "2.95 MHz"),
        BW_2M90(18, 2900000, 2850000, 2925000, "2.90 MHz"),
        BW_2M80(19, 2800000, 2775000, 2850000, "2.80 MHz"),
        BW_2M75(20, 2750000, 2750000, 2775000, "2.75 MHz"),
        BW_2M70(21, 2700000, 2650000, 2750000, "2.70 MHz"),
        BW_2M60(22, 2600000, 2575000, 2650000, "2.60 MHz"),
        BW_2M55(23, 2550000, 2525000, 2575000, "2.55 MHz"),
        BW_2M50(24, 2500000, 2475000, 2525000, "2.50 MHz"),
        BW_2M45(25, 2450000, 2425000, 2475000, "2.45 MHz"),
        BW_2M40(26, 2400000, 2350000, 2425000, "2.40 MHz"),
        BW_2M30(27, 2300000, 2290000, 2350000, "2.30 MHz"),
        BW_2M28(28, 2280000, 2260000, 2290000, "2.28 MHz"),
        BW_2M24(29, 0x222E00, 2220000, 2260000, "2.24 MHz"),
        BW_2M20(30, 2200000, 2175000, 2220000, "2.20 MHz"),
        BW_2M15(31, 2150000, 0, 2175000, "2.15 MHz");

        private int mValue;
        private int mBandwidth;
        private int mMinBandwidth;
        private int mMaxBandwidth;
        private String mLabel;

        private ChannelFilter(int value, int bandwidth, int minimumBandwidth, int maximumBandwidth, String label) {
            this.mValue = value;
            this.mBandwidth = bandwidth;
            this.mMinBandwidth = minimumBandwidth;
            this.mMaxBandwidth = maximumBandwidth;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.FILT3;
        }

        public static byte getMask() {
            return 31;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public int getBandwidth() {
            return this.mBandwidth;
        }

        public int getMinimumBandwidth() {
            return this.mMinBandwidth;
        }

        public int getMaximumBandwidth() {
            return this.mMaxBandwidth;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static ChannelFilter getFilter(int bandwidth) {
            ChannelFilter[] channelFilterArray = ChannelFilter.values();
            int n = channelFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChannelFilter filter = channelFilterArray[n2];
                if (filter.getMinimumBandwidth() <= bandwidth && bandwidth < filter.getMaximumBandwidth()) {
                    return filter;
                }
                ++n2;
            }
            return BW_5M50;
        }

        public static ChannelFilter fromRegisterValue(int registerValue) {
            int value = registerValue & ChannelFilter.getMask();
            ChannelFilter[] channelFilterArray = ChannelFilter.values();
            int n = channelFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChannelFilter filter = channelFilterArray[n2];
                if (value == filter.getValue()) {
                    return filter;
                }
                ++n2;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized channel filter value [" + value + "]");
        }
    }

    public static enum DCGainCombination {
        LOOKUP_TABLE_0(Register.QLUT0, Register.ILUT0, E4KMixerGain.GAIN_4, IFStage1Gain.GAIN_MINUS3),
        LOOKUP_TABLE_1(Register.QLUT1, Register.ILUT1, E4KMixerGain.GAIN_4, IFStage1Gain.GAIN_PLUS6),
        LOOKUP_TABLE_2(Register.QLUT2, Register.ILUT2, E4KMixerGain.GAIN_12, IFStage1Gain.GAIN_MINUS3),
        LOOKUP_TABLE_3(Register.QLUT3, Register.ILUT3, E4KMixerGain.GAIN_12, IFStage1Gain.GAIN_PLUS6);

        private Register mQRegister;
        private Register mIRegister;
        private E4KMixerGain mMixerGain;
        private IFStage1Gain mIFStage1Gain;

        private DCGainCombination(Register qRegister, Register iRegister, E4KMixerGain mixer, IFStage1Gain stage1) {
            this.mQRegister = qRegister;
            this.mIRegister = iRegister;
            this.mMixerGain = mixer;
            this.mIFStage1Gain = stage1;
        }

        public Register getQRegister() {
            return this.mQRegister;
        }

        public Register getIRegister() {
            return this.mIRegister;
        }

        public E4KMixerGain getMixerGain() {
            return this.mMixerGain;
        }

        public IFStage1Gain getIFStage1Gain() {
            return this.mIFStage1Gain;
        }
    }

    public static enum E4KEnhanceGain {
        AUTOMATIC(0, "Auto"),
        GAIN_1(1, "10 db"),
        GAIN_3(3, "30 db"),
        GAIN_5(5, "50 db"),
        GAIN_7(7, "70 db");

        private int mValue;
        private String mLabel;

        private E4KEnhanceGain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.AGC11;
        }

        public static byte getMask() {
            return 7;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static E4KEnhanceGain fromRegisterValue(int registerValue) {
            int value = registerValue & E4KEnhanceGain.getMask();
            E4KEnhanceGain[] e4KEnhanceGainArray = E4KEnhanceGain.values();
            int n = e4KEnhanceGainArray.length;
            int n2 = 0;
            while (n2 < n) {
                E4KEnhanceGain setting = e4KEnhanceGainArray[n2];
                if (value == setting.getValue()) {
                    return setting;
                }
                ++n2;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized Enhance Gain value [" + value + "]");
        }
    }

    public static enum E4KGain {
        AUTOMATIC("Auto", E4KMixerGain.AUTOMATIC, E4KLNAGain.AUTOMATIC, E4KEnhanceGain.AUTOMATIC),
        MANUAL("Manual", null, null, null),
        MINUS_10("-1.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_MINUS_50, E4KEnhanceGain.AUTOMATIC),
        PLUS_15("1.5 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_MINUS_25, E4KEnhanceGain.AUTOMATIC),
        PLUS_40("4.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_0, E4KEnhanceGain.AUTOMATIC),
        PLUS_65("6.5 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_25, E4KEnhanceGain.AUTOMATIC),
        PLUS_90("9.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_50, E4KEnhanceGain.AUTOMATIC),
        PLUS_115("11.5 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_75, E4KEnhanceGain.AUTOMATIC),
        PLUS_140("14.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_100, E4KEnhanceGain.AUTOMATIC),
        PLUS_165("16.5 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_125, E4KEnhanceGain.AUTOMATIC),
        PLUS_190("19.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_150, E4KEnhanceGain.AUTOMATIC),
        PLUS_215("21.5 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_175, E4KEnhanceGain.AUTOMATIC),
        PLUS_240("24.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_200, E4KEnhanceGain.AUTOMATIC),
        PLUS_290("29.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_250, E4KEnhanceGain.AUTOMATIC),
        PLUS_340("34.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_300, E4KEnhanceGain.AUTOMATIC),
        PLUS_420("42.0 db", E4KMixerGain.GAIN_12, E4KLNAGain.GAIN_PLUS_300, E4KEnhanceGain.AUTOMATIC);

        private String mLabel;
        private E4KMixerGain mMixerGain;
        private E4KLNAGain mLNAGain;
        private E4KEnhanceGain mEnhanceGain;

        private E4KGain(String label, E4KMixerGain mixerGain, E4KLNAGain lnaGain, E4KEnhanceGain enhanceGain) {
            this.mLabel = label;
            this.mMixerGain = mixerGain;
            this.mLNAGain = lnaGain;
            this.mEnhanceGain = enhanceGain;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public E4KMixerGain getMixerGain() {
            return this.mMixerGain;
        }

        public E4KLNAGain getLNAGain() {
            return this.mLNAGain;
        }

        public E4KEnhanceGain getEnhanceGain() {
            return this.mEnhanceGain;
        }
    }

    public static enum E4KLNAGain {
        AUTOMATIC(-1, "Auto"),
        GAIN_MINUS_50(0, "-5.0 db"),
        GAIN_MINUS_25(1, "-2.5 db"),
        GAIN_PLUS_0(4, "0.0 db"),
        GAIN_PLUS_25(5, "2.5 db"),
        GAIN_PLUS_50(6, "5.0 db"),
        GAIN_PLUS_75(7, "7.5 db"),
        GAIN_PLUS_100(8, "10.0 db"),
        GAIN_PLUS_125(9, "12.5 db"),
        GAIN_PLUS_150(10, "15.0 db"),
        GAIN_PLUS_175(11, "17.5 db"),
        GAIN_PLUS_200(12, "20.0 db"),
        GAIN_PLUS_250(13, "25.0 db"),
        GAIN_PLUS_300(14, "30.0 db");

        private int mValue;
        private String mLabel;

        private E4KLNAGain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN1;
        }

        public static byte getMask() {
            return 15;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static E4KLNAGain fromRegisterValue(int registerValue) {
            int value = registerValue & E4KLNAGain.getMask();
            E4KLNAGain[] e4KLNAGainArray = E4KLNAGain.values();
            int n = e4KLNAGainArray.length;
            int n2 = 0;
            while (n2 < n) {
                E4KLNAGain setting = e4KLNAGainArray[n2];
                if (value == setting.getValue()) {
                    return setting;
                }
                ++n2;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized LNA Gain value [" + value + "]");
        }
    }

    public static enum E4KMixerGain {
        AUTOMATIC(-1, "Auto"),
        GAIN_4(0, "4 db"),
        GAIN_12(1, "12 db");

        private int mValue;
        private String mLabel;

        private E4KMixerGain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN2;
        }

        public static byte getMask() {
            return 1;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static E4KMixerGain fromRegisterValue(int registerValue) {
            int value = registerValue & E4KMixerGain.getMask();
            E4KMixerGain[] e4KMixerGainArray = E4KMixerGain.values();
            int n = e4KMixerGainArray.length;
            int n2 = 0;
            while (n2 < n) {
                E4KMixerGain setting = e4KMixerGainArray[n2];
                if (value == setting.getValue()) {
                    return setting;
                }
                ++n2;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized Mixer Gain value [" + value + "]");
        }
    }

    public static enum IFFilter {
        MIX("Mix"),
        CHAN("Channel"),
        RC("RC");

        private String mLabel;

        private IFFilter(String label) {
            this.mLabel = label;
        }

        public String getLabel() {
            return this.mLabel;
        }
    }

    public static enum IFStage1Gain {
        GAIN_MINUS3(0, "-3 db"),
        GAIN_PLUS6(1, "6 db");

        private int mValue;
        private String mLabel;

        private IFStage1Gain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN3;
        }

        public static byte getMask() {
            return 1;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static IFStage1Gain fromRegisterValue(int registerValue) {
            int value = registerValue & IFStage1Gain.getMask();
            IFStage1Gain[] iFStage1GainArray = IFStage1Gain.values();
            int n = iFStage1GainArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFStage1Gain setting = iFStage1GainArray[n2];
                if (value == setting.getValue()) {
                    return setting;
                }
                ++n2;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized IF Gain Stage 1 value [" + value + "]");
        }
    }

    public static enum IFStage2Gain {
        GAIN_PLUS0(0, "0 db"),
        GAIN_PLUS3(2, "3 db"),
        GAIN_PLUS6(4, "6 db"),
        GAIN_PLUS9(6, "9 db");

        private int mValue;
        private String mLabel;

        private IFStage2Gain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN3;
        }

        public static byte getMask() {
            return 6;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static IFStage2Gain fromRegisterValue(int registerValue) {
            int value = registerValue & IFStage2Gain.getMask();
            IFStage2Gain[] iFStage2GainArray = IFStage2Gain.values();
            int n = iFStage2GainArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFStage2Gain setting = iFStage2GainArray[n2];
                if (value == setting.getValue()) {
                    return setting;
                }
                ++n2;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized IF Gain Stage 2 value [" + value + "]");
        }
    }

    public static enum IFStage3Gain {
        GAIN_PLUS0(0, "0 db"),
        GAIN_PLUS3(8, "3 db"),
        GAIN_PLUS6(16, "6 db"),
        GAIN_PLUS9(48, "9 db");

        private int mValue;
        private String mLabel;

        private IFStage3Gain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN3;
        }

        public static byte getMask() {
            return 24;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static IFStage3Gain fromRegisterValue(int registerValue) {
            int value = registerValue & IFStage3Gain.getMask();
            IFStage3Gain[] iFStage3GainArray = IFStage3Gain.values();
            int n = iFStage3GainArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFStage3Gain setting = iFStage3GainArray[n2];
                if (value == setting.getValue()) {
                    return setting;
                }
                ++n2;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized IF Gain Stage 3 value [" + value + "]");
        }
    }

    public static enum IFStage4Gain {
        GAIN_PLUS0(0, "0 db"),
        GAIN_PLUS1(32, "1 db"),
        GAIN_PLUS2A(64, "2 db"),
        GAIN_PLUS2B(96, "2 db");

        private int mValue;
        private String mLabel;

        private IFStage4Gain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN3;
        }

        public static byte getMask() {
            return 96;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static IFStage4Gain fromRegisterValue(int registerValue) {
            int value = registerValue & IFStage4Gain.getMask();
            IFStage4Gain[] iFStage4GainArray = IFStage4Gain.values();
            int n = iFStage4GainArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFStage4Gain setting = iFStage4GainArray[n2];
                if (value == setting.getValue()) {
                    return setting;
                }
                ++n2;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized IF Gain Stage 4 value [" + value + "]");
        }
    }

    public static enum IFStage5Gain {
        GAIN_PLUS3(0, "3 db"),
        GAIN_PLUS6(1, "6 db"),
        GAIN_PLUS9(2, "9 db"),
        GAIN_PLUS12(3, "12 db"),
        GAIN_PLUS15A(4, "15 db"),
        GAIN_PLUS15B(5, "15 db"),
        GAIN_PLUS15C(6, "15 db"),
        GAIN_PLUS15D(7, "15 db");

        private int mValue;
        private String mLabel;

        private IFStage5Gain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN4;
        }

        public static byte getMask() {
            return 7;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static IFStage5Gain fromRegisterValue(int registerValue) {
            int value = registerValue & IFStage5Gain.getMask();
            IFStage5Gain[] iFStage5GainArray = IFStage5Gain.values();
            int n = iFStage5GainArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFStage5Gain setting = iFStage5GainArray[n2];
                if (value == setting.getValue()) {
                    return setting;
                }
                ++n2;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized IF Gain Stage 5 value [" + value + "]");
        }
    }

    public static enum IFStage6Gain {
        GAIN_PLUS3(0, "3 db"),
        GAIN_PLUS6(8, "6 db"),
        GAIN_PLUS9(16, "9 db"),
        GAIN_PLUS12(24, "12 db"),
        GAIN_PLUS15A(32, "15 db"),
        GAIN_PLUS15B(40, "15 db"),
        GAIN_PLUS15C(48, "15 db"),
        GAIN_PLUS15D(56, "15 db");

        private int mValue;
        private String mLabel;

        private IFStage6Gain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN4;
        }

        public static byte getMask() {
            return 56;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static IFStage6Gain fromRegisterValue(int registerValue) {
            int value = registerValue & IFStage6Gain.getMask();
            IFStage6Gain[] iFStage6GainArray = IFStage6Gain.values();
            int n = iFStage6GainArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFStage6Gain setting = iFStage6GainArray[n2];
                if (value == setting.getValue()) {
                    return setting;
                }
                ++n2;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized IF Gain Stage 6 value [" + value + "]");
        }
    }

    public static enum MixerFilter {
        BW_27M0(0, 27000000, 4800000, 28800000, "27.0 MHz"),
        BW_4M6(128, 4600000, 4400000, 4800000, "4.6 MHz"),
        BW_4M2(144, 4200000, 4000000, 4400000, "4.2 MHz"),
        BW_3M8(160, 3800000, 3600000, 4000000, "3.8 MHz"),
        BW_3M4(176, 3400000, 3200000, 3600000, "3.4 MHz"),
        BW_3M0(192, 3000000, 2850000, 3200000, "3.0 MHz"),
        BW_2M7(208, 2700000, 2500000, 2850000, "2.7 MHz"),
        BW_2M3(224, 2300000, 0x200B20, 2500000, "2.3 MHz"),
        BW_1M9(240, 1900000, 0, 0x200B20, "1.9 MHz");

        private int mValue;
        private int mBandwidth;
        private int mMinBandwidth;
        private int mMaxBandwidth;
        private String mLabel;

        private MixerFilter(int value, int bandwidth, int minimumBandwidth, int maximumBandwidth, String label) {
            this.mValue = value;
            this.mBandwidth = bandwidth;
            this.mMinBandwidth = minimumBandwidth;
            this.mMaxBandwidth = maximumBandwidth;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.FILT2;
        }

        public static byte getMask() {
            return -16;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public int getBandwidth() {
            return this.mBandwidth;
        }

        public int getMinimumBandwidth() {
            return this.mMinBandwidth;
        }

        public int getMaximumBandwidth() {
            return this.mMaxBandwidth;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static MixerFilter getFilter(int bandwidth) {
            MixerFilter[] mixerFilterArray = MixerFilter.values();
            int n = mixerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                MixerFilter filter = mixerFilterArray[n2];
                if (filter.getMinimumBandwidth() <= bandwidth && bandwidth < filter.getMaximumBandwidth()) {
                    return filter;
                }
                ++n2;
            }
            return BW_27M0;
        }

        public static MixerFilter fromRegisterValue(int registerValue) {
            int value = registerValue & MixerFilter.getMask();
            MixerFilter[] mixerFilterArray = MixerFilter.values();
            int n = mixerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                MixerFilter filter = mixerFilterArray[n2];
                if (value == filter.getValue()) {
                    return filter;
                }
                ++n2;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized mixer filter value [" + value + "]");
        }
    }

    public static enum PLL {
        PLL_72M4(15, 72400000L, 48, 600000, true, "72.4 MHz"),
        PLL_81M2(14, 81200000L, 40, 720000, true, "81.2 MHz"),
        PLL_108M3(13, 108300000L, 32, 900000, true, "108.3 MHz"),
        PLL_162M5(12, 162500000L, 24, 1200000, true, "162.5 MHz"),
        PLL_216M6(11, 216600000L, 16, 1800000, true, "216.6 MHz"),
        PLL_325M0(10, 325000000L, 12, 2400000, true, "325.0 MHz"),
        PLL_350M0(9, 350000000L, 8, 3600000, true, "350.0 MHz"),
        PLL_432M0(3, 432000000L, 8, 3600000, false, "432.0 MHz"),
        PLL_667M0(2, 667000000L, 6, 4800000, false, "667.0 MHz"),
        PLL_1200M0(1, 1200000000L, 4, 0x6DDD00, false, "1200.0 MHz");

        private int mValue;
        private long mFrequency;
        private int mMultiplier;
        private int mScaledOscillator;
        private boolean mRequires3PhaseMixing;
        private String mLabel;

        private PLL(int value, long frequency, int multiplier, int scaledOscillator, boolean requires3Phase, String label) {
            this.mValue = value;
            this.mFrequency = frequency;
            this.mMultiplier = multiplier;
            this.mScaledOscillator = scaledOscillator;
            this.mRequires3PhaseMixing = requires3Phase;
            this.mLabel = label;
        }

        public byte getIndex() {
            return (byte)this.mValue;
        }

        public long getFrequency() {
            return this.mFrequency;
        }

        public byte getMultiplier() {
            return (byte)this.mMultiplier;
        }

        public int getScaledOscillator() {
            return this.mScaledOscillator;
        }

        public boolean requires3PhaseMixing() {
            return this.mRequires3PhaseMixing;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static PLL fromFrequency(long frequency) {
            PLL[] pLLArray = PLL.values();
            int n = pLLArray.length;
            int n2 = 0;
            while (n2 < n) {
                PLL pll = pLLArray[n2];
                if (frequency < pll.getFrequency()) {
                    return pll;
                }
                ++n2;
            }
            return PLL_72M4;
        }

        public static PLL fromSetting(int setting) {
            int value = setting & 0xF;
            PLL[] pLLArray = PLL.values();
            int n = pLLArray.length;
            int n2 = 0;
            while (n2 < n) {
                PLL pll = pLLArray[n2];
                if (value == pll.getIndex()) {
                    return pll;
                }
                ++n2;
            }
            return PLL_72M4;
        }
    }

    public static enum RCFilter {
        BW_21M4(0, 21400000, 21200000, 28800000, "21.4 MHz"),
        BW_21M0(1, 21000000, 19300000, 21200000, "21.0 MHz"),
        BW_17M6(2, 17600000, 16150000, 19300000, "17.6 MHz"),
        BW_14M7(3, 14700000, 13550000, 16150000, "14.7 MHz"),
        BW_12M4(4, 12400000, 11500000, 13550000, "12.4 MHz"),
        BW_10M6(5, 10600000, 9800000, 11500000, "10.6 MHz"),
        BW_9M0(6, 9000000, 8350000, 9800000, "9.0 MHz"),
        BW_7M7(7, 7700000, 7050000, 8350000, "7.7 MHz"),
        BW_6M4(8, 6400000, 5805000, 7050000, "6.4 MHz"),
        BW_5M3(9, 5300000, 4850000, 5805000, "5.3 MHz"),
        BW_4M4(10, 4400000, 3900000, 4850000, "4.4 MHz"),
        BW_3M4(11, 3400000, 3000000, 3900000, "3.4 MHz"),
        BW_2M6(12, 2600000, 2200000, 3000000, "2.6 MHz"),
        BW_1M8(13, 1800000, 1500000, 2200000, "1.8 MHz"),
        BW_1M2(14, 1200000, 1100000, 1500000, "1.2 MHz"),
        BW_1M0(15, 1000000, 0, 1100000, "1.0 MHz");

        private int mValue;
        private int mBandwidth;
        private int mMinBandwidth;
        private int mMaxBandwidth;
        private String mLabel;

        private RCFilter(int value, int bandwidth, int minimumBandwidth, int maximumBandwidth, String label) {
            this.mValue = value;
            this.mBandwidth = bandwidth;
            this.mMinBandwidth = minimumBandwidth;
            this.mMaxBandwidth = maximumBandwidth;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.FILT2;
        }

        public static byte getMask() {
            return 15;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public int getBandwidth() {
            return this.mBandwidth;
        }

        public int getMinimumBandwidth() {
            return this.mMinBandwidth;
        }

        public int getMaximumBandwidth() {
            return this.mMaxBandwidth;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static RCFilter getFilter(int bandwidth) {
            RCFilter[] rCFilterArray = RCFilter.values();
            int n = rCFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                RCFilter filter = rCFilterArray[n2];
                if (filter.getMinimumBandwidth() <= bandwidth && bandwidth < filter.getMaximumBandwidth()) {
                    return filter;
                }
                ++n2;
            }
            return BW_21M4;
        }

        public static RCFilter fromRegisterValue(int registerValue) {
            int value = registerValue & RCFilter.getMask();
            RCFilter[] rCFilterArray = RCFilter.values();
            int n = rCFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                RCFilter filter = rCFilterArray[n2];
                if (value == filter.getValue()) {
                    return filter;
                }
                ++n2;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized rc filter value [" + value + "]");
        }
    }

    public static enum RFFilter {
        NO_FILTER(0, 0L, 0L),
        M360(0, 350000000L, 370000000L),
        M380(1, 370000000L, 392500000L),
        M405(2, 392500000L, 417500000L),
        M425(3, 417500000L, 437500000L),
        M450(4, 437500000L, 462500000L),
        M475(5, 462500000L, 490000000L),
        M505(6, 490000000L, 522500000L),
        M540(7, 522500000L, 557500000L),
        M575(8, 557500000L, 595000000L),
        M615(9, 595000000L, 642500000L),
        M670(10, 642500000L, 695000000L),
        M720(11, 695000000L, 740000000L),
        M760(12, 740000000L, 800000000L),
        M840(13, 800000000L, 865000000L),
        M890(14, 865000000L, 930000000L),
        M970(15, 930000000L, 1135000000L),
        M1300(0, 1135000000L, 1310000000L),
        M1320(1, 1310000000L, 1340000000L),
        M1360(2, 1340000000L, 1385000000L),
        M1410(3, 1385000000L, 1427500000L),
        M1445(4, 1427500000L, 1452500000L),
        M1460(5, 1452500000L, 1475000000L),
        M1490(6, 1475000000L, 1510000000L),
        M1530(7, 1510000000L, 1545000000L),
        M1560(8, 1545000000L, 1575000000L),
        M1590(9, 1575000000L, 1615000000L),
        M1640(10, 1615000000L, 1650000000L),
        M1660(11, 1650000000L, 1670000000L),
        M1680(12, 1670000000L, 1690000000L),
        M1700(13, 1690000000L, 1710000000L),
        M1720(14, 1710000000L, 1735000000L),
        M1750(15, 1735000000L, 2147000000L);

        private int mValue;
        private long mMinFrequency;
        private long mMaxFrequency;

        private RFFilter(int value, long minFrequency, long maxFrequency) {
            this.mValue = value;
            this.mMinFrequency = minFrequency;
            this.mMaxFrequency = maxFrequency;
        }

        public static Register getRegister() {
            return Register.FILT1;
        }

        public static byte getMask() {
            return 15;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public long getMinimumFrequency() {
            return this.mMinFrequency;
        }

        public long getMaximumFrequency() {
            return this.mMaxFrequency;
        }

        public static RFFilter fromFrequency(long frequency) {
            if (frequency < 350000000L) {
                return NO_FILTER;
            }
            RFFilter[] rFFilterArray = RFFilter.values();
            int n = rFFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                RFFilter filter = rFFilterArray[n2];
                if (filter.getMinimumFrequency() <= frequency && frequency < filter.getMaximumFrequency()) {
                    return filter;
                }
                ++n2;
            }
            throw new IllegalArgumentException("E4KTunerController - cannot find RF filter for frequency [" + frequency + "]");
        }
    }

    public static enum Register {
        DUMMY(0),
        MASTER1(0),
        MASTER2(1),
        MASTER3(2),
        MASTER4(3),
        MASTER5(4),
        CLK_INP(5),
        REF_CLK(6),
        SYNTH1(7),
        SYNTH2(8),
        SYNTH3(9),
        SYNTH4(10),
        SYNTH5(11),
        SYNTH6(12),
        SYNTH7(13),
        SYNTH8(14),
        SYNTH9(15),
        FILT1(16),
        FILT2(17),
        FILT3(18),
        GAIN1(20),
        GAIN2(21),
        GAIN3(22),
        GAIN4(23),
        AGC1(26),
        AGC2(27),
        AGC3(28),
        AGC4(29),
        AGC5(30),
        AGC6(31),
        AGC7(32),
        AGC8(33),
        AGC11(36),
        AGC12(37),
        DC1(41),
        DC2(42),
        DC3(43),
        DC4(44),
        DC5(45),
        DC6(46),
        DC7(47),
        DC8(48),
        QLUT0(80),
        QLUT1(81),
        QLUT2(82),
        QLUT3(83),
        ILUT0(96),
        ILUT1(97),
        ILUT2(98),
        ILUT3(99),
        DCTIME1(112),
        DCTIME2(113),
        DCTIME3(114),
        DCTIME4(115),
        PWM1(116),
        PWM2(117),
        PWM3(118),
        PWM4(119),
        BIAS(120),
        CLKOUT_PWDN(122),
        CHFILT_CALIB(123),
        I2C_REG_ADDR(125),
        MAGIC_1(126),
        MAGIC_2(127),
        MAGIC_3(130),
        MAGIC_4(134),
        MAGIC_5(135),
        MAGIC_6(136),
        MAGIC_7(159),
        MAGIC_8(160),
        I2C_REGISTER(200);

        private int mValue;

        private Register(int value) {
            this.mValue = value;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }
    }
}

