/*
 * Decompiled with CFR 0.152.
 */
package filter;

import common.Log;
import filter.Filter;
import javax.sound.sampled.AudioFormat;

public class RaisedCosineFilter
extends Filter {
    protected double[] xv;
    int M = 0;
    double GAIN = 1.0;
    double alpha = 0.5;
    double Fc = 0.0;
    double[] xcoeffs;

    public RaisedCosineFilter(AudioFormat af, int size) {
        super(af, size);
    }

    @Override
    public void init(double sampleRate, double freq, int len) {
        this.M = len;
        this.xcoeffs = new double[this.M + 1];
        this.Fc = freq / sampleRate;
        this.xv = new double[this.M + 1];
        double sumofsquares = 0.0;
        double[] tempCoeffs = new double[this.M + 1];
        int limit = (int)(0.5 / (this.alpha * this.Fc));
        int i = 0;
        while (i <= this.M) {
            double sinc = Math.sin(Math.PI * 2 * this.Fc * (double)(i - this.M / 2)) / (double)(i - this.M / 2);
            double cos = Math.cos(this.alpha * Math.PI * this.Fc * (double)(i - this.M / 2)) / (1.0 - Math.pow(2.0 * this.alpha * this.Fc * (double)(i - this.M / 2), 2.0));
            tempCoeffs[i] = i == this.M / 2 ? Math.PI * 2 * this.Fc * cos : sinc * cos;
            if (i - this.M / 2 == limit || i - this.M / 2 == -limit) {
                tempCoeffs[i] = 0.7853981633974483 * sinc;
            }
            sumofsquares += tempCoeffs[i] * tempCoeffs[i];
            ++i;
        }
        this.GAIN = Math.sqrt(sumofsquares);
        Log.println("Raised Cosine Filter GAIN: " + this.GAIN);
        super.init(sampleRate, freq, len);
        this.name = "RaisedCosine (" + this.cutoffFreq + " " + this.xcoeffs.length + " stereo:" + this.stereo + " Rate: " + this.SAMPLERATE + ")";
        i = 0;
        while (i < tempCoeffs.length) {
            this.xcoeffs[i] = tempCoeffs[tempCoeffs.length - i - 1] / this.GAIN;
            ++i;
        }
    }

    @Override
    public double filterDouble(double in) {
        int i = 0;
        while (i < this.M) {
            this.xv[i] = this.xv[i + 1];
            ++i;
        }
        this.xv[this.M] = in;
        if (this.calculateNow()) {
            double sum = 0.0;
            i = 0;
            while (i <= this.M) {
                sum += this.xcoeffs[i] * this.xv[i];
                ++i;
            }
            return sum;
        }
        return 0.0;
    }

    @Override
    protected int getFilterLength() {
        return this.xcoeffs.length;
    }

    @Override
    public double[] getKernal() {
        return this.xcoeffs;
    }
}

