/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FilterPanel
extends JPanel
implements ChangeListener,
ActionListener {
    public static final int MATCHED = 2;
    public static final int RAISED_COSINE = 0;
    public static final int WINDOWED_SINC = 1;
    public static final int MAX_FILTERS = 3;
    String[] filterName = new String[]{"Raised Cosine", "Windowed Sinc", "Matched"};
    public static final int WS_LEN_MIN = 480;
    public static final int WS_LEN_MAX = 4800;
    public static final int RC_LEN_MIN = 64;
    public static final int RC_LEN_MAX = 512;
    public static final int FREQ_MIN = 0;
    public static final int FREQ_MAX = 400;
    public static final int FREQ_STEP = 25;
    JRadioButton[] filterRadioButtons;
    JSlider rcSlider;
    JSlider wsSlider;
    JSlider freqSlider;
    JLabel lFreq;
    JLabel lLength;
    private String L_FREQ = "Cutoff frequency (Hz)";
    private String L_LENGTH = "Filter Length (samples)";

    FilterPanel() {
        this.setBorder(new TitledBorder(null, "Data Under Voice (DUV) Filter", 4, 2, null, null));
        this.initializeGui();
    }

    public void initializeGui() {
        this.setLayout(new BoxLayout(this, 1));
        ButtonGroup group = new ButtonGroup();
        this.filterRadioButtons = new JRadioButton[3];
        int i = 0;
        while (i < 3) {
            this.filterRadioButtons[i] = this.addRadioButton(this.filterName[i]);
            group.add(this.filterRadioButtons[i]);
            ++i;
        }
        JLabel filler0 = new JLabel("");
        filler0.setMinimumSize(new Dimension(14, 14));
        filler0.setMaximumSize(new Dimension(14, 14));
        this.add(filler0);
        this.lFreq = new JLabel(this.L_FREQ);
        this.lFreq.setAlignmentX(0.0f);
        this.add(this.lFreq);
        this.freqSlider = this.createSlider(0, 400, (int)Config.filterFrequency);
        this.freqSlider.setMinorTickSpacing(25);
        this.add(this.freqSlider);
        JLabel filler1 = new JLabel("");
        filler1.setMinimumSize(new Dimension(14, 14));
        filler1.setMaximumSize(new Dimension(14, 14));
        this.add(filler1);
        this.lLength = new JLabel(this.L_LENGTH);
        this.lLength.setAlignmentX(0.0f);
        this.add(this.lLength);
        this.rcSlider = this.createSlider(64, 512, 64);
        this.wsSlider = this.createSlider(480, 4800, 960);
        this.add(this.rcSlider);
        this.add(this.wsSlider);
        JLabel filler2 = new JLabel("");
        filler2.setMinimumSize(new Dimension(14, 44));
        filler2.setMaximumSize(new Dimension(14, 44));
        this.add(filler2);
        this.setFilter();
    }

    private JSlider createSlider(int min, int max, int tick) {
        JSlider slideFilterLength = new JSlider(0, min, max, tick);
        slideFilterLength.addChangeListener(this);
        slideFilterLength.setMajorTickSpacing(tick);
        slideFilterLength.setPaintTicks(true);
        slideFilterLength.setPaintLabels(true);
        slideFilterLength.setSnapToTicks(true);
        return slideFilterLength;
    }

    public static void checkFilterParams() {
        if (Config.useFilterNumber == 0) {
            if (Config.filterLength > 512) {
                Config.filterLength = 512;
            }
        } else if (Config.useFilterNumber == 1 && Config.filterLength < 480) {
            Config.filterLength = 480;
        }
    }

    private void updateSlider() {
        FilterPanel.checkFilterParams();
        if (Config.useFilterNumber == 0) {
            this.rcSlider.setVisible(true);
            this.wsSlider.setVisible(false);
            this.rcSlider.setValue(Config.filterLength);
            this.freqSlider.setVisible(true);
        } else if (Config.useFilterNumber == 1) {
            this.rcSlider.setVisible(false);
            this.wsSlider.setVisible(true);
            this.wsSlider.setValue(Config.filterLength);
            this.freqSlider.setVisible(true);
        } else {
            this.rcSlider.setVisible(false);
            this.wsSlider.setVisible(false);
            this.freqSlider.setVisible(false);
        }
        this.lFreq.setText(String.valueOf(this.L_FREQ) + " " + Config.filterFrequency);
        this.lLength.setText(String.valueOf(this.L_LENGTH) + " " + Config.filterLength);
    }

    private void setFilter() {
        this.updateSlider();
        this.filterRadioButtons[Config.useFilterNumber].setSelected(true);
    }

    private JRadioButton addRadioButton(String name) {
        JRadioButton radioButton = new JRadioButton(name);
        radioButton.setEnabled(true);
        radioButton.addActionListener(this);
        this.add(radioButton);
        return radioButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i = 0;
        while (i < 3) {
            if (e.getSource() == this.filterRadioButtons[i]) {
                Config.useFilterNumber = i;
                this.setFilter();
                Config.save();
            }
            ++i;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            if (source == this.freqSlider) {
                int freq = source.getValue();
                Config.filterFrequency = freq;
                Config.save();
            } else {
                int len;
                Config.filterLength = len = source.getValue();
                Config.save();
            }
        }
    }
}

