/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;

public class ServerDownloadDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JButton btnSave;
    JButton btnCancel;
    JButton btnClear;
    JButton btnSelectAll;
    JList<String> list;

    public ServerDownloadDialog(JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        int x;
        this.setTitle("Download Server Data");
        this.setDefaultCloseOperation(2);
        int y = this.getOwner().getY() + this.getOwner().getHeight() / 2 - 300;
        if (y < 0) {
            y = 0;
        }
        if ((x = this.getOwner().getX() + this.getOwner().getWidth() / 2 - 150) < 0) {
            x = 0;
        }
        this.setBounds(x, y, 300, 400);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(contentPane);
        JPanel southpanel = new JPanel();
        contentPane.add((Component)southpanel, "South");
        southpanel.setLayout(new FlowLayout(1, 5, 5));
        this.btnSave = new JButton("Download");
        this.btnSave.addActionListener(this);
        southpanel.add(this.btnSave);
        this.getRootPane().setDefaultButton(this.btnSave);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this);
        southpanel.add(this.btnCancel);
        JPanel northpanel = new JPanel();
        contentPane.add((Component)northpanel, "North");
        northpanel.setLayout(new BoxLayout(northpanel, 0));
        this.btnSelectAll = new JButton("Select all");
        northpanel.add(this.btnSelectAll);
        this.btnClear = new JButton("Clear");
        northpanel.add(this.btnClear);
        this.btnSelectAll.addActionListener(this);
        this.btnClear.addActionListener(this);
        JPanel centerpanel = new JPanel();
        contentPane.add((Component)centerpanel, "Center");
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        ArrayList<Spacecraft> names = Config.satManager.spacecraftList;
        for (Spacecraft sat : names) {
            listModel.addElement(sat.user_display_name);
        }
        this.list = new JList(listModel);
        this.list.setSelectionModel(new DefaultListSelectionModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (ServerDownloadDialog.this.list.isSelectedIndex(index0)) {
                    ServerDownloadDialog.this.list.removeSelectionInterval(index0, index1);
                } else {
                    ServerDownloadDialog.this.list.addSelectionInterval(index0, index1);
                }
            }
        });
        this.list.setLayoutOrientation(0);
        this.list.setVisibleRowCount(-1);
        ListModel<String> model = this.list.getModel();
        this.list.setSelectionInterval(0, ((DefaultListModel)model).getSize() - 1);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(100, 200));
        centerpanel.add(listScroller);
    }

    public void setSelectedValues(JList<String> list, List<String> values) {
        list.clearSelection();
        for (String value : values) {
            int index = this.getIndex(list.getModel(), value);
            if (index < 0) continue;
            list.addSelectionInterval(index, index);
        }
    }

    public int getIndex(ListModel<String> model, Object value) {
        if (value == null) {
            return -1;
        }
        if (model instanceof DefaultListModel) {
            return ((DefaultListModel)model).indexOf(value);
        }
        int i = 0;
        while (i < model.getSize()) {
            if (value.equals(model.getElementAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnCancel) {
            this.dispose();
        }
        if (e.getSource() == this.btnSelectAll) {
            ListModel<String> model = this.list.getModel();
            this.list.setSelectionInterval(0, ((DefaultListModel)model).getSize() - 1);
        }
        if (e.getSource() == this.btnClear) {
            this.list.clearSelection();
        }
        if (e.getSource() == this.btnSave) {
            boolean dispose = true;
            List<String> satNames = this.list.getSelectedValuesList();
            if (satNames.isEmpty()) {
                Log.errorDialog("Error", "You must pick at least one spacecraft to download");
                return;
            }
            ArrayList<Spacecraft> sats = new ArrayList<Spacecraft>();
            for (String name : satNames) {
                sats.add(Config.satManager.getSpacecraftByDisplayName(name));
            }
            ((MainWindow)this.getOwner()).downloadServerData(sats);
            if (dispose) {
                this.dispose();
            }
        }
    }
}

