/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import common.Spacecraft;
import decoder.Decoder;
import decoder.FoxBPSK.FoxBPSKCostasDecoder;
import decoder.FoxBPSK.FoxBPSKDotProdDecoder;
import decoder.FoxFskDecoder;
import decoder.SinkAudio;
import decoder.SourceAudio;
import decoder.SourceIQ;
import decoder.SourceSoundCardAudio;
import decoder.SourceUSB;
import decoder.SourceWav;
import device.DeviceException;
import device.DevicePanel;
import device.TunerController;
import device.TunerManager;
import device.fcd.FCDTunerController;
import device.rtl.RTL2832TunerController;
import gui.AudioGraphPanel;
import gui.EyePanel;
import gui.FFTPanel;
import gui.MainWindow;
import gui.PhasorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.usb.UsbException;
import org.usb4java.LibUsbException;
import telemetry.Format.TelemFormat;
import telemetry.FramePart;

public class SourceTab
extends JPanel
implements Runnable,
ItemListener,
ActionListener,
PropertyChangeListener,
FocusListener,
MouseListener {
    Thread audioGraphThread;
    Thread eyePanelThread;
    Thread phasorPanelThread;
    Thread fftPanelThread;
    Thread decoder1Thread;
    Thread decoder2Thread;
    AudioGraphPanel audioGraph;
    EyePanel eyePanel;
    PhasorPanel phasorPanel;
    public FFTPanel fftPanel;
    JButton btnMonitorAudio;
    JCheckBox rdbtnMonitorFilteredAudio;
    JCheckBox rdbtnViewFilteredAudio;
    JCheckBox rdbtnSquelchAudio;
    JCheckBox rdbtnFilterOutputAudio;
    JCheckBox rdbtnWriteDebugData;
    JCheckBox rdbtnShowIF;
    public JCheckBox rdbtnFindSignal;
    JCheckBox rdbtnShowLog;
    JCheckBox rdbtnFcdLnaGain;
    JCheckBox rdbtnFcdMixerGain;
    JTextField peakLevel;
    JTextField avgLevel;
    JTextField bitLevel;
    JButton btnFftZoomIn;
    JButton btnFftZoomOut;
    JCheckBox cbRetuneCenterFrequency;
    JComboBox<String> speakerComboBox;
    JButton btnStartButton;
    JComboBox<String> soundCardComboBox;
    JLabel lblFileName;
    JLabel lblFile;
    JComboBox<String> cbSoundCardRate;
    JComboBox<RTL2832TunerController.SampleRate> cbRtlSampleRate;
    JPanel panelFile;
    DevicePanel panelFcd;
    JPanel SDRpanel;
    JComboBox<String> cbFormat;
    JRadioButton highSpeed;
    JRadioButton iqAudio;
    JRadioButton afAudio;
    JRadioButton showSNR;
    JLabel showLabel;
    JRadioButton showLevel;
    JRadioButton viewHighSpeed;
    JRadioButton viewLowSpeed;
    JButton unpause;
    JButton play;
    JPanel findSignalPanel;
    JPanel autoViewpanel;
    Box.Filler audioOptionsFiller;
    JTextArea log;
    JScrollPane logScrollPane;
    JCheckBox autoStart;
    JPanel sourcePanel;
    JPanel audioOutputPanel;
    JLabel lblWarnNoFindSignal;
    JPanel warnNoTrackingPanel;
    JCheckBox cbTurboWavFilePlayback;
    Image img_audio;
    Image img_mute;
    TunerController rfDevice;
    TunerManager tunerManager;
    static final int RATE_96000_IDX = 2;
    static final int RATE_192000_IDX = 3;
    private TelemFormat selectedFormat;
    private Task task;
    Thread progressThread;
    JFileChooser fc = null;
    FileDialog fd = null;
    public static final String RETUNE_AND_SWITCH_MODE = "Retune center / Switch modes";
    public static final String RETUNE_AND_SWITCH_MODE_TIP = "Change the center frequency if the spacecraft is outside the band.  Switch modes if needed.";
    public static final String SWITCH_MODE = "Auto Switch Modes";
    public static final String SWITCH_MODE_TIP = "Automatically switch the source modes if needed.e.g. FSK to BPSK";
    public static final String FUNCUBE1 = "FUNcube Dongle V1.0";
    public static final String FUNCUBE2 = "FUNcube Dongle V2.0";
    public Decoder decoder1;
    Decoder decoder2;
    public SourceIQ iqSource1;
    SourceIQ iqSource2;
    SinkAudio sink = null;
    private boolean monitorFiltered;
    public static boolean STARTED = false;
    JLabel lblWhenAboveHorizon;
    JLabel lblFreq;
    JLabel lblkHz;
    JPanel opts;
    JPanel satPanel;
    JPanel optionsPanel;
    JLabel[] satPosition;
    private JTextField txtFreq;
    MainWindow mainWindow;
    private JProgressBar progressBar;
    int splitPaneHeight;
    JSplitPane splitPane;
    ArrayList<String> usbSources;
    String[] soundcardSources;
    String[] allSources;
    int usbErrorCount = 0;
    int usbFatalErrorCount = 0;
    private boolean aboveHorizon = false;

    public SourceTab(MainWindow mw) {
        this.mainWindow = mw;
        this.setLayout(new BorderLayout(3, 3));
        JPanel bottomPanel = new JPanel();
        this.buildBottomPanel(this, "Center", bottomPanel);
        JPanel optionsRowPanel = new JPanel();
        this.buildOptionsRow(this, "South", optionsRowPanel);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout(3, 3));
        this.add((Component)topPanel, "North");
        JPanel rightPanel = new JPanel();
        this.buildRightPanel(topPanel, "East", rightPanel);
        this.fd = new FileDialog((Frame)MainWindow.frame, "Select Wav file", 0);
        this.fd.setFile("*.wav");
        this.fc = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Wav files", "wav", "wave");
        this.fc.setFileFilter(filter);
        this.sourcePanel = new JPanel();
        this.buildLeftPanel(topPanel, "Center", this.sourcePanel);
        this.enableSourceModeSelectionComponents(!Config.retuneCenterFrequency);
        this.autoViewpanel.setVisible(false);
        if (this.soundCardComboBox.getSelectedIndex() != 0 && Config.startButtonPressed) {
            while (!Config.payloadStore.initialized()) {
                Log.println("Waiting for Payload store before hitting start...");
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.processStartButtonClick();
        }
        this.showSourceOptions(Config.showSourceOptions);
        this.showAudioOptions(Config.showAudioOptions);
    }

    public void showAudioOptions(boolean b) {
        this.optionsPanel.setVisible(b);
        this.audioOutputPanel.setVisible(b);
    }

    public void showSourceOptions(boolean b) {
        this.sourcePanel.setVisible(b);
    }

    public void showSatOptions(boolean b) {
        this.satPanel.setVisible(b);
    }

    public void showEye(boolean b) {
        this.eyePanel.setVisible(b);
    }

    public void showPhasor(boolean b) {
        if (this.decoder1 != null && (this.decoder1 instanceof FoxBPSKDotProdDecoder || this.decoder1 instanceof FoxBPSKCostasDecoder)) {
            this.phasorPanel.setVisible(b);
        }
    }

    public TelemFormat getSelectedFormat() {
        return this.selectedFormat;
    }

    private void buildOptionsRow(JPanel parent, String layout, JPanel optionsPanelmain) {
        parent.add((Component)optionsPanelmain, layout);
        optionsPanelmain.setLayout(new BorderLayout());
        JPanel optionsPanel = new JPanel();
        optionsPanelmain.add((Component)optionsPanel, "Center");
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 0));
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 0));
        JPanel options1 = new JPanel();
        options1.setLayout(new FlowLayout(0));
        optionsPanel.add(options1);
        this.showLabel = new JLabel("Show");
        options1.add(this.showLabel);
        this.showLevel = this.addRadioButton("Peak", options1);
        this.showSNR = this.addRadioButton("SNR", options1);
        ButtonGroup group = new ButtonGroup();
        group.add(this.showLevel);
        group.add(this.showSNR);
        if (Config.showSNR) {
            this.showSNR.setSelected(true);
        } else {
            this.showLevel.setSelected(true);
        }
        this.warnNoTrackingPanel = new JPanel();
        this.warnNoTrackingPanel.setLayout(new BorderLayout());
        this.lblWarnNoFindSignal = new JLabel();
        this.lblWarnNoFindSignal.setForeground(Config.AMSAT_RED);
        this.lblWarnNoFindSignal.setBorder(new EmptyBorder(2, 10, 2, 10));
        this.warnNoTrackingPanel.add((Component)this.lblWarnNoFindSignal, "East");
        optionsPanelmain.add((Component)this.warnNoTrackingPanel, "East");
        this.rdbtnShowIF = new JCheckBox("Show IF");
        optionsPanel.add(this.rdbtnShowIF);
        this.rdbtnShowIF.addItemListener(this);
        this.rdbtnShowIF.setSelected(Config.showIF);
        this.rdbtnShowIF.setVisible(false);
        this.findSignalPanel = new JPanel();
        this.findSignalPanel.setLayout(new BoxLayout(this.findSignalPanel, 0));
        this.rdbtnFindSignal = new JCheckBox("Find Signal");
        options1.add(this.rdbtnFindSignal);
        this.rdbtnFindSignal.addItemListener(this);
        this.rdbtnFindSignal.setSelected(Config.findSignal);
        this.rdbtnFindSignal.setVisible(false);
        optionsPanel.add(this.findSignalPanel);
        JLabel when = new JLabel("|  Find Signal when peak over ");
        this.findSignalPanel.add(when);
        this.peakLevel = new JTextField(Double.toString(Config.SCAN_SIGNAL_THRESHOLD));
        this.peakLevel.setMinimumSize(new Dimension(30, 1));
        this.peakLevel.addActionListener(this);
        this.peakLevel.addFocusListener(this);
        this.findSignalPanel.add(this.peakLevel);
        JLabel rf = new JLabel("dB, SNR over ");
        this.findSignalPanel.add(rf);
        this.avgLevel = new JTextField(Double.toString(Config.ANALYZE_SNR_THRESHOLD));
        this.avgLevel.setMinimumSize(new Dimension(30, 1));
        this.avgLevel.addActionListener(this);
        this.avgLevel.addFocusListener(this);
        this.findSignalPanel.add(this.avgLevel);
        JLabel bit = new JLabel("dB and bit SNR over ");
        this.findSignalPanel.add(bit);
        this.bitLevel = new JTextField(Double.toString(Config.BIT_SNR_THRESHOLD));
        this.bitLevel.setMinimumSize(new Dimension(30, 1));
        this.bitLevel.addActionListener(this);
        this.bitLevel.addFocusListener(this);
        this.findSignalPanel.add(this.bitLevel);
        JLabel bitdb = new JLabel("dB");
        this.findSignalPanel.add(bitdb);
        this.findSignalPanel.add(new Box.Filler(new Dimension(10, 1), new Dimension(1500, 1), new Dimension(1500, 1)));
        this.findSignalPanel.setVisible(Config.findSignal);
        this.btnFftZoomIn = new JButton("+");
        this.btnFftZoomIn.addActionListener(this);
        this.btnFftZoomOut = new JButton("-");
        this.btnFftZoomOut.addActionListener(this);
    }

    private void buildBottomPanel(JPanel parent, String layout, JPanel bottomPanel) {
        bottomPanel.setLayout(new BorderLayout(3, 3));
        bottomPanel.setPreferredSize(new Dimension(800, 250));
        this.audioGraph = new AudioGraphPanel();
        this.audioGraph.setBorder(new BevelBorder(1, null, null, null, null));
        bottomPanel.add((Component)this.audioGraph, "Center");
        this.audioGraph.setBackground(Color.LIGHT_GRAY);
        if (this.audioGraphThread != null) {
            this.audioGraph.stopProcessing();
        }
        this.audioGraphThread = new Thread(this.audioGraph);
        this.audioGraphThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.audioGraphThread.start();
        JPanel eyePhasorPanel = new JPanel();
        eyePhasorPanel.setLayout(new BorderLayout());
        this.eyePanel = new EyePanel();
        this.eyePanel.setBorder(new BevelBorder(1, null, null, null, null));
        bottomPanel.add((Component)eyePhasorPanel, "East");
        eyePhasorPanel.add((Component)this.eyePanel, "West");
        this.eyePanel.setBackground(Color.LIGHT_GRAY);
        this.eyePanel.setPreferredSize(new Dimension(200, 100));
        this.eyePanel.setMaximumSize(new Dimension(200, 100));
        this.eyePanel.setVisible(true);
        this.phasorPanel = new PhasorPanel();
        this.phasorPanel.setBorder(new BevelBorder(1, null, null, null, null));
        eyePhasorPanel.add((Component)this.phasorPanel, "East");
        this.phasorPanel.setBackground(Color.LIGHT_GRAY);
        this.phasorPanel.setPreferredSize(new Dimension(200, 100));
        this.phasorPanel.setMaximumSize(new Dimension(200, 100));
        this.phasorPanel.setVisible(false);
        this.fftPanel = new FFTPanel();
        this.fftPanel.setBorder(new BevelBorder(1, null, null, null, null));
        this.fftPanel.setBackground(Color.LIGHT_GRAY);
        this.showFFT(false);
        this.fftPanel.setPreferredSize(new Dimension(100, 150));
        this.fftPanel.setMaximumSize(new Dimension(100, 150));
        this.splitPane = new JSplitPane(0, bottomPanel, this.fftPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        if (Config.splitPaneHeight != 0) {
            this.splitPane.setDividerLocation(Config.splitPaneHeight);
        } else {
            this.splitPane.setDividerLocation(200);
        }
        SplitPaneUI spui = this.splitPane.getUI();
        if (spui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)spui).getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (Config.iq) {
                        Config.splitPaneHeight = SourceTab.this.splitPaneHeight = SourceTab.this.splitPane.getDividerLocation();
                    }
                }
            });
        }
        parent.add((Component)this.splitPane, layout);
    }

    public boolean buildTrackedSpacecraftList() {
        boolean oneTracked = false;
        if (this.satPanel != null) {
            this.opts.remove(this.satPanel);
        }
        this.satPanel = new JPanel();
        this.satPanel.setBorder(new TitledBorder(null, "Spacecraft Tracked", 4, 2, null, null));
        this.opts.add((Component)this.satPanel, "North");
        this.satPanel.setLayout(new BoxLayout(this.satPanel, 1));
        JPanel[] satRows = new JPanel[Config.satManager.spacecraftList.size()];
        JLabel[] satName = new JLabel[Config.satManager.spacecraftList.size()];
        if (Config.satManager.spacecraftList.size() == 0) {
            JLabel lbl = new JLabel("  No spacecraft loaded.");
            lbl.setForeground(Color.RED);
            JLabel lbl1 = new JLabel("  Use the spacecraft menu");
            lbl1.setForeground(Color.RED);
            JLabel lbl2 = new JLabel("  to add a satellite.");
            lbl2.setForeground(Color.RED);
            this.satPanel.add(lbl);
            this.satPanel.add(lbl1);
            this.satPanel.add(lbl2);
        } else {
            this.satPosition = new JLabel[Config.satManager.spacecraftList.size()];
            int s = 0;
            while (s < Config.satManager.spacecraftList.size()) {
                Spacecraft sat = Config.satManager.spacecraftList.get(s);
                satRows[s] = new JPanel();
                satRows[s].setLayout(new FlowLayout(0));
                this.satPanel.add(satRows[s]);
                satName[s] = new JLabel(String.valueOf(sat.user_priority) + "/" + sat.user_display_name + "   ");
                this.satPosition[s] = new JLabel("Not Tracked");
                if (sat.user_track) {
                    this.satPosition[s].setText("Tracked");
                    oneTracked = true;
                }
                this.satPosition[s].setToolTipText("Click to Toggle Tracking on/off");
                this.satPosition[s].addMouseListener(this);
                satRows[s].add(satName[s]);
                satRows[s].add(this.satPosition[s]);
                ++s;
            }
        }
        this.autoStart = new JCheckBox("Auto Start");
        this.autoStart.setSelected(Config.whenAboveHorizon);
        this.autoStart.addItemListener(this);
        this.satPanel.add(this.autoStart);
        this.showSatOptions(Config.showSatOptions);
        this.showEye(Config.showEye);
        if (this.decoder1 != null && (this.decoder1 instanceof FoxBPSKDotProdDecoder || this.decoder1 instanceof FoxBPSKCostasDecoder)) {
            this.showPhasor(Config.showPhasor);
        }
        return oneTracked;
    }

    private void buildRightPanel(JPanel parent, String layout, JPanel rightPanel) {
        parent.add((Component)rightPanel, layout);
        this.opts = new JPanel();
        rightPanel.add(this.opts);
        this.opts.setLayout(new BorderLayout());
        this.optionsPanel = new JPanel();
        this.optionsPanel.setBorder(new TitledBorder(null, "Audio Options", 4, 2, null, null));
        this.opts.add((Component)this.optionsPanel, "Center");
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
        this.rdbtnViewFilteredAudio = new JCheckBox("View Filtered Audio");
        this.optionsPanel.add(this.rdbtnViewFilteredAudio);
        this.rdbtnViewFilteredAudio.addItemListener(this);
        this.rdbtnViewFilteredAudio.setSelected(Config.viewFilteredAudio);
        this.rdbtnMonitorFilteredAudio = new JCheckBox("Monitor Filtered Audio");
        this.optionsPanel.add(this.rdbtnMonitorFilteredAudio);
        this.rdbtnMonitorFilteredAudio.addItemListener(this);
        this.rdbtnMonitorFilteredAudio.setSelected(Config.monitorFilteredAudio);
        this.rdbtnSquelchAudio = new JCheckBox("Squelch when no telemetry");
        this.optionsPanel.add(this.rdbtnSquelchAudio);
        this.rdbtnSquelchAudio.addItemListener(this);
        this.rdbtnSquelchAudio.setSelected(Config.squelchAudio);
        this.rdbtnFilterOutputAudio = new JCheckBox("LPF Monitored Audio");
        this.optionsPanel.add(this.rdbtnFilterOutputAudio);
        this.rdbtnFilterOutputAudio.addItemListener(this);
        this.rdbtnFilterOutputAudio.setSelected(Config.filterOutputAudio);
        this.rdbtnFilterOutputAudio.setVisible(false);
        this.play = new JButton(">");
        this.play.addActionListener(this);
        this.optionsPanel.add(this.play);
        this.unpause = new JButton("||");
        this.unpause.addActionListener(this);
        this.optionsPanel.add(this.unpause);
        if (Config.debugValues) {
            this.play.setVisible(true);
            this.unpause.setVisible(true);
        }
    }

    public void log(String text) {
        if (this.rdbtnShowLog.isSelected()) {
            this.log.append(text);
            this.log.setCaretPosition(this.log.getLineCount());
        }
    }

    private String[] getSources() {
        this.soundcardSources = SourceSoundCardAudio.getAudioSources();
        this.usbSources = new ArrayList();
        this.usbSources.add("RTL SDR");
        String[] allSources = new String[this.soundcardSources.length + this.usbSources.size()];
        int j = 0;
        String[] stringArray = this.soundcardSources;
        int n = this.soundcardSources.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            allSources[j++] = s;
            ++n2;
        }
        if (this.usbSources != null) {
            for (String s : this.usbSources) {
                allSources[j++] = s;
            }
        }
        return allSources;
    }

    private void buildLeftPanel(JPanel parent, String layout, JPanel leftPanel) {
        parent.add((Component)leftPanel, layout);
        leftPanel.setLayout(new BorderLayout(3, 3));
        JPanel panel_2 = new JPanel();
        leftPanel.add((Component)panel_2, "North");
        panel_2.setMinimumSize(new Dimension(10, 35));
        panel_2.setLayout(new BoxLayout(panel_2, 0));
        JLabel lblSource = new JLabel("Source");
        panel_2.add(lblSource);
        lblSource.setAlignmentX(0.0f);
        lblSource.setMinimumSize(new Dimension(120, 14));
        lblSource.setMaximumSize(new Dimension(120, 14));
        panel_2.add(new Box.Filler(new Dimension(10, 10), new Dimension(100, 10), new Dimension(500, 10)));
        JLabel format = new JLabel("Telem Format:  ");
        panel_2.add(format);
        String[] formatTest = Config.satManager.getFormats();
        this.cbFormat = new JComboBox<String>(formatTest);
        this.cbFormat.setVisible(true);
        this.cbFormat.setEnabled(true);
        this.cbFormat.addActionListener(this);
        this.cbFormat.setMaximumSize(new Dimension(200, 30));
        panel_2.add(this.cbFormat);
        panel_2.add(new Box.Filler(new Dimension(200, 10), new Dimension(200, 10), new Dimension(500, 10)));
        this.highSpeed = this.addRadioButton("High Speed", panel_2);
        this.highSpeed.setVisible(false);
        this.setupFormat();
        JPanel centerPanel = new JPanel();
        leftPanel.add((Component)centerPanel, "Center");
        centerPanel.setLayout(new BorderLayout(3, 3));
        JPanel panel_1 = new JPanel();
        centerPanel.add((Component)panel_1, "North");
        this.btnStartButton = new JButton("Start");
        panel_1.add(this.btnStartButton);
        this.btnStartButton.addActionListener(this);
        this.btnStartButton.setEnabled(false);
        this.btnStartButton.setAlignmentX(0.5f);
        this.tunerManager = new TunerManager();
        this.allSources = this.getSources();
        this.soundCardComboBox = new JComboBox<String>(this.allSources);
        this.soundCardComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                SourceTab.this.soundCardComboBox.removeAllItems();
                String[] stringArray = SourceTab.this.allSources;
                int n = SourceTab.this.allSources.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    SourceTab.this.soundCardComboBox.addItem(s);
                    ++n2;
                }
            }
        });
        this.soundCardComboBox.addActionListener(this);
        panel_1.add(this.soundCardComboBox);
        String[] scRates = new String[]{"44100", "48000", "96000", "192000"};
        this.cbSoundCardRate = new JComboBox<String>(scRates);
        this.cbSoundCardRate.setVisible(false);
        this.cbSoundCardRate.addActionListener(this);
        panel_1.add(this.cbSoundCardRate);
        this.cbSoundCardRate.setSelectedItem(Integer.toString(Config.scSampleRate));
        this.cbRtlSampleRate = new JComboBox<RTL2832TunerController.SampleRate>(RTL2832TunerController.SampleRate.values());
        this.cbRtlSampleRate.addActionListener(this);
        int rate = Config.loadGraphIntValue("SDR", 0, 0, "RTL", "RtlSampleRate");
        RTL2832TunerController.SampleRate s = RTL2832TunerController.SampleRate.getClosest(rate);
        if (s != null) {
            this.cbRtlSampleRate.setSelectedItem((Object)s);
        }
        panel_1.add(this.cbRtlSampleRate);
        this.cbRtlSampleRate.setVisible(false);
        this.afAudio = this.addRadioButton("AF", panel_1);
        this.iqAudio = this.addRadioButton("IQ", panel_1);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.afAudio);
        group2.add(this.iqAudio);
        JPanel panel_c = new JPanel();
        centerPanel.add((Component)panel_c, "Center");
        panel_c.setLayout(new BoxLayout(panel_c, 1));
        JPanel panelHorizon = new JPanel();
        panel_c.add(panelHorizon);
        this.lblWhenAboveHorizon = new JLabel("Decoder will start when spacecraft above horizon ");
        this.lblWhenAboveHorizon.setForeground(Config.AMSAT_RED);
        this.lblWhenAboveHorizon.setVisible(false);
        panelHorizon.add(this.lblWhenAboveHorizon);
        JPanel panelSDRtop = new JPanel();
        panel_c.add(panelSDRtop);
        panelSDRtop.setLayout(new FlowLayout(1, 5, 5));
        JPanel panelFreq = new JPanel();
        panelSDRtop.add((Component)panelFreq, "Center");
        panelFreq.setLayout(new BoxLayout(panelFreq, 0));
        this.lblFreq = new JLabel("Center Frequency ");
        panelFreq.add(this.lblFreq);
        this.lblFreq.setVisible(false);
        this.txtFreq = new JTextField();
        this.txtFreq.addActionListener(this);
        this.txtFreq.addFocusListener(this);
        panelFreq.add(this.txtFreq);
        this.txtFreq.setColumns(10);
        this.txtFreq.setVisible(false);
        this.txtFreq.setEnabled(!Config.retuneCenterFrequency);
        this.lblkHz = new JLabel(" kHz   ");
        panelFreq.add(this.lblkHz);
        this.lblkHz.setVisible(false);
        this.cbRetuneCenterFrequency = new JCheckBox(RETUNE_AND_SWITCH_MODE);
        panelFreq.add(this.cbRetuneCenterFrequency);
        this.cbRetuneCenterFrequency.addItemListener(this);
        this.cbRetuneCenterFrequency.setToolTipText(RETUNE_AND_SWITCH_MODE_TIP);
        this.cbRetuneCenterFrequency.setSelected(Config.retuneCenterFrequency);
        if (Config.iq) {
            this.iqAudio.doClick();
        } else {
            this.afAudio.doClick();
        }
        this.SDRpanel = new JPanel();
        panel_c.add((Component)this.SDRpanel, "South");
        this.SDRpanel.setLayout(new BorderLayout());
        this.SDRpanel.setVisible(false);
        this.panelFile = new JPanel();
        panel_c.add((Component)this.panelFile, "Center");
        this.panelFile.setLayout(new BoxLayout(this.panelFile, 1));
        this.lblFile = new JLabel("File: ");
        this.lblFileName = new JLabel("none");
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setLayout(new BoxLayout(fileNamePanel, 0));
        this.panelFile.add(fileNamePanel);
        fileNamePanel.add(this.lblFile);
        fileNamePanel.add(this.lblFileName);
        this.lblFileName.setForeground(Color.GRAY);
        this.lblFileName.setHorizontalAlignment(2);
        this.progressBar = new JProgressBar();
        this.panelFile.add(this.progressBar);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("0:00 mins");
        this.cbTurboWavFilePlayback = new JCheckBox("Fast playback (not recommended)");
        this.cbTurboWavFilePlayback.setSelected(Config.turboWavFilePlayback);
        this.cbTurboWavFilePlayback.addItemListener(this);
        this.panelFile.add(this.cbTurboWavFilePlayback);
        this.panelFile.setVisible(false);
        this.audioOutputPanel = new JPanel();
        leftPanel.add((Component)this.audioOutputPanel, "South");
        this.audioOutputPanel.setLayout(new BorderLayout(3, 3));
        JPanel panel_3 = new JPanel();
        this.audioOutputPanel.add((Component)panel_3, "North");
        panel_3.setMinimumSize(new Dimension(10, 35));
        panel_3.setLayout(new BoxLayout(panel_3, 1));
        JLabel lblOutput = new JLabel("Output");
        panel_3.add(lblOutput);
        lblSource.setAlignmentX(0.0f);
        JPanel panelCombo = new JPanel();
        this.audioOutputPanel.add((Component)panelCombo, "Center");
        this.speakerComboBox = new JComboBox<String>(SinkAudio.getAudioSinks());
        this.speakerComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                SourceTab.this.speakerComboBox.removeAllItems();
                String[] stringArray = SinkAudio.getAudioSinks();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    SourceTab.this.speakerComboBox.addItem(s);
                    ++n2;
                }
            }
        });
        this.speakerComboBox.addActionListener(this);
        this.btnMonitorAudio = new JButton();
        if (Config.monitorAudio) {
            this.btnMonitorAudio.setText("Silence Speaker");
            this.speakerComboBox.setEnabled(false);
        } else {
            this.btnMonitorAudio.setText("Monitor Audio");
        }
        panelCombo.add(this.btnMonitorAudio);
        this.btnMonitorAudio.setAlignmentX(0.5f);
        this.btnMonitorAudio.addActionListener(this);
        panelCombo.add(this.speakerComboBox);
        this.autoViewpanel = new JPanel();
        this.autoViewpanel.add(new Box.Filler(new Dimension(10, 1), new Dimension(40, 1), new Dimension(1500, 1)));
        JLabel view = new JLabel("View ");
        panelCombo.add(this.autoViewpanel);
        this.autoViewpanel.add(view);
        this.viewLowSpeed = this.addRadioButton("DUV", this.autoViewpanel);
        this.viewHighSpeed = this.addRadioButton("HS Audio", this.autoViewpanel);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.viewLowSpeed);
        group3.add(this.viewHighSpeed);
        this.viewLowSpeed.setSelected(true);
        this.autoViewpanel.setVisible(true);
        if (Config.soundCard != null && !Config.soundCard.equalsIgnoreCase("NONE")) {
            this.soundCardComboBox.setSelectedItem(Config.soundCard);
        }
        if (Config.audioSink != null && !Config.audioSink.equalsIgnoreCase("NONE")) {
            this.speakerComboBox.setSelectedIndex(SinkAudio.getDeviceIdByName(Config.audioSink));
        }
    }

    public JButton createIconButton(String icon, String name, String toolTip) {
        JButton btn;
        BufferedImage wPic = null;
        try {
            wPic = ImageIO.read(this.getClass().getResource(icon));
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
        if (wPic != null) {
            btn = new JButton(new ImageIcon(wPic));
            btn.setMargin(new Insets(0, 0, 0, 0));
        } else {
            btn = new JButton(name);
        }
        btn.setToolTipText(toolTip);
        btn.addActionListener(this);
        return btn;
    }

    public void setupFormat() {
        this.selectedFormat = Config.satManager.getFormatByName(Config.format);
        if (this.selectedFormat == null) {
            Config.format = "FSK 200bps (Fox1)";
            this.selectedFormat = Config.satManager.getFormatByName(Config.format);
            Config.save();
        }
        this.cbFormat.setSelectedItem(Config.format);
    }

    private JRadioButton addRadioButton(String name, JPanel panel) {
        JRadioButton radioButton = new JRadioButton(name);
        radioButton.setEnabled(true);
        radioButton.addActionListener(this);
        panel.add(radioButton);
        return radioButton;
    }

    public boolean fileActions() {
        File file = null;
        File dir = null;
        if (Config.windowCurrentDirectory != "") {
            dir = new File(Config.windowCurrentDirectory);
        }
        this.soundCardComboBox.hidePopup();
        if (Config.useNativeFileChooser) {
            if (dir != null) {
                this.fd.setDirectory(dir.getAbsolutePath());
            }
            this.fd.setVisible(true);
            String filename = this.fd.getFile();
            String dirname = this.fd.getDirectory();
            if (filename == null) {
                Log.println("You cancelled the choice");
            } else {
                Log.println("File: " + filename);
                Log.println("DIR: " + dirname);
                file = new File(String.valueOf(dirname) + filename);
            }
        } else {
            this.fc.setPreferredSize(new Dimension(Config.windowFcWidth, Config.windowFcHeight));
            if (dir != null) {
                this.fc.setCurrentDirectory(dir);
            }
            int returnVal = this.fc.showOpenDialog(this);
            Config.windowFcHeight = this.fc.getHeight();
            Config.windowFcWidth = this.fc.getWidth();
            if (returnVal == 0) {
                file = this.fc.getSelectedFile();
            }
        }
        if (file != null) {
            Config.windowCurrentDirectory = file.getParent();
            Config.save();
            this.lblFileName.setText(file.getName());
            this.panelFile.setVisible(true);
            this.btnStartButton.setEnabled(true);
            this.cbSoundCardRate.setVisible(false);
            this.cbRtlSampleRate.setVisible(false);
            return true;
        }
        Config.save();
        return false;
    }

    public void chooseFile() {
        this.soundCardComboBox.setSelectedIndex(1);
    }

    public void chooseIQFile() {
        this.soundCardComboBox.setSelectedIndex(1);
        this.iqAudio.setSelected(true);
    }

    void showFFT(boolean b) {
        this.fftPanel.setVisible(b);
        if (b) {
            if (Config.splitPaneHeight != 0) {
                this.splitPane.setDividerLocation(Config.splitPaneHeight);
            } else {
                this.splitPane.setDividerLocation(200);
            }
        }
        this.mainWindow.chckbxmntmShowFFT.setState(b);
    }

    private void setIQVisible(boolean b) {
        this.showFFT(b);
        this.rdbtnFindSignal.setVisible(false);
        this.rdbtnFindSignal.setEnabled(false);
        this.findSignalPanel.setVisible(b);
        this.showSNR.setVisible(b);
        this.showLevel.setVisible(b);
        this.showLabel.setVisible(b);
        this.setFreqVisible(b);
        if (this.soundCardComboBox.getSelectedIndex() >= this.soundcardSources.length) {
            this.cbSoundCardRate.setVisible(false);
            this.cbRtlSampleRate.setVisible(true);
        } else {
            this.cbSoundCardRate.setVisible(true);
            this.cbRtlSampleRate.setVisible(false);
        }
    }

    private void setFreqVisible(boolean b) {
        this.lblFreq.setVisible(b);
        this.lblkHz.setVisible(b);
        this.txtFreq.setVisible(b);
    }

    public void setViewDecoder1() {
        try {
            if (this.decoder2 != null) {
                this.decoder2.stopAudioMonitor();
            }
            if (this.decoder1 != null && Config.monitorAudio && this.sink != null) {
                this.decoder1.setMonitorAudio(this.sink, Config.monitorAudio, this.speakerComboBox.getSelectedIndex());
            }
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace(Log.getWriter());
        }
        catch (LineUnavailableException e1) {
            e1.printStackTrace(Log.getWriter());
        }
        if (this.decoder1 != null) {
            this.audioGraph.startProcessing(this.decoder1);
            this.eyePanel.startProcessing(this.decoder1);
            if (this.decoder1 instanceof FoxBPSKDotProdDecoder || this.decoder1 instanceof FoxBPSKCostasDecoder) {
                this.phasorPanel.setVisible(Config.showPhasor);
                this.phasorPanel.startProcessing(this.decoder1);
            } else {
                this.phasorPanel.setVisible(false);
            }
            this.fftPanel.startProcessing(this.iqSource1);
        }
        this.viewLowSpeed.setSelected(true);
    }

    public void setViewDecoder2() {
        if (this.decoder2 != null) {
            try {
                if (this.decoder1 != null) {
                    this.decoder1.stopAudioMonitor();
                }
                if (this.decoder2 != null && Config.monitorAudio && this.sink != null) {
                    this.decoder2.setMonitorAudio(this.sink, Config.monitorAudio, this.speakerComboBox.getSelectedIndex());
                }
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace(Log.getWriter());
            }
            catch (LineUnavailableException e1) {
                e1.printStackTrace(Log.getWriter());
            }
            this.audioGraph.startProcessing(this.decoder2);
            this.eyePanel.startProcessing(this.decoder2);
            this.fftPanel.startProcessing(this.iqSource2);
            this.viewHighSpeed.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.unpause) {
            Config.decoderPaused = false;
            Config.decoderPlay = false;
        }
        if (e.getSource() == this.play) {
            Config.decoderPlay = true;
        }
        if (e.getSource() == this.cbFormat) {
            Config.format = (String)this.cbFormat.getSelectedItem();
            this.selectedFormat = Config.satManager.getFormatByName(Config.format);
            Config.save();
        }
        if (e.getSource() == this.viewHighSpeed) {
            this.setViewDecoder2();
        }
        if (e.getSource() == this.viewLowSpeed) {
            this.setViewDecoder1();
        }
        if (e.getSource() == this.iqAudio) {
            Config.iq = true;
            this.setIQVisible(true);
            Config.save();
        }
        if (e.getSource() == this.afAudio) {
            Config.iq = false;
            this.setIQVisible(false);
            Config.save();
        }
        if (e.getSource() == this.showSNR) {
            Config.showSNR = true;
            Config.save();
        }
        if (e.getSource() == this.showLevel) {
            Config.showSNR = false;
            Config.save();
        }
        if (e.getSource() == this.peakLevel) {
            try {
                Config.SCAN_SIGNAL_THRESHOLD = Double.parseDouble(this.peakLevel.getText());
            }
            catch (NumberFormatException n) {
                Log.errorDialog("Invalid Value", n.getMessage());
            }
            Config.save();
        }
        if (e.getSource() == this.avgLevel) {
            try {
                Config.ANALYZE_SNR_THRESHOLD = Double.parseDouble(this.avgLevel.getText());
            }
            catch (NumberFormatException n) {
                Log.errorDialog("Invalid Value", n.getMessage());
            }
            Config.save();
        }
        if (e.getSource() == this.bitLevel) {
            try {
                Config.BIT_SNR_THRESHOLD = Double.parseDouble(this.bitLevel.getText());
            }
            catch (NumberFormatException n) {
                Log.errorDialog("Invalid Value", n.getMessage());
            }
            Config.save();
        }
        if (e.getSource() == this.txtFreq) {
            try {
                double f = this.setCenterFreq();
                this.txtFreq.setText(Double.toString(f));
            }
            catch (DeviceException e1) {
                Log.errorDialog("ERROR with txtFreq", e1.getMessage());
                e1.printStackTrace(Log.getWriter());
            }
            catch (IOException e1) {
                e1.printStackTrace(Log.getWriter());
            }
            catch (LibUsbException e2) {
                e2.printStackTrace(Log.getWriter());
            }
            Config.save();
        }
        if (e.getSource() == this.soundCardComboBox) {
            this.processSoundCardComboBox();
        }
        if (e.getSource() == this.speakerComboBox) {
            this.processSpeakerComboBox();
        }
        if (e.getSource() == this.cbSoundCardRate) {
            Config.scSampleRate = Integer.parseInt((String)this.cbSoundCardRate.getSelectedItem());
            Config.save();
        }
        if (e.getSource() == this.btnMonitorAudio) {
            if (!Config.monitorAudio) {
                if (this.decoder1 != null) {
                    this.setupAudioSink(this.decoder1);
                }
            } else if (this.sink != null) {
                this.sink.flush();
                this.sink.closeOutput();
                this.sink = null;
            }
            try {
                Config.monitorAudio = this.viewLowSpeed.isSelected() ? (this.decoder1 != null ? this.decoder1.toggleAudioMonitor(this.sink, this.monitorFiltered, this.speakerComboBox.getSelectedIndex()) : !Config.monitorAudio) : (this.decoder2 != null ? this.decoder2.toggleAudioMonitor(this.sink, this.monitorFiltered, this.speakerComboBox.getSelectedIndex()) : !Config.monitorAudio);
            }
            catch (IllegalArgumentException e1) {
                JOptionPane.showMessageDialog(this, "Is there a valid sound card attached?\n" + e1.toString(), "CAN'T MONITOR THE AUDIO", 0);
            }
            catch (LineUnavailableException e1) {
                JOptionPane.showMessageDialog(this, "Is there a valid sound card attached?\n" + e1.toString(), "CAN'T MONITOR THE AUDIO", 0);
            }
            if (Config.monitorAudio) {
                this.btnMonitorAudio.setText("Silence Speaker");
                this.speakerComboBox.setEnabled(false);
            } else {
                this.btnMonitorAudio.setText("Monitor Audio");
                this.speakerComboBox.setEnabled(true);
            }
            Config.save();
        }
        if (e.getSource() == this.btnStartButton) {
            this.processStartButtonClick();
        }
        if (e.getSource() == this.btnFftZoomIn) {
            this.fftPanel.zoomIn();
        }
        if (e.getSource() == this.btnFftZoomOut) {
            this.fftPanel.zoomOut();
        }
    }

    private void setupAudioSink(Decoder decoder12) {
        int position = this.speakerComboBox.getSelectedIndex();
        if (this.sink != null) {
            this.sink.flush();
            this.sink.closeOutput();
            this.sink = null;
        }
        boolean connected = false;
        int retries = 0;
        int MAX_RETRIES = 5;
        LineUnavailableException err = null;
        while (!connected && retries < MAX_RETRIES) {
            try {
                this.sink = new SinkAudio(decoder12.getAudioFormat());
                if (this.sink != null) {
                    this.sink.setDevice(position);
                }
                if (position != -1) {
                    Config.audioSink = SinkAudio.getDeviceName(position);
                    Config.save();
                }
                connected = true;
            }
            catch (LineUnavailableException e1) {
                e1.printStackTrace(Log.getWriter());
                err = e1;
                ++retries;
                ++this.usbErrorCount;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace(Log.getWriter());
                }
            }
            catch (IllegalArgumentException e1) {
                JOptionPane.showMessageDialog(this, e1.toString(), "ARGUMENT ERROR", 0);
                e1.printStackTrace(Log.getWriter());
                this.stopButton();
            }
        }
        if (!connected) {
            if (retries > 0) {
                ++this.usbFatalErrorCount;
            }
            MainWindow.setUsbErrors(this.usbFatalErrorCount, this.usbErrorCount);
            JOptionPane.showMessageDialog(this, "Your Operating System says the soundcard is not available to monitor the audio.  Error is:\n" + err.toString(), "ERROR", 0);
            this.stopButton();
        }
    }

    private SourceWav setWavFile(boolean IQ) {
        SourceWav audioSource = null;
        try {
            audioSource = new SourceWav(String.valueOf(Config.windowCurrentDirectory) + File.separator + this.lblFileName.getText(), IQ);
        }
        catch (UnsupportedAudioFileException e) {
            Log.errorDialog("ERROR With Audio File", e.toString());
            e.printStackTrace(Log.getWriter());
            this.stopButton();
        }
        catch (IOException e) {
            Log.errorDialog("ERROR With File", e.toString());
            e.printStackTrace(Log.getWriter());
            this.stopButton();
        }
        if (this.task != null) {
            this.task.resetProgress();
        }
        return audioSource;
    }

    private void processSoundCardComboBox() {
        String source = (String)this.soundCardComboBox.getSelectedItem();
        int position = this.soundCardComboBox.getSelectedIndex();
        if (source != null && position > 0) {
            if (position == 1) {
                this.fileActions();
            } else if (position >= this.soundcardSources.length) {
                this.btnStartButton.setEnabled(true);
                this.cbSoundCardRate.setVisible(false);
                this.panelFile.setVisible(false);
                this.setIQVisible(true);
            } else {
                int fcdSelected = this.fcdSelected();
                if (fcdSelected <= 0) {
                    Config.scSampleRate = Integer.parseInt((String)this.cbSoundCardRate.getSelectedItem());
                }
                this.btnStartButton.setEnabled(true);
                this.cbSoundCardRate.setVisible(true);
                this.panelFile.setVisible(false);
                if (Config.iq) {
                    this.setIQVisible(true);
                } else {
                    this.setIQVisible(false);
                }
            }
        }
        Config.soundCard = this.soundCardComboBox.getItemAt(this.soundCardComboBox.getSelectedIndex());
    }

    private void processSpeakerComboBox() {
        int position = this.speakerComboBox.getSelectedIndex();
        if (position != -1) {
            Config.audioSink = SinkAudio.getDeviceName(position);
        }
    }

    private void releaseFcd() {
        if (this.rfDevice != null) {
            try {
                this.rfDevice.cleanup();
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (DeviceException e) {
                e.printStackTrace(Log.getWriter());
            }
            this.rfDevice = null;
        }
    }

    private int fcdSelected() {
        String source = (String)this.soundCardComboBox.getSelectedItem();
        Pattern pattern2 = Pattern.compile(FUNCUBE2);
        Matcher matcher2 = pattern2.matcher(source);
        if (matcher2.find()) {
            return 2;
        }
        Pattern pattern1 = Pattern.compile(FUNCUBE1);
        Matcher matcher1 = pattern1.matcher(source);
        if (matcher1.find()) {
            return 1;
        }
        return 0;
    }

    private void connectFCD(short vendorId, short deviceId) throws UsbException, DeviceException {
        if (this.rfDevice == null) {
            try {
                this.rfDevice = this.tunerManager.findDevice(vendorId, deviceId, RTL2832TunerController.SampleRate.RATE_0_240MHZ);
            }
            catch (Exception e1) {
                this.rfDevice = this.tunerManager.findDevice(vendorId, deviceId, RTL2832TunerController.SampleRate.RATE_0_240MHZ);
            }
        }
    }

    private int usingFcd() throws IOException, DeviceException, UsbException {
        int fcdSelected = this.fcdSelected();
        if (fcdSelected > 0) {
            short vendorId = 0;
            short deviceId = 0;
            if (this.rfDevice == null) {
                if (fcdSelected == 2) {
                    vendorId = 1240;
                    deviceId = -1231;
                    this.cbSoundCardRate.setSelectedIndex(3);
                } else {
                    vendorId = 1240;
                    deviceId = -1194;
                    this.cbSoundCardRate.setSelectedIndex(2);
                }
                this.connectFCD(vendorId, deviceId);
                if (this.rfDevice == null) {
                    this.lblkHz.setText(" kHz    |   FCD ERR - SET FREQ MANUALLY");
                    Log.println("ERROR setting FCD device on panel and reading its settings, but carrying on...");
                    return 0;
                }
            }
            if (this.panelFcd == null) {
                try {
                    this.panelFcd = this.rfDevice.getDevicePanel();
                }
                catch (IOException e) {
                    e.printStackTrace(Log.getWriter());
                }
                catch (DeviceException e) {
                    e.printStackTrace(Log.getWriter());
                }
            }
            int retried = 0;
            while (retried < 5) {
                try {
                    this.panelFcd.setDevice(this.rfDevice);
                }
                catch (LibUsbException e) {
                    if (e.getErrorCode() == -9 || e.getErrorCode() == -7 || e.getErrorCode() == -10 || e.getErrorCode() == -6 || e.getErrorCode() == -8 || e.getErrorCode() == -1) {
                        ++this.usbErrorCount;
                        ++retried;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    Log.errorDialog("USB Hardware error setting frequency", "Check the device is connected correctly and working.  Error:\n" + e.getMessage());
                    this.stopButton();
                }
                catch (DeviceException e) {
                    this.lblkHz.setText(" kHz    |   FCD DEVICE NOT CONNECTED");
                    Log.println("ERROR setting FCD device on panel and reading its settings, but carrying on...");
                }
                break;
            }
            if (retried >= 5) {
                ++this.usbFatalErrorCount;
            }
            if (retried > 0) {
                MainWindow.setUsbErrors(this.usbFatalErrorCount, this.usbErrorCount);
            }
            this.SDRpanel.add((Component)this.panelFcd, "Center");
            this.SDRpanel.setVisible(true);
            if (this.rfDevice.isConnected()) {
                this.panelFcd.setEnabled(true);
            } else {
                this.panelFcd.setEnabled(false);
            }
            Config.iq = true;
            this.iqAudio.setSelected(true);
            this.setIQVisible(true);
        } else {
            this.SDRpanel.setVisible(false);
            this.panelFcd = null;
        }
        return fcdSelected;
    }

    private void setFcdSampleRate() {
        Config.scSampleRate = this.rfDevice.SAMPLE_RATE;
        if (this.rfDevice.SAMPLE_RATE == 96000) {
            this.cbSoundCardRate.setSelectedIndex(2);
        } else {
            this.cbSoundCardRate.setSelectedIndex(3);
        }
        Config.save();
    }

    private SourceSoundCardAudio setupSoundCard(boolean highSpeed, int sampleRate) {
        int position = this.soundCardComboBox.getSelectedIndex();
        int circularBufferSize = sampleRate * 4;
        if (this.selectedFormat != null && this.selectedFormat.getInt("bps") == 9600) {
            circularBufferSize = sampleRate * 4;
        }
        SourceSoundCardAudio audioSource = null;
        boolean storeStereo = false;
        if (Config.iq) {
            storeStereo = true;
        }
        boolean connected = false;
        int retries = 0;
        int MAX_RETRIES = 5;
        LineUnavailableException err = null;
        while (!connected && retries < MAX_RETRIES) {
            try {
                audioSource = new SourceSoundCardAudio(circularBufferSize, sampleRate, position, 0, storeStereo);
                connected = true;
            }
            catch (LineUnavailableException e1) {
                e1.printStackTrace(Log.getWriter());
                err = e1;
                ++retries;
                ++this.usbErrorCount;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace(Log.getWriter());
                }
            }
            catch (IllegalArgumentException e1) {
                JOptionPane.showMessageDialog(this, e1.toString(), "ARGUMENT ERROR", 0);
                e1.printStackTrace(Log.getWriter());
                this.stopButton();
            }
        }
        if (!connected) {
            if (retries > 0) {
                ++this.usbFatalErrorCount;
            }
            MainWindow.setUsbErrors(this.usbFatalErrorCount, this.usbErrorCount);
            JOptionPane.showMessageDialog(this, "Your operating system says the device or soundcard is not available.  Error is:\n" + err.toString(), "ERROR", 0);
            this.stopButton();
        }
        return audioSource;
    }

    private void setupDecoder(SourceAudio audioSource, SourceAudio audioSource2) {
        if (this.selectedFormat == null) {
            return;
        }
        if (this.selectedFormat.isFSK()) {
            this.decoder1 = new FoxFskDecoder(audioSource, 0, this.selectedFormat);
        } else if (this.selectedFormat.isBPSK()) {
            this.decoder1 = Config.useCostas ? (this.iqSource1 != null ? new FoxBPSKCostasDecoder(audioSource, 0, 1, this.selectedFormat) : (Config.iq ? new FoxBPSKCostasDecoder(audioSource, 0, 0, this.selectedFormat) : new FoxBPSKCostasDecoder(audioSource, 0, 1, this.selectedFormat))) : new FoxBPSKDotProdDecoder(audioSource, 0, 0, this.selectedFormat);
        }
        Config.save();
        if (Config.monitorAudio) {
            this.setupAudioSink(this.decoder1);
        }
    }

    public void processStartButtonClick() {
        int position = this.soundCardComboBox.getSelectedIndex();
        this.lblkHz.setText(" kHz   ");
        if (STARTED) {
            this.stopButton();
        } else {
            this.viewLowSpeed.setSelected(true);
            STARTED = true;
            this.btnStartButton.setText("Stop");
            this.stopDecoder();
            Config.scSampleRate = Integer.parseInt((String)this.cbSoundCardRate.getSelectedItem());
            if (this.task != null) {
                Log.println("Stopping file progress task-");
                this.task.end();
            }
            if (position != 0) {
                SourceAudio audioSource;
                if (position == 1) {
                    SourceWav wav = this.setWavFile(Config.iq);
                    if (wav != null) {
                        if (this.task != null) {
                            this.task.end();
                        }
                        this.task = new Task(wav);
                        this.progressThread = new Thread(this.task);
                        this.progressThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                        if (Config.iq) {
                            if (this.iqSource1 != null) {
                                this.iqSource1.stop("SourceTab:startClick-File");
                            }
                            this.iqSource1 = new SourceIQ((int)wav.getAudioFormat().getSampleRate() * 4, 0, this.selectedFormat);
                            this.iqSource1.setAudioSource(wav, 0);
                            this.setupDecoder(this.iqSource1, this.iqSource1);
                            try {
                                this.txtFreq.setText(Double.toString(Config.fcdFrequency));
                                this.setCenterFreq();
                            }
                            catch (DeviceException e) {
                                Log.println("ERROR setting the Center Frequency: " + e.getMessage());
                                e.printStackTrace(Log.getWriter());
                            }
                            catch (IOException e) {
                                Log.println("ERROR setting the Center Frequency: " + e.getMessage());
                                e.printStackTrace(Log.getWriter());
                            }
                            Config.passManager.setDecoder1(this.decoder1, this.iqSource1, this);
                        } else {
                            this.setupDecoder(wav, wav);
                        }
                        Config.soundCard = "";
                        this.progressThread.start();
                    } else {
                        this.stopButton();
                    }
                } else if (position >= this.soundcardSources.length) {
                    if (this.autoViewpanel != null) {
                        this.autoViewpanel.setVisible(false);
                    }
                    short vendorId = 0;
                    short deviceId = 0;
                    if (position - this.soundcardSources.length == 0) {
                        vendorId = 3034;
                        deviceId = 10296;
                    }
                    RTL2832TunerController.SampleRate sampleRate = (RTL2832TunerController.SampleRate)((Object)this.cbRtlSampleRate.getSelectedItem());
                    if (this.rfDevice == null) {
                        try {
                            this.rfDevice = this.tunerManager.findDevice(vendorId, deviceId, sampleRate);
                        }
                        catch (UsbException e1) {
                            Log.errorDialog("ERROR", "USB Issue trying to open device:\n" + e1.getMessage());
                            e1.printStackTrace();
                            this.rfDevice = null;
                        }
                        catch (DeviceException e) {
                            Log.errorDialog("ERROR", "Device could not be opened:\n" + e.getMessage());
                            e.printStackTrace();
                            this.rfDevice = null;
                        }
                        catch (LibUsbException e2) {
                            Log.errorDialog("ERROR", "USB Issue trying to communicate with device:\n" + e2.getMessage());
                            e2.printStackTrace();
                            this.rfDevice = null;
                        }
                    }
                    if (this.rfDevice == null) {
                        if (position - this.soundcardSources.length == 0) {
                            vendorId = 3034;
                            deviceId = 10290;
                        }
                        try {
                            this.rfDevice = this.tunerManager.findDevice(vendorId, deviceId, sampleRate);
                        }
                        catch (UsbException e1) {
                            Log.errorDialog("ERROR", "USB Issue trying to open device:\n" + e1.getMessage());
                            e1.printStackTrace();
                            this.rfDevice = null;
                        }
                        catch (DeviceException e) {
                            Log.errorDialog("ERROR", "Device could not be opened:\n" + e.getMessage());
                            e.printStackTrace();
                            this.rfDevice = null;
                        }
                    }
                    if (this.rfDevice == null) {
                        Log.errorDialog("Missing USB device", "Insert the device or choose anther source");
                        this.stopButton();
                    } else {
                        Log.println("USB Source Selected: " + this.rfDevice.name);
                        if (this.panelFcd == null) {
                            try {
                                this.panelFcd = this.rfDevice.getDevicePanel();
                            }
                            catch (IOException e) {
                                Log.errorDialog("USB Panel Error", e.getMessage());
                                e.printStackTrace(Log.getWriter());
                                this.stopButton();
                            }
                            catch (DeviceException e) {
                                Log.errorDialog("USB Device Error", e.getMessage());
                                e.printStackTrace(Log.getWriter());
                                this.stopButton();
                            }
                            catch (LibUsbException e2) {
                                Log.errorDialog("ERROR", "USB Issue trying to communicate with device:\n" + e2.getMessage());
                                e2.printStackTrace();
                                this.rfDevice = null;
                            }
                        }
                        int retried = 0;
                        while (retried < 5) {
                            try {
                                this.rfDevice.setSampleRate(sampleRate);
                                Config.saveGraphIntParam("SDR", 0, 0, "RTL", "RtlSampleRate", sampleRate.getRate());
                                this.panelFcd.setDevice(this.rfDevice);
                            }
                            catch (LibUsbException e) {
                                if (e.getErrorCode() == -9 || e.getErrorCode() == -7 || e.getErrorCode() == -10 || e.getErrorCode() == -6 || e.getErrorCode() == -8 || e.getErrorCode() == -1) {
                                    ++this.usbErrorCount;
                                    ++retried;
                                    try {
                                        Thread.sleep(200L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    continue;
                                }
                                Log.errorDialog("USB Hardware error setting frequency", "Check the device is connected correctly and working.  Error:\n" + e.getMessage());
                                this.stopButton();
                            }
                            catch (IOException e) {
                                Log.errorDialog("USB Panel Error", e.getMessage());
                                e.printStackTrace(Log.getWriter());
                                this.stopButton();
                            }
                            catch (DeviceException e) {
                                Log.errorDialog("USB Device Error", e.getMessage());
                                e.printStackTrace(Log.getWriter());
                                this.stopButton();
                            }
                            catch (UsbException e) {
                                Log.errorDialog("USB Hardware Error", e.getMessage());
                                e.printStackTrace(Log.getWriter());
                                this.stopButton();
                            }
                            break;
                        }
                        if (retried >= 5) {
                            ++this.usbFatalErrorCount;
                        }
                        MainWindow.setUsbErrors(this.usbFatalErrorCount, this.usbErrorCount);
                        this.SDRpanel.add((Component)this.panelFcd, "Center");
                        this.SDRpanel.setVisible(true);
                        this.panelFcd.setEnabled(false);
                        Config.iq = true;
                        this.iqAudio.setSelected(true);
                        this.setIQVisible(true);
                        int rate = this.panelFcd.getSampleRate();
                        int channels = 0;
                        if (position - this.soundcardSources.length == 2) {
                            this.setFcdSampleRate();
                            Config.soundCard = this.soundCardComboBox.getItemAt(this.soundCardComboBox.getSelectedIndex());
                            audioSource = this.setupSoundCard(this.highSpeed.isSelected(), Config.scSampleRate);
                        } else {
                            audioSource = new SourceUSB("USB Source", rate, rate * 2, channels);
                            this.rfDevice.setUsbSource((SourceUSB)audioSource);
                        }
                        this.iqSource1 = new SourceIQ(rate * 2, 0, this.selectedFormat);
                        this.iqSource1.setAudioSource(audioSource, 0);
                        this.setupDecoder(this.iqSource1, this.iqSource1);
                        Config.passManager.setDecoder1(this.decoder1, this.iqSource1, this);
                        Config.soundCard = this.soundCardComboBox.getItemAt(this.soundCardComboBox.getSelectedIndex());
                    }
                } else {
                    int fcdSelected = 0;
                    try {
                        fcdSelected = this.usingFcd();
                        if (fcdSelected > 0) {
                            this.setFcdSampleRate();
                        } else {
                            Config.scSampleRate = Integer.parseInt((String)this.cbSoundCardRate.getSelectedItem());
                        }
                        Config.soundCard = this.soundCardComboBox.getItemAt(this.soundCardComboBox.getSelectedIndex());
                        audioSource = this.setupSoundCard(this.highSpeed.isSelected(), Config.scSampleRate);
                        if (audioSource != null) {
                            if (fcdSelected > 0 || Config.iq) {
                                Log.println("IQ Source Selected");
                                this.iqSource1 = new SourceIQ(Config.scSampleRate * 4, 0, this.selectedFormat);
                                this.iqSource1.setAudioSource(audioSource, 0);
                                this.setupDecoder(this.iqSource1, this.iqSource2);
                                Config.passManager.setDecoder1(this.decoder1, this.iqSource1, this);
                                this.txtFreq.setText(Double.toString(Config.fcdFrequency));
                                this.setCenterFreq();
                            } else {
                                this.setupDecoder(audioSource, audioSource);
                            }
                        }
                    }
                    catch (IOException e) {
                        Log.errorDialog("FCD Start Error", e.getMessage());
                        e.printStackTrace(Log.getWriter());
                        this.stopButton();
                    }
                    catch (DeviceException e) {
                        Log.errorDialog("ERROR", "FCD Startup Error writing commands: " + e.getMessage());
                        e.printStackTrace(Log.getWriter());
                        this.stopButton();
                    }
                    catch (UsbException e) {
                        Log.errorDialog("ERROR", "FCD Startup error with USB: " + e.getMessage());
                        e.printStackTrace(Log.getWriter());
                        this.stopButton();
                    }
                }
                if (this.decoder1 != null) {
                    this.decoder1Thread = new Thread(this.decoder1);
                    this.decoder1Thread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                    if (this.decoder2 != null) {
                        this.decoder2Thread = new Thread(this.decoder2);
                        this.decoder2Thread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                    }
                    if (Config.monitorAudio && this.sink != null) {
                        try {
                            this.decoder1.setMonitorAudio(this.sink, Config.monitorAudio, this.speakerComboBox.getSelectedIndex());
                        }
                        catch (IllegalArgumentException e) {
                            Log.errorDialog("ERROR", "Can't monitor the audio " + e.getMessage());
                            e.printStackTrace(Log.getWriter());
                        }
                        catch (LineUnavailableException e) {
                            Log.errorDialog("ERROR", "Can't monitor the audio.  Is the soundcard working? Error is:\n" + e.getMessage());
                            e.printStackTrace(Log.getWriter());
                        }
                    }
                }
                if (this.decoder1Thread != null) {
                    try {
                        this.decoder1Thread.start();
                        this.audioGraph.startProcessing(this.decoder1);
                        if (this.eyePanelThread == null) {
                            this.eyePanelThread = new Thread(this.eyePanel);
                            this.eyePanelThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                            this.eyePanelThread.start();
                        }
                        this.eyePanel.startProcessing(this.decoder1);
                        if (this.decoder1 instanceof FoxBPSKDotProdDecoder || this.decoder1 instanceof FoxBPSKCostasDecoder) {
                            if (this.phasorPanelThread == null) {
                                this.phasorPanelThread = new Thread(this.phasorPanel);
                                this.phasorPanelThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                                this.phasorPanelThread.start();
                            }
                            this.phasorPanel.startProcessing(this.decoder1);
                            this.phasorPanel.setVisible(Config.showPhasor);
                        } else {
                            this.phasorPanel.setVisible(false);
                        }
                        this.enableSourceSelectionComponents(false);
                        if (this.iqSource1 != null) {
                            if (this.fftPanelThread == null) {
                                this.fftPanelThread = new Thread(this.fftPanel);
                                this.fftPanelThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
                                this.fftPanelThread.start();
                            }
                            this.fftPanel.startProcessing(this.iqSource1);
                        }
                    }
                    catch (IllegalThreadStateException e2) {
                        JOptionPane.showMessageDialog(this, e2.toString(), "THREAD LAUNCH ERROR", 0);
                    }
                    if (this.decoder2Thread != null) {
                        try {
                            this.decoder2Thread.start();
                        }
                        catch (IllegalThreadStateException e2) {
                            JOptionPane.showMessageDialog(this, e2.toString(), "THREAD2 LAUNCH ERROR", 0);
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (this.rfDevice != null) {
                        this.txtFreq.setText(Double.toString(Config.fcdFrequency));
                        try {
                            double f = this.setCenterFreq();
                            this.txtFreq.setText(Double.toString(f));
                        }
                        catch (DeviceException e) {
                            Log.println("ERROR setting the Center Frequency: " + e.getMessage());
                            e.printStackTrace(Log.getWriter());
                        }
                        catch (IOException e) {
                            Log.println("ERROR setting the Center Frequency: " + e.getMessage());
                            e.printStackTrace(Log.getWriter());
                        }
                    }
                }
            }
        }
        Config.startButtonPressed = STARTED;
        Config.save();
    }

    public double setCenterFreqKhz(double freq) {
        double f = 0.0;
        this.txtFreq.setText(Double.toString(freq));
        try {
            f = this.setCenterFreq();
            this.txtFreq.setText(Double.toString(f));
        }
        catch (DeviceException e) {
            Log.println("ERROR setting the Center Frequency: " + e.getMessage());
            e.printStackTrace(Log.getWriter());
        }
        catch (IOException e) {
            Log.println("ERROR setting the Center Frequency: " + e.getMessage());
            e.printStackTrace(Log.getWriter());
        }
        return f;
    }

    private double setCenterFreq() throws DeviceException, IOException {
        double freq = Config.fcdFrequency;
        try {
            this.txtFreq.selectAll();
            freq = (double)Math.round(Double.parseDouble(this.txtFreq.getText()) * 1000.0) / 1000.0;
            if (this.iqSource1 != null) {
                this.iqSource1.setCenterFreqkHz(freq);
            }
            if (this.iqSource2 != null) {
                this.iqSource2.setCenterFreqkHz(freq);
            }
            Config.fcdFrequency = freq;
            if (this.rfDevice != null && this.panelFcd != null) {
                if (freq < (double)this.rfDevice.getMinFreq() || freq > (double)this.rfDevice.getMaxFreq()) {
                    Log.errorDialog("DEVICE ERROR", "Frequency must be between " + this.rfDevice.getMinFreq() + " and " + this.rfDevice.getMaxFreq());
                } else {
                    int retried = 0;
                    while (retried < 5) {
                        try {
                            this.rfDevice.setFrequency((long)(freq * 1000.0));
                            this.panelFcd.updateFilter();
                        }
                        catch (LibUsbException e) {
                            if (e.getErrorCode() == -9 || e.getErrorCode() == -7 || e.getErrorCode() == -10 || e.getErrorCode() == -6 || e.getErrorCode() == -1) {
                                ++this.usbErrorCount;
                                ++retried;
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (InterruptedException interruptedException) {}
                                continue;
                            }
                            Log.errorDialog("LibUSB error setting frequency", "Check the device is connected correctly and working.  Error:\n" + e.getMessage());
                        }
                        catch (UsbException e) {
                            Log.errorDialog("USB Hardware error setting frequency", "Check the device is connected correctly and working.  Error:\n" + e.getMessage());
                        }
                        break;
                    }
                    if (retried >= 5) {
                        ++this.usbFatalErrorCount;
                    }
                    MainWindow.setUsbErrors(this.usbFatalErrorCount, this.usbErrorCount);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Config.save();
        return freq;
    }

    private void stopDecoder() {
        if (this.decoder1 != null) {
            this.decoder1.stopProcessing();
            this.decoder1 = null;
            if (this.iqSource1 != null) {
                this.iqSource1.stop("SourceTab:stopDecoder1");
            }
            this.iqSource1 = null;
            this.decoder1Thread = null;
            Config.passManager.setDecoder1(this.decoder1, this.iqSource1, this);
        }
        if (this.decoder2 != null) {
            this.decoder2.stopProcessing();
            this.decoder2 = null;
            if (this.iqSource2 != null) {
                this.iqSource2.stop("SourceTab:stopDecoder2");
            }
            this.iqSource2 = null;
            this.decoder2Thread = null;
            Config.passManager.setDecoder2(this.decoder2, this.iqSource2, this);
        }
        if (this.rfDevice != null && !(this.rfDevice instanceof FCDTunerController)) {
            try {
                this.rfDevice.cleanup();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DeviceException e) {
                e.printStackTrace();
            }
        }
        if (this.soundCardComboBox.getSelectedIndex() >= this.soundcardSources.length) {
            this.SDRpanel.setVisible(true);
            if (this.panelFcd != null) {
                this.panelFcd.setEnabled(true);
            }
        } else {
            this.SDRpanel.setVisible(false);
        }
    }

    private void stopButton() {
        this.stop();
    }

    private void stop() {
        this.stopDecoder();
        STARTED = false;
        this.btnStartButton.setText("Start");
        if (!Config.whenAboveHorizon || this.soundCardComboBox.getSelectedIndex() == 0) {
            this.enableSourceSelectionComponents(true);
        }
    }

    private void enableSourceSelectionComponents(boolean t) {
        this.soundCardComboBox.setEnabled(t);
        this.cbSoundCardRate.setEnabled(t);
        this.cbRtlSampleRate.setEnabled(t);
        this.enableSourceModeSelectionComponents(t);
        this.iqAudio.setEnabled(t);
        this.afAudio.setEnabled(t);
        MainWindow.enableSourceSelection(t);
    }

    private void enableSourceModeSelectionComponents(boolean t) {
        this.cbFormat.setEnabled(t);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.rdbtnViewFilteredAudio) {
            if (e.getStateChange() == 2) {
                this.audioGraph.showUnFilteredAudio();
                Config.viewFilteredAudio = false;
            } else {
                this.audioGraph.showFilteredAudio();
                Config.viewFilteredAudio = true;
            }
            Config.save();
        }
        if (e.getSource() == this.rdbtnMonitorFilteredAudio) {
            if (e.getStateChange() == 2) {
                this.monitorFiltered = false;
                Config.monitorFilteredAudio = false;
                Config.save();
            } else {
                Config.monitorFilteredAudio = true;
                this.monitorFiltered = true;
                Config.save();
            }
            Config.save();
        }
        if (e.getSource() == this.cbTurboWavFilePlayback) {
            if (e.getStateChange() == 2) {
                Config.turboWavFilePlayback = false;
                Config.save();
            } else {
                Config.turboWavFilePlayback = true;
                Config.save();
            }
            Config.save();
        }
        if (e.getSource() == this.rdbtnSquelchAudio) {
            if (e.getStateChange() == 2) {
                Config.squelchAudio = false;
                Config.save();
            } else {
                Config.squelchAudio = true;
                Config.save();
            }
            Config.save();
        }
        if (e.getSource() == this.rdbtnFilterOutputAudio) {
            if (e.getStateChange() == 2) {
                Config.filterOutputAudio = false;
                Config.save();
            } else {
                Config.filterOutputAudio = true;
                Config.save();
            }
            Config.save();
        }
        if (e.getSource() == this.rdbtnWriteDebugData) {
            Config.debugValues = e.getStateChange() != 2;
            Config.save();
        }
        if (e.getSource() == this.cbRetuneCenterFrequency) {
            Config.retuneCenterFrequency = e.getStateChange() != 2;
            this.txtFreq.setEnabled(!Config.retuneCenterFrequency);
            this.enableSourceModeSelectionComponents(!Config.retuneCenterFrequency);
            Config.save();
        }
        Config.save();
        if (e.getSource() == this.autoStart) {
            Config.whenAboveHorizon = e.getStateChange() != 2;
            Config.save();
        }
        if (e.getSource() == this.rdbtnShowIF) {
            Config.showIF = e.getStateChange() != 2;
            Config.save();
        }
        if (e.getSource() == this.rdbtnFindSignal) {
            Config.findSignal = e.getStateChange() != 2;
            this.findSignalPanel.setVisible(Config.findSignal);
            Config.save();
        }
        if (e.getSource() == this.rdbtnShowLog) {
            if (e.getStateChange() == 2) {
                this.logScrollPane.setVisible(false);
                this.log.setVisible(false);
                Log.setGUILog(null);
            } else {
                this.logScrollPane.setVisible(true);
                this.log.setVisible(true);
                MainWindow.frame.repaint();
                Log.setGUILog(this);
            }
            Config.save();
        }
    }

    public void shutdown() {
        Config.startButtonPressed = STARTED;
        if (this.rfDevice != null) {
            try {
                this.rfDevice.cleanup();
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
            catch (DeviceException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        if (this.decoder1 != null) {
            this.decoder1.stopProcessing();
        }
        if (this.decoder2 != null) {
            this.decoder2.stopProcessing();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.peakLevel) {
            try {
                Config.SCAN_SIGNAL_THRESHOLD = Double.parseDouble(this.peakLevel.getText());
            }
            catch (NumberFormatException n) {
                Log.errorDialog("Invalid Value", n.getMessage());
            }
            Config.save();
        }
        if (e.getSource() == this.avgLevel) {
            try {
                Config.ANALYZE_SNR_THRESHOLD = Double.parseDouble(this.avgLevel.getText());
            }
            catch (NumberFormatException n) {
                Log.errorDialog("Invalid Value", n.getMessage());
            }
            Config.save();
        }
        if (e.getSource() == this.bitLevel) {
            try {
                Config.BIT_SNR_THRESHOLD = Double.parseDouble(this.bitLevel.getText());
            }
            catch (NumberFormatException n) {
                Log.errorDialog("Invalid Value", n.getMessage());
            }
            Config.save();
        }
        if (e.getSource() == this.txtFreq) {
            try {
                double f = this.setCenterFreq();
                this.txtFreq.setText(Double.toString(f));
            }
            catch (DeviceException e1) {
                Log.errorDialog("ERROR loosing focus", e1.getMessage());
                e1.printStackTrace(Log.getWriter());
            }
            catch (IOException e1) {
                e1.printStackTrace(Log.getWriter());
            }
            catch (LibUsbException e2) {
                e2.printStackTrace(Log.getWriter());
            }
        }
    }

    public boolean sdrSelected() {
        return this.soundCardComboBox.getSelectedIndex() >= this.soundcardSources.length;
    }

    public void startDecoding() {
        this.aboveHorizon = true;
    }

    public void stopDecoding() {
        this.aboveHorizon = false;
    }

    public boolean isStarted() {
        return STARTED;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("SourceTab:Tracking");
        while (true) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SourceTab.this.usbFatalErrorCount > MainWindow.usbFatalErrorCount) {
                        MainWindow.setUsbErrors(SourceTab.this.usbFatalErrorCount, SourceTab.this.usbErrorCount);
                    }
                    boolean atLeastOneTracked = false;
                    try {
                        if (Config.satManager.updated) {
                            atLeastOneTracked = SourceTab.this.buildTrackedSpacecraftList();
                            Config.satManager.updated = false;
                        }
                        int s = 0;
                        while (s < Config.satManager.spacecraftList.size()) {
                            Spacecraft sat = Config.satManager.spacecraftList.get(s);
                            if (sat.user_track) {
                                atLeastOneTracked = true;
                            }
                            if ((Config.foxTelemCalcsPosition || Config.whenAboveHorizon && SourceTab.this.aboveHorizon) && sat.user_track && sat.aboveHorizon()) {
                                SourceTab.this.satPosition[s].setForeground(Config.AMSAT_RED);
                            } else {
                                SourceTab.this.satPosition[s].setForeground(Config.AMSAT_BLUE);
                            }
                            if (Config.foxTelemCalcsPosition && sat.user_track) {
                                if (sat.satPos != null) {
                                    double az = FramePart.radToDeg(sat.satPos.getAzimuth());
                                    double el = FramePart.radToDeg(sat.satPos.getElevation());
                                    String position = String.format("%2.1f", az) + " | " + String.format("%2.1f", el);
                                    if (Config.foxTelemCalcsDoppler) {
                                        double freq = sat.satPos.getDopplerFrequency(sat.user_telemetryDownlinkFreqkHz);
                                        String sign = "";
                                        if (freq > 0.0) {
                                            sign = "+";
                                        }
                                        position = String.valueOf(position) + " | " + sign + String.format("%2.3f", freq) + "kHz";
                                    }
                                    SourceTab.this.satPosition[s].setText(position);
                                } else {
                                    String msg = "Tracked / ";
                                    if (Config.whenAboveHorizon) {
                                        msg = "Not " + msg;
                                        SourceTab.this.satPosition[s].setForeground(Color.GRAY);
                                    }
                                    msg = sat.satPosErrorCode == -998.0 ? String.valueOf(msg) + "No T0" : (sat.satPosErrorCode == -997.0 ? String.valueOf(msg) + "No TLE" : String.valueOf(msg) + "No Position");
                                    SourceTab.this.satPosition[s].setText(msg);
                                }
                            } else if (Config.useDDEforAzEl && sat.user_track) {
                                if (Config.satPC != null && Config.satPC.conversation != null) {
                                    String satName = Config.satPC.getSatellite();
                                    if (satName != null && satName.equalsIgnoreCase(sat.user_keps_name)) {
                                        double az = Config.satPC.getAzimuth();
                                        double el = Config.satPC.getElevation();
                                        if (el > 0.0) {
                                            SourceTab.this.satPosition[s].setForeground(Config.AMSAT_RED);
                                        } else {
                                            SourceTab.this.satPosition[s].setForeground(Config.AMSAT_BLUE);
                                        }
                                        String position = String.format("%2.1f", az) + " | " + String.format("%2.1f", el);
                                        SourceTab.this.satPosition[s].setText(position);
                                    } else {
                                        SourceTab.this.satPosition[s].setText("Tracked via SATPC32");
                                    }
                                } else {
                                    SourceTab.this.satPosition[s].setText("SATPC32 - not found");
                                }
                            } else if (sat.user_track) {
                                SourceTab.this.satPosition[s].setText("Tracked");
                            } else {
                                SourceTab.this.satPosition[s].setText("Not Tracked");
                                SourceTab.this.satPosition[s].setForeground(Color.GRAY);
                            }
                            ++s;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (Config.foxTelemCalcsPosition) {
                        if (Config.iq) {
                            SourceTab.this.cbRetuneCenterFrequency.setText(SourceTab.RETUNE_AND_SWITCH_MODE);
                            SourceTab.this.cbRetuneCenterFrequency.setToolTipText(SourceTab.RETUNE_AND_SWITCH_MODE_TIP);
                        } else {
                            SourceTab.this.cbRetuneCenterFrequency.setText(SourceTab.SWITCH_MODE);
                            SourceTab.this.cbRetuneCenterFrequency.setToolTipText(SourceTab.SWITCH_MODE_TIP);
                        }
                    }
                    if (atLeastOneTracked && (Config.foxTelemCalcsPosition || Config.useDDEforAzEl)) {
                        SourceTab.this.autoStart.setEnabled(true);
                        if ((Config.foxTelemCalcsPosition || Config.useDDEforAzEl) && !Config.findSignal) {
                            SourceTab.this.cbRetuneCenterFrequency.setEnabled(true);
                        } else if (Config.whenAboveHorizon) {
                            SourceTab.this.cbRetuneCenterFrequency.setEnabled(true);
                        } else {
                            SourceTab.this.cbRetuneCenterFrequency.setEnabled(false);
                            SourceTab.this.cbRetuneCenterFrequency.setSelected(false);
                        }
                    } else {
                        SourceTab.this.autoStart.setEnabled(false);
                        SourceTab.this.cbRetuneCenterFrequency.setEnabled(false);
                        SourceTab.this.cbRetuneCenterFrequency.setSelected(false);
                    }
                    SourceTab.this.autoStart.setSelected(Config.whenAboveHorizon);
                    if (SourceTab.this.soundCardComboBox.getSelectedIndex() == 0) {
                        SourceTab.this.btnStartButton.setEnabled(false);
                    } else if (Config.satManager.spacecraftList.size() == 0) {
                        SourceTab.this.btnStartButton.setEnabled(false);
                    } else if (Config.whenAboveHorizon && SourceTab.this.soundCardComboBox.getSelectedIndex() != 0) {
                        SourceTab.this.rdbtnFindSignal.setEnabled(false);
                        SourceTab.this.btnStartButton.setEnabled(false);
                        SourceTab.this.lblWhenAboveHorizon.setVisible(true);
                        if (SourceTab.this.aboveHorizon && !STARTED) {
                            SourceTab.this.processStartButtonClick();
                        }
                        if (!SourceTab.this.aboveHorizon && STARTED) {
                            SourceTab.this.processStartButtonClick();
                        }
                    } else {
                        SourceTab.this.btnStartButton.setEnabled(true);
                        SourceTab.this.lblWhenAboveHorizon.setVisible(false);
                    }
                    if (Config.iq && atLeastOneTracked && !Config.foxTelemCalcsDoppler) {
                        if (!Config.findSignal) {
                            SourceTab.this.warnNoTrackingPanel.setVisible(true);
                            SourceTab.this.lblWarnNoFindSignal.setText("WARNING: Find Signal and Doppler Tracking are both disabled");
                        } else {
                            SourceTab.this.warnNoTrackingPanel.setVisible(false);
                        }
                    } else {
                        SourceTab.this.warnNoTrackingPanel.setVisible(false);
                    }
                    if (Config.foxTelemCalcsDoppler && !atLeastOneTracked) {
                        SourceTab.this.warnNoTrackingPanel.setVisible(true);
                        SourceTab.this.lblWarnNoFindSignal.setText("WARNING: Doppler tracking is on but no spacecraft are tracked");
                    }
                    if (Config.findSignal) {
                        SourceTab.this.rdbtnFindSignal.setSelected(true);
                        if (Config.iq) {
                            SourceTab.this.findSignalPanel.setVisible(true);
                        }
                        if (!atLeastOneTracked) {
                            SourceTab.this.warnNoTrackingPanel.setVisible(true);
                            SourceTab.this.lblWarnNoFindSignal.setText("WARNING: Find Signal is on but no spacecraft are tracked");
                        }
                    } else {
                        SourceTab.this.rdbtnFindSignal.setEnabled(false);
                        SourceTab.this.rdbtnFindSignal.setSelected(false);
                        SourceTab.this.findSignalPanel.setVisible(false);
                    }
                    if (Config.debugValues && !SourceTab.this.unpause.isVisible()) {
                        SourceTab.this.unpause.setVisible(true);
                        SourceTab.this.play.setVisible(true);
                    }
                    if (!Config.debugValues && SourceTab.this.unpause.isVisible()) {
                        SourceTab.this.unpause.setVisible(false);
                        SourceTab.this.play.setVisible(false);
                    }
                }
            });
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int s = 0;
        while (s < Config.satManager.spacecraftList.size()) {
            if (e.getSource() == this.satPosition[s]) {
                Config.satManager.spacecraftList.get((int)s).user_track = !Config.satManager.spacecraftList.get((int)s).user_track;
                Config.satManager.spacecraftList.get(s).save();
            }
            ++s;
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    class Task
    implements Runnable {
        int progress;
        SourceWav wavSource;

        public Task(SourceWav wav) {
            this.wavSource = wav;
            this.progress = 0;
        }

        public void setProgress(int p) {
            this.progress = p;
        }

        public void resetProgress() {
            this.progress = 0;
            this.setProgress(this.progress);
        }

        @Override
        public void run() {
            Thread.currentThread().setName("ProgressBar");
            this.setProgress(0);
            while (this.progress < 100 && this.wavSource != null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.progress = this.wavSource != null ? this.wavSource.getPercentProgress() : -1;
                if (this.progress == -1) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SourceTab.this.progressBar.setValue(Math.min(Task.this.progress, 100));
                        if (Task.this.wavSource.getLengthInSeconds() < 120) {
                            SourceTab.this.progressBar.setString(Task.this.wavSource.getLengthInSeconds() * Task.this.progress / 100 + " secs");
                        } else {
                            String mins = "" + Task.this.wavSource.getLengthInSeconds() * Task.this.progress / 100 / 60;
                            int sec = Task.this.wavSource.getLengthInSeconds() * Task.this.progress / 100 % 60;
                            String secs = "" + sec;
                            if (sec < 10) {
                                secs = "0" + secs;
                            }
                            SourceTab.this.progressBar.setString(mins + ":" + secs + " mins");
                        }
                    }
                });
            }
            this.setProgress(100);
            this.done();
            Log.println("WORKER IS DONE");
        }

        public void done() {
            Toolkit.getDefaultToolkit().beep();
            SourceTab.this.stopButton();
        }

        public void end() {
            this.setProgress(100);
        }
    }
}

