/*
 * Decompiled with CFR 0.152.
 */
package gui.graph;

import common.Config;
import common.Spacecraft;
import gui.MainWindow;
import gui.graph.DiagnosticTableModel;
import gui.graph.GraphFrame;
import gui.graph.HardErrorTableModel;
import gui.graph.IcrDiagnosticTableModel;
import gui.graph.IsisAntennaStatusTableModel;
import gui.graph.SoftError84488TableModel;
import gui.graph.SoftErrorTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import telemetry.conversion.ConversionLegacy;

public class DiagnosticTable
extends JPanel {
    Spacecraft fox;
    double[][] graphData = null;
    String title = "Test Graph";
    String fieldName = null;
    int conversionType;
    GraphFrame graphFrame;
    JTable table;
    AbstractTableModel tableModel;
    JScrollPane scrollPane;

    DiagnosticTable(String t, String fieldName, int conversionType, GraphFrame gf, Spacecraft sat) {
        this.conversionType = conversionType;
        this.title = t;
        this.fieldName = fieldName;
        this.graphFrame = gf;
        this.fox = sat;
        this.setLayout(new BorderLayout());
        JLabel titleLabel = new JLabel(this.title);
        titleLabel.setFont(new Font("SansSerif", 1, Config.graphAxisFontSize + 3));
        this.add((Component)titleLabel, "North");
        this.table = this.addErrorTable();
        this.updateData();
    }

    private JTable addErrorTable() {
        JTable table;
        block19: {
            DefaultTableCellRenderer centerRenderer;
            TableColumn column;
            block21: {
                block20: {
                    block18: {
                        if (this.conversionType == 18) {
                            this.tableModel = new DiagnosticTableModel();
                        } else if (this.conversionType == 19) {
                            this.tableModel = new HardErrorTableModel();
                        } else if (this.conversionType == 20) {
                            this.tableModel = new SoftErrorTableModel();
                        } else if (this.conversionType == 39) {
                            this.tableModel = new SoftError84488TableModel();
                        } else if (this.conversionType == 35) {
                            this.tableModel = new IcrDiagnosticTableModel();
                        } else if (this.conversionType == 51) {
                            this.tableModel = new IsisAntennaStatusTableModel();
                        }
                        table = new JTable(this.tableModel);
                        table.setAutoCreateRowSorter(true);
                        this.scrollPane = new JScrollPane(table, 22, 32);
                        table.setFillsViewportHeight(true);
                        table.setAutoResizeMode(4);
                        this.add((Component)this.scrollPane, "Center");
                        column = null;
                        column = table.getColumnModel().getColumn(0);
                        column.setPreferredWidth(45);
                        column = table.getColumnModel().getColumn(1);
                        column.setPreferredWidth(55);
                        centerRenderer = new DefaultTableCellRenderer();
                        centerRenderer.setHorizontalAlignment(0);
                        if (this.conversionType != 18) break block18;
                        column = table.getColumnModel().getColumn(2);
                        column.setPreferredWidth(250);
                        break block19;
                    }
                    if (this.conversionType != 19) break block20;
                    int i = 0;
                    while (i < 6) {
                        column = table.getColumnModel().getColumn(i + 2);
                        column.setPreferredWidth(60);
                        column.setCellRenderer(centerRenderer);
                        column.setHeaderRenderer(centerRenderer);
                        ++i;
                    }
                    break block19;
                }
                if (this.conversionType != 20) break block21;
                int i = 0;
                while (i < 4) {
                    column = table.getColumnModel().getColumn(i + 2);
                    column.setPreferredWidth(60);
                    column.setCellRenderer(centerRenderer);
                    column.setHeaderRenderer(centerRenderer);
                    ++i;
                }
                if (this.conversionType != 39) break block19;
                column = table.getColumnModel().getColumn(6);
                column.setPreferredWidth(60);
                column.setCellRenderer(centerRenderer);
                column.setHeaderRenderer(centerRenderer);
                break block19;
            }
            if (this.conversionType == 35) {
                int i = 0;
                while (i < 4) {
                    column = table.getColumnModel().getColumn(i + 2);
                    column.setPreferredWidth(60);
                    column.setCellRenderer(centerRenderer);
                    column.setHeaderRenderer(centerRenderer);
                    ++i;
                }
            } else if (this.conversionType == 51) {
                int i = 0;
                while (i < 15) {
                    column = table.getColumnModel().getColumn(i + 2);
                    column.setPreferredWidth(60);
                    column.setCellRenderer(centerRenderer);
                    column.setHeaderRenderer(centerRenderer);
                    ++i;
                }
            }
        }
        return table;
    }

    public void updateData() {
        if (this.conversionType == 18) {
            this.updateDiagnosticData();
        } else if (this.conversionType == 19) {
            this.updateHardErrorData();
        } else if (this.conversionType == 20) {
            this.updateSoftErrorData();
        } else if (this.conversionType == 39) {
            this.updateSoftErrorData84488();
        } else if (this.conversionType == 35) {
            this.updateIcrDiagnosticData();
        } else if (this.conversionType == 51) {
            this.updateIsisAntennaData();
        }
    }

    private void setColumnName(int col, String name) {
        int viewColumn = this.table.convertColumnIndexToView(col);
        TableColumn column = this.table.getColumnModel().getColumn(viewColumn);
        column.setHeaderValue(name);
        this.table.getTableHeader().repaint();
    }

    public void updateDiagnosticData() {
        boolean reverse = false;
        if (this.graphFrame.showLatest == 0) {
            reverse = true;
        }
        this.graphData = Config.payloadStore.getGraphData(this.fieldName, this.graphFrame.SAMPLES, this.graphFrame.fox, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, this.graphFrame.layout.name, false, reverse);
        String[][] tableData = new String[this.graphData[0].length][7];
        if (this.graphData[0].length > 0) {
            int i = this.graphData[0].length - 1;
            while (i >= 0) {
                int value = (int)this.graphData[0][i];
                String display = null;
                display = ConversionLegacy.ihuDiagnosticString(value, false, this.fox);
                if (display != null) {
                    this.initTableColumns(tableData, i);
                    tableData[i][2] = display;
                }
                --i;
            }
            ((DiagnosticTableModel)this.tableModel).setData(tableData);
        }
        MainWindow.frame.repaint();
    }

    public void updateHardErrorData() {
        boolean reverse = false;
        if (this.graphFrame.showLatest == 0) {
            reverse = true;
        }
        this.graphData = Config.payloadStore.getGraphData(this.fieldName, this.graphFrame.SAMPLES, this.graphFrame.fox, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, this.graphFrame.layout.name, false, reverse);
        String[][] tableData = new String[this.graphData[0].length][8];
        if (this.graphData[0].length > 0) {
            int i = this.graphData[0].length - 1;
            while (i >= 0) {
                int value = (int)this.graphData[0][i];
                String[] display = null;
                display = ConversionLegacy.hardErrorStringArray(value, false);
                if (display != null) {
                    this.initTableColumns(tableData, i);
                    int j = 2;
                    while (j < 8) {
                        tableData[i][j] = display[j - 2];
                        ++j;
                    }
                }
                --i;
            }
            ((HardErrorTableModel)this.tableModel).setData(tableData);
        }
        MainWindow.frame.repaint();
    }

    public void updateSoftErrorData() {
        boolean reverse = false;
        if (this.graphFrame.showLatest == 0) {
            reverse = true;
        }
        this.graphData = Config.payloadStore.getGraphData(this.fieldName, this.graphFrame.SAMPLES, this.graphFrame.fox, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, this.graphFrame.layout.name, false, reverse);
        String[][] tableData = new String[this.graphData[0].length][6];
        if (this.graphData[0].length > 0) {
            int i = this.graphData[0].length - 1;
            while (i >= 0) {
                int value = (int)this.graphData[0][i];
                String[] display = null;
                display = ConversionLegacy.softErrorStringArrayFox1A(value, false);
                if (display != null) {
                    this.initTableColumns(tableData, i);
                    int j = 2;
                    while (j < 6) {
                        tableData[i][j] = display[j - 2];
                        ++j;
                    }
                }
                --i;
            }
            ((SoftErrorTableModel)this.tableModel).setData(tableData);
        }
        MainWindow.frame.repaint();
    }

    public void updateSoftErrorData84488() {
        boolean reverse = false;
        if (this.graphFrame.showLatest == 0) {
            reverse = true;
        }
        this.graphData = Config.payloadStore.getGraphData(this.fieldName, this.graphFrame.SAMPLES, this.graphFrame.fox, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, this.graphFrame.layout.name, false, reverse);
        String[][] tableData = new String[this.graphData[0].length][7];
        if (this.graphData[0].length > 0) {
            int i = this.graphData[0].length - 1;
            while (i >= 0) {
                int value = (int)this.graphData[0][i];
                String[] display = null;
                display = ConversionLegacy.softErrorStringArray84488(value, false);
                if (display != null) {
                    this.initTableColumns(tableData, i);
                    int j = 2;
                    while (j < 7) {
                        tableData[i][j] = display[j - 2];
                        ++j;
                    }
                }
                --i;
            }
            ((SoftError84488TableModel)this.tableModel).setData(tableData);
        }
        MainWindow.frame.repaint();
    }

    public void updateIcrDiagnosticData() {
        boolean reverse = false;
        if (this.graphFrame.showLatest == 0) {
            reverse = true;
        }
        this.graphData = Config.payloadStore.getGraphData(this.fieldName, this.graphFrame.SAMPLES, this.graphFrame.fox, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, this.graphFrame.layout.name, false, reverse);
        String[][] tableData = new String[this.graphData[0].length][7];
        if (this.graphData[0].length > 0) {
            int i = this.graphData[0].length - 1;
            while (i >= 0) {
                int value = (int)this.graphData[0][i];
                String[] display = null;
                display = ConversionLegacy.icrDiagnosticStringArray(value, false);
                if (display != null) {
                    this.initTableColumns(tableData, i);
                    int j = 2;
                    while (j < 6) {
                        tableData[i][j] = display[j - 2];
                        ++j;
                    }
                }
                --i;
            }
            ((IcrDiagnosticTableModel)this.tableModel).setData(tableData);
        }
        MainWindow.frame.repaint();
    }

    public void updateIsisAntennaData() {
        boolean reverse = false;
        if (this.graphFrame.showLatest == 0) {
            reverse = true;
        }
        this.graphData = Config.payloadStore.getGraphData(this.fieldName, this.graphFrame.SAMPLES, this.graphFrame.fox, this.graphFrame.START_RESET, this.graphFrame.START_UPTIME, this.graphFrame.layout.name, false, reverse);
        String[][] tableData = new String[this.graphData[0].length][17];
        if (this.graphData[0].length > 0) {
            int i = this.graphData[0].length - 1;
            while (i >= 0) {
                int value = (int)this.graphData[0][i];
                String[] display = null;
                display = ConversionLegacy.isisAntennaStatusArray(value, false);
                if (display != null) {
                    this.initTableColumns(tableData, i);
                    int j = 2;
                    while (j < 17) {
                        tableData[i][j] = display[j - 2];
                        ++j;
                    }
                }
                --i;
            }
            ((IsisAntennaStatusTableModel)this.tableModel).setData(tableData);
        }
        MainWindow.frame.repaint();
    }

    private void initTableColumns(String[][] tableData, int i) {
        if (this.graphFrame.showUTCtime) {
            this.setColumnName(0, "Date");
            this.setColumnName(1, "Time (UTC)");
            int resets = (int)this.graphData[2][i];
            long uptime = (int)this.graphData[1][i];
            if (this.fox.hasTimeZero(resets)) {
                tableData[i][1] = this.fox.getUtcTimeForReset(resets, uptime);
                tableData[i][0] = this.fox.getUtcDateForReset(resets, uptime);
            } else {
                tableData[i][1] = "";
                tableData[i][0] = "";
            }
        } else {
            this.setColumnName(0, "Epoch");
            this.setColumnName(1, "Uptime");
            tableData[i][0] = Integer.toString((int)this.graphData[2][i]);
            tableData[i][1] = Long.toString((long)this.graphData[1][i]);
        }
    }
}

