/*
 * Decompiled with CFR 0.152.
 */
package gui.herci;

import common.Config;
import common.Log;
import common.Spacecraft;
import decoder.FoxDecoder;
import gui.MainWindow;
import gui.herci.HerciHSTableModel;
import gui.herci.HerciHsPacketTableModel;
import gui.tabs.DisplayModule;
import gui.tabs.ExperimentTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.LayoutLoadException;
import telemetry.herci.HerciHighspeedHeader;
import telemetry.herci.PayloadHERCIhighSpeed;

public class HerciHSTab
extends ExperimentTab
implements Runnable,
ItemListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    public static final String HERCITAB = "HERCITAB";
    public final int DEFAULT_DIVIDER_LOCATION = 226;
    PayloadHERCIhighSpeed hsPayload;
    HerciHighspeedHeader hsHeader;
    JLabel lblFramesDecoded;
    JLabel lblHSpayload;
    int displayRows = 28;
    JLabel[] lblBytes = new JLabel[this.displayRows];
    HerciHSTableModel radTableModel;
    HerciHsPacketTableModel radPacketTableModel;
    private static final String DECODED = "HS Payloads Decoded: ";

    public HerciHSTab(Spacecraft sat) {
        this.fox = sat;
        this.foxId = this.fox.foxId;
        this.splitPaneHeight = Config.loadGraphIntValue(this.fox.getIdString(), 99, 1, HERCITAB, "splitPaneHeight");
        JLabel lblId = new JLabel("University of Iowa High Energy Radiation CubeSat Instrument (HERCI)");
        lblId.setFont(new Font("SansSerif", 1, 14));
        lblId.setForeground(this.textLblColor);
        this.topPanel.add(lblId);
        lblId.setMaximumSize(new Dimension(1600, 20));
        lblId.setMinimumSize(new Dimension(1600, 20));
        this.lblFramesDecoded = new JLabel(DECODED);
        this.lblFramesDecoded.setFont(new Font("SansSerif", 1, 14));
        this.lblFramesDecoded.setBorder(new EmptyBorder(5, 2, 5, 5));
        this.topPanel.add(this.lblFramesDecoded);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 0));
        JPanel healthPanel = new JPanel();
        healthPanel.setLayout(new BoxLayout(healthPanel, 1));
        this.lblHSpayload = new JLabel();
        this.lblHSpayload.setBorder(new EmptyBorder(5, 2, 5, 5));
        healthPanel.add(this.lblHSpayload);
        int r = 0;
        while (r < this.displayRows) {
            this.lblBytes[r] = new JLabel();
            ++r;
        }
        this.initDisplayHalves(healthPanel);
        BitArrayLayout rad = this.fox.getLayoutByName("herciHSheader");
        BitArrayLayout none = null;
        try {
            this.analyzeModules(rad, none, none, 20);
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("FATAL - Load Aborted", e.getMessage());
            e.printStackTrace(Log.getWriter());
            System.exit(1);
        }
        this.splitPane = new JSplitPane(0, healthPanel, this.centerPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        if (this.splitPaneHeight != 0) {
            this.splitPane.setDividerLocation(this.splitPaneHeight);
        } else {
            this.splitPane.setDividerLocation(226);
        }
        SplitPaneUI spui = this.splitPane.getUI();
        if (spui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)spui).getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    HerciHSTab.this.splitPaneHeight = HerciHSTab.this.splitPane.getDividerLocation();
                    Log.println("SplitPane: " + HerciHSTab.this.splitPaneHeight);
                    Config.saveGraphIntParam(HerciHSTab.this.fox.getIdString(), 99, 1, HerciHSTab.HERCITAB, "splitPaneHeight", HerciHSTab.this.splitPaneHeight);
                }
            });
        }
        Dimension minimumSize = new Dimension(100, 50);
        healthPanel.setMinimumSize(minimumSize);
        this.centerPanel.setMinimumSize(minimumSize);
        this.add((Component)this.splitPane, "Center");
        this.showRawBytes = new JCheckBox("Show Raw Bytes", Config.displayRawRadData);
        this.bottomPanel.add(this.showRawBytes);
        this.showRawBytes.addItemListener(this);
        this.addBottomFilter();
        this.radTableModel = new HerciHSTableModel();
        this.radPacketTableModel = new HerciHsPacketTableModel();
        this.addTables(this.radTableModel, this.radPacketTableModel);
    }

    @Override
    protected void addTables(AbstractTableModel radTableModel, AbstractTableModel radPacketTableModel) {
        super.addTables(radTableModel, radPacketTableModel);
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(0);
        column.setPreferredWidth(45);
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(55);
        column = this.table.getColumnModel().getColumn(2);
        column.setPreferredWidth(55);
        int i = 0;
        while (i < 868) {
            column = this.table.getColumnModel().getColumn(i + 3);
            if (i < 100) {
                column.setPreferredWidth(25);
            } else {
                column.setPreferredWidth(30);
            }
            ++i;
        }
        column = this.table2.getColumnModel().getColumn(0);
        column.setPreferredWidth(45);
        column = this.table2.getColumnModel().getColumn(1);
        column.setPreferredWidth(55);
        column = this.table2.getColumnModel().getColumn(2);
        column.setPreferredWidth(55);
        column = this.table2.getColumnModel().getColumn(3);
        column.setPreferredWidth(90);
        column = this.table2.getColumnModel().getColumn(4);
        column.setPreferredWidth(35);
        column = this.table2.getColumnModel().getColumn(5);
        column.setPreferredWidth(35);
        column = this.table2.getColumnModel().getColumn(6);
        column.setPreferredWidth(55);
        column = this.table2.getColumnModel().getColumn(7);
        column.setPreferredWidth(35);
        column = this.table2.getColumnModel().getColumn(8);
        column.setPreferredWidth(45);
        column = this.table2.getColumnModel().getColumn(9);
        column.setPreferredWidth(45);
        column = this.table2.getColumnModel().getColumn(10);
        column.setPreferredWidth(45);
        column = this.table2.getColumnModel().getColumn(11);
        column.setPreferredWidth(600);
        if (this.showRawBytes.isSelected()) {
            this.scrollPane2.setVisible(false);
            this.scrollPane.setVisible(true);
        } else {
            this.scrollPane2.setVisible(true);
            this.scrollPane.setVisible(false);
        }
    }

    private void parseMiniPackets() {
        String[][] rawData = Config.payloadStore.getHerciPacketData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, true, this.reverse);
        String[][] data = new String[rawData.length][9];
        long[][] keydata = new long[rawData.length][3];
        int k = rawData.length - 1;
        while (k >= 0) {
            keydata[rawData.length - k - 1][0] = Long.parseLong(rawData[k][0]);
            keydata[rawData.length - k - 1][1] = Long.parseLong(rawData[k][1]);
            keydata[rawData.length - k - 1][2] = Long.parseLong(rawData[k][2]);
            data[rawData.length - k - 1][0] = String.valueOf(rawData[k][3]) + ":" + rawData[k][5];
            data[rawData.length - k - 1][1] = rawData[k][6];
            data[rawData.length - k - 1][2] = rawData[k][7];
            data[rawData.length - k - 1][3] = Integer.parseInt(rawData[k][8]) / 40 + ":" + Integer.parseInt(rawData[k][8]) % 40;
            int j = 9;
            while (j < 13) {
                data[rawData.length - k - 1][j - 5] = FoxDecoder.hex(Integer.parseInt(rawData[k][j]) & 0xFF);
                ++j;
            }
            data[rawData.length - k - 1][8] = "";
            j = 14;
            while (j < rawData[k].length) {
                if (rawData[k][j] != null) {
                    data[rawData.length - k - 1][8] = String.valueOf(data[rawData.length - k - 1][8]) + FoxDecoder.plainhex(Integer.parseInt(rawData[k][j]) & 0xFF) + " ";
                }
                ++j;
            }
            --k;
        }
        if (data.length > 0) {
            this.radPacketTableModel.setData(keydata, data);
        }
    }

    private void parseRawBytes() {
        if (this.hsPayload == null) {
            return;
        }
        String[][] rawData = Config.payloadStore.getHerciHsData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, this.reverse);
        String[][] data = new String[rawData.length][868];
        long[][] keydata = new long[rawData.length][3];
        int j = 0;
        int i = rawData.length - 1;
        while (i >= 0) {
            int reset = Integer.parseInt(rawData[i][0]);
            long uptime = Long.parseLong(rawData[i][1]);
            int type = Integer.parseInt(rawData[i][2]);
            keydata[j][0] = reset;
            keydata[j][1] = uptime;
            keydata[j][2] = type;
            int k = 0;
            while (k < 868) {
                data[j][k] = FoxDecoder.plainhex(Integer.parseInt(rawData[i][k + 3]) & 0xFF);
                ++k;
            }
            ++j;
            --i;
        }
        if (rawData.length > 0) {
            this.radTableModel.setData(keydata, data);
        }
    }

    @Override
    protected void parseExperimentFrames() {
        if (Config.displayRawRadData) {
            this.parseRawBytes();
            this.scrollPane2.setVisible(false);
            this.scrollPane.setVisible(true);
        } else {
            this.parseMiniPackets();
            this.scrollPane2.setVisible(true);
            this.scrollPane.setVisible(false);
        }
        MainWindow.frame.repaint();
    }

    public void updateTab(FramePart rad, boolean refreshTable) {
        if (!Config.payloadStore.initialized()) {
            return;
        }
        if (rad == null) {
            return;
        }
        this.hsHeader = (HerciHighspeedHeader)rad;
        this.lblHSpayload.setText("HERCI EXPERIMENT PAYLOAD: 868 bytes. Epoch:" + rad.getResets() + " Uptime:" + rad.getUptime());
        if (rad != null) {
            DisplayModule mod;
            DisplayModule[] displayModuleArray = this.topModules;
            int n = this.topModules.length;
            int n2 = 0;
            while (n2 < n) {
                mod = displayModuleArray[n2];
                if (mod != null) {
                    mod.updateRtValues(rad);
                }
                ++n2;
            }
            if (this.bottomModules != null) {
                displayModuleArray = this.bottomModules;
                n = this.bottomModules.length;
                n2 = 0;
                while (n2 < n) {
                    mod = displayModuleArray[n2];
                    if (mod != null) {
                        mod.updateRtValues(rad);
                    }
                    ++n2;
                }
            }
        }
    }

    private void displayFramesDecoded(int u) {
        this.lblFramesDecoded.setText(DECODED + u);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("HerciHSTab");
        this.running = true;
        this.done = false;
        int currentFrames = 0;
        boolean justStarted = true;
        while (this.running) {
            int frames;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: HERCI thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            if (this.foxId == 0 || !Config.payloadStore.initialized()) continue;
            if (Config.displayRawRadData != this.showRawBytes.isSelected()) {
                this.showRawBytes.setSelected(Config.displayRawRadData);
                if (this.hsPayload != null) {
                    this.parseExperimentFrames();
                    this.updateTab(Config.payloadStore.getLatestHerciHeader(this.foxId), true);
                }
            }
            if (Config.displayRawValues != this.showRawValues.isSelected()) {
                this.showRawValues.setSelected(Config.displayRawValues);
                this.updateTab(Config.payloadStore.getLatestHerciHeader(this.foxId), true);
            }
            if ((frames = Config.payloadStore.getNumberOfFrames(this.foxId, "herciHSdata")) == currentFrames) continue;
            currentFrames = frames;
            this.hsPayload = Config.payloadStore.getLatestHerci(this.foxId);
            Config.payloadStore.setUpdated(this.foxId, "herciHSdata", false);
            if (this.hsPayload != null) {
                this.parseExperimentFrames();
                this.updateTab(Config.payloadStore.getLatestHerciHeader(this.foxId), true);
            }
            this.displayFramesDecoded(frames);
            MainWindow.setTotalDecodes();
            if (!justStarted) continue;
            this.openGraphs();
            justStarted = false;
        }
        this.done = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showRawValues) {
            Config.displayRawValues = e.getStateChange() != 2;
            Config.save();
            if (this.hsHeader != null) {
                this.updateTab(this.hsHeader, false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
    }

    @Override
    public void parseFrames() {
        this.parseExperimentFrames();
    }

    @Override
    protected void displayRow(JTable table, int fromRow, int row) {
        long type_l = 0L;
        long reset_l = (Long)table.getValueAt(row, 0);
        long uptime = (Long)table.getValueAt(row, 1);
        type_l = (Long)table.getValueAt(row, 2);
        Log.println("EPOCH: " + reset_l);
        Log.println("UPTIME: " + uptime);
        Log.println("TYPE: " + type_l);
        int reset = (int)reset_l;
        int type = (int)type_l;
        int headerType = 0;
        headerType = table.getModel() instanceof HerciHSTableModel ? type + 200 : (type /= 1000) + 200;
        Log.println("Header Type: " + headerType);
        this.hsPayload = (PayloadHERCIhighSpeed)Config.payloadStore.getFramePart(this.foxId, reset, uptime, type, "herciHSdata", false);
        this.updateTab((HerciHighspeedHeader)Config.payloadStore.getFramePart(this.foxId, reset, uptime, headerType, "herciHSheader", false), false);
        if (fromRow == -1) {
            fromRow = row;
        }
        if (fromRow <= row) {
            table.setRowSelectionInterval(fromRow, row);
        } else {
            table.setRowSelectionInterval(row, fromRow);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

