/*
 * Decompiled with CFR 0.152.
 */
package gui.legacyTabs;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import gui.RadiationPacketTableModel;
import gui.tabs.DisplayModule;
import gui.tabs.ExperimentLayoutTableModel;
import gui.tabs.ExperimentTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import telemetry.BitArrayLayout;
import telemetry.CobsDecodeException;
import telemetry.FramePart;
import telemetry.LayoutLoadException;
import telemetry.legacyPayloads.RadiationPacket;
import telemetry.legacyPayloads.RadiationTelemetry;

public class VulcanTab
extends ExperimentTab
implements ItemListener,
Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    public static final String VULCANTAB = "VULCANTAB";
    private static final String DECODED = "Radiation Payloads Decoded: ";
    public final int DEFAULT_DIVIDER_LOCATION = 350;
    JLabel lblName;
    private String NAME;
    JLabel lblFramesDecoded;
    JPanel healthPanel;
    JPanel topHalfPackets;
    JPanel bottomHalfPackets;
    DisplayModule vucModule;
    DisplayModule lepModule;
    DisplayModule lastExposure;
    DisplayModule lastState;
    DisplayModule vulcanExp1;
    DisplayModule vulcanExp2;
    DisplayModule vulcanExp3;
    DisplayModule vulcanExp4;
    JRadioButton decodePacket;
    JRadioButton decodeTelem;
    boolean displayTelem = true;
    ExperimentLayoutTableModel radTableModel;
    RadiationPacketTableModel radPacketTableModel;
    int total;

    public VulcanTab(Spacecraft sat, int displayType) {
        this.fox = sat;
        this.foxId = this.fox.foxId;
        this.NAME = String.valueOf(this.fox.toString()) + " Vanderbilt University Radiation Experiments";
        this.splitPaneHeight = Config.loadGraphIntValue(this.fox.getIdString(), 99, 7, VULCANTAB, "splitPaneHeight");
        int fonth = Config.displayModuleFontSize * 14 / 11;
        this.lblName = new JLabel(this.NAME);
        this.lblName.setMaximumSize(new Dimension(1600, fonth));
        this.lblName.setMinimumSize(new Dimension(1600, fonth));
        this.lblName.setFont(new Font("SansSerif", 1, fonth));
        this.topPanel.add(this.lblName);
        this.lblFramesDecoded = new JLabel(DECODED);
        this.lblFramesDecoded.setFont(new Font("SansSerif", 1, fonth));
        this.lblFramesDecoded.setBorder(new EmptyBorder(5, 2, 5, 5));
        this.topPanel.add(this.lblFramesDecoded);
        this.healthPanel = new JPanel();
        this.healthPanel.setLayout(new BoxLayout(this.healthPanel, 1));
        this.healthPanel.setBorder(new SoftBevelBorder(1, null, null, null, null));
        this.healthPanel.setBackground(Color.DARK_GRAY);
        this.topHalfPackets = new JPanel();
        this.topHalfPackets.setBackground(Color.DARK_GRAY);
        this.bottomHalfPackets = new JPanel();
        this.bottomHalfPackets.setBackground(Color.DARK_GRAY);
        this.healthPanel.add(this.topHalfPackets);
        this.healthPanel.add(this.bottomHalfPackets);
        this.initDisplayHalves(this.healthPanel);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 0));
        BitArrayLayout rad = null;
        String layoutName = "radtelemetry2";
        if (displayType == 8) {
            layoutName = "wodradtelemetry2";
        }
        rad = this.fox.getLayoutByName(layoutName);
        BitArrayLayout rawLayout = null;
        String rawlayoutName = "radtelemetry";
        if (displayType == 8) {
            rawlayoutName = "wodradtelemetry2";
        }
        rawLayout = this.fox.getLayoutByName(rawlayoutName);
        BitArrayLayout none = null;
        if (rad == null) {
            Log.errorDialog("MISSING LAYOUTS", "The spacecraft file for satellite " + this.fox.user_display_name + " is missing the layout definition for " + layoutName + "\n  Remove this satellite or fix the layout file");
            System.exit(1);
        } else {
            try {
                this.analyzeModules(rad, none, none, displayType);
            }
            catch (LayoutLoadException e) {
                Log.errorDialog("FATAL - Load Aborted", e.getMessage());
                e.printStackTrace(Log.getWriter());
                System.exit(1);
            }
        }
        this.splitPane = new JSplitPane(0, this.healthPanel, this.centerPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        if (this.splitPaneHeight != 0) {
            this.splitPane.setDividerLocation(this.splitPaneHeight);
        } else {
            this.splitPane.setDividerLocation(350);
        }
        SplitPaneUI spui = this.splitPane.getUI();
        if (spui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)spui).getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    VulcanTab.this.splitPaneHeight = VulcanTab.this.splitPane.getDividerLocation();
                    Log.println("SplitPane: " + VulcanTab.this.splitPaneHeight);
                    Config.saveGraphIntParam(VulcanTab.this.fox.getIdString(), 99, 7, VulcanTab.VULCANTAB, "splitPaneHeight", VulcanTab.this.splitPaneHeight);
                }
            });
        }
        Dimension minimumSize = new Dimension(100, 50);
        this.healthPanel.setMinimumSize(minimumSize);
        this.centerPanel.setMinimumSize(minimumSize);
        this.add((Component)this.splitPane, "Center");
        this.showRawBytes = new JCheckBox("Show Raw Bytes", Config.displayRawRadData);
        this.bottomPanel.add(this.showRawBytes);
        this.showRawBytes.addItemListener(this);
        this.decodePacket = this.addRadioButton("Packets (Buffered Mode)", this.bottomPanel);
        this.decodeTelem = this.addRadioButton("Telemetry", this.bottomPanel);
        ButtonGroup group = new ButtonGroup();
        group.add(this.decodePacket);
        group.add(this.decodeTelem);
        if (this.displayTelem) {
            this.decodeTelem.setSelected(true);
        } else {
            this.decodePacket.setSelected(true);
        }
        this.decodeTelem.setVisible(false);
        this.decodePacket.setVisible(false);
        this.addBottomFilter();
        this.radTableModel = new ExperimentLayoutTableModel(rawLayout);
        this.radPacketTableModel = new RadiationPacketTableModel();
        this.addTables(this.radTableModel, this.radPacketTableModel);
        this.addPacketModules();
        this.topHalfPackets.setVisible(false);
        this.bottomHalfPackets.setVisible(false);
        this.parseExperimentFrames();
    }

    private JRadioButton addRadioButton(String name, JPanel panel) {
        JRadioButton radioButton = new JRadioButton(name);
        radioButton.setEnabled(true);
        radioButton.addActionListener(this);
        panel.add(radioButton);
        return radioButton;
    }

    @Override
    protected void addTables(AbstractTableModel radTableModel, AbstractTableModel radPacketTableModel) {
        super.addTables(radTableModel, radPacketTableModel);
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(0);
        column.setPreferredWidth(45);
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(55);
        int i = 0;
        while (i < this.table.getColumnCount() - 2) {
            column = this.table.getColumnModel().getColumn(i + 2);
            column.setPreferredWidth(25);
            ++i;
        }
        column = this.table2.getColumnModel().getColumn(0);
        column.setPreferredWidth(45);
        column = this.table2.getColumnModel().getColumn(1);
        column.setPreferredWidth(55);
        column = this.table2.getColumnModel().getColumn(2);
        column.setPreferredWidth(80);
        column = this.table2.getColumnModel().getColumn(3);
        column.setPreferredWidth(70);
        column = this.table2.getColumnModel().getColumn(4);
        column.setPreferredWidth(600);
    }

    protected void displayFramesDecoded(int u) {
        this.total = u;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VulcanTab.this.lblFramesDecoded.setText(VulcanTab.DECODED + VulcanTab.this.total);
                VulcanTab.this.lblFramesDecoded.invalidate();
                VulcanTab.this.topPanel.getParent().validate();
            }
        });
    }

    private void addPacketModules() {
        this.vucModule = new DisplayModule(this.fox, "Vanderbilt University Controller (VUC)", 6, null, 5, DisplayModule.vulcanFontColor);
        this.topHalfPackets.add(this.vucModule);
        this.vucModule.addName(1, "Uptime (s)", "VUC UPTIME", 5);
        this.vucModule.addName(2, "Livetime (s)", "VUC LIVETIME", 5);
        this.vucModule.addName(3, "Hard Resets", "HARD RESETS", 5);
        this.vucModule.addName(4, "Soft Resets", "SOFT RESETS", 5);
        this.vucModule.addName(5, "Run State", "VUC RUN STATE", 5);
        this.lepModule = new DisplayModule(this.fox, "Low Energy Proton (LEP) Experiment", 5, null, 6, DisplayModule.vulcanFontColor);
        this.topHalfPackets.add(this.lepModule);
        this.lepModule.addName(1, "Restarts", "LEP RESTARTS", 6);
        this.lepModule.addName(2, "Uptime (s)", "LEP UPTIME", 6);
        this.lepModule.addName(3, "Livetime (s)", "LEP LIVETIME", 6);
        this.lepModule.addName(4, "Total Memory Upsets", "LEP TOTAL MEMORY UPSETS", 6);
        this.lastExposure = new DisplayModule(this.fox, "Last LEP Exposure", 6, null, 7, DisplayModule.vulcanFontColor);
        this.topHalfPackets.add(this.lastExposure);
        this.lastExposure.addName(1, "Start (s)", "LOCAL CLOCK START", 7);
        this.lastExposure.addName(2, "End (s)", "LOCAL CLOCK END", 7);
        this.lastExposure.addName(3, "Memories S0-S7", "MEMORIES", 7);
        this.lastExposure.addName(4, "Current (mA)", "CURRENT", 7);
        this.lastExposure.addName(5, "Upsets", "UPSETS", 7);
        this.lastState = new DisplayModule(this.fox, "Last State", 4, null, 7, DisplayModule.vulcanFontColor);
        this.topHalfPackets.add(this.lastState);
        this.lastState.addName(1, "Clock (s)", "LOCAL CLOCK", 7);
        this.lastState.addName(2, "Experiment", "EXPERIMENT", 7);
        this.lastState.addName(3, "State", "STATE", 7);
        this.vulcanExp1 = this.addVulcanExpModule("Vulcan Experiment 1", "1");
        this.vulcanExp2 = this.addVulcanExpModule("Vulcan Experiment 2", "2");
        this.vulcanExp3 = this.addVulcanExpModule("Vulcan Experiment 3", "3");
        this.vulcanExp4 = this.addVulcanExpModule("Vulcan Experiment 4", "4");
    }

    private DisplayModule addVulcanExpModule(String title, String number) {
        DisplayModule mod = new DisplayModule(this.fox, title, 4, null, 5, DisplayModule.vulcanFontColor);
        this.bottomHalfPackets.add(mod);
        mod.addName(1, "Drift", "EXP" + number + " DRIFT", 5);
        mod.addName(2, "Power (mW) ", "EXP" + number + " POWER", 5);
        mod.addName(3, "State", "EXP" + number + " STATE", 5);
        return mod;
    }

    @Override
    protected void parseExperimentFrames() {
        if (!Config.payloadStore.initialized()) {
            return;
        }
        if (Config.displayRawRadData) {
            String[][] data = Config.payloadStore.getRadData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, this.reverse);
            if (data != null && data.length > 0) {
                this.parseRawBytes(data, this.radTableModel);
            }
        } else if (this.displayTelem) {
            String[][] data = Config.payloadStore.getRadTelemData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, this.reverse);
            if (data != null && data.length > 0) {
                this.parseTelemetry(data);
            }
            this.topHalfPackets.setVisible(false);
            this.bottomHalfPackets.setVisible(false);
            this.topHalf.setVisible(true);
        } else {
            String[][] data = Config.payloadStore.getRadData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, this.reverse);
            if (data != null && data.length > 0) {
                this.parsePackets(data);
            }
            this.topHalfPackets.setVisible(true);
            this.bottomHalfPackets.setVisible(true);
            this.topHalf.setVisible(false);
        }
        if (this.showRawBytes.isSelected()) {
            this.scrollPane2.setVisible(false);
            this.scrollPane.setVisible(true);
        } else {
            this.scrollPane2.setVisible(true);
            this.scrollPane.setVisible(false);
        }
        MainWindow.frame.repaint();
    }

    protected void parseTelemetry(String[][] data) {
        ArrayList<RadiationTelemetry> packets = new ArrayList<RadiationTelemetry>(20);
        int i = 0;
        while (i < data.length) {
            RadiationTelemetry radTelem = null;
            radTelem = new RadiationTelemetry(Integer.valueOf(data[i][0]), Long.valueOf(data[i][1]), this.fox.getLayoutByName("radtelemetry2"));
            radTelem.rawBits = null;
            int k = 2;
            while (k < this.fox.getLayoutByName((String)"radtelemetry2").NUMBER_OF_FIELDS) {
                try {
                    int val;
                    radTelem.fieldValue[k - 2] = val = Integer.valueOf(data[i][k]).intValue();
                }
                catch (NumberFormatException val) {
                    // empty catch block
                }
                ++k;
            }
            if (radTelem != null) {
                packets.add(radTelem);
            }
            ++i;
        }
        long[][] keyPacketData = new long[packets.size()][2];
        String[][] packetData = new String[packets.size()][3];
        int i2 = 0;
        while (i2 < packets.size()) {
            String telem;
            keyPacketData[packets.size() - i2 - 1][0] = ((RadiationTelemetry)packets.get((int)i2)).resets;
            keyPacketData[packets.size() - i2 - 1][1] = ((RadiationTelemetry)packets.get((int)i2)).uptime;
            packetData[packets.size() - i2 - 1][0] = "TELEMETRY";
            packetData[packets.size() - i2 - 1][1] = "" + ((RadiationTelemetry)packets.get((int)i2)).fieldValue[3];
            packetData[packets.size() - i2 - 1][2] = telem = ((RadiationTelemetry)packets.get(i2)).toDataString(this.fox);
            ++i2;
        }
        if (data.length > 0) {
            this.radPacketTableModel.setData(keyPacketData, packetData);
        }
    }

    protected void parsePackets(String[][] data) {
        int i = 2;
        int p = 0;
        int bytesAdded = 0;
        boolean hasMoreBytes = true;
        boolean endOfRowReached = false;
        boolean foundPacket = false;
        ArrayList<RadiationPacket> packets = new ArrayList<RadiationPacket>(20);
        RadiationPacket previousPacket = null;
        RadiationPacket packet = null;
        while (hasMoreBytes) {
            try {
                if (Integer.valueOf(data[p][i]) == 126) {
                    if (foundPacket) {
                        if (previousPacket != null) {
                            try {
                                packet.parseRawBytes();
                                previousPacket.parseRawBytes();
                            }
                            catch (CobsDecodeException cobsDecodeException) {
                                // empty catch block
                            }
                            int previousSeq = previousPacket.getSequence();
                            int sequence = packet.getSequence();
                            if (sequence == previousSeq + 1) {
                                packets.add(previousPacket);
                            }
                            previousPacket = null;
                        }
                        if (endOfRowReached) {
                            endOfRowReached = false;
                            previousPacket = packet;
                        } else {
                            packets.add(packet);
                        }
                        packet = new RadiationPacket(Integer.valueOf(data[p][0]), Long.valueOf(data[p][1]));
                        bytesAdded = 0;
                    } else {
                        foundPacket = true;
                        packet = new RadiationPacket(Integer.valueOf(data[p][0]), Long.valueOf(data[p][1]));
                        bytesAdded = 0;
                    }
                    ++i;
                }
                if (foundPacket && bytesAdded < packet.MAX_PACKET_BYTES) {
                    packet.addRawByte(Integer.valueOf(data[p][i]));
                    ++bytesAdded;
                }
            }
            catch (NumberFormatException previousSeq) {
                // empty catch block
            }
            if (++i != data[p].length) continue;
            endOfRowReached = true;
            i = 2;
            if (++p != data.length) continue;
            hasMoreBytes = false;
        }
        int lastTelem = -1;
        int lastExpStart = -1;
        int lastExpEnd = -1;
        int lastStateChange = -1;
        long[][] keyPacketData = new long[packets.size()][2];
        String[][] packetData = new String[packets.size()][3];
        i = 0;
        while (i < packets.size()) {
            String bytes;
            try {
                ((RadiationPacket)packets.get(i)).parseRawBytes();
            }
            catch (CobsDecodeException cobsDecodeException) {
                // empty catch block
            }
            keyPacketData[packets.size() - i - 1][0] = ((RadiationPacket)packets.get((int)i)).reset;
            keyPacketData[packets.size() - i - 1][1] = ((RadiationPacket)packets.get((int)i)).uptime;
            String type = "";
            packetData[packets.size() - i - 1][0] = type = ((RadiationPacket)packets.get(i)).getTypeString();
            packetData[packets.size() - i - 1][1] = "" + ((RadiationPacket)packets.get((int)i)).fieldValue[1];
            packetData[packets.size() - i - 1][2] = bytes = ((RadiationPacket)packets.get(i)).getDataString();
            if (((RadiationPacket)packets.get(i)).getType() == 3) {
                lastTelem = i;
            }
            if (((RadiationPacket)packets.get(i)).getType() == 3) {
                lastExpStart = i;
            }
            if (((RadiationPacket)packets.get(i)).getType() == 5) {
                lastExpEnd = i;
            }
            if (((RadiationPacket)packets.get(i)).getType() == 4) {
                lastStateChange = i;
            }
            ++i;
        }
        if (packetData.length > 0) {
            this.radPacketTableModel.setData(keyPacketData, packetData);
            if (lastTelem != -1) {
                this.vucModule.updateVulcanValues((RadiationPacket)packets.get(lastTelem));
                this.lepModule.updateVulcanValues((RadiationPacket)packets.get(lastTelem));
                this.lepModule.updateVulcanValues((RadiationPacket)packets.get(lastTelem));
                this.vulcanExp1.updateVulcanValues((RadiationPacket)packets.get(lastTelem));
                this.vulcanExp2.updateVulcanValues((RadiationPacket)packets.get(lastTelem));
                this.vulcanExp3.updateVulcanValues((RadiationPacket)packets.get(lastTelem));
                this.vulcanExp4.updateVulcanValues((RadiationPacket)packets.get(lastTelem));
            }
            if (lastStateChange != -1) {
                this.lastState.updateVulcanValues((RadiationPacket)packets.get(lastStateChange));
            }
            if (lastExpStart != -1) {
                this.lastExposure.updateVulcanValues((RadiationPacket)packets.get(lastExpStart));
            }
            if (lastExpEnd != -1) {
                this.lastExposure.updateVulcanValues((RadiationPacket)packets.get(lastExpEnd));
            }
            MainWindow.frame.repaint();
        } else {
            long[][] emptyKey = new long[][]{new long[2]};
            String[][] empty = new String[][]{{"", "", "", "", ""}};
            this.radPacketTableModel.setData(emptyKey, empty);
        }
    }

    public void updateTab(FramePart rad, boolean refreshTable) {
        if (!Config.payloadStore.initialized()) {
            return;
        }
        if (rad != null) {
            DisplayModule mod;
            DisplayModule[] displayModuleArray = this.topModules;
            int n = this.topModules.length;
            int n2 = 0;
            while (n2 < n) {
                mod = displayModuleArray[n2];
                if (mod != null) {
                    mod.updateRtValues(rad);
                }
                ++n2;
            }
            if (this.bottomModules != null) {
                displayModuleArray = this.bottomModules;
                n = this.bottomModules.length;
                n2 = 0;
                while (n2 < n) {
                    mod = displayModuleArray[n2];
                    if (mod != null) {
                        mod.updateRtValues(rad);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("VulcanTab");
        this.running = true;
        this.done = false;
        int currentFrames = 0;
        boolean justStarted = true;
        while (this.running) {
            int frames;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: HealthTab thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            if (!Config.payloadStore.initialized()) continue;
            if (Config.displayRawRadData != this.showRawBytes.isSelected()) {
                this.showRawBytes.setSelected(Config.displayRawRadData);
                this.parseExperimentFrames();
            }
            if (Config.displayRawValues != this.showRawValues.isSelected()) {
                this.showRawValues.setSelected(Config.displayRawValues);
                this.updateTab(Config.payloadStore.getLatestRadTelem(this.foxId), true);
            }
            if (this.foxId == 0 || (frames = Config.payloadStore.getNumberOfFrames(this.foxId, "radtelemetry")) == currentFrames) continue;
            currentFrames = frames;
            this.updateTab(Config.payloadStore.getLatestRadTelem(this.foxId), true);
            this.parseFrames();
            this.displayFramesDecoded(frames);
            Config.payloadStore.setUpdated(this.foxId, "radtelemetry", false);
            MainWindow.setTotalDecodes();
            if (justStarted) {
                this.openGraphs();
                justStarted = false;
            }
            MainWindow.frame.repaint();
        }
        this.done = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showRawValues) {
            Config.displayRawValues = e.getStateChange() != 2;
            Config.save();
            this.updateTab(Config.payloadStore.getLatestRadTelem(this.foxId), true);
        }
    }

    @Override
    protected void displayRow(JTable table, int fromRow, int row) {
        long reset_l = (Long)table.getValueAt(row, 0);
        long uptime = (Long)table.getValueAt(row, 1);
        int reset = (int)reset_l;
        this.updateTab((RadiationTelemetry)Config.payloadStore.getFramePart(this.foxId, reset, uptime, "radtelemetry2", false), false);
        if (fromRow == -1) {
            fromRow = row;
        }
        if (fromRow <= row) {
            table.setRowSelectionInterval(fromRow, row);
        } else {
            table.setRowSelectionInterval(row, fromRow);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.decodePacket) {
            this.displayTelem = false;
            this.parseExperimentFrames();
        }
        if (e.getSource() == this.decodeTelem) {
            this.displayTelem = true;
            this.parseExperimentFrames();
        }
    }

    @Override
    public void parseFrames() {
        this.parseExperimentFrames();
    }
}

