/*
 * Decompiled with CFR 0.152.
 */
package gui.mesat1;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import gui.WrapLayout;
import gui.legacyTabs.ImagePanel;
import gui.mesat1.MesatImageThumb;
import gui.tabs.FoxTelemTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import telemetry.FramePart;
import telemetry.legacyPayloads.CameraJpeg;
import telemetry.mesat.MesatImage;
import telemetry.mesat.SortedMesatImageList;

public class MesatCameraTab
extends FoxTelemTab
implements Runnable,
MouseListener,
ItemListener,
ActionListener,
FocusListener {
    public static final int MAX_THUMBNAILS_LIMIT = 500;
    public static final int DEFAULT_THUMBNAILS = 30;
    public static final int MIN_SAMPLES = 1;
    public static final String CAMERATAB = "MESAT1CAMERATAB";
    public int maxThumbnails = 30;
    public static final int THUMB_X = 100;
    private static final String DECODED = "Images: ";
    private SortedMesatImageList imageIndex;
    Spacecraft fox;
    int foxId = 0;
    int selectedThumb = 0;
    MesatImage selectedImage;
    JLabel lblName;
    private String NAME;
    JLabel lblImagesDecoded;
    JCheckBox showLatestImage;
    JSplitPane splitPane;
    JPanel topPanel;
    JPanel bottomPanel;
    JPanel thumbnailsPanel;
    JPanel picturePanel;
    JPanel leftHalf;
    JPanel rightHalf;
    JTextField displayNumber2;
    private JLabel lblImageNo;
    private JLabel lblFromUptime;
    private JCheckBox cbComposite;
    private JTextField textImageNo;
    private JTextField textFromUptime;
    private JLabel lblFromReset;
    private JTextField textFromReset;
    public static long DEFAULT_START_UPTIME = 0L;
    public static int DEFAULT_START_RESET = 0;
    public long START_UPTIME = DEFAULT_START_UPTIME;
    public int START_RESET = DEFAULT_START_RESET;
    public int IMAGE_NO = 0;
    ImagePanel picture;
    MesatImageThumb[] thumbnails;
    JLabel picReset;
    JLabel picUptime;
    JLabel picNumber;
    JLabel picChannel;
    JLabel picDate;
    JLabel[] picBlock;
    int splitPaneHeight = 0;
    private static final String PIC_RESET = "Epoch: ";
    private static final String PIC_UPTIME = "Uptime: ";
    private static final String PIC_NUMBER = "Image Number: ";
    private static final String PIC_CHANNEL = "Channel: ";
    private static final String PIC_DATE = "Downloaded: ";
    int actualThumbnails = 0;

    public MesatCameraTab(Spacecraft sat) {
        this.fox = sat;
        this.foxId = this.fox.foxId;
        this.loadProperties();
        this.NAME = String.valueOf(this.fox.toString()) + " University of Maine Multispectral Camera";
        this.splitPaneHeight = Config.loadGraphIntValue(this.fox.getIdString(), 99, 5, CAMERATAB, "splitPaneHeight");
        this.setLayout(new BorderLayout(0, 0));
        this.thumbnails = new MesatImageThumb[this.maxThumbnails];
        this.topPanel = new JPanel();
        this.topPanel.setMinimumSize(new Dimension(34, 250));
        this.add((Component)this.topPanel, "North");
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 0));
        int fonth = Config.displayModuleFontSize * 14 / 11;
        this.lblName = new JLabel(this.NAME);
        this.lblName.setMaximumSize(new Dimension(1600, Config.displayModuleFontSize * 20 / 11));
        this.lblName.setMinimumSize(new Dimension(1600, Config.displayModuleFontSize * 20 / 11));
        this.lblName.setFont(new Font("SansSerif", 1, fonth));
        this.topPanel.add(this.lblName);
        this.lblImagesDecoded = new JLabel(DECODED);
        this.lblImagesDecoded.setToolTipText("The number of images that we have downloaded from Fox");
        this.lblImagesDecoded.setFont(new Font("SansSerif", 1, fonth));
        this.lblImagesDecoded.setBorder(new EmptyBorder(5, 2, 5, 5));
        this.topPanel.add(this.lblImagesDecoded);
        this.picturePanel = new JPanel();
        this.picturePanel.setLayout(new BorderLayout(0, 0));
        this.picturePanel.setBorder(new SoftBevelBorder(1, null, null, null, null));
        this.picturePanel.setBackground(Color.DARK_GRAY);
        this.leftHalf = new JPanel();
        this.leftHalf.setLayout(new BoxLayout(this.leftHalf, 1));
        this.picReset = this.addPicParam(PIC_RESET);
        this.picUptime = this.addPicParam(PIC_UPTIME);
        this.picNumber = this.addPicParam(PIC_NUMBER);
        this.picChannel = this.addPicParam(PIC_CHANNEL);
        this.picDate = this.addPicParam(PIC_DATE);
        this.picBlock = new JLabel[12];
        int i = 0;
        while (i < 11) {
            this.picBlock[i] = this.addPicBlockParam("Block " + i + ":  ");
            ++i;
        }
        this.leftHalf.add(new Box.Filler(new Dimension(10, 10), new Dimension(100, 400), new Dimension(100, 500)));
        this.rightHalf = new JPanel();
        this.rightHalf.setBackground(Color.DARK_GRAY);
        this.rightHalf.setLayout(new BorderLayout(0, 0));
        this.picture = new ImagePanel();
        this.rightHalf.add((Component)this.picture, "Center");
        this.picturePanel.add((Component)this.leftHalf, "West");
        this.picturePanel.add((Component)this.rightHalf, "Center");
        this.thumbnailsPanel = new JPanel();
        this.thumbnailsPanel.setLayout(new WrapLayout(3, 25, 25));
        JScrollPane scrollPane = new JScrollPane(this.thumbnailsPanel, 22, 31);
        this.splitPane = new JSplitPane(0, this.picturePanel, scrollPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        if (this.splitPaneHeight != 0) {
            this.splitPane.setDividerLocation(this.splitPaneHeight);
        } else {
            this.splitPane.setDividerLocation(450);
        }
        SplitPaneUI spui = this.splitPane.getUI();
        if (spui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)spui).getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    MesatCameraTab.this.splitPaneHeight = MesatCameraTab.this.splitPane.getDividerLocation();
                    Log.println("SplitPane: " + MesatCameraTab.this.splitPaneHeight);
                    MesatCameraTab.this.displayPictureParams(MesatCameraTab.this.selectedThumb);
                    Config.saveGraphIntParam(MesatCameraTab.this.fox.getIdString(), 99, 5, MesatCameraTab.CAMERATAB, "splitPaneHeight", MesatCameraTab.this.splitPaneHeight);
                }
            });
        }
        Dimension minimumSize = new Dimension(100, 50);
        this.picturePanel.setMinimumSize(minimumSize);
        this.thumbnailsPanel.setMinimumSize(minimumSize);
        this.add((Component)this.splitPane, "Center");
        this.bottomPanel = new JPanel();
        this.add((Component)this.bottomPanel, "South");
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
        this.showLatestImage = new JCheckBox("Show Latest Image", Config.showLatestImage);
        this.showLatestImage.setMinimumSize(new Dimension(150, fonth));
        this.bottomPanel.add(this.showLatestImage);
        this.showLatestImage.addItemListener(this);
        this.bottomPanel.add(new Box.Filler(new Dimension(10, 10), new Dimension(500, 10), new Dimension(1500, 10)));
        this.addBottomFilter();
    }

    private JLabel addPicParam(String text) {
        JLabel title = new JLabel(text);
        title.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        JLabel lab = new JLabel();
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(3));
        panel.add(title);
        panel.add(lab);
        this.leftHalf.add(panel);
        title.setBorder(new EmptyBorder(3, 5, 3, 0));
        lab.setBorder(new EmptyBorder(3, 0, 3, 25));
        return lab;
    }

    private JLabel addPicBlockParam(String text) {
        JLabel title = new JLabel(text);
        title.setFont(new Font("SansSerif", 0, Config.displayModuleFontSize * 9 / 11));
        JLabel lab = new JLabel();
        lab.setFont(new Font("SansSerif", 0, Config.displayModuleFontSize * 9 / 11));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(3));
        panel.add(title);
        panel.add(lab);
        this.leftHalf.add(panel);
        return lab;
    }

    protected void addBottomFilter() {
        JLabel displayNumber1 = new JLabel("Displaying last");
        this.displayNumber2 = new JTextField();
        this.displayNumber2.setColumns(4);
        JLabel displayNumber3 = new JLabel("images decoded");
        displayNumber1.setFont(new Font("SansSerif", 0, 10));
        displayNumber3.setFont(new Font("SansSerif", 0, 10));
        displayNumber1.setBorder(new EmptyBorder(5, 2, 5, 10));
        displayNumber3.setBorder(new EmptyBorder(5, 2, 5, 10));
        this.displayNumber2.setText(Integer.toString(this.maxThumbnails));
        this.displayNumber2.addActionListener(this);
        this.bottomPanel.add(displayNumber1);
        this.bottomPanel.add(this.displayNumber2);
        this.bottomPanel.add(displayNumber3);
        this.lblImageNo = new JLabel("   Image  ");
        this.lblImageNo.setFont(new Font("SansSerif", 0, 10));
        this.bottomPanel.add(this.lblImageNo);
        this.textImageNo = new JTextField();
        this.bottomPanel.add(this.textImageNo);
        this.textImageNo.setText(Integer.toString(0));
        this.textImageNo.setColumns(8);
        this.textImageNo.addActionListener(this);
        this.textImageNo.addFocusListener(this);
        this.cbComposite = new JCheckBox("Composite");
        this.bottomPanel.add(this.cbComposite);
        this.cbComposite.addItemListener(this);
        this.lblFromReset = new JLabel("   from Epoch  ");
        this.lblFromReset.setFont(new Font("SansSerif", 0, 10));
        this.bottomPanel.add(this.lblFromReset);
        this.textFromReset = new JTextField();
        this.bottomPanel.add(this.textFromReset);
        this.textFromReset.setText(Integer.toString(this.START_RESET));
        this.textFromReset.setColumns(8);
        this.textFromReset.addActionListener(this);
        this.textFromReset.addFocusListener(this);
        this.lblFromUptime = new JLabel("   from Uptime  ");
        this.lblFromUptime.setFont(new Font("SansSerif", 0, 10));
        this.bottomPanel.add(this.lblFromUptime);
        this.textFromUptime = new JTextField();
        this.bottomPanel.add(this.textFromUptime);
        this.textFromUptime.setText(Long.toString(this.START_UPTIME));
        this.textFromUptime.setColumns(8);
        this.textFromUptime.addActionListener(this);
        this.textFromUptime.addFocusListener(this);
    }

    private void loadThumbs() {
        int j = 0;
        while (j < this.actualThumbnails) {
            if (this.thumbnails[j] != null) {
                this.thumbnailsPanel.remove(this.thumbnails[j]);
            }
            ++j;
        }
        this.imageIndex = Config.payloadStore.mesatImageStore.getIndex(this.foxId, this.maxThumbnails, this.START_RESET, this.START_UPTIME, this.IMAGE_NO);
        if (this.imageIndex == null) {
            return;
        }
        this.actualThumbnails = this.imageIndex.size();
        this.thumbnails = new MesatImageThumb[this.actualThumbnails];
        int i = 0;
        while (i < this.actualThumbnails) {
            if ((this.IMAGE_NO == 0 || ((MesatImage)this.imageIndex.get((int)i)).image_index == this.IMAGE_NO) && ((MesatImage)this.imageIndex.get(this.actualThumbnails - i - 1)).fileExists()) {
                if (this.selectedImage != null && ((MesatImage)this.imageIndex.get(this.actualThumbnails - i - 1)).compareTo(this.selectedImage) == 0) {
                    this.selectedThumb = i;
                }
                BufferedImage thumb = null;
                thumb = ((MesatImage)this.imageIndex.get(this.actualThumbnails - i - 1)).getThumbnail(100);
                if (thumb != null) {
                    if (this.thumbnails[i] == null) {
                        this.thumbnails[i] = new MesatImageThumb();
                    }
                    this.thumbnails[i].setThumb(thumb, ((MesatImage)this.imageIndex.get((int)(this.actualThumbnails - i - 1))).epoch, ((MesatImage)this.imageIndex.get((int)(this.actualThumbnails - i - 1))).fromUptime, ((MesatImage)this.imageIndex.get((int)(this.actualThumbnails - i - 1))).image_index, ((MesatImage)this.imageIndex.get((int)(this.actualThumbnails - i - 1))).image_channel);
                    this.thumbnailsPanel.add(this.thumbnails[i]);
                    this.thumbnails[i].addMouseListener(this);
                    this.thumbnails[i].setBorder(new MatteBorder(3, 3, 3, 3, Color.GRAY));
                }
            }
            ++i;
        }
        if (this.actualThumbnails > 0) {
            if (Config.showLatestImage) {
                if (this.thumbnails != null && this.selectedThumb < this.thumbnails.length && this.selectedThumb >= 0) {
                    if (this.thumbnails[this.selectedThumb] != null) {
                        this.thumbnails[this.selectedThumb].setBorder(new MatteBorder(3, 3, 3, 3, Color.GRAY));
                    }
                    this.selectedThumb = 0;
                    if (this.thumbnails[this.selectedThumb] != null) {
                        this.selectThumb(this.selectedThumb);
                    }
                }
            } else if (this.selectedThumb < this.thumbnails.length && this.thumbnails[this.selectedThumb] != null) {
                this.selectThumb(this.selectedThumb);
            }
        }
    }

    private void selectThumb(int t) {
        this.thumbnails[t].setBorder(new MatteBorder(3, 3, 3, 3, Color.BLUE));
        int selected = this.imageIndex.size() - t - 1;
        this.selectedImage = (MesatImage)this.imageIndex.get(selected);
    }

    private void displayPictureParams(int clicked) {
        block16: {
            if (this.imageIndex == null) {
                return;
            }
            MesatImage red = null;
            MesatImage green = null;
            MesatImage blue = null;
            boolean showCompositeImage = this.cbComposite.isSelected();
            int selected = this.imageIndex.size() - clicked - 1;
            BufferedImage pic = null;
            if (selected >= 0 && this.imageIndex != null) {
                if (showCompositeImage && this.IMAGE_NO != 0) {
                    int i = 0;
                    while (i < this.imageIndex.size()) {
                        if (((MesatImage)this.imageIndex.get((int)i)).image_channel == 0) {
                            red = (MesatImage)this.imageIndex.get(i);
                        }
                        if (((MesatImage)this.imageIndex.get((int)i)).image_channel == 1) {
                            green = (MesatImage)this.imageIndex.get(i);
                        }
                        if (((MesatImage)this.imageIndex.get((int)i)).image_channel == 2) {
                            blue = (MesatImage)this.imageIndex.get(i);
                        }
                        ++i;
                    }
                }
                if (showCompositeImage && this.IMAGE_NO != 0) {
                    pic = MesatImage.getCompositeImage(red, green, blue);
                } else if (selected != -1 && this.imageIndex.size() > selected && this.imageIndex.get(selected) != null) {
                    pic = ((MesatImage)this.imageIndex.get(selected)).getImage();
                }
            }
            if (pic == null) break block16;
            double ratio = (double)this.splitPaneHeight / (double)pic.getHeight();
            BufferedImage dimg = CameraJpeg.scale(pic, ratio);
            this.picture.setBufferedImage(dimg);
            if (showCompositeImage && this.IMAGE_NO != 0) {
                this.picReset.setText("various");
                this.picUptime.setText("various");
                this.picNumber.setText("" + ((MesatImage)this.imageIndex.get((int)selected)).image_index);
                this.picChannel.setText("0, 1, 2");
                this.picDate.setText("various");
                int i = 0;
                while (i < 11) {
                    this.picBlock[i].setText("" + (red.getBlockByteNumbers()[i] + red.getBlockByteNumbers()[i] + red.getBlockByteNumbers()[i]));
                    ++i;
                }
            } else {
                this.picReset.setText("" + ((MesatImage)this.imageIndex.get((int)selected)).epoch);
                this.picUptime.setText("" + ((MesatImage)this.imageIndex.get((int)selected)).fromUptime);
                this.picNumber.setText("" + ((MesatImage)this.imageIndex.get((int)selected)).image_index);
                MesatImage cfr_ignored_0 = (MesatImage)this.imageIndex.get(selected);
                this.picChannel.setText(MesatImage.image_channels_desc[((MesatImage)this.imageIndex.get((int)selected)).image_channel]);
                this.picDate.setText(this.displayCaptureDate(((MesatImage)this.imageIndex.get((int)selected)).captureDate));
                int[] blockCounts = ((MesatImage)this.imageIndex.get(selected)).getBlockByteNumbers();
                int i = 0;
                while (i < 11) {
                    if (blockCounts[i] > 5956) {
                        this.picBlock[i].setText("FULL");
                    } else {
                        this.picBlock[i].setText("" + blockCounts[i]);
                    }
                    ++i;
                }
            }
        }
    }

    private String displayCaptureDate(String u) {
        Date result = null;
        String reportDate = null;
        try {
            FramePart.fileDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            result = FramePart.fileDateFormat.parse(u);
            FramePart.reportDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            reportDate = FramePart.reportDateFormat.format(result);
        }
        catch (ParseException e) {
            reportDate = u;
        }
        catch (Exception e) {
            reportDate = u;
        }
        return reportDate;
    }

    private void setImagesDownloaded(int pc) {
        this.lblImagesDecoded.setText(DECODED + pc);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("MesatCameraTab");
        this.running = true;
        this.done = false;
        int currentFrames = 0;
        while (this.running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: MesatCameraTab thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            if (this.foxId == 0 || !Config.payloadStore.initialized() || Config.payloadStore.mesatImageStore == null) continue;
            Config.payloadStore.mesatImageStore.buildBlockMapsIfNeeded();
            int numberOfFrames = Config.payloadStore.mesatImageStore.getNumberOfImages();
            if (currentFrames == numberOfFrames && !Config.payloadStore.mesatImageStore.getUpdatedImage()) continue;
            if (Config.debugCameraFrames) {
                Log.println("New tab data from the mesat1 camera");
            }
            currentFrames = numberOfFrames;
            this.loadThumbs();
            this.displayPictureParams(this.selectedThumb);
            this.setImagesDownloaded(Config.payloadStore.mesatImageStore.getNumberOfImages());
            Config.payloadStore.mesatImageStore.setUpdatedImage(false);
            MainWindow.frame.repaint();
        }
        this.done = true;
    }

    public void saveProperties() {
        Config.saveGraphIntParam(this.fox.getIdString(), 99, 5, CAMERATAB, "maxThumbnails", this.maxThumbnails);
        Config.saveGraphIntParam(this.fox.getIdString(), 99, 5, CAMERATAB, "fromReset", this.START_RESET);
        Config.saveGraphLongParam(this.fox.getIdString(), 99, 5, CAMERATAB, "fromUptime", this.START_UPTIME);
        Config.saveGraphIntParam(this.fox.getIdString(), 99, 5, CAMERATAB, "selectedThumb", this.selectedThumb);
    }

    public void loadProperties() {
        this.maxThumbnails = Config.loadGraphIntValue(this.fox.getIdString(), 99, 5, CAMERATAB, "maxThumbnails");
        if (this.maxThumbnails == 0) {
            this.maxThumbnails = 30;
        }
        if (this.maxThumbnails > 500) {
            this.maxThumbnails = 500;
        }
        this.START_RESET = Config.loadGraphIntValue(this.fox.getIdString(), 99, 5, CAMERATAB, "fromReset");
        this.START_UPTIME = Config.loadGraphLongValue(this.fox.getIdString(), 99, 5, CAMERATAB, "fromUptime");
        this.selectedThumb = Config.loadGraphIntValue(this.fox.getIdString(), 99, 5, CAMERATAB, "selectedThumb");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int i = 0;
        while (i < this.thumbnails.length) {
            if (e.getSource() == this.thumbnails[i]) {
                if (this.selectedThumb != -1 && this.selectedThumb < this.thumbnails.length && this.thumbnails[this.selectedThumb] != null) {
                    this.thumbnails[this.selectedThumb].setBorder(new MatteBorder(3, 3, 3, 3, Color.GRAY));
                }
                this.selectedThumb = i;
                this.displayPictureParams(this.selectedThumb);
                this.selectThumb(i);
                this.cbComposite.setSelected(false);
                this.saveProperties();
            }
            ++i;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        int i = 0;
        while (i < this.thumbnails.length) {
            if (e.getSource() == this.thumbnails[i]) {
                this.thumbnails[i].setBorder(new MatteBorder(3, 3, 3, 3, Color.DARK_GRAY));
            }
            ++i;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        int i = 0;
        while (i < this.thumbnails.length) {
            if (e.getSource() == this.thumbnails[i]) {
                if (this.selectedThumb == i) {
                    this.selectThumb(i);
                } else {
                    this.thumbnails[i].setBorder(new MatteBorder(3, 3, 3, 3, Color.GRAY));
                }
            }
            ++i;
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showLatestImage) {
            Config.showLatestImage = e.getStateChange() != 2;
            Config.save();
        } else if (source == this.cbComposite && this.IMAGE_NO != 0) {
            this.loadThumbs();
            this.displayPictureParams(this.selectedThumb);
            this.repaint();
        }
    }

    private void parseTextFields() {
        String text;
        block15: {
            block14: {
                block13: {
                    text = this.displayNumber2.getText();
                    try {
                        this.maxThumbnails = Integer.parseInt(text);
                        if (this.maxThumbnails > 500) {
                            this.maxThumbnails = 500;
                            text = Integer.toString(500);
                        }
                        if (this.maxThumbnails < 1) {
                            this.maxThumbnails = 1;
                            text = Integer.toString(1);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.displayNumber2.setText(text);
                    text = this.textFromReset.getText();
                    try {
                        this.START_RESET = Integer.parseInt(text);
                        if (this.START_RESET < 0) {
                            this.START_RESET = 0;
                        }
                    }
                    catch (NumberFormatException ex) {
                        if (!text.equals("")) break block13;
                        this.START_RESET = DEFAULT_START_RESET;
                    }
                }
                this.textFromReset.setText(text);
                text = this.textFromUptime.getText();
                try {
                    this.START_UPTIME = Integer.parseInt(text);
                    if (this.START_UPTIME < 0L) {
                        this.START_UPTIME = 0L;
                    }
                }
                catch (NumberFormatException ex) {
                    if (!text.equals("")) break block14;
                    this.START_UPTIME = DEFAULT_START_UPTIME;
                }
            }
            this.textFromUptime.setText(text);
            text = this.textImageNo.getText();
            try {
                this.IMAGE_NO = Integer.parseInt(text);
                if (this.IMAGE_NO < 0) {
                    this.IMAGE_NO = 0;
                }
            }
            catch (NumberFormatException ex) {
                if (!text.equals("")) break block15;
                this.IMAGE_NO = 0;
            }
        }
        this.textImageNo.setText(text);
        this.loadThumbs();
        this.displayPictureParams(this.selectedThumb);
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.displayNumber2) {
            this.parseTextFields();
        } else if (e.getSource() == this.textFromReset) {
            this.parseTextFields();
        } else if (e.getSource() == this.textFromUptime) {
            this.parseTextFields();
        } else if (e.getSource() == this.textImageNo) {
            this.parseTextFields();
        }
        this.saveProperties();
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }
}

