/*
 * Decompiled with CFR 0.152.
 */
package gui.tabs;

import common.Config;
import common.Spacecraft;
import gui.graph.GraphFrame;
import gui.tabs.DisplayTableModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import telemetry.legacyPayloads.RadiationPacket;
import telemetry.payloads.PayloadMaxValues;
import telemetry.payloads.PayloadMinValues;
import telemetry.payloads.PayloadRtValues;

public class DisplayTableModule
extends JPanel
implements ActionListener,
MouseListener {
    Spacecraft fox;
    int size = 0;
    String[] fieldName = null;
    int[] display;
    String title = null;
    GraphFrame[] graph = null;
    String noValue = "0000";
    DisplayTableModel displayTableModel;
    JTable table;
    String[][] data;
    int id = 1;
    public static final int DISPLAY_RT_ONLY = 0;
    public static final int DISPLAY_MAX_ONLY = 1;
    public static final int DISPLAY_MIN_ONLY = 2;
    public static final int DISPLAY_ALL = 3;
    public static final int DISPLAY_VULCAN = 4;
    public static final int DISPLAY_LEP = 5;
    public static final int DISPLAY_LEP_EXPOSURE = 6;
    public static final int DISPLAY_VULCAN_EXP = 7;
    public static Color vulcanFontColor = new Color(153, 0, 0);
    int moduleType = 3;

    public DisplayTableModule(Spacecraft sat, String title, int size, int modType) {
        this.fox = sat;
        this.size = size;
        this.title = title;
        TitledBorder border = new TitledBorder(null, title, 4, 2, null, null);
        this.moduleType = modType;
        if (this.moduleType >= 4) {
            border.setTitleFont(new Font("SansSerif", 1, 10));
            border.setTitleColor(vulcanFontColor);
        } else {
            border.setTitleFont(new Font("SansSerif", 1, 12));
            border.setTitleColor(Color.BLUE);
        }
        this.setBorder(border);
        this.displayTableModel = new DisplayTableModel();
        this.table = new JTable(this.displayTableModel);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(1);
        this.table.setOpaque(false);
        this.add(new JScrollPane(this.table));
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(0);
        column.setPreferredWidth(130);
        column.setMinWidth(60);
        this.data = new String[size][4];
        int i = 1;
        while (i < 4) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(25);
            column.setMinWidth(25);
            ++i;
        }
        this.fieldName = new String[size];
        this.graph = new GraphFrame[size];
        this.display = new int[size];
        this.initGui();
    }

    public void addName(int i, String name, String fieldName, int display) {
        this.data[i][0] = name;
        this.fieldName[i] = fieldName;
        this.display[i] = display;
    }

    public void addNameOLD(int i, String name, String fieldName, int display) {
    }

    public void updateRtValues(PayloadRtValues rt) {
        int i = 0;
        while (i < this.size) {
            if (this.fieldName[i] != null) {
                this.data[i][1] = Config.displayRawValues ? Integer.toString(rt.getRawValue(this.fieldName[i])) : rt.getStringValue(this.fieldName[i], this.fox);
                if (this.graph[i] != null) {
                    this.graph[i].updateGraphData("DisplayTableModule.updateRtValues");
                }
            }
            ++i;
        }
        this.displayTableModel.setData(this.data);
    }

    public void updateMaxValues(PayloadMaxValues rt) {
        int i = 0;
        while (i < this.size) {
            if (this.fieldName[i] != null) {
                this.data[i][3] = Config.displayRawValues ? Integer.toString(rt.getRawValue(this.fieldName[i])) : rt.getStringValue(this.fieldName[i], this.fox);
            }
            ++i;
        }
        this.displayTableModel.setData(this.data);
    }

    public void updateMinValues(PayloadMinValues rt) {
        int i = 0;
        while (i < this.size) {
            if (this.fieldName[i] != null) {
                this.data[i][2] = Config.displayRawValues ? Integer.toString(rt.getRawValue(this.fieldName[i])) : rt.getStringValue(this.fieldName[i], this.fox);
            }
            ++i;
        }
        this.displayTableModel.setData(this.data);
    }

    public void updateVulcanValues(RadiationPacket rad) {
        int i = 0;
        while (i < this.size) {
            if (this.fieldName[i] != null) {
                this.data[i][1] = Config.displayRawValues ? Integer.toString(rad.getRawValue(this.fieldName[i])) : rad.getStringValue(this.fieldName[i]);
            }
            ++i;
        }
        this.displayTableModel.setData(this.data);
    }

    private void initGui() {
        this.data[0][0] = " ";
        this.data[0][1] = "RT";
        this.data[0][2] = "MIN";
        this.data[0][3] = "MAX";
        this.displayTableModel.setData(this.data);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public void saveGraphs() {
        int i = 0;
        while (i < this.graph.length) {
            if (this.graph[i] != null) {
                this.graph[i].saveProperties(true);
            }
            ++i;
        }
    }
}

