/*
 * Decompiled with CFR 0.152.
 */
package gui.tabs;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import gui.tabs.DisplayModule;
import gui.tabs.ExperimentLayoutTableModel;
import gui.tabs.ExperimentTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.LayoutLoadException;

public class NamedExperimentTab
extends ExperimentTab
implements ItemListener,
Runnable {
    private static final String DECODED = "Payloads Decoded: ";
    public final int DEFAULT_DIVIDER_LOCATION = 350;
    JLabel lblName;
    private String NAME;
    JLabel lblFramesDecoded;
    ExperimentLayoutTableModel expTableModel;
    ExperimentLayoutTableModel expTableModel2;
    JPanel healthPanel;
    boolean displayTelem = true;
    BitArrayLayout layout;
    BitArrayLayout layout2;
    int total;

    public NamedExperimentTab(Spacecraft sat, String displayName, BitArrayLayout displayLayout, BitArrayLayout displayLayout2, int displayType) {
        this.fox = sat;
        this.foxId = this.fox.foxId;
        this.NAME = String.valueOf(this.fox.toString()) + " " + displayName;
        this.layout = displayLayout;
        this.layout2 = displayLayout2;
        this.splitPaneHeight = Config.loadGraphIntValue(this.fox.getIdString(), 99, 1, this.layout.name, "splitPaneHeight");
        this.lblName = new JLabel(this.NAME);
        this.lblName.setMaximumSize(new Dimension(1600, 20));
        this.lblName.setMinimumSize(new Dimension(1600, 20));
        this.lblName.setFont(new Font("SansSerif", 1, 14));
        this.topPanel.add(this.lblName);
        this.lblFramesDecoded = new JLabel(DECODED);
        this.lblFramesDecoded.setFont(new Font("SansSerif", 1, 14));
        this.lblFramesDecoded.setBorder(new EmptyBorder(5, 2, 5, 5));
        this.topPanel.add(this.lblFramesDecoded);
        this.healthPanel = new JPanel();
        this.healthPanel.setLayout(new BoxLayout(this.healthPanel, 1));
        this.healthPanel.setBorder(new SoftBevelBorder(1, null, null, null, null));
        this.healthPanel.setBackground(Color.DARK_GRAY);
        this.initDisplayHalves(this.healthPanel);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 0));
        BitArrayLayout none = null;
        if (this.layout2 == null) {
            this.layout2 = this.layout;
        }
        try {
            this.analyzeModules(this.layout2, none, none, displayType);
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("FATAL - Load Aborted", e.getMessage());
            e.printStackTrace(Log.getWriter());
            System.exit(1);
        }
        this.splitPane = new JSplitPane(0, this.healthPanel, this.centerPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        if (this.splitPaneHeight != 0) {
            this.splitPane.setDividerLocation(this.splitPaneHeight);
        } else {
            this.splitPane.setDividerLocation(350);
        }
        SplitPaneUI spui = this.splitPane.getUI();
        if (spui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)spui).getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    NamedExperimentTab.this.splitPaneHeight = NamedExperimentTab.this.splitPane.getDividerLocation();
                    Config.saveGraphIntParam(NamedExperimentTab.this.fox.getIdString(), 99, 1, NamedExperimentTab.this.layout.name, "splitPaneHeight", NamedExperimentTab.this.splitPaneHeight);
                }
            });
        }
        Dimension minimumSize = new Dimension(100, 50);
        this.healthPanel.setMinimumSize(minimumSize);
        this.centerPanel.setMinimumSize(minimumSize);
        this.add((Component)this.splitPane, "Center");
        this.showRawBytes = new JCheckBox("Show Raw Bytes", Config.displayRawRadData);
        this.bottomPanel.add(this.showRawBytes);
        this.showRawBytes.addItemListener(this);
        this.addBottomFilter();
        this.expTableModel = new ExperimentLayoutTableModel(this.layout);
        this.expTableModel2 = new ExperimentLayoutTableModel(this.layout2);
        this.addTables(this.expTableModel, this.expTableModel2);
        this.parseExperimentFrames();
    }

    protected void displayFramesDecoded(int u) {
        this.total = u;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NamedExperimentTab.this.lblFramesDecoded.setText(NamedExperimentTab.DECODED + NamedExperimentTab.this.total);
                NamedExperimentTab.this.lblFramesDecoded.invalidate();
                NamedExperimentTab.this.topPanel.validate();
            }
        });
    }

    @Override
    protected void addTables(AbstractTableModel expTableModel, AbstractTableModel expTableModel2) {
        int w;
        super.addTables(expTableModel, expTableModel2);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(0);
        column.setPreferredWidth(10 + 7 * this.table.getColumnName(0).length());
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(10 + 7 * this.table.getColumnName(0).length());
        int i = 0;
        while (i < this.table.getColumnCount() - 2) {
            column = this.table.getColumnModel().getColumn(i + 2);
            w = this.layout.fieldName[i].length();
            column.setPreferredWidth(10 + 7 * w);
            ++i;
        }
        column = this.table2.getColumnModel().getColumn(0);
        column.setPreferredWidth(10 + 7 * this.table.getColumnName(0).length());
        column = this.table2.getColumnModel().getColumn(1);
        column.setPreferredWidth(10 + 7 * this.table.getColumnName(0).length());
        i = 0;
        while (i < this.table2.getColumnCount() - 2) {
            column = this.table2.getColumnModel().getColumn(i + 2);
            w = this.layout2.fieldName[i].length();
            column.setPreferredWidth(10 + 7 * w);
            ++i;
        }
    }

    @Override
    protected void parseExperimentFrames() {
        if (Config.payloadStore == null) {
            return;
        }
        if (!Config.payloadStore.initialized()) {
            return;
        }
        String[][] data = null;
        if (Config.displayRawRadData) {
            data = Config.payloadStore.getTableData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, false, this.reverse, this.layout.name);
            if (data != null && data.length > 0) {
                this.parseRawBytes(data, this.expTableModel);
            }
        } else {
            data = Config.payloadStore.getTableData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, false, this.reverse, this.layout2.name);
            if (data != null && data.length > 0) {
                this.parseRawBytes(data, this.expTableModel2);
            }
        }
        if (this.showRawBytes.isSelected()) {
            this.scrollPane2.setVisible(false);
            this.scrollPane.setVisible(true);
        } else {
            this.scrollPane2.setVisible(true);
            this.scrollPane.setVisible(false);
        }
        this.displayFramesDecoded(Config.payloadStore.getNumberOfFrames(this.foxId, this.layout.name));
        MainWindow.frame.repaint();
    }

    public void updateTab(FramePart rad, boolean refreshTable) {
        if (!Config.payloadStore.initialized()) {
            return;
        }
        if (rad != null) {
            DisplayModule mod;
            DisplayModule[] displayModuleArray = this.topModules;
            int n = this.topModules.length;
            int n2 = 0;
            while (n2 < n) {
                mod = displayModuleArray[n2];
                if (mod != null) {
                    mod.updateRtValues(rad);
                }
                ++n2;
            }
            if (this.bottomModules != null) {
                displayModuleArray = this.bottomModules;
                n = this.bottomModules.length;
                n2 = 0;
                while (n2 < n) {
                    mod = displayModuleArray[n2];
                    if (mod != null) {
                        mod.updateRtValues(rad);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("ExpTab: " + this.layout.name);
        this.running = true;
        this.done = false;
        int currentFrames = 0;
        boolean justStarted = true;
        while (this.running) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: HealthTab thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            if (this.foxId == 0 || !Config.payloadStore.initialized()) continue;
            int frames = Config.payloadStore.getNumberOfFrames(this.foxId, this.layout.name);
            if (frames != currentFrames) {
                currentFrames = frames;
                this.updateTab(Config.payloadStore.getLatest(this.foxId, this.layout2.name), true);
                this.displayFramesDecoded(Config.payloadStore.getNumberOfFrames(this.foxId, this.layout.name));
                Config.payloadStore.setUpdated(this.foxId, this.layout.name, false);
                MainWindow.setTotalDecodes();
                this.parseExperimentFrames();
                if (justStarted) {
                    this.openGraphs();
                    justStarted = false;
                }
                MainWindow.frame.repaint();
            }
            if (Config.displayRawRadData != this.showRawBytes.isSelected()) {
                this.showRawBytes.setSelected(Config.displayRawRadData);
                this.parseExperimentFrames();
                this.updateTab(Config.payloadStore.getLatest(this.foxId, this.layout2.name), true);
            }
            if (Config.displayRawValues == this.showRawValues.isSelected()) continue;
            this.showRawValues.setSelected(Config.displayRawValues);
            this.updateTab(Config.payloadStore.getLatest(this.foxId, this.layout2.name), true);
        }
        this.done = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showRawValues) {
            Config.displayRawValues = e.getStateChange() != 2;
            Config.save();
            this.updateTab(Config.payloadStore.getLatest(this.foxId, this.layout2.name), true);
        }
        if (source == this.cbUTC) {
            this.updateTab(Config.payloadStore.getLatest(this.foxId, this.layout2.name), true);
        }
    }

    @Override
    public void parseFrames() {
        this.parseExperimentFrames();
    }

    @Override
    protected void displayRow(JTable table, int fromRow, int row) {
        long reset_l = (Long)table.getValueAt(row, 0);
        long uptime = (Long)table.getValueAt(row, 1);
        int reset = (int)reset_l;
        this.updateTab(Config.payloadStore.getFramePart(this.foxId, reset, uptime, this.layout2.name, false), false);
        if (fromRow == -1) {
            fromRow = row;
        }
        if (fromRow <= row) {
            table.setRowSelectionInterval(fromRow, row);
        } else {
            table.setRowSelectionInterval(row, fromRow);
        }
    }
}

