/*
 * Decompiled with CFR 0.152.
 */
package gui.uw;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import gui.tabs.DisplayModule;
import gui.tabs.ExperimentTab;
import gui.uw.CanPacketRawTableModel;
import gui.uw.CanPacketTableModel;
import gui.uw.WodUwExperimentTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.LayoutLoadException;
import telemetry.uw.UwCanPacket;

public class UwExperimentTab
extends ExperimentTab
implements ItemListener,
Runnable,
MouseListener {
    private static final long serialVersionUID = 1L;
    public static final String UWTAB = "UWEXPTAB";
    private static final String DECODED = "Payloads Decoded: ";
    private static final String CAN_DECODED = " CAN Pkts: ";
    public final int DEFAULT_DIVIDER_LOCATION = 350;
    JLabel lblName;
    private String NAME;
    JLabel lblFramesDecoded;
    CanPacketRawTableModel radTableModel;
    CanPacketTableModel radPacketTableModel;
    JPanel healthPanel;
    JPanel topHalfPackets;
    JPanel bottomHalfPackets;
    boolean displayTelem = true;
    BitArrayLayout[] layout;
    public static int[] ids = new int[]{308871750, 308871681, 308871684, 307823128, 307823125, 307823126, 307823127, 307823184};

    public UwExperimentTab(Spacecraft sat, int displayType) {
        this.fox = sat;
        this.foxId = this.fox.foxId;
        this.NAME = String.valueOf(this.fox.toString()) + " CAN PACKETS";
        int j = 0;
        this.layout = new BitArrayLayout[ids.length];
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int canid = nArray[n2];
            this.layout[j++] = Config.satManager.getLayoutByCanId(6, canid);
            ++n2;
        }
        this.splitPaneHeight = Config.loadGraphIntValue(this.fox.getIdString(), 99, 1, UWTAB, "splitPaneHeight");
        this.lblName = new JLabel(this.NAME);
        this.lblName.setMaximumSize(new Dimension(1600, 20));
        this.lblName.setMinimumSize(new Dimension(1600, 20));
        this.lblName.setFont(new Font("SansSerif", 1, 14));
        this.topPanel.add(this.lblName);
        this.lblFramesDecoded = new JLabel("Payloads Decoded:  CAN Pkts: ");
        this.lblFramesDecoded.setFont(new Font("SansSerif", 1, 14));
        this.lblFramesDecoded.setBorder(new EmptyBorder(5, 2, 5, 5));
        this.topPanel.add(this.lblFramesDecoded);
        this.healthPanel = new JPanel();
        this.healthPanel.setLayout(new BoxLayout(this.healthPanel, 1));
        this.healthPanel.setBorder(new SoftBevelBorder(1, null, null, null, null));
        this.healthPanel.setBackground(Color.DARK_GRAY);
        this.topHalfPackets = new JPanel();
        this.topHalfPackets.setBackground(Color.DARK_GRAY);
        this.bottomHalfPackets = new JPanel();
        this.bottomHalfPackets.setBackground(Color.DARK_GRAY);
        this.healthPanel.add(this.topHalfPackets);
        this.healthPanel.add(this.bottomHalfPackets);
        this.initDisplayHalves(this.healthPanel);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 0));
        this.addModules();
        this.splitPane = new JSplitPane(0, this.healthPanel, this.centerPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        if (this.splitPaneHeight != 0) {
            this.splitPane.setDividerLocation(this.splitPaneHeight);
        } else {
            this.splitPane.setDividerLocation(350);
        }
        SplitPaneUI spui = this.splitPane.getUI();
        if (spui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)spui).getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    UwExperimentTab.this.splitPaneHeight = UwExperimentTab.this.splitPane.getDividerLocation();
                    Config.saveGraphIntParam(UwExperimentTab.this.fox.getIdString(), 99, 1, UwExperimentTab.UWTAB, "splitPaneHeight", UwExperimentTab.this.splitPaneHeight);
                }
            });
        }
        Dimension minimumSize = new Dimension(100, 50);
        this.healthPanel.setMinimumSize(minimumSize);
        this.centerPanel.setMinimumSize(minimumSize);
        this.add((Component)this.splitPane, "Center");
        this.showRawBytes = new JCheckBox("Show Raw Bytes", Config.displayRawRadData);
        this.bottomPanel.add(this.showRawBytes);
        this.showRawBytes.addItemListener(this);
        this.addBottomFilter();
        this.radTableModel = new CanPacketRawTableModel();
        this.radPacketTableModel = new CanPacketTableModel();
        this.addTables(this.radTableModel, this.radPacketTableModel);
        this.addPacketModules();
        this.topHalfPackets.setVisible(false);
        this.bottomHalfPackets.setVisible(false);
        this.parseExperimentFrames();
    }

    public static boolean inCanIds(int id) {
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int canid = nArray[n2];
            if (id == canid) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void addModules() {
        try {
            this.makeDisplayModules(this.layout, 11);
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("FATAL - Load Aborted", e.getMessage());
            e.printStackTrace(Log.getWriter());
            System.exit(1);
        }
    }

    protected void displayFramesDecoded(int u, int c) {
        this.lblFramesDecoded.setText(DECODED + u + CAN_DECODED + c);
    }

    private void addPacketModules() {
    }

    @Override
    protected void addTables(AbstractTableModel radTableModel, AbstractTableModel radPacketTableModel) {
        super.addTables(radTableModel, radPacketTableModel);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(0);
        column.setPreferredWidth(45);
        column.setCellRenderer(centerRenderer);
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(55);
        column.setCellRenderer(centerRenderer);
        column = this.table.getColumnModel().getColumn(2);
        column.setPreferredWidth(55);
        column.setCellRenderer(centerRenderer);
        column = this.table.getColumnModel().getColumn(3);
        column.setPreferredWidth(75);
        column.setCellRenderer(centerRenderer);
        column = this.table.getColumnModel().getColumn(4);
        column.setPreferredWidth(75);
        column.setCellRenderer(centerRenderer);
        column = this.table.getColumnModel().getColumn(5);
        column.setPreferredWidth(55);
        column.setCellRenderer(centerRenderer);
        int i = 0;
        while (i < 8) {
            column = this.table.getColumnModel().getColumn(i + 6);
            column.setPreferredWidth(45);
            ++i;
        }
        column = this.table2.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column.setCellRenderer(centerRenderer);
        column = this.table2.getColumnModel().getColumn(1);
        column.setPreferredWidth(150);
        column.setCellRenderer(centerRenderer);
        column = this.table2.getColumnModel().getColumn(2);
        column.setPreferredWidth(150);
        column = this.table2.getColumnModel().getColumn(3);
        column.setPreferredWidth(150);
        column = this.table2.getColumnModel().getColumn(4);
        column.setPreferredWidth(155);
        column = this.table2.getColumnModel().getColumn(5);
        column.setPreferredWidth(55);
        column.setCellRenderer(centerRenderer);
    }

    protected void parseRawBytes(String[][] data, CanPacketRawTableModel radTableModel) {
        long[][] keyRawData = new long[data.length][3];
        String[][] rawData = new String[data.length][11];
        int i = 0;
        while (i < data.length) {
            int id = UwCanPacket.getIdFromRawBytes(Integer.valueOf(data[data.length - i - 1][3]), Integer.valueOf(data[data.length - i - 1][4]), Integer.valueOf(data[data.length - i - 1][5]), Integer.valueOf(data[data.length - i - 1][6]));
            int len = UwCanPacket.getLengthFromRawBytes(Integer.valueOf(data[data.length - i - 1][3]), Integer.valueOf(data[data.length - i - 1][4]), Integer.valueOf(data[data.length - i - 1][5]), Integer.valueOf(data[data.length - i - 1][6]));
            int k = 0;
            while (k < 3) {
                try {
                    if (k < 3) {
                        keyRawData[i][k] = Long.parseLong(data[data.length - i - 1][k]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++k;
            }
            rawData[i][0] = "" + id;
            rawData[i][1] = String.format("%08x", id);
            rawData[i][2] = Integer.toString(len);
            k = 7;
            while (k < data[0].length) {
                if (data[data.length - i - 1].length > k && data[data.length - i - 1][k] != null) {
                    rawData[i][k - 4] = Integer.toHexString(Integer.valueOf(data[data.length - i - 1][k]));
                }
                if (rawData[i][k - 4] == null) {
                    rawData[i][k - 4] = "";
                }
                ++k;
            }
            ++i;
        }
        radTableModel.setData(keyRawData, rawData);
    }

    private boolean in(int[] array, int a) {
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            if (a == b) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void parseExperimentFrames() {
        if (!Config.payloadStore.initialized()) {
            return;
        }
        String[][] data = null;
        if (Config.displayRawRadData) {
            boolean showParsedPackets = false;
            if (showParsedPackets) {
                int maxCanIDs = 250;
                String[][][] all = new String[maxCanIDs][][];
                int number = 0;
                int total = 0;
                int[] nArray = this.fox.canFrames.canId;
                int n = this.fox.canFrames.canId.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    if (!this.in(WodUwExperimentTab.wod_ids, id)) {
                        BitArrayLayout lay = Config.satManager.getLayoutByCanId(this.fox.foxId, id);
                        String[][] records = Config.payloadStore.getTableData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, true, this.reverse, lay.name);
                        if (records.length > 0) {
                            all[number] = records;
                            ++number;
                            total += records.length;
                        }
                    }
                    ++n2;
                }
                int k = 0;
                data = new String[total][];
                int j = 0;
                while (j < number) {
                    int r = 0;
                    while (r < all[j].length) {
                        data[k++] = all[j][r];
                        ++r;
                    }
                    ++j;
                }
            } else {
                data = Config.payloadStore.getTableData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, true, this.reverse, "canpacket");
            }
            if (data != null && data.length > 0) {
                this.parseRawBytes(data, this.radTableModel);
            }
        } else {
            String[][] totals = new String[250][];
            int number = 0;
            int[] nArray = this.fox.canFrames.canId;
            int n = this.fox.canFrames.canId.length;
            int n3 = 0;
            while (n3 < n) {
                int id = nArray[n3];
                if (!this.in(WodUwExperimentTab.wod_ids, id)) {
                    BitArrayLayout lay = Config.satManager.getLayoutByCanId(this.fox.foxId, id);
                    if (lay == null) {
                        return;
                    }
                    int total = Config.payloadStore.getNumberOfFrames(this.fox.foxId, lay.name);
                    if (total > 0) {
                        String[] row = new String[]{"" + id, this.fox.canFrames.getGroundByCanId(id), this.fox.canFrames.getNameByCanId(id), this.fox.canFrames.getSenderByCanId(id), "" + total};
                        totals[number] = row;
                        ++number;
                    }
                }
                ++n3;
            }
            data = new String[number][];
            int j = 0;
            while (j < number) {
                data[j] = totals[j];
                ++j;
            }
            if (data != null && data.length > 0) {
                this.parseTelemetry(data);
            }
        }
        if (this.showRawBytes.isSelected()) {
            this.scrollPane2.setVisible(false);
            this.scrollPane.setVisible(true);
        } else {
            this.scrollPane2.setVisible(true);
            this.scrollPane.setVisible(false);
        }
        this.displayFramesDecoded(Config.payloadStore.getNumberOfFrames(this.foxId, "cantelemetry"), this.getTotalPackets());
        MainWindow.frame.repaint();
    }

    protected void parseTelemetry(String[][] data) {
        int len = data.length;
        long[][] keyPacketData = null;
        String[][] packetData = null;
        keyPacketData = new long[len][1];
        packetData = new String[len][5];
        int i = 0;
        while (i < len) {
            keyPacketData[len - i - 1][0] = Long.parseLong(data[i][0]);
            packetData[len - i - 1][0] = String.format("%08x", Long.parseLong(data[i][0]));
            packetData[len - i - 1][1] = data[i][1];
            packetData[len - i - 1][2] = data[i][2];
            packetData[len - i - 1][3] = data[i][3];
            packetData[len - i - 1][4] = data[i][4];
            ++i;
        }
        if (packetData.length > 0) {
            this.radPacketTableModel.setData(keyPacketData, packetData);
        }
    }

    public void updateTab(FramePart rad, boolean refreshTable) {
        if (!Config.payloadStore.initialized()) {
            return;
        }
        if (rad != null) {
            DisplayModule[] displayModuleArray = this.topModules;
            int n = this.topModules.length;
            int n2 = 0;
            while (n2 < n) {
                FramePart data;
                DisplayModule mod = displayModuleArray[n2];
                if (mod != null && mod.getTelemLayout() != null && (data = Config.payloadStore.getLatest(this.foxId, mod.getTelemLayout().name)) != null) {
                    mod.updateRtValues(data);
                }
                ++n2;
            }
        }
    }

    private int getTotalPackets() {
        int total = 0;
        if (this.showRawBytes.isSelected()) {
            total = Config.payloadStore.getNumberOfFrames(this.fox.foxId, "canpacket");
        } else {
            int[] nArray = this.fox.canFrames.canId;
            int n = this.fox.canFrames.canId.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                if (!this.in(WodUwExperimentTab.wod_ids, id)) {
                    BitArrayLayout lay = Config.satManager.getLayoutByCanId(this.fox.foxId, id);
                    if (lay == null) {
                        return 0;
                    }
                    total += Config.payloadStore.getNumberOfFrames(this.fox.foxId, lay.name);
                }
                ++n2;
            }
        }
        return total;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("UwTab");
        this.running = true;
        this.done = false;
        int currentFrames = 0;
        boolean justStarted = true;
        while (this.running) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: HealthTab thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            if (this.foxId == 0 || !Config.payloadStore.initialized()) continue;
            if (Config.displayRawRadData != this.showRawBytes.isSelected()) {
                this.showRawBytes.setSelected(Config.displayRawRadData);
                this.parseExperimentFrames();
                this.updateTab(Config.payloadStore.getLatest(this.foxId, "cantelemetry"), true);
            }
            if (Config.displayRawValues != this.showRawValues.isSelected()) {
                this.showRawValues.setSelected(Config.displayRawValues);
                this.updateTab(Config.payloadStore.getLatest(this.foxId, "cantelemetry"), true);
            }
            boolean refresh = false;
            int frames = Config.payloadStore.getNumberOfFrames(this.foxId, "cantelemetry");
            if (frames != currentFrames) {
                currentFrames = frames;
                Config.payloadStore.setUpdated(this.foxId, "cantelemetry", false);
                refresh = true;
            }
            if (!refresh) continue;
            this.parseExperimentFrames();
            this.updateTab(Config.payloadStore.getLatest(this.foxId, "cantelemetry"), true);
            this.displayFramesDecoded(frames, this.getTotalPackets());
            MainWindow.setTotalDecodes();
            if (!justStarted) continue;
            this.openGraphs();
            justStarted = false;
        }
        this.done = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showRawValues) {
            Config.displayRawValues = e.getStateChange() != 2;
            Config.save();
            this.updateTab(Config.payloadStore.getLatest(this.foxId, "cantelemetry"), true);
        }
    }

    @Override
    public void parseFrames() {
        this.parseExperimentFrames();
    }

    @Override
    protected void displayRow(JTable table, int fromRow, int row) {
        if (Config.displayRawRadData) {
            long reset_l = (Long)table.getValueAt(row, 0);
            long uptime = (Long)table.getValueAt(row, 1);
            int reset = (int)reset_l;
            this.updateTab(Config.payloadStore.getFramePart(this.foxId, reset, uptime, "cantelemetry", false), false);
        } else {
            this.updateTab(Config.payloadStore.getLatest(this.foxId, "cantelemetry"), true);
        }
        if (fromRow == -1) {
            fromRow = row;
        }
        if (fromRow <= row) {
            table.setRowSelectionInterval(fromRow, row);
        } else {
            table.setRowSelectionInterval(row, fromRow);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

