/*
 * Decompiled with CFR 0.152.
 */
package gui.uw;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import gui.uw.UwExperimentTab;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import javax.swing.JTable;
import telemetry.BitArrayLayout;
import telemetry.LayoutLoadException;

public class WodUwExperimentTab
extends UwExperimentTab {
    private static final long serialVersionUID = 1L;
    public static int[] wod_ids = new int[]{309920562, 309920256, 309330499};

    public WodUwExperimentTab(Spacecraft sat) {
        super(sat, 8);
    }

    @Override
    protected void addModules() {
        int j = 0;
        this.layout = new BitArrayLayout[ids.length];
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int canid = nArray[n2];
            this.layout[j++] = Config.satManager.getLayoutByCanId(6, canid);
            ++n2;
        }
        BitArrayLayout rad = null;
        rad = this.fox.getLayoutByName("wodcantelemetry");
        BitArrayLayout none = null;
        try {
            this.analyzeModules(rad, none, none, 12);
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("FATAL - Load Aborted", e.getMessage());
            e.printStackTrace(Log.getWriter());
            System.exit(1);
        }
    }

    @Override
    protected void parseExperimentFrames() {
        if (!Config.payloadStore.initialized()) {
            return;
        }
        String[][] data = null;
        if (Config.displayRawRadData) {
            boolean showParsedPackets = false;
            if (showParsedPackets) {
                int maxCanIDs = wod_ids.length;
                String[][][] all = new String[maxCanIDs][][];
                int number = 0;
                int total = 0;
                int[] nArray = wod_ids;
                int n = wod_ids.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    BitArrayLayout lay = Config.satManager.getLayoutByCanId(this.fox.foxId, id);
                    String[][] records = Config.payloadStore.getTableData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, true, this.reverse, lay.name);
                    if (records.length > 0) {
                        all[number] = records;
                        ++number;
                        total += records.length;
                    }
                    ++n2;
                }
                int k = 0;
                data = new String[total][];
                int j = 0;
                while (j < number) {
                    int r = 0;
                    while (r < all[j].length) {
                        data[k++] = all[j][r];
                        ++r;
                    }
                    ++j;
                }
            } else {
                data = Config.payloadStore.getTableData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, true, this.reverse, "wodcanpacket");
            }
            if (data != null && data.length > 0) {
                this.parseRawBytes(data, this.radTableModel);
            }
        } else {
            String[][] totals = new String[250][];
            int number = 0;
            int[] nArray = wod_ids;
            int n = wod_ids.length;
            int n3 = 0;
            while (n3 < n) {
                int id = nArray[n3];
                BitArrayLayout lay = Config.satManager.getLayoutByCanId(this.fox.foxId, id);
                if (lay == null) {
                    return;
                }
                int total = Config.payloadStore.getNumberOfFrames(this.fox.foxId, lay.name);
                if (total > 0) {
                    String[] row = new String[]{"" + id, this.fox.canFrames.getGroundByCanId(id), this.fox.canFrames.getNameByCanId(id), this.fox.canFrames.getSenderByCanId(id), "" + total};
                    totals[number] = row;
                    ++number;
                }
                ++n3;
            }
            data = new String[number][];
            int j = 0;
            while (j < number) {
                data[j] = totals[j];
                ++j;
            }
            if (data != null && data.length > 0) {
                this.parseTelemetry(data);
            }
        }
        if (this.showRawBytes.isSelected()) {
            this.scrollPane2.setVisible(false);
            this.scrollPane.setVisible(true);
        } else {
            this.scrollPane2.setVisible(true);
            this.scrollPane.setVisible(false);
        }
        this.displayFramesDecoded(Config.payloadStore.getNumberOfFrames(this.foxId, "wodcantelemetry"), this.getTotalPackets());
        MainWindow.frame.repaint();
    }

    @Override
    protected void displayRow(JTable table, int fromRow, int row) {
        if (Config.displayRawRadData) {
            long reset_l = (Long)table.getValueAt(row, 0);
            long uptime = (Long)table.getValueAt(row, 1);
            int reset = (int)reset_l;
            this.updateTab(Config.payloadStore.getFramePart(this.foxId, reset, uptime, "wodcantelemetry", false), false);
        } else {
            this.updateTab(Config.payloadStore.getLatest(this.foxId, "wodcantelemetry"), true);
        }
        if (fromRow == -1) {
            fromRow = row;
        }
        if (fromRow <= row) {
            table.setRowSelectionInterval(fromRow, row);
        } else {
            table.setRowSelectionInterval(row, fromRow);
        }
    }

    private int getTotalPackets() {
        int total = 0;
        if (this.showRawBytes.isSelected()) {
            total = Config.payloadStore.getNumberOfFrames(this.fox.foxId, "wodcanpacket");
        } else {
            int[] nArray = wod_ids;
            int n = wod_ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                BitArrayLayout lay = Config.satManager.getLayoutByCanId(this.fox.foxId, id);
                if (lay == null) {
                    return 0;
                }
                total += Config.payloadStore.getNumberOfFrames(this.fox.foxId, lay.name);
                ++n2;
            }
        }
        return total;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("UwWODTab");
        this.running = true;
        this.done = false;
        int currentFrames = 0;
        boolean justStarted = true;
        while (this.running) {
            int frames;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: HealthTab thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            if (Config.displayRawRadData != this.showRawBytes.isSelected()) {
                this.showRawBytes.setSelected(Config.displayRawRadData);
                this.parseExperimentFrames();
                this.updateTab(Config.payloadStore.getLatest(this.foxId, "wodcantelemetry"), true);
            }
            if (this.foxId == 0 || !Config.payloadStore.initialized() || (frames = Config.payloadStore.getNumberOfFrames(this.foxId, "wodcantelemetry")) == currentFrames) continue;
            currentFrames = frames;
            Config.payloadStore.setUpdated(this.foxId, "wodcantelemetry", false);
            this.parseExperimentFrames();
            this.updateTab(Config.payloadStore.getLatest(this.foxId, "wodcantelemetry"), true);
            this.displayFramesDecoded(frames, this.getTotalPackets());
            MainWindow.setTotalDecodes();
            if (!justStarted) continue;
            this.openGraphs();
            justStarted = false;
        }
        this.done = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showRawValues) {
            Config.displayRawValues = e.getStateChange() != 2;
            Config.save();
            this.updateTab(Config.payloadStore.getLatest(this.foxId, "wodcantelemetry"), true);
        }
    }
}

