/*
 * Decompiled with CFR 0.152.
 */
package network;

import common.Config;
import common.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import telemetry.FramePart;

public class FtpLogs
implements Runnable {
    boolean running = false;
    String server = "n0jy.org";
    int port = 21;
    String user = "g0kla";
    String pass = "argyl3sw3@t3R";
    FTPClient ftpClient = new FTPClient();

    public void stopProcessing() {
        this.running = false;
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                Thread.sleep(60000 * Config.ftpPeriod);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: ftpLogs thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            try {
                if (!Config.ftpFiles) continue;
                this.sendFiles();
            }
            catch (SocketException e) {
                Log.println("ERROR: ftpLogs socket exception");
                e.printStackTrace(Log.getWriter());
            }
            catch (IOException e) {
                Log.println("ERROR: ftpLogs IO Exception");
                e.printStackTrace(Log.getWriter());
            }
        }
    }

    private void sendFiles() throws SocketException, IOException {
        this.ftpClient.connect(this.server, this.port);
        Log.println("Connected to " + this.server + ".");
        Log.print(this.ftpClient.getReplyString());
        int reply = this.ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            this.ftpClient.disconnect();
            Log.println("FTP server refused connection.");
        } else {
            this.ftpClient.login(this.user, this.pass);
            Log.println("Logging in..");
            Log.print(this.ftpClient.getReplyString());
            this.ftpClient.enterLocalPassiveMode();
            this.ftpClient.setControlKeepAliveTimeout(300L);
            this.ftpClient.setFileType(0);
            this.ftpClient.disconnect();
        }
    }

    private void sendFile(String fileName) throws FileNotFoundException {
        File firstLocalFile = new File(fileName);
        String firstRemoteFile = String.valueOf(FramePart.fileDateStamp()) + "_" + Config.callsign.toLowerCase() + "_" + fileName;
        FileInputStream inputStream = new FileInputStream(firstLocalFile);
        Log.println("Uploading log file: " + fileName);
        try {
            boolean done = this.ftpClient.storeFile(firstRemoteFile, inputStream);
            Log.print(this.ftpClient.getReplyString());
            ((InputStream)inputStream).close();
            if (done) {
                Log.println(" ... success.");
            } else {
                Log.println(" ... fail.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.println(" ... fail.");
        }
    }
}

