/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import spacecraftEditor.SpacecraftEditPanel;
import spacecraftEditor.SpacecraftEditorWindow;
import spacecraftEditor.listEditors.CsvTableModel;
import spacecraftEditor.listEditors.ListTableModel;
import spacecraftEditor.listEditors.TableListEditPanel;
import telemetry.Format.TelemFormat;
import telemetry.LayoutLoadException;

public class SourceTableListEditPanel
extends TableListEditPanel {
    private static final long serialVersionUID = 1L;
    JPanel sourceFormatDetails;
    JPanel sourceStats;
    JLabel labFrameLen;
    JLabel labHeaderLen;
    JLabel labDataLen;
    JLabel labRSWords;
    JLabel labTrailerLen;

    public SourceTableListEditPanel(Spacecraft sat, String title, ListTableModel listTableModel, CsvTableModel csvTableModel, SpacecraftEditPanel parent) {
        super(sat, title, listTableModel, csvTableModel, "format", parent);
        this.txtFilename.setEditable(false);
        this.lFilename.setText("File");
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
        this.sourceFormatDetails = new JPanel();
        this.leftPanel.add(this.sourceFormatDetails);
        TitledBorder headingSources = SpacecraftEditPanel.title("Format Details");
        this.sourceFormatDetails.setBorder(headingSources);
        this.sourceFormatDetails.setLayout(new BorderLayout());
        this.sourceStats = new JPanel();
        this.leftPanel.add(this.sourceFormatDetails);
        this.sourceStats.setLayout(new BoxLayout(this.sourceStats, 1));
        this.sourceFormatDetails.add((Component)this.sourceStats, "North");
        this.labFrameLen = new JLabel();
        this.labHeaderLen = new JLabel();
        this.labDataLen = new JLabel();
        this.labRSWords = new JLabel();
        this.labTrailerLen = new JLabel();
        this.sourceStats.add(this.labFrameLen);
        this.sourceStats.add(this.labHeaderLen);
        this.sourceStats.add(this.labDataLen);
        this.sourceStats.add(this.labRSWords);
        this.sourceStats.add(this.labTrailerLen);
    }

    @Override
    protected JPanel addCenterPanel() {
        JPanel center = new JPanel();
        return center;
    }

    @Override
    protected void updateRow(int row) {
        this.txtName.setText(((String[])this.dataLines.get(row))[1]);
        this.txtFilename.setText(((String[])this.dataLines.get(row))[2]);
        this.updateSourceStats(row);
    }

    @Override
    protected void browseListItem() {
        Log.println("Browse for Source filename ...");
        File dir = new File(Config.spacecraftDir);
        File file = SpacecraftEditorWindow.pickFile(dir, this, "Specify file", "Select", "format");
        if (file == null) {
            return;
        }
        String fileName = file.getName();
        try {
            TelemFormat tmpFormat = new TelemFormat(String.valueOf(Config.spacecraftDir) + File.separator + fileName);
            this.txtFilename.setText(tmpFormat.name);
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("ERROR", "Can not parse the format from format file: \n" + fileName + "\n" + e);
        }
    }

    @Override
    protected void loadTable() {
        this.dataLines = new ArrayList();
        int i = 0;
        while (i < this.sat.numberOfSources) {
            String[] dataToAdd = new String[this.listTableModel.getColumnCount()];
            dataToAdd[0] = "" + i;
            dataToAdd[1] = this.sat.sourceName != null && this.sat.sourceName[i] != null ? this.sat.sourceName[i] : "NONE";
            dataToAdd[2] = this.sat.sourceFormatName != null && this.sat.sourceFormatName[i] != null ? this.sat.sourceFormatName[i] : "NONE";
            this.dataLines.add(dataToAdd);
            ++i;
        }
    }

    @Override
    protected void saveTable() throws IOException, LayoutLoadException {
        this.sat.sourceFormat = new TelemFormat[this.dataLines.size()];
        this.sat.sourceName = new String[this.dataLines.size()];
        this.sat.numberOfSources = this.dataLines.size();
        this.sat.sourceFormatName = new String[this.dataLines.size()];
        int j = 0;
        while (j < this.dataLines.size()) {
            if (((String[])this.dataLines.get(j))[1] == null) {
                this.sat.sourceName[j] = null;
            } else {
                this.sat.sourceFormat[j] = Config.satManager.getFormatByName(((String[])this.dataLines.get(j))[2]);
                this.sat.sourceFormatName[j] = ((String[])this.dataLines.get(j))[2];
                this.sat.sourceName[j] = ((String[])this.dataLines.get(j))[1];
            }
            ++j;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (e.getSource() == this.table) {
            if (this.sat.numberOfSources == 0) {
                return;
            }
            int row = this.table.rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            int col = this.table.columnAtPoint(e.getPoint());
            if (row >= 0 && col >= 0) {
                try {
                    this.saveTable();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (LayoutLoadException e1) {
                    e1.printStackTrace();
                }
                Log.println("CLICKED SOURCE ROW: " + row + " and COL: " + col + " COUNT: " + e.getClickCount());
                String name = (String)this.table.getValueAt(row, 1);
                if (name != null && !name.equalsIgnoreCase("NONE")) {
                    if (this.sat.sourceFormat == null || this.sat.sourceFormat[row] == null) {
                        return;
                    }
                    System.out.println("Edit:" + this.sat.sourceFormat[row]);
                    this.updateSourceStats(row);
                }
            }
        }
    }

    private void updateSourceStats(int row) {
        if (this.sat.sourceFormat == null) {
            return;
        }
        if (this.sat.sourceFormat.length == 0) {
            return;
        }
        if (this.sat.sourceFormat[row] == null) {
            return;
        }
        int numRsWords = this.sat.sourceFormat[row].getInt("rs_words");
        int headerLength = this.sat.sourceFormat[row].getInt("header_length");
        int frameLength = this.sat.sourceFormat[row].getFrameLength();
        int dataLength = this.sat.sourceFormat[row].getInt("data_length");
        int trailerLength = 32 * numRsWords;
        this.labFrameLen.setText("Frame Length: " + frameLength);
        this.labHeaderLen.setText("Header Length: " + headerLength);
        this.labDataLen.setText("Data Length: " + dataLength);
        this.labRSWords.setText("RS Words: " + numRsWords);
        this.labTrailerLen.setText("Trailer Length: " + trailerLength);
        this.repaint();
    }
}

