/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor.listEditors;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import gui.ProgressPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import spacecraftEditor.SpacecraftEditorWindow;
import spacecraftEditor.listEditors.CsvFileEditorGrid;
import spacecraftEditor.listEditors.CsvTableModel;
import telemetry.LayoutLoadException;

public abstract class CsvFileEditPanel
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    protected String FILE_EXT = "csv";
    public CsvFileEditorGrid csvFileEditorGrid;
    protected CsvTableModel tableModel;
    JPanel centerPanel;
    protected JPanel footerPanel;
    protected JPanel footerFilePanel;
    ArrayList<String[]> dataLines;
    protected String filename;
    protected Spacecraft sat;
    JButton btnLoad;
    JButton btnAddAbove;
    JButton btnAddBelow;
    JButton btnRemove;
    JButton btnSave;
    JButton btnUp;
    JButton btnDown;
    JTextField csvFilename;

    public CsvFileEditPanel(Spacecraft sat, CsvTableModel model, String titleString, String file, String file_ext) {
        this.sat = sat;
        this.tableModel = model;
        this.filename = file;
        this.FILE_EXT = file_ext;
        this.setLayout(new BorderLayout());
        this.setTitle(titleString);
        this.csvFileEditorGrid = new CsvFileEditorGrid(model, this);
        this.add(this.csvFileEditorGrid);
        this.footerPanel = new JPanel();
        this.footerPanel.setLayout(new BoxLayout(this.footerPanel, 1));
        this.add((Component)this.footerPanel, "South");
        JPanel footerPanel1 = new JPanel();
        JPanel footerPanel2 = new JPanel();
        this.footerFilePanel = new JPanel();
        this.footerFilePanel.setLayout(new BorderLayout());
        this.footerPanel.add(this.footerFilePanel);
        this.footerFilePanel.add((Component)footerPanel1, "Center");
        this.footerPanel.add(footerPanel2);
        JLabel lf3 = new JLabel("Filename");
        this.csvFilename = new JTextField(this.filename);
        footerPanel1.add(lf3);
        footerPanel1.add(this.csvFilename);
        this.csvFilename.setEditable(false);
        this.csvFilename.setColumns(20);
        this.csvFilename.addMouseListener(this);
        this.btnLoad = new JButton("Load");
        this.btnUp = new JButton("Up");
        this.btnDown = new JButton("Down");
        this.btnAddAbove = new JButton("Add Above");
        this.btnAddBelow = new JButton("Add Below");
        this.btnRemove = new JButton("Remove");
        this.btnSave = new JButton("Save");
        footerPanel2.add(this.btnLoad);
        footerPanel2.add(this.btnUp);
        footerPanel2.add(this.btnDown);
        footerPanel2.add(this.btnAddAbove);
        footerPanel2.add(this.btnAddBelow);
        footerPanel2.add(this.btnRemove);
        footerPanel2.add(this.btnSave);
        this.btnLoad.addActionListener(this);
        this.btnUp.addActionListener(this);
        this.btnDown.addActionListener(this);
        this.btnAddAbove.addActionListener(this);
        this.btnAddBelow.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.btnSave.addActionListener(this);
        this.setFile(file);
        if (this.dataLines == null) {
            this.initData();
            return;
        }
    }

    protected abstract void updateSpacecraft();

    private void setTitle(String titleString) {
        TitledBorder title = new TitledBorder(null, titleString, 4, 2, null, null);
        title.setTitleFont(new Font("SansSerif", 1, 14));
        this.setBorder(title);
    }

    public void setFilenameText(String file) {
        this.csvFilename.setText(file);
        this.filename = file;
    }

    public boolean setFile(String file) {
        if (file != null) {
            ProgressPanel initProgress = null;
            initProgress = new ProgressPanel(MainWindow.frame, "Loading file " + this.filename + ", please wait ...", false);
            initProgress.setVisible(true);
            this.filename = file;
            this.csvFilename.setText(file);
            this.setTitle(" : " + file);
            try {
                this.load();
                initProgress.updateProgress(100);
                return true;
            }
            catch (FileNotFoundException e) {
                Log.errorDialog("ERROR", "Could not load CSV file:\n" + file + "\n" + e);
            }
            catch (LayoutLoadException e) {
                Log.errorDialog("ERROR", "Could not parse CSV file\n" + file + "\n" + e);
            }
            initProgress.updateProgress(100);
        }
        return false;
    }

    private void initData() {
        this.dataLines = new ArrayList();
        String[] line = new String[this.tableModel.getColumnCount()];
        int j = 0;
        while (j < line.length) {
            line[j] = "" + j;
            ++j;
        }
        this.dataLines.add(line);
        this.setData();
    }

    private void setData() {
        String[][] data = new String[this.dataLines.size()][this.tableModel.getColumnCount()];
        int j = 0;
        while (j < this.dataLines.size()) {
            data[j] = this.dataLines.get(j);
            ++j;
        }
        this.tableModel.setData(data);
    }

    protected void load() throws FileNotFoundException, LayoutLoadException {
        String fileName = String.valueOf(Config.spacecraftDir) + File.separator + this.filename;
        Log.println("Loading CSV File: " + fileName);
        BufferedReader dis = new BufferedReader(new FileReader(fileName));
        this.dataLines = new ArrayList();
        try {
            try {
                String line;
                while ((line = dis.readLine()) != null) {
                    if (line == null) continue;
                    String[] dataToAdd = new String[this.tableModel.getColumnCount()];
                    String[] lineOfdata = line.split(",");
                    int d = 0;
                    while (d < lineOfdata.length) {
                        if (d < this.tableModel.getColumnCount()) {
                            dataToAdd[d] = lineOfdata[d];
                        } else {
                            int n = this.tableModel.getColumnCount() - 1;
                            dataToAdd[n] = String.valueOf(dataToAdd[n]) + " " + lineOfdata[d];
                        }
                        ++d;
                    }
                    this.dataLines.add(dataToAdd);
                }
                this.setData();
                this.updateSpacecraft();
            }
            catch (NumberFormatException e) {
                Log.errorDialog("ERROR", "Error processing the CSV file\n" + e);
                try {
                    dis.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "Can not load the CSV file\n" + e);
                try {
                    dis.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save() throws IOException {
        if (this.filename == null) {
            Log.errorDialog("ERROR", "No filename is defined.  Nothing was saved.");
            return;
        }
        if (this.filename.equalsIgnoreCase("")) {
            Log.infoDialog("INFO", "Pick a filename to save this to first");
            return;
        }
        String fileName = String.valueOf(Config.spacecraftDir) + File.separator + this.filename;
        try (BufferedWriter dis = new BufferedWriter(new FileWriter(fileName, false));){
            int j = 0;
            while (j < this.dataLines.size()) {
                String line = "";
                int i = 0;
                while (i < this.dataLines.get(j).length - 1) {
                    line = this.dataLines.get(j)[i] == null ? String.valueOf(line) + "0," : String.valueOf(line) + this.dataLines.get(j)[i] + ",";
                    ++i;
                }
                line = this.dataLines.get(j)[this.dataLines.get(j).length - 1] == null ? String.valueOf(line) + " \n" : String.valueOf(line) + this.dataLines.get(j)[this.dataLines.get(j).length - 1] + "\n";
                dis.write(line);
                ++j;
            }
        }
        this.updateSpacecraft();
    }

    private void addRows(boolean above, int row, int num) {
        if (row == -1) {
            return;
        }
        if (above) {
            int i = 0;
            while (i < num) {
                String[] empty_row = new String[this.tableModel.getColumnCount()];
                this.dataLines.add(row, empty_row);
                ++i;
            }
        } else {
            int i = 0;
            while (i < num) {
                String[] empty_row = new String[this.tableModel.getColumnCount()];
                this.dataLines.add(row + num, empty_row);
                ++i;
            }
        }
        this.setData();
        this.csvFileEditorGrid.table.setRowSelectionInterval(row, row);
    }

    private void browseFile() {
        Log.println("Browse for File ...");
        File dir = new File(Config.spacecraftDir);
        File file = SpacecraftEditorWindow.pickFile(dir, this, "Specify file", "Select", this.FILE_EXT);
        if (file == null) {
            return;
        }
        this.csvFilename.setText(file.getName());
        this.filename = file.getName();
    }

    private void removeRow(int row) {
        Log.println("Removing row " + row);
        if (!this.tableModel.isCellEditable(row, 0)) {
            Log.errorDialog("ERROR", "This row is read only and cannot be removed!");
            return;
        }
        if (this.dataLines.size() == 0) {
            return;
        }
        this.dataLines.remove(row);
        this.setData();
        if (this.dataLines.size() == 0) {
            return;
        }
        if (row >= this.dataLines.size()) {
            this.csvFileEditorGrid.table.setRowSelectionInterval(row - 1, row - 1);
        } else {
            this.csvFileEditorGrid.table.setRowSelectionInterval(row, row);
        }
        try {
            this.save();
        }
        catch (IOException e1) {
            Log.errorDialog("ERROR", "Could not save the CSV file\n" + e1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row;
        if (e.getSource() == this.btnAddAbove) {
            Log.println("Adding Rows Above ...");
            if (this.dataLines == null) {
                this.initData();
                return;
            }
            if (this.dataLines.size() == 0) {
                return;
            }
            row = this.csvFileEditorGrid.table.getSelectedRow();
            this.addRows(true, row, this.csvFileEditorGrid.table.getSelectedRowCount());
        }
        if (e.getSource() == this.btnAddBelow) {
            Log.println("Adding Rows Below ...");
            if (this.dataLines == null) {
                this.initData();
                return;
            }
            if (this.dataLines.size() == 0) {
                return;
            }
            row = this.csvFileEditorGrid.table.getSelectedRow();
            this.addRows(false, row, this.csvFileEditorGrid.table.getSelectedRowCount());
        }
        if (e.getSource() == this.btnSave) {
            try {
                this.save();
            }
            catch (IOException e1) {
                Log.errorDialog("ERROR", "Could not save table to :" + this.filename + "\n" + e1);
            }
        }
        if (e.getSource() == this.btnLoad) {
            try {
                this.load();
            }
            catch (IOException e1) {
                Log.errorDialog("ERROR", "Could not load table from :" + this.filename + "\n" + e1);
            }
            catch (LayoutLoadException e1) {
                Log.errorDialog("ERROR", "Could not parse table from :" + this.filename + "\n" + e1);
            }
        }
        if (e.getSource() == this.btnRemove) {
            int i = 0;
            int[] nArray = this.csvFileEditorGrid.table.getSelectedRows();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int row2 = nArray[n2];
                this.removeRow(row2 - i++);
                ++n2;
            }
            try {
                this.save();
            }
            catch (IOException e1) {
                Log.errorDialog("ERROR", "Could not save the CSV file\n" + e1);
            }
        }
        if (e.getSource() == this.btnUp) {
            int row3 = this.csvFileEditorGrid.table.getSelectedRow();
            Log.println("Moving row up:" + row3);
            if (this.dataLines.size() == 0) {
                return;
            }
            if (row3 < 1) {
                return;
            }
            String[] line = this.dataLines.get(row3);
            this.dataLines.remove(row3);
            this.dataLines.add(row3 - 1, line);
            this.setData();
            this.csvFileEditorGrid.table.setRowSelectionInterval(row3 - 1, row3 - 1);
            try {
                this.save();
            }
            catch (IOException e1) {
                Log.errorDialog("ERROR", "Could not save the CSV file\n" + e1);
            }
        }
        if (e.getSource() == this.btnDown) {
            int row4 = this.csvFileEditorGrid.table.getSelectedRow();
            Log.println("Moving row down:" + row4);
            if (this.dataLines.size() == 0) {
                return;
            }
            if (row4 >= this.dataLines.size() - 1) {
                return;
            }
            String[] line = this.dataLines.get(row4);
            this.dataLines.remove(row4);
            this.dataLines.add(row4 + 1, line);
            this.setData();
            this.csvFileEditorGrid.table.setRowSelectionInterval(row4 + 1, row4 + 1);
            try {
                this.save();
            }
            catch (IOException e1) {
                Log.errorDialog("ERROR", "Could not save the CSV file\n" + e1);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.csvFilename) {
            this.browseFile();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

