/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor.listEditors.frames;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import spacecraftEditor.SpacecraftEditPanel;
import spacecraftEditor.SpacecraftEditorWindow;
import spacecraftEditor.TextEditorFrame;
import spacecraftEditor.listEditors.frames.FrameTableModel;
import spacecraftEditor.listEditors.frames.FramesTableModel;
import telemetry.BitArrayLayout;
import telemetry.LayoutLoadException;
import telemetry.SatPayloadStore;
import telemetry.frames.FrameLayout;

public class FrameListEditPanel
extends JPanel
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String FRAME_TEMPLATE_FILENAME = "FRAME_template.frame";
    SpacecraftEditPanel parent;
    Spacecraft sat;
    JTable frameListTable;
    JPanel rightPanel;
    FramesTableModel framesListTableModel;
    FrameTableModel frameTableModel;
    JTable frameTable;
    JButton btnAddFrame;
    JButton btnRemoveFrame;
    JButton btnBrowseFrame;
    JButton btnUpdateFrame;
    JTextField frameFilename;
    JTextField frameName;

    public FrameListEditPanel(Spacecraft sat, SpacecraftEditPanel parent) {
        this.sat = sat;
        this.parent = parent;
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(0, 0));
        JPanel rightPanel = this.addLeftPanel();
        this.add((Component)rightPanel, "West");
        JPanel centerPanel = this.addCenterPanel();
        this.add((Component)centerPanel, "Center");
        this.updateRow(0);
        if (this.frameListTable != null && this.frameListTable.getRowCount() > 0) {
            this.frameListTable.setRowSelectionInterval(0, 0);
        }
    }

    private void loadFramesTable() {
        String[][] data = new String[this.sat.numberOfFrameLayouts][3];
        int i = 0;
        while (i < this.sat.numberOfFrameLayouts) {
            data[i][0] = "" + i;
            data[i][1] = this.sat.frameLayout[i] != null ? this.sat.frameLayout[i].name : "NONE";
            data[i][2] = this.sat.frameLayoutFilename[i] != null ? this.sat.frameLayoutFilename[i] : "NONE";
            ++i;
        }
        if (this.sat.numberOfFrameLayouts > 0) {
            this.framesListTableModel.setData(data);
        } else {
            String[][] fakeRow = new String[][]{{"", "", "", ""}};
            this.framesListTableModel.setData(fakeRow);
        }
    }

    private void scrollToRow(JTable table, int row) {
        Rectangle cellRect = table.getCellRect(row, 0, false);
        if (cellRect != null) {
            table.scrollRectToVisible(cellRect);
        }
    }

    private JPanel addLeftPanel() {
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        JPanel leftPanel1 = new JPanel();
        leftPanel.add(leftPanel1);
        leftPanel1.setLayout(new BorderLayout());
        TitledBorder headingFrames = SpacecraftEditPanel.title("Frames");
        leftPanel1.setBorder(headingFrames);
        this.framesListTableModel = new FramesTableModel();
        this.frameListTable = new JTable(this.framesListTableModel);
        this.frameListTable.setAutoCreateRowSorter(true);
        JScrollPane scrollPane = new JScrollPane(this.frameListTable, 22, 31);
        scrollPane.setPreferredSize(new Dimension(100, 400));
        this.frameListTable.setFillsViewportHeight(true);
        leftPanel1.add((Component)scrollPane, "Center");
        TableColumn column = this.frameListTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(20);
        column = this.frameListTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(100);
        column = this.frameListTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(200);
        String PREV = "prev";
        String NEXT = "next";
        InputMap inMap = this.frameListTable.getInputMap(1);
        inMap.put(KeyStroke.getKeyStroke("UP"), PREV);
        inMap.put(KeyStroke.getKeyStroke("DOWN"), NEXT);
        ActionMap actMap = this.frameListTable.getActionMap();
        actMap.put(PREV, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = FrameListEditPanel.this.frameListTable.getSelectedRow();
                if (row > 0) {
                    FrameListEditPanel.this.updateRow(row - 1);
                    FrameListEditPanel.this.frameListTable.setRowSelectionInterval(row - 1, row - 1);
                    FrameListEditPanel.this.scrollToRow(FrameListEditPanel.this.frameListTable, row - 1);
                }
            }
        });
        actMap.put(NEXT, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = FrameListEditPanel.this.frameListTable.getSelectedRow();
                if (row < FrameListEditPanel.this.frameListTable.getRowCount() - 1) {
                    FrameListEditPanel.this.updateRow(row + 1);
                    FrameListEditPanel.this.frameListTable.setRowSelectionInterval(row + 1, row + 1);
                    FrameListEditPanel.this.scrollToRow(FrameListEditPanel.this.frameListTable, row + 1);
                }
            }
        });
        this.frameListTable.addMouseListener(this);
        this.loadFramesTable();
        JPanel footerPanel = new JPanel();
        leftPanel.add((Component)footerPanel, "South");
        footerPanel.setLayout(new BoxLayout(footerPanel, 1));
        JPanel footerPanelRow1 = new JPanel();
        footerPanelRow1.setLayout(new BoxLayout(footerPanelRow1, 0));
        footerPanel.add(footerPanelRow1);
        JPanel f1 = new JPanel();
        f1.setLayout(new BoxLayout(f1, 1));
        JLabel lf1 = new JLabel("Name");
        this.frameName = new JTextField();
        f1.add(lf1);
        f1.add(this.frameName);
        footerPanelRow1.add(f1);
        JPanel f3 = new JPanel();
        f3.setLayout(new BoxLayout(f3, 1));
        JLabel lf3 = new JLabel("Filename");
        this.frameFilename = new JTextField();
        f3.add(lf3);
        f3.add(this.frameFilename);
        this.frameFilename.setEditable(false);
        this.frameFilename.addMouseListener(this);
        footerPanelRow1.add(f3);
        JPanel footerPanelRow2 = new JPanel();
        footerPanel.add(footerPanelRow2);
        this.btnAddFrame = new JButton("Add");
        this.btnAddFrame.addActionListener(this);
        this.btnBrowseFrame = new JButton("Browse");
        this.btnBrowseFrame.addActionListener(this);
        this.btnRemoveFrame = new JButton("Remove");
        this.btnRemoveFrame.addActionListener(this);
        this.btnUpdateFrame = new JButton("Update");
        this.btnUpdateFrame.addActionListener(this);
        footerPanelRow2.add(this.btnAddFrame);
        footerPanelRow2.add(this.btnUpdateFrame);
        footerPanelRow2.add(this.btnRemoveFrame);
        this.btnAddFrame.setEnabled(true);
        this.btnRemoveFrame.setEnabled(true);
        leftPanel.add(new Box.Filler(new Dimension(500, 10), new Dimension(500, 400), new Dimension(500, 500)));
        return leftPanel;
    }

    private JPanel addCenterPanel() {
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
        TitledBorder heading2 = SpacecraftEditPanel.title("Frame");
        this.rightPanel.setBorder(heading2);
        return this.rightPanel;
    }

    private void addFrame() {
        String[] newFrameLayoutFilenames = new String[this.sat.numberOfFrameLayouts + 1];
        newFrameLayoutFilenames[this.sat.numberOfFrameLayouts] = this.frameFilename.getText();
        int i = 0;
        while (i < this.sat.numberOfFrameLayouts) {
            newFrameLayoutFilenames[i] = this.sat.frameLayoutFilename[i];
            ++i;
        }
        this.sat.frameLayoutFilename = newFrameLayoutFilenames;
        try {
            File dest = new File(String.valueOf(Config.spacecraftDir) + this.frameFilename.getText());
            if (!dest.isFile()) {
                File source = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + Spacecraft.SPACECRAFT_DIR + File.separator + "templates" + File.separator + FRAME_TEMPLATE_FILENAME);
                SatPayloadStore.copyFile(source, dest);
            }
            FrameLayout[] newFrameLayouts = new FrameLayout[this.sat.numberOfFrameLayouts + 1];
            newFrameLayouts[this.sat.numberOfFrameLayouts] = new FrameLayout(this.sat.foxId, this.frameFilename.getText());
            newFrameLayouts[this.sat.numberOfFrameLayouts].name = this.frameName.getText();
            int i2 = 0;
            while (i2 < this.sat.numberOfFrameLayouts) {
                newFrameLayouts[i2] = this.sat.frameLayout[i2];
                ++i2;
            }
            this.sat.frameLayout = newFrameLayouts;
            ++this.sat.numberOfFrameLayouts;
            this.parent.save();
            this.loadFramesTable();
            this.frameName.setText("");
            this.frameFilename.setText("");
        }
        catch (IOException e1) {
            Log.errorDialog("ERROR", "You need to specify a valid frame file\n" + e1);
        }
        catch (LayoutLoadException e1) {
            Log.errorDialog("ERROR", "Could not parse the frame template\n" + e1);
        }
    }

    private void browseFrame() {
        System.out.println("Browse for Frame ...");
        File dir = new File(Config.spacecraftDir);
        File file = SpacecraftEditorWindow.pickFile(dir, this, "Specify frame file", "Select", "frame");
        if (file == null) {
            return;
        }
        this.frameFilename.setText(file.getName());
    }

    private void updateRow(int row) {
        if (this.sat.frameLayout == null) {
            return;
        }
        if (this.sat.frameLayout.length == 0) {
            return;
        }
        this.frameName.setText(this.sat.frameLayout[row].name);
        this.frameFilename.setText(this.sat.frameLayoutFilename[row]);
        if (this.rightPanel != null) {
            this.remove(this.rightPanel);
        }
        this.rightPanel = new JPanel();
        this.add(this.rightPanel);
        this.rightPanel.setLayout(new BorderLayout());
        TitledBorder heading2 = SpacecraftEditPanel.title("Frame: " + this.sat.frameLayout[row].name);
        this.rightPanel.setBorder(heading2);
        JPanel stats = new JPanel();
        stats.setLayout(new BoxLayout(stats, 1));
        this.rightPanel.add((Component)stats, "North");
        int calculatedDataLength = 0;
        try {
            FrameLayout frameLayout = new FrameLayout(this.sat.foxId, this.sat.frameLayoutFilename[row]);
            if (frameLayout != null) {
                this.frameTableModel = new FrameTableModel();
                this.frameTable = new JTable(this.frameTableModel);
                this.frameTable.setAutoCreateRowSorter(true);
                JScrollPane scrollPane = new JScrollPane(this.frameTable, 22, 31);
                scrollPane.setPreferredSize(new Dimension(100, 400));
                this.frameTable.setFillsViewportHeight(true);
                this.rightPanel.add((Component)scrollPane, "Center");
                TableColumn column = this.frameTable.getColumnModel().getColumn(0);
                column.setPreferredWidth(20);
                column = this.frameTable.getColumnModel().getColumn(1);
                column.setPreferredWidth(160);
                int i = 0;
                while (i < this.frameTable.getColumnModel().getColumnCount()) {
                    TableColumn column2 = this.frameTable.getColumnModel().getColumn(i);
                    column2.setCellRenderer(new FrameTableCellRenderer());
                    ++i;
                }
                this.setPayloadComboBox();
                this.frameTable.addMouseListener(this);
                int numOfPayloads = frameLayout.getNumberOfPayloads();
                String[][] data = new String[numOfPayloads][3];
                int i2 = 0;
                while (i2 < numOfPayloads) {
                    data[i2][0] = "" + i2;
                    data[i2][1] = frameLayout.getPayloadName(i2);
                    int len = frameLayout.getPayloadLength(i2);
                    calculatedDataLength += len;
                    data[i2][2] = "" + len;
                    ++i2;
                }
                this.frameTableModel.setData(data);
                if (this.sat.sourceFormat == null || this.sat.sourceFormat.length == 0 || this.sat.sourceFormat[this.parent.sourceFormatSelected] == null) {
                    Log.errorDialog("MISSING", "For " + this.sat + " Source Format is missing or incorrect.  Can't calculate frame lengths\n" + "While not fatal, you are missing that diagnostic information in the editor.\n" + "Pick a valid source format on the paramaters tab.");
                } else {
                    int headerLength = this.sat.sourceFormat[this.parent.sourceFormatSelected].getInt("header_length");
                    int frameLength = this.sat.sourceFormat[this.parent.sourceFormatSelected].getFrameLength();
                    int dataLength = this.sat.sourceFormat[this.parent.sourceFormatSelected].getInt("data_length");
                    int trailerLength = this.sat.sourceFormat[this.parent.sourceFormatSelected].getTrailerLength();
                    int calculatedFrameLength = (calculatedDataLength += headerLength) + trailerLength;
                    JLabel labFrameLen = new JLabel("Length of this frame: " + calculatedFrameLength + "   ( Format: " + frameLength + " )");
                    if (frameLength < calculatedFrameLength) {
                        labFrameLen.setForeground(Config.AMSAT_RED);
                    }
                    JLabel labHeaderLen = new JLabel("Header Length: " + headerLength);
                    JLabel labDataLen = new JLabel("Data Length: " + calculatedDataLength + "   ( Format: " + dataLength + " )");
                    if (dataLength < calculatedDataLength) {
                        labDataLen.setForeground(Config.AMSAT_RED);
                    }
                    JLabel labTrailerLen = new JLabel("Trailer Length: " + trailerLength);
                    stats.add(labFrameLen);
                    stats.add(labHeaderLen);
                    stats.add(labDataLen);
                    stats.add(labTrailerLen);
                }
            }
            this.rightPanel.revalidate();
            this.rightPanel.repaint();
        }
        catch (LayoutLoadException e1) {
            Log.errorDialog("ERROR", "Error in the frame layout\n" + e1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row;
        if (e.getSource() == this.btnAddFrame) {
            System.out.println("Adding Frame ...");
            this.addFrame();
        }
        if (e.getSource() == this.btnBrowseFrame) {
            this.browseFrame();
        }
        if (e.getSource() == this.btnUpdateFrame) {
            row = this.frameListTable.getSelectedRow();
            System.out.println("Updating row " + row);
            if (this.sat.numberOfFrameLayouts == 0) {
                return;
            }
            try {
                this.sat.frameLayout[row] = new FrameLayout(this.sat.foxId, this.frameFilename.getText());
                this.sat.frameLayoutFilename[row] = this.frameFilename.getText();
                this.sat.frameLayout[row].name = this.frameName.getText();
                this.parent.save();
                this.loadFramesTable();
                this.frameName.setText("");
                this.frameFilename.setText("");
            }
            catch (LayoutLoadException e1) {
                Log.errorDialog("ERROR", "Could not load the payload file\n" + e1);
            }
        }
        if (e.getSource() == this.btnRemoveFrame) {
            row = this.frameListTable.getSelectedRow();
            System.out.println("Removing row " + row);
            if (this.sat.numberOfFrameLayouts == 0) {
                return;
            }
            if (row == -1) {
                Log.infoDialog("Select a row", "Select a frame in the table to remove\n");
                return;
            }
            int n = Log.optionYNdialog("Remove Frame layout file too?", "Remove this frame layout file as well as the frame table row?\n" + this.frameFilename.getText() + "\n\n" + "If this file is used by other rows or spacecraft then click No.  Otherwise this file will be gone forever.\n");
            if (n != 1) {
                File file = new File(String.valueOf(Config.spacecraftDir) + this.frameFilename.getText());
                System.out.println("Removing: " + file.getAbsolutePath());
                try {
                    SatPayloadStore.remove(file.getAbsolutePath());
                }
                catch (IOException ef) {
                    Log.errorDialog("ERROR removing File", "\nCould not remove the frame layout file\n" + ef.getMessage());
                }
            }
            if (this.sat.numberOfFrameLayouts == 1) {
                this.sat.numberOfFrameLayouts = 0;
                this.sat.frameLayout = null;
                this.sat.frameLayoutFilename = null;
            } else {
                int j = 0;
                FrameLayout[] newLayouts = new FrameLayout[this.sat.numberOfFrameLayouts - 1];
                int i = 0;
                while (i < this.sat.numberOfFrameLayouts) {
                    if (i != row) {
                        newLayouts[j++] = this.sat.frameLayout[i];
                    }
                    ++i;
                }
                this.sat.frameLayout = newLayouts;
                j = 0;
                String[] newLayoutFilenames = new String[this.sat.numberOfFrameLayouts - 1];
                int i2 = 0;
                while (i2 < this.sat.numberOfFrameLayouts) {
                    if (i2 != row) {
                        newLayoutFilenames[j++] = this.sat.frameLayoutFilename[i2];
                    }
                    ++i2;
                }
                this.sat.frameLayoutFilename = newLayoutFilenames;
                --this.sat.numberOfFrameLayouts;
            }
            this.parent.save();
            this.loadFramesTable();
            this.frameName.setText("");
            this.frameFilename.setText("");
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.frameFilename) {
            this.browseFrame();
        }
        if (e.getSource() == this.frameListTable) {
            int row = this.frameListTable.rowAtPoint(e.getPoint());
            int col = this.frameListTable.columnAtPoint(e.getPoint());
            if (row >= 0 && col >= 0) {
                Log.println("CLICKED ROW: " + row + " and COL: " + col + " COUNT: " + e.getClickCount());
                String masterFolder = Config.spacecraftDir;
                if (e.getClickCount() == 2) {
                    TextEditorFrame editor = new TextEditorFrame(this.sat, String.valueOf(masterFolder) + File.separator + this.sat.frameLayoutFilename[row]);
                    editor.setVisible(true);
                }
                this.updateRow(row);
            }
        }
    }

    public void setPayloadComboBox() {
        String[] payloads = this.sat.getPayloadList();
        JComboBox<String> payloadBox = new JComboBox<String>(payloads);
        TableColumn moduleColumn = this.frameTable.getColumnModel().getColumn(1);
        moduleColumn.setCellEditor(new DefaultCellEditor(payloadBox));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public class FrameTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            if (row > 0 && column == 1) {
                String value = (String)FrameListEditPanel.this.frameTableModel.getValueAt(row, column);
                BitArrayLayout lay = FrameListEditPanel.this.sat.getLayoutByName(value);
                if (lay == null) {
                    cell.setForeground(Color.red);
                    return cell;
                }
                cell.setForeground(Color.black);
            }
            return cell;
        }
    }
}

