/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor.listEditors.payload;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.tabs.CanExperimentTab;
import gui.tabs.FoxTelemTab;
import gui.tabs.HealthTabRt;
import gui.tabs.NamedExperimentTab;
import gui.tabs.WodHealthTab;
import gui.tabs.WodNamedExperimentTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import spacecraftEditor.SpacecraftEditPanel;
import spacecraftEditor.SpacecraftEditorWindow;
import spacecraftEditor.listEditors.payload.PayloadCsvFileEditPanel;
import spacecraftEditor.listEditors.payload.PayloadLayoutTableModel;
import spacecraftEditor.listEditors.payload.PayloadListTableModel;
import telemetry.BitArrayLayout;
import telemetry.LayoutLoadException;
import telemetry.SatPayloadStore;

public class PayloadListEditPanel
extends JPanel
implements MouseListener,
ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    public static final String PAYLOAD_TEMPLATE_FILENAME = "PAYLOAD_template.csv";
    SpacecraftEditPanel parent;
    Spacecraft sat;
    JTabbedPane tabbedPane;
    JTable payloadsTable;
    JPanel rightPanel;
    JPanel rightPanel1;
    PayloadCsvFileEditPanel payloadCsvFileEditPanel;
    PayloadListTableModel layoutsListTableModel;
    JComboBox<String> payloadType;
    JButton btnAddPayload;
    JButton btnRemovePayload;
    JButton btnBrowsePayload;
    JButton btnUpdatePayload;
    JButton btnGeneratePayload;
    JTextField payloadFilename;
    JTextField payloadName;
    JTextField tabName;
    JTextField title;
    JTextField parentPayload;
    JTextArea codeTextArea;
    JCheckBox hasGPSTime;
    FoxTelemTab modulesTab;
    JPanel tab = new JPanel();

    public PayloadListEditPanel(Spacecraft sat, SpacecraftEditPanel parent) {
        this.sat = sat;
        this.parent = parent;
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(0, 0));
        JPanel rightPanel = this.addLeftPanel();
        this.add((Component)rightPanel, "West");
        this.tabbedPane = this.addCenterPanel();
        this.add((Component)this.tabbedPane, "Center");
        this.updateTabs(0);
        if (this.payloadsTable.getRowCount() > 0) {
            this.payloadsTable.setRowSelectionInterval(0, 0);
        }
    }

    private void savePayloadsListTable() throws FileNotFoundException, LayoutLoadException {
        this.sat.layout = new BitArrayLayout[this.layoutsListTableModel.getRowCount()];
        this.sat.numberOfLayouts = this.layoutsListTableModel.getRowCount();
        this.sat.layoutFilename = new String[this.layoutsListTableModel.getRowCount()];
        int j = 0;
        while (j < this.layoutsListTableModel.getRowCount()) {
            if (this.layoutsListTableModel.getValueAt(j, 1) == null) {
                this.sat.layout[j] = null;
            } else {
                this.sat.layoutFilename[j] = (String)this.layoutsListTableModel.getValueAt(j, 2);
                this.sat.layout[j] = new BitArrayLayout(String.valueOf(Config.spacecraftDir) + File.separator + this.sat.layoutFilename[j]);
                this.sat.layout[j].name = (String)this.layoutsListTableModel.getValueAt(j, 1);
                this.sat.layout[j].typeStr = (String)this.layoutsListTableModel.getValueAt(j, 3);
                this.sat.layout[j].shortTitle = (String)this.layoutsListTableModel.getValueAt(j, 4);
                this.sat.layout[j].title = (String)this.layoutsListTableModel.getValueAt(j, 5);
                this.sat.layout[j].parentLayout = (String)this.layoutsListTableModel.getValueAt(j, 6);
                this.sat.layout[j].hasGPSTime = Boolean.parseBoolean((String)this.layoutsListTableModel.getValueAt(j, 7));
            }
            ++j;
        }
        this.parent.save();
    }

    private void loadPayloadsListTable() {
        String[][] data = new String[this.sat.numberOfLayouts][this.layoutsListTableModel.getColumnCount()];
        int i = 0;
        while (i < this.sat.numberOfLayouts) {
            data[i][0] = "" + i;
            if (this.sat.layout[i] != null) {
                data[i][1] = this.sat.layout[i].name != null ? this.sat.layout[i].name : "NONE";
                data[i][2] = i < this.sat.layoutFilename.length && this.sat.layoutFilename[i] != null ? this.sat.layoutFilename[i] : "-";
                data[i][3] = this.sat.layout[i].typeStr;
                data[i][4] = this.sat.layout[i].shortTitle != null ? this.sat.layout[i].shortTitle : "";
                data[i][5] = this.sat.layout[i].title != null ? this.sat.layout[i].title : "";
                data[i][6] = this.sat.layout[i].parentLayout != null ? this.sat.layout[i].parentLayout : "";
                data[i][7] = "" + this.sat.layout[i].hasGPSTime;
            }
            ++i;
        }
        if (this.sat.numberOfLayouts > 0) {
            this.layoutsListTableModel.setData(data);
        } else {
            String[][] fakeRow = new String[][]{{"", "", "", "", "", "", "", ""}};
            this.layoutsListTableModel.setData(fakeRow);
        }
    }

    private void scrollToRow(JTable table, int row) {
        Rectangle cellRect = table.getCellRect(row, 0, false);
        if (cellRect != null) {
            table.scrollRectToVisible(cellRect);
        }
    }

    private JPanel addLeftPanel() {
        JPanel centerPanel = new JPanel();
        JPanel centerPanel2 = new JPanel();
        centerPanel.add(centerPanel2);
        centerPanel2.setLayout(new BorderLayout());
        TitledBorder headingLayout = SpacecraftEditPanel.title("Payloads");
        centerPanel2.setBorder(headingLayout);
        this.layoutsListTableModel = new PayloadListTableModel();
        this.payloadsTable = new JTable(this.layoutsListTableModel);
        this.payloadsTable.setAutoCreateRowSorter(true);
        JScrollPane scrollPane = new JScrollPane(this.payloadsTable, 22, 31);
        scrollPane.setPreferredSize(new Dimension(100, 400));
        this.payloadsTable.setFillsViewportHeight(true);
        centerPanel2.add((Component)scrollPane, "Center");
        TableColumn column = this.payloadsTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(20);
        column = this.payloadsTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(100);
        column = this.payloadsTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(200);
        column = this.payloadsTable.getColumnModel().getColumn(3);
        column.setPreferredWidth(40);
        TableColumnModel tcm = this.payloadsTable.getColumnModel();
        tcm.removeColumn(tcm.getColumn(4));
        tcm.removeColumn(tcm.getColumn(4));
        tcm.removeColumn(tcm.getColumn(4));
        this.payloadsTable.addMouseListener(this);
        String PREV = "prev";
        String NEXT = "next";
        InputMap inMap = this.payloadsTable.getInputMap(1);
        inMap.put(KeyStroke.getKeyStroke("UP"), PREV);
        inMap.put(KeyStroke.getKeyStroke("DOWN"), NEXT);
        ActionMap actMap = this.payloadsTable.getActionMap();
        actMap.put(PREV, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = PayloadListEditPanel.this.payloadsTable.getSelectedRow();
                if (row > 0) {
                    PayloadListEditPanel.this.updateTabs(row - 1);
                    PayloadListEditPanel.this.payloadsTable.setRowSelectionInterval(row - 1, row - 1);
                    PayloadListEditPanel.this.scrollToRow(PayloadListEditPanel.this.payloadsTable, row - 1);
                }
            }
        });
        actMap.put(NEXT, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = PayloadListEditPanel.this.payloadsTable.getSelectedRow();
                if (row < PayloadListEditPanel.this.payloadsTable.getRowCount() - 1) {
                    PayloadListEditPanel.this.updateTabs(row + 1);
                    PayloadListEditPanel.this.payloadsTable.setRowSelectionInterval(row + 1, row + 1);
                    PayloadListEditPanel.this.scrollToRow(PayloadListEditPanel.this.payloadsTable, row + 1);
                }
            }
        });
        this.loadPayloadsListTable();
        JPanel footerPanel = new JPanel();
        centerPanel2.add((Component)footerPanel, "South");
        footerPanel.setLayout(new BoxLayout(footerPanel, 1));
        JPanel footerPanelRow1 = new JPanel();
        footerPanelRow1.setLayout(new BoxLayout(footerPanelRow1, 0));
        footerPanel.add(footerPanelRow1);
        JPanel f1 = new JPanel();
        f1.setLayout(new BoxLayout(f1, 1));
        JLabel lf1 = new JLabel("Name");
        this.payloadName = new JTextField();
        f1.add(lf1);
        f1.add(this.payloadName);
        footerPanelRow1.add(f1);
        JPanel f2 = new JPanel();
        f2.setLayout(new BoxLayout(f2, 1));
        JLabel lf2 = new JLabel("Tab Type");
        this.payloadType = new JComboBox<String>(BitArrayLayout.types);
        this.payloadType.addActionListener(this);
        this.payloadType.setSelectedIndex(0);
        f2.add(lf2);
        f2.add(this.payloadType);
        footerPanelRow1.add(f2);
        JPanel f3 = new JPanel();
        f3.setLayout(new BoxLayout(f3, 1));
        JLabel lf3 = new JLabel("Filename");
        this.payloadFilename = new JTextField();
        f3.add(lf3);
        f3.add(this.payloadFilename);
        this.payloadFilename.setEditable(false);
        this.payloadFilename.addMouseListener(this);
        footerPanelRow1.add(f3);
        JPanel footerPanelRow15 = new JPanel();
        footerPanel.add(footerPanelRow15);
        JPanel f15 = new JPanel();
        f15.setLayout(new BoxLayout(f15, 1));
        JLabel lf15 = new JLabel("Tab Name");
        this.tabName = new JTextField();
        f15.add(lf15);
        f15.add(this.tabName);
        footerPanelRow15.add(f15);
        JPanel f35 = new JPanel();
        f35.setLayout(new BoxLayout(f35, 1));
        JLabel lf35 = new JLabel("Parent");
        this.parentPayload = new JTextField();
        f35.add(lf35);
        f35.add(this.parentPayload);
        footerPanelRow15.add(f35);
        JPanel f25 = new JPanel();
        f25.setLayout(new BoxLayout(f25, 1));
        JLabel lf25 = new JLabel("Title");
        this.title = new JTextField();
        this.title.setColumns(30);
        f25.add(lf25);
        f25.add(this.title);
        footerPanelRow15.add(f25);
        JPanel footerPanelRow16 = new JPanel();
        footerPanel.add(footerPanelRow16);
        this.hasGPSTime = new JCheckBox("Has GPS TIme");
        this.hasGPSTime.setEnabled(this.sat.hasGPSTime);
        this.hasGPSTime.addItemListener(this);
        this.hasGPSTime.setToolTipText("Set to true if this payload contains the GPS time");
        footerPanelRow16.add(this.hasGPSTime);
        JPanel footerPanelRow2 = new JPanel();
        footerPanel.add(footerPanelRow2);
        this.btnAddPayload = new JButton("Add");
        this.btnAddPayload.addActionListener(this);
        this.btnBrowsePayload = new JButton("Browse");
        this.btnBrowsePayload.addActionListener(this);
        this.btnRemovePayload = new JButton("Remove");
        this.btnRemovePayload.addActionListener(this);
        this.btnUpdatePayload = new JButton("Update");
        this.btnUpdatePayload.addActionListener(this);
        this.btnGeneratePayload = new JButton("Re-Generate ->");
        this.btnGeneratePayload.addActionListener(this);
        footerPanelRow2.add(this.btnAddPayload);
        footerPanelRow2.add(this.btnUpdatePayload);
        footerPanelRow2.add(this.btnRemovePayload);
        footerPanelRow2.add(this.btnGeneratePayload);
        this.btnAddPayload.setEnabled(true);
        if (this.sat.numberOfLayouts == 0) {
            this.btnRemovePayload.setEnabled(false);
        }
        footerPanel.add(new Box.Filler(new Dimension(400, 10), new Dimension(400, 400), new Dimension(400, 500)));
        return centerPanel;
    }

    private JTabbedPane addCenterPanel() {
        this.tabbedPane = new JTabbedPane(3);
        this.tabbedPane.setTabLayoutPolicy(1);
        this.add((Component)this.tabbedPane, "Center");
        PayloadLayoutTableModel payloadTableModel = new PayloadLayoutTableModel();
        this.payloadCsvFileEditPanel = new PayloadCsvFileEditPanel(this.sat, payloadTableModel, "Payload", null);
        this.codeTextArea = new JTextArea();
        JScrollPane scpane = new JScrollPane(this.codeTextArea);
        this.codeTextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.codeTextArea.setLineWrap(true);
        this.codeTextArea.setWrapStyleWord(true);
        this.codeTextArea.setEditable(true);
        this.codeTextArea.setVisible(true);
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>Payload</b></body></html>", this.payloadCsvFileEditPanel);
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>Code</b></body></html>", this.codeTextArea);
        this.tab.setLayout(new BorderLayout());
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>Modules</b></body></html>", this.tab);
        this.updateTabs(0);
        return this.tabbedPane;
    }

    private void updateTabs(int row) {
        if (this.sat == null || this.sat.layoutFilename == null || this.sat.layoutFilename.length == 0) {
            return;
        }
        this.payloadName.setText(this.sat.layout[row].name);
        this.payloadFilename.setText(this.sat.layoutFilename[row]);
        this.payloadType.setSelectedItem(this.sat.layout[row].typeStr);
        if (this.sat.layout[row].shortTitle != null) {
            this.tabName.setText(this.sat.layout[row].shortTitle);
        } else {
            this.tabName.setText("");
        }
        if (this.sat.layout[row].title != null) {
            this.title.setText(this.sat.layout[row].title);
        } else {
            this.title.setText("");
        }
        if (this.sat.layout[row].parentLayout != null) {
            this.parentPayload.setText(this.sat.layout[row].parentLayout);
        } else {
            this.parentPayload.setText("");
        }
        this.hasGPSTime.setSelected(this.sat.layout[row].hasGPSTime);
        this.payloadCsvFileEditPanel.setFile(this.sat.layoutFilename[row]);
        try {
            this.savePayloadsListTable();
        }
        catch (IOException e1) {
            Log.errorDialog("ERROR", "Error saving details to file\n" + e1);
        }
        catch (LayoutLoadException e2) {
            Log.errorDialog("ERROR", "Error saving table\n" + e2);
        }
        this.loadPayloadsListTable();
        this.generatePayload();
        this.generateTab(row);
    }

    private void generateTab(int row) {
        BitArrayLayout canPktLayout;
        if (this.modulesTab != null) {
            this.tab.remove(this.modulesTab);
        }
        BitArrayLayout lay = this.sat.layout[row];
        BitArrayLayout secondaryLayout = this.sat.getSecondaryLayoutFromPrimaryName(lay.name);
        String title = "Experiment: " + lay.name;
        if (lay.title != null) {
            title = lay.title;
        }
        if (lay.isRealTime() || lay.isMAX() || lay.isMIN()) {
            try {
                this.modulesTab = new HealthTabRt(this.sat);
            }
            catch (LayoutLoadException e) {
                Log.errorDialog("ERROR loading health tab", "" + e);
            }
        }
        if (lay.isWOD()) {
            try {
                this.modulesTab = new WodHealthTab(this.sat);
            }
            catch (LayoutLoadException e) {
                Log.errorDialog("ERROR loading WOD tab", "" + e);
            }
        }
        if (lay.isExperiment()) {
            this.modulesTab = new NamedExperimentTab(this.sat, title, lay, secondaryLayout, 5);
        }
        if (lay.isWODExperiment()) {
            this.modulesTab = new WodNamedExperimentTab(this.sat, title, lay, secondaryLayout, 8);
        }
        if (lay.isCanExperiment()) {
            canPktLayout = this.sat.hasFOXDB_V3 ? this.sat.getLayoutByType("CAN_PKT") : Config.satManager.getLayoutByName(this.sat.foxId, "canpacket");
            this.modulesTab = new CanExperimentTab(this.sat, title, lay, canPktLayout, 5);
        }
        if (lay.isCanWodExperiment()) {
            canPktLayout = this.sat.hasFOXDB_V3 ? this.sat.getLayoutByType("WOD_CAN_PKT") : Config.satManager.getLayoutByName(this.sat.foxId, "wodcanpacket");
            this.modulesTab = new CanExperimentTab(this.sat, title, lay, canPktLayout, 5);
        }
        if (this.modulesTab != null) {
            this.tab.add((Component)this.modulesTab, "Center");
            this.tabbedPane.repaint();
        }
    }

    private void addPayload() {
        try {
            File dest = new File(String.valueOf(Config.spacecraftDir) + this.payloadFilename.getText());
            if (!dest.isFile()) {
                File source = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + Spacecraft.SPACECRAFT_DIR + File.separator + "templates" + File.separator + PAYLOAD_TEMPLATE_FILENAME);
                SatPayloadStore.copyFile(source, dest);
            }
            String[] newLayoutFilenames = new String[this.sat.numberOfLayouts + 1];
            newLayoutFilenames[this.sat.numberOfLayouts] = this.payloadFilename.getText();
            int i = 0;
            while (i < this.sat.numberOfLayouts) {
                newLayoutFilenames[i] = this.sat.layoutFilename[i];
                ++i;
            }
            this.sat.layoutFilename = newLayoutFilenames;
            BitArrayLayout[] newLayouts = new BitArrayLayout[this.sat.numberOfLayouts + 1];
            newLayouts[this.sat.numberOfLayouts] = new BitArrayLayout(String.valueOf(Config.spacecraftDir) + File.separator + this.payloadFilename.getText());
            newLayouts[this.sat.numberOfLayouts].name = this.payloadName.getText();
            newLayouts[this.sat.numberOfLayouts].shortTitle = this.tabName.getText();
            newLayouts[this.sat.numberOfLayouts].title = this.title.getText();
            newLayouts[this.sat.numberOfLayouts].parentLayout = this.parentPayload.getText();
            newLayouts[this.sat.numberOfLayouts].hasGPSTime = this.hasGPSTime.isSelected();
            newLayouts[this.sat.numberOfLayouts].typeStr = (String)this.payloadType.getSelectedItem();
            int i2 = 0;
            while (i2 < this.sat.numberOfLayouts) {
                newLayouts[i2] = this.sat.layout[i2];
                ++i2;
            }
            this.sat.layout = newLayouts;
            ++this.sat.numberOfLayouts;
            this.loadPayloadsListTable();
            this.savePayloadsListTable();
            this.payloadCsvFileEditPanel.setFile(this.payloadFilename.getText());
            this.payloadName.setText("");
            this.payloadFilename.setText("");
            this.payloadType.setSelectedIndex(0);
        }
        catch (IOException e1) {
            Log.errorDialog("ERROR", "You need to specify a valid payload file\n" + e1);
        }
        catch (LayoutLoadException e1) {
            Log.errorDialog("ERROR", "Could not parse the payload template\n" + e1);
        }
    }

    private void browsePayload() {
        Log.println("Browse for Payload ...");
        File dir = new File(Config.spacecraftDir);
        File file = SpacecraftEditorWindow.pickFile(dir, this, "Specify payload file", "Select", "csv");
        if (file == null) {
            return;
        }
        this.payloadFilename.setText(file.getName());
    }

    private void generatePayload() {
        Log.println("Generate Payload ...");
        if (Config.python.equalsIgnoreCase("")) {
            this.codeTextArea.setText("C code is generated with a python script.  Setup the path to python on File > Setings screen");
            return;
        }
        if (Config.payloadHeaderGenScript.equalsIgnoreCase("")) {
            this.codeTextArea.setText("C code is generated with a python script.  Setup the script name on File > Setings screen");
            return;
        }
        File layout = new File(String.valueOf(Config.spacecraftDir) + File.separator + this.payloadFilename.getText());
        if (!layout.isFile()) {
            Log.errorDialog("ERROR", "Select a row with a valid payload file\n");
            return;
        }
        String SCRIPT = String.valueOf(System.getProperty("user.dir")) + File.separator + "gen_header.py";
        String COMMAND = String.valueOf(Config.python) + " " + SCRIPT + " " + this.payloadName.getText() + " " + layout;
        Log.println(" running: " + COMMAND);
        String s = null;
        boolean failed = false;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(COMMAND);
        }
        catch (IOException e1) {
            failed = true;
        }
        if (p != null) {
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            this.codeTextArea.setText(null);
            try {
                while ((s = stdInput.readLine()) != null) {
                    this.codeTextArea.append(String.valueOf(s) + "\n");
                }
            }
            catch (IOException e) {
                this.codeTextArea.append("Could not read command output\n" + e + "\n");
            }
            Log.println("Here is the standard error of the code generation (if any):\n");
            try {
                while ((s = stdError.readLine()) != null) {
                    this.codeTextArea.append(String.valueOf(s) + "\n");
                    Log.println(s);
                }
            }
            catch (IOException e) {
                this.codeTextArea.append("Could not read command errors\n" + e + "\n");
            }
        }
        if (failed) {
            Log.errorDialog("ERROR", "Error could not run the python generate script:\n" + COMMAND + "\n" + "Make sure python is in the path or put the full path to python on the File > Settings screen\n");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block40: {
            String typeStr;
            if (e.getSource() != this.payloadType) break block40;
            switch (typeStr = (String)this.payloadType.getSelectedItem()) {
                case "RT": {
                    this.payloadName.setText("rttelemetry");
                    this.payloadName.setEditable(false);
                    break;
                }
                case "MAX": {
                    this.payloadName.setText("maxtelemetry");
                    this.payloadName.setEditable(false);
                    break;
                }
                case "MIN": {
                    this.payloadName.setText("mintelemetry");
                    this.payloadName.setEditable(false);
                    break;
                }
                case "WOD": {
                    this.payloadName.setText("wodtelemetry");
                    this.payloadName.setEditable(false);
                    break;
                }
                default: {
                    this.payloadName.setEditable(true);
                }
            }
        }
        if (e.getSource() == this.btnAddPayload) {
            Log.println("Adding Payload ...");
            this.addPayload();
        }
        if (e.getSource() == this.btnBrowsePayload) {
            this.browsePayload();
        }
        if (e.getSource() == this.btnUpdatePayload) {
            int row = this.payloadsTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            Log.println("Updating row " + row);
            if (this.sat.numberOfLayouts == 0) {
                return;
            }
            try {
                this.sat.layout[row] = new BitArrayLayout(String.valueOf(Config.spacecraftDir) + File.separator + this.payloadFilename.getText());
                this.sat.layoutFilename[row] = this.payloadFilename.getText();
                this.sat.layout[row].name = this.payloadName.getText();
                this.sat.layout[row].shortTitle = this.tabName.getText();
                this.sat.layout[row].title = this.title.getText();
                this.sat.layout[row].parentLayout = this.parentPayload.getText();
                this.sat.layout[row].typeStr = (String)this.payloadType.getSelectedItem();
                this.sat.layout[row].hasGPSTime = this.hasGPSTime.isSelected();
                this.loadPayloadsListTable();
                this.savePayloadsListTable();
                this.payloadName.setText("");
                this.payloadFilename.setText("");
                this.payloadType.setSelectedIndex(0);
            }
            catch (FileNotFoundException e1) {
                Log.errorDialog("ERROR", "Could not initilize the payload file\n" + e1);
            }
            catch (LayoutLoadException e1) {
                Log.errorDialog("ERROR", "Could not load the payload file\n" + e1);
            }
        }
        if (e.getSource() == this.btnRemovePayload) {
            int row = this.payloadsTable.getSelectedRow();
            Log.println("Removing row " + row);
            if (this.sat.numberOfLayouts == 0) {
                return;
            }
            int n = Log.optionYNdialog("Remove payload file too?", "Remove this payload file as well as the payload table row?\n" + this.payloadFilename.getText() + "\n\n" + "If this file is used by other rows or spacecraft then click No.  Otherwise this file will be gone forever.\n");
            if (n != 1) {
                File file = new File(String.valueOf(Config.spacecraftDir) + this.payloadFilename.getText());
                try {
                    SatPayloadStore.remove(file.getAbsolutePath());
                }
                catch (IOException ef) {
                    Log.errorDialog("ERROR removing File", "\nCould not remove the payload file\n" + ef.getMessage());
                }
            }
            if (this.sat.numberOfLayouts == 1) {
                this.sat.numberOfLayouts = 0;
                this.sat.layout = null;
                this.sat.layoutFilename = null;
            } else {
                int j = 0;
                BitArrayLayout[] newLayouts = new BitArrayLayout[this.sat.numberOfLayouts - 1];
                int i = 0;
                while (i < this.sat.numberOfLayouts) {
                    if (i != row) {
                        newLayouts[j++] = this.sat.layout[i];
                    }
                    ++i;
                }
                this.sat.layout = newLayouts;
                j = 0;
                String[] newLayoutFilenames = new String[this.sat.numberOfLayouts - 1];
                int i2 = 0;
                while (i2 < this.sat.numberOfLayouts) {
                    if (i2 != row) {
                        newLayoutFilenames[j++] = this.sat.layoutFilename[i2];
                    }
                    ++i2;
                }
                this.sat.layoutFilename = newLayoutFilenames;
                --this.sat.numberOfLayouts;
            }
            this.loadPayloadsListTable();
            try {
                this.savePayloadsListTable();
            }
            catch (IOException e1) {
                Log.errorDialog("ERROR", "Error saving details to file\n" + e1);
            }
            catch (LayoutLoadException e2) {
                Log.errorDialog("ERROR", "Error saving table\n" + e2);
            }
            this.payloadName.setText("");
            this.payloadFilename.setText("");
            this.payloadType.setSelectedIndex(0);
        }
        if (e.getSource() == this.btnGeneratePayload) {
            int row = this.payloadsTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            Log.println("Generating row " + row);
            this.updateTabs(row);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.payloadFilename) {
            this.browsePayload();
        }
        if (e.getSource() == this.payloadsTable) {
            if (this.sat.numberOfLayouts == 0) {
                return;
            }
            int row = this.payloadsTable.rowAtPoint(e.getPoint());
            int col = this.payloadsTable.columnAtPoint(e.getPoint());
            if (row >= 0 && col >= 0) {
                Log.println("PRESSED ROW: " + row + " and COL: " + col + " COUNT: " + e.getClickCount());
                String masterFolder = Config.spacecraftDir;
                this.updateTabs(row);
                this.payloadsTable.setRowSelectionInterval(row, row);
                if (e.getClickCount() == 2) {
                    File file = new File(String.valueOf(masterFolder) + File.separator + this.sat.layoutFilename[row]);
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException e1) {
                        Log.errorDialog("ERROR", "Could not open payload file\n" + e1);
                    }
                }
            }
            this.hasGPSTime.setEnabled(this.sat.hasGPSTime);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }
}

