/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor.listEditors.stringLookupTables;

import common.Log;
import common.Spacecraft;
import java.io.IOException;
import java.util.ArrayList;
import spacecraftEditor.SpacecraftEditPanel;
import spacecraftEditor.listEditors.CsvTableModel;
import spacecraftEditor.listEditors.ListTableModel;
import spacecraftEditor.listEditors.TableListEditPanel;
import telemetry.LayoutLoadException;
import telemetry.conversion.ConversionStringLookUpTable;

public class StringLookupTableListEditPanel
extends TableListEditPanel {
    private static final long serialVersionUID = 1L;

    public StringLookupTableListEditPanel(Spacecraft sat, String title, ListTableModel listTableModel, CsvTableModel csvTableModel, SpacecraftEditPanel parent) {
        super(sat, title, listTableModel, csvTableModel, "tab", parent);
    }

    @Override
    protected void loadTable() {
        this.dataLines = new ArrayList();
        int i = 0;
        while (i < this.sat.numberOfStringLookupTables) {
            String[] dataToAdd = new String[this.listTableModel.getColumnCount()];
            dataToAdd[0] = "" + i;
            dataToAdd[1] = this.sat.stringLookupTable[i] != null ? this.sat.stringLookupTable[i].getName() : "NONE";
            dataToAdd[2] = this.sat.stringLookupTableFilename[i] != null ? this.sat.stringLookupTableFilename[i] : "NONE";
            this.dataLines.add(dataToAdd);
            ++i;
        }
    }

    @Override
    protected void saveTable() throws IOException, LayoutLoadException {
        this.sat.stringLookupTable = new ConversionStringLookUpTable[this.dataLines.size()];
        this.sat.numberOfStringLookupTables = this.dataLines.size();
        this.sat.stringLookupTableFilename = new String[this.dataLines.size()];
        int j = 0;
        while (j < this.dataLines.size()) {
            try {
                if (((String[])this.dataLines.get(j))[1] == null) {
                    this.sat.stringLookupTable[j] = null;
                } else {
                    this.sat.stringLookupTableFilename[j] = ((String[])this.dataLines.get(j))[2];
                    this.sat.stringLookupTable[j] = new ConversionStringLookUpTable(((String[])this.dataLines.get(j))[1], this.sat.stringLookupTableFilename[j], this.sat);
                }
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "File is not a valid lookup table, row removed\n" + e);
                this.sat.stringLookupTable[j] = null;
                this.sat.stringLookupTableFilename[j] = null;
                this.sat.stringLookupTable[j] = null;
                --this.sat.numberOfStringLookupTables;
                this.dataLines.remove(j);
            }
            ++j;
        }
    }
}

