/*
 * Decompiled with CFR 0.152.
 */
package telemServer;

import common.Log;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ServerProcess
implements Runnable {
    public static final String NONE = "NONE";
    public static final int DUV_FRAME_LEN = 768;
    public static final int HIGH_SPEED_FRAME_LEN = 42176;
    public static final int PSK_FRAME_LEN = 4576;
    public static final byte[] OK = new byte[]{79, 77, 13, 10};
    public static final byte[] FAIL = new byte[]{70, 65, 13, 10};
    String u;
    String p;
    String db;
    private Socket socket = null;
    private int sequence = 0;
    public static final int MAX_FRAME_SIZE = 5600;
    public static final DateFormat fileDateName = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final DateFormat yearDirName = new SimpleDateFormat("yyyy");
    public static final DateFormat monthDirName = new SimpleDateFormat("MM");
    public static final DateFormat dayDirName = new SimpleDateFormat("dd");

    public ServerProcess(String u, String p, String db, Socket socket, int seq) {
        this.sequence = seq;
        this.socket = socket;
        this.u = u;
        this.p = p;
        this.db = db;
    }

    String nextSTPFile() throws IOException {
        Date today = Calendar.getInstance().getTime();
        String year = ServerProcess.datePartName(today, yearDirName);
        String month = ServerProcess.datePartName(today, monthDirName);
        String day = ServerProcess.datePartName(today, dayDirName);
        String fileName = ServerProcess.datePartName(today, fileDateName);
        this.makeDir(year);
        this.makeDir(String.valueOf(year) + File.separator + month);
        this.makeDir(String.valueOf(year) + File.separator + month + File.separator + day);
        String f = String.valueOf(year) + File.separator + month + File.separator + day + File.separator + fileName + "." + this.sequence + ".stp";
        return f;
    }

    String exceptionDir() throws IOException {
        Date today = Calendar.getInstance().getTime();
        String year = ServerProcess.datePartName(today, yearDirName);
        String month = ServerProcess.datePartName(today, monthDirName);
        String day = ServerProcess.datePartName(today, dayDirName);
        this.makeDir(year);
        this.makeDir(String.valueOf(year) + File.separator + month);
        this.makeDir(String.valueOf(year) + File.separator + month + File.separator + day);
        String exception = String.valueOf(year) + File.separator + month + File.separator + day + File.separator + "exception";
        this.makeDir(exception);
        return exception;
    }

    public static String datePartName(Date today, DateFormat df) {
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String reportDate = df.format(today);
        return reportDate;
    }

    public void makeDir(String dir) throws IOException {
        File aFile = new File(dir);
        if (aFile.isDirectory()) {
            return;
        }
        aFile.mkdir();
        if (!aFile.isDirectory()) {
            throw new IOException("Can not make the dir: " + dir);
        }
    }

    public boolean fileExists(String fileName) {
        File toFile = new File(fileName);
        return toFile.exists();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void storeException(File f) throws IOException {
        if (f != null) {
            String exceptions = this.exceptionDir();
            File toFile = new File(String.valueOf(exceptions) + File.separator + f.getName() + ".ex");
            if (!f.renameTo(toFile)) {
                Log.println("-" + this.socket.getInetAddress() + " ERROR: Could not rename the file into the exeption dir: " + f.getPath());
            }
        } else {
            Log.println("-" + this.socket.getInetAddress() + " Don't know which file to store as an exception");
        }
    }
}

