/*
 * Decompiled with CFR 0.152.
 */
package telemServer;

import common.Log;
import common.Spacecraft;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.LayoutLoadException;
import telemetry.PayloadDbStore;
import telemetry.SortedFramePartArrayList;
import telemetry.legacyPayloads.PayloadRadExpData;
import telemetry.payloads.PayloadMaxValues;
import telemetry.payloads.PayloadMinValues;
import telemetry.payloads.PayloadRtValues;

public class WebHealthTab {
    Spacecraft fox;
    PayloadDbStore payloadDbStore;
    FramePart payloadRt;
    PayloadMaxValues payloadMax;
    PayloadMinValues payloadMin;
    BitArrayLayout rtlayout;
    BitArrayLayout maxlayout;
    BitArrayLayout minlayout;
    String[] topModuleNames = new String[20];
    int[] topModuleLines = new int[20];
    String[] bottomModuleNames = new String[10];
    int[] bottomModuleLines = new int[10];
    int numOfTopModules = 1;
    int numOfBottomModules = 1;
    int port = 8080;

    public WebHealthTab(PayloadDbStore pdb, Spacecraft f, int p, String layout) throws LayoutLoadException {
        this.fox = f;
        if (this.fox == null) {
            throw new LayoutLoadException("Spacecraft is not valid");
        }
        this.port = p;
        this.payloadDbStore = pdb;
        this.rtlayout = this.fox.getLayoutByName(layout);
        if (this.fox.hasFOXDB_V3) {
            this.maxlayout = this.fox.getLayoutByName(this.fox.getLayoutNameByType("MAX"));
            this.minlayout = this.fox.getLayoutByName(this.fox.getLayoutNameByType("MIN"));
        } else {
            this.maxlayout = this.fox.getLayoutByName("maxtelemetry");
            this.minlayout = this.fox.getLayoutByName("mintelemetry");
        }
        this.analyzeModules(this.rtlayout, this.maxlayout, this.minlayout, 0);
    }

    public void setRtPayload(FramePart rt) {
        this.payloadRt = rt;
    }

    public void setMaxPayload(PayloadMaxValues max) {
        this.payloadMax = max;
    }

    public void setMinPayload(PayloadMinValues min) {
        this.payloadMin = min;
    }

    public String toCsvString(String fieldName, boolean convert, int num, int fromReset, int fromUptime) {
        String s = "";
        double[][] graphData = this.payloadDbStore.getRtGraphData(fieldName, num, this.fox, fromReset, fromUptime, false, true);
        if (graphData != null) {
            int i = 0;
            while (i < graphData[0].length) {
                s = String.valueOf(s) + (int)graphData[2][i] + "," + (int)graphData[1][i] + "," + graphData[0][i] + "/n";
                ++i;
            }
        }
        s = String.valueOf(s) + "</table>";
        return s;
    }

    public String toGraphString(String fieldName, boolean convert, int num, int fromReset, int fromUptime) {
        String s = "";
        s = String.valueOf(s) + "<style> td { border: 5px } th { background-color: lightgray; border: 3px solid lightgray; } td { padding: 5px; vertical-align: top; background-color: darkgray } </style>";
        s = String.valueOf(s) + "<h1 class='entry-title'>Fox " + this.fox.getIdString() + " - " + fieldName + "</h1>" + "<table><tr><th>Reset</th> <th>Uptime </th> <th>" + fieldName + "</th> </tr>";
        double[][] graphData = null;
        if (this.rtlayout.hasFieldName(fieldName)) {
            graphData = this.payloadDbStore.getRtGraphData(fieldName, num, this.fox, fromReset, fromUptime, false, true);
        } else if (this.minlayout.hasFieldName(fieldName)) {
            graphData = this.payloadDbStore.getMinGraphData(fieldName, num, this.fox, fromReset, fromUptime, false, true);
        } else if (this.maxlayout.hasFieldName(fieldName)) {
            graphData = this.payloadDbStore.getMaxGraphData(fieldName, num, this.fox, fromReset, fromUptime, false, true);
        }
        if (graphData != null) {
            int i = 0;
            while (i < graphData[0].length) {
                s = String.valueOf(s) + "<tr>";
                s = String.valueOf(s) + "<td>" + (int)graphData[2][i] + "</td>" + "<td>" + (int)graphData[1][i] + "</td>" + "<td>" + graphData[0][i] + "</td>";
                s = String.valueOf(s) + "</tr>";
                ++i;
            }
        }
        s = String.valueOf(s) + "</table>";
        return s;
    }

    public String toGraphString(String fieldName, boolean convert, int num, int fromReset, int fromUptime, String layout) {
        String s = "";
        s = String.valueOf(s) + "<style> td { border: 5px } th { background-color: lightgray; border: 3px solid lightgray; } td { padding: 5px; vertical-align: top; background-color: darkgray } </style>";
        s = String.valueOf(s) + "<h1 class='entry-title'>Fox " + this.fox.getIdString() + " - " + fieldName + "</h1>" + "<table><tr><th>Reset</th> <th>Uptime </th> <th>" + fieldName + "</th> </tr>";
        double[][] graphData = this.payloadDbStore.getGraphData(fieldName, num, this.fox, fromReset, (long)fromUptime, false, true, layout);
        if (graphData != null) {
            int i = 0;
            while (i < graphData[0].length) {
                s = String.valueOf(s) + "<tr>";
                s = String.valueOf(s) + "<td>" + (int)graphData[2][i] + "</td>" + "<td>" + (int)graphData[1][i] + "</td>" + "<td>" + graphData[0][i] + "</td>";
                s = String.valueOf(s) + "</tr>";
                ++i;
            }
        }
        s = String.valueOf(s) + "</table>";
        return s;
    }

    public String toString() {
        String s = "";
        String mode = "UNKNOWN";
        if (this.fox.hasModeInHeader) {
            mode = this.determineModeFromHeader();
        } else {
            PayloadRadExpData radPayload = this.payloadDbStore.getLatestRad(this.fox.foxId);
            mode = Spacecraft.determineModeString(this.fox, (PayloadRtValues)this.payloadRt, this.payloadMax, this.payloadMin, radPayload);
        }
        if (this.payloadRt != null) {
            s = String.valueOf(s) + "<h1 class='entry-title'>Fox " + this.fox.getIdString() + "</h1>";
            s = String.valueOf(s) + "<style> table.table1 td { border: 5px solid lightgray; } " + "table.table1 th { background-color: lightgray; border: 3px solid lightgray; } " + "table.table1 td { padding: 5px; vertical-align: top; background-color: darkgray } </style>";
            s = String.valueOf(s) + "<style> table.table2 td { border: 0px solid darkgray; } " + "table.table2 th { background-color: darkgray; border: 1px solid darkgray; } " + "table.table2 td { padding: 0px; vertical-align: top; background-color: darkgray } </style>";
            boolean realtime = false;
            boolean wod = false;
            if (this.fox.hasFOXDB_V3) {
                if (this.payloadRt.getLayout().isRealTime()) {
                    realtime = true;
                }
                if (this.payloadRt.getLayout().isWOD()) {
                    wod = true;
                }
            } else {
                String layoutName = this.payloadRt.getLayout().name;
                if (layoutName.equalsIgnoreCase("rttelemetry")) {
                    realtime = true;
                }
                if (layoutName.equalsIgnoreCase("wodtelemetry")) {
                    wod = true;
                }
            }
            s = realtime ? String.valueOf(s) + "<h3>REAL TIME Telemetry   Reset: " + this.payloadRt.getResets() + " Uptime: " + this.payloadRt.getUptime() : (wod ? String.valueOf(s) + "<h3>Whole Orbit Telemetry   Reset: " + this.payloadRt.getResets() + " Uptime: " + this.payloadRt.getUptime() : String.valueOf(s) + "<h3>Telemetry   Reset: " + this.payloadRt.getResets() + " Uptime: " + this.payloadRt.getUptime());
            s = String.valueOf(s) + " Mode: " + mode + "<br>";
            s = String.valueOf(s) + "</h3>";
            if (this.payloadRt.getCaptureDate() != null) {
                s = String.valueOf(s) + " Received: " + this.formatCaptureDate(this.payloadRt.getCaptureDate()) + "<br>";
            }
            if (this.payloadMax != null) {
                s = String.valueOf(s) + "Last MAX Reset: " + this.payloadMax.getResets() + " Uptime: " + this.payloadMax.getUptime() + ".";
            }
            if (this.payloadMin != null) {
                s = String.valueOf(s) + " Last MIN Reset: " + this.payloadMin.getResets() + " Uptime: " + this.payloadMin.getUptime() + ".</br><p>";
            }
            s = String.valueOf(s) + "<table class='table1'>";
            s = String.valueOf(s) + "<tr bgcolor=silver>";
            int i = 1;
            while (i < 4) {
                s = String.valueOf(s) + "<th><strong>" + this.topModuleNames[i] + "<strong>" + "</th>";
                ++i;
            }
            s = String.valueOf(s) + "</tr>";
            s = String.valueOf(s) + "<tr>";
            i = 1;
            while (i < 4) {
                s = String.valueOf(s) + this.buildModule(i);
                ++i;
            }
            s = String.valueOf(s) + "</tr>";
            s = String.valueOf(s) + "<tr bgcolor=silver>";
            i = 4;
            while (i < 6) {
                s = String.valueOf(s) + "<th><strong>" + this.topModuleNames[i] + "</strong>" + "</th>";
                ++i;
            }
            s = String.valueOf(s) + "</tr><tr>";
            i = 4;
            while (i < 6) {
                s = String.valueOf(s) + this.buildModule(i);
                ++i;
            }
            s = String.valueOf(s) + "</tr>";
            s = String.valueOf(s) + "<tr bgcolor=silver>";
            i = 6;
            while (i < 9) {
                s = String.valueOf(s) + "<th><strong>" + this.topModuleNames[i] + "</strong>" + "</th>";
                ++i;
            }
            s = String.valueOf(s) + "</tr><tr>";
            i = 6;
            while (i < 9) {
                s = String.valueOf(s) + this.buildModule(i);
                ++i;
            }
            s = String.valueOf(s) + "</tr>";
            s = String.valueOf(s) + "<tr bgcolor=silver>";
            i = 9;
            while (i < 12) {
                s = String.valueOf(s) + "<th><strong>" + this.topModuleNames[i] + "</strong>" + "</th>";
                ++i;
            }
            s = String.valueOf(s) + "</tr><tr>";
            i = 9;
            while (i < 12) {
                s = String.valueOf(s) + this.buildModule(i);
                ++i;
            }
            s = String.valueOf(s) + "</tr>";
            s = String.valueOf(s) + "</table>";
        }
        return s;
    }

    public String determineModeFromHeader() {
        SortedFramePartArrayList payloads = new SortedFramePartArrayList(this.fox.numberOfLayouts);
        int maxLayouts = 4;
        int i = 0;
        while (i <= maxLayouts && i < this.fox.layout.length) {
            FramePart part = this.payloadDbStore.getLatest(this.fox.foxId, this.fox.layout[i].name);
            if (part != null) {
                payloads.add(part);
            }
            payloads.add(part);
            ++i;
        }
        int mode = 0;
        if (payloads.size() > 0) {
            mode = ((FramePart)payloads.get((int)(payloads.size() - 1))).newMode;
        }
        return Spacecraft.getModeString(mode);
    }

    private String buildModule(int i) {
        String s = "";
        s = String.valueOf(s) + "<td><table class='table2'>";
        s = String.valueOf(s) + "<tr><th></th><th>RT</th><th>MIN</th><th>MAX</th></tr>";
        try {
            s = String.valueOf(s) + this.addModuleLines(this.topModuleNames[i], this.topModuleLines[i], this.rtlayout, this.payloadRt);
            if (this.maxlayout != null && this.payloadMax != null) {
                s = String.valueOf(s) + this.addModuleLines(this.topModuleNames[i], this.topModuleLines[i], this.maxlayout, this.payloadMax);
            }
            if (this.minlayout != null && this.payloadMin != null) {
                s = String.valueOf(s) + this.addModuleLines(this.topModuleNames[i], this.topModuleLines[i], this.minlayout, this.payloadMin);
            }
        }
        catch (LayoutLoadException e) {
            e.printStackTrace(Log.getWriter());
        }
        s = String.valueOf(s) + "</table></td>";
        return s;
    }

    private String addModuleLines(String topModuleName, int topModuleLine, BitArrayLayout rt, FramePart payloadRt) throws LayoutLoadException {
        String layoutName = payloadRt.getLayout().name;
        String s = "";
        int j = 0;
        while (j < rt.NUMBER_OF_FIELDS) {
            if (rt.module[j].equals(topModuleName)) {
                if (rt.moduleLinePosition[j] > topModuleLine) {
                    throw new LayoutLoadException("Found error in Layout File: " + rt.fileName + ".\nModule: " + topModuleName + " has " + topModuleLine + " lines, so we can not add " + rt.shortName[j] + " on line " + rt.moduleLinePosition[j]);
                }
                if (!rt.fieldName[j].startsWith("IHUDiag")) {
                    s = String.valueOf(s) + "<tr>";
                    s = String.valueOf(s) + "<td>";
                    boolean wod = false;
                    if (this.fox.hasFOXDB_V3) {
                        if (payloadRt.getLayout().isWOD()) {
                            wod = true;
                        }
                    } else if (layoutName.equalsIgnoreCase("wodtelemetry")) {
                        wod = true;
                    }
                    if (wod) {
                        s = String.valueOf(s) + "<a href=/tlm/wodGraph.php?" + "sat=" + this.fox.foxId;
                        s = String.valueOf(s) + "&wod-field=";
                    } else {
                        s = String.valueOf(s) + "<a href=/tlm/graph.php?" + "sat=" + this.fox.foxId;
                        s = String.valueOf(s) + "&field=";
                    }
                    s = String.valueOf(s) + rt.fieldName[j] + "&raw=conv" + "&reset=0" + "&uptime=0" + "&rows=100" + "&port=" + this.port + ">" + rt.shortName[j] + "</a>";
                    s = String.valueOf(s) + this.formatUnits(rt.fieldUnits[j]) + "</td>";
                    s = rt.moduleDisplayType[j] == 0 ? String.valueOf(s) + "<td align=left colspan=3>" : String.valueOf(s) + "<td align=center > ";
                    s = String.valueOf(s) + payloadRt.getStringValue(rt.fieldName[j], this.fox) + "</td>";
                    if (rt.moduleDisplayType[j] != 0) {
                        s = String.valueOf(s) + "<td align=center >";
                        if (rt.moduleDisplayType[j] == 4) {
                            if (this.payloadMax != null) {
                                s = String.valueOf(s) + this.payloadMax.getStringValue(rt.fieldName[j], this.fox);
                            }
                        } else if (this.payloadMin != null) {
                            s = String.valueOf(s) + this.payloadMin.getStringValue(rt.fieldName[j], this.fox);
                        }
                    }
                    if (rt.moduleDisplayType[j] != 0) {
                        s = String.valueOf(s) + "</td><td align=center >";
                        if (rt.moduleDisplayType[j] == 4) {
                            if (this.payloadMin != null) {
                                s = String.valueOf(s) + this.payloadMin.getStringValue(rt.fieldName[j], this.fox);
                            }
                        } else if (this.payloadMax != null) {
                            s = String.valueOf(s) + this.payloadMax.getStringValue(rt.fieldName[j], this.fox);
                        }
                    }
                    s = String.valueOf(s) + "</td></tr>";
                }
            }
            ++j;
        }
        return s;
    }

    private String formatUnits(String unit) {
        if (unit.equals("-") || unit.equalsIgnoreCase("NONE")) {
            return "";
        }
        unit = " (" + unit + ")";
        return unit;
    }

    private String formatCaptureDate(String u) {
        Date result = null;
        String reportDate = null;
        try {
            FramePart.fileDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            result = FramePart.fileDateFormat.parse(u);
            FramePart.reportDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            reportDate = FramePart.reportDateFormat.format(result);
        }
        catch (ParseException e) {
            reportDate = "unknown";
        }
        catch (NumberFormatException e) {
            reportDate = "unknown";
        }
        catch (Exception e) {
            reportDate = "unknown";
        }
        return reportDate;
    }

    protected void analyzeModules(BitArrayLayout rt, BitArrayLayout max, BitArrayLayout min, int moduleType) throws LayoutLoadException {
        int i = 0;
        while (i < rt.NUMBER_OF_FIELDS) {
            if (!rt.module[i].equalsIgnoreCase("NONE")) {
                if (!this.containedIn(this.topModuleNames, rt.module[i])) {
                    this.topModuleNames[rt.moduleNum[i]] = rt.module[i];
                    ++this.numOfTopModules;
                }
                int n = rt.moduleNum[i];
                this.topModuleLines[n] = this.topModuleLines[n] + 1;
            }
            ++i;
        }
        if (max != null) {
            i = 0;
            while (i < max.NUMBER_OF_FIELDS) {
                if (!max.module[i].equalsIgnoreCase("NONE")) {
                    if (!this.containedIn(this.topModuleNames, max.module[i])) {
                        this.topModuleNames[max.moduleNum[i]] = max.module[i];
                        ++this.numOfTopModules;
                    }
                    int n = max.moduleNum[i];
                    this.topModuleLines[n] = this.topModuleLines[n] + 1;
                }
                ++i;
            }
        }
        if (min != null) {
            i = 0;
            while (i < min.NUMBER_OF_FIELDS) {
                if (!min.module[i].equalsIgnoreCase("NONE")) {
                    if (!this.containedIn(this.topModuleNames, min.module[i])) {
                        this.topModuleNames[min.moduleNum[i]] = min.module[i];
                        ++this.numOfTopModules;
                    }
                    int n = min.moduleNum[i];
                    this.topModuleLines[n] = this.topModuleLines[n] + 1;
                }
                ++i;
            }
        }
    }

    private boolean containedIn(String[] array, String item) {
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && s.equals(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

