/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import telemetry.BitArray;
import telemetry.BitArrayLayout;
import telemetry.conversion.Conversion;
import telemetry.conversion.ConversionLegacy;
import telemetry.conversion.ConversionMathExpression;
import telemetry.conversion.ConversionTimestamp;
import telemetry.frames.Header;
import telemetry.herci.HerciHighSpeedPacket;
import telemetry.herci.HerciHighspeedHeader;
import telemetry.herci.PayloadHERCIhighSpeed;
import telemetry.legacyPayloads.PayloadRadExpData;
import telemetry.legacyPayloads.PayloadWODRad;
import telemetry.legacyPayloads.RadiationTelemetry;
import telemetry.legacyPayloads.WodRadiationTelemetry;
import telemetry.payloads.CanPacket;
import telemetry.payloads.PayloadCanExperiment;
import telemetry.payloads.PayloadCanWODExperiment;
import telemetry.payloads.PayloadExperiment;
import telemetry.payloads.PayloadMaxValues;
import telemetry.payloads.PayloadMinValues;
import telemetry.payloads.PayloadRtValues;
import telemetry.payloads.PayloadWOD;
import telemetry.payloads.PayloadWODExperiment;
import telemetry.uw.PayloadUwExperiment;
import telemetry.uw.PayloadWODUwExperiment;
import telemetry.uw.UwCanPacket;
import uk.me.g4dpz.satellite.SatPos;

public abstract class FramePart
extends BitArray
implements Comparable<FramePart> {
    protected int MAX_BYTES = 78;
    public static final int TYPE_DEBUG = 0;
    public static final int TYPE_REAL_TIME = 1;
    public static final int TYPE_MAX_VALUES = 2;
    public static final int TYPE_MIN_VALUES = 3;
    public static final int TYPE_CAMERA_DATA = 5;
    public static final int TYPE_RAD_EXP_DATA = 4;
    public static final int TYPE_HERCI_HIGH_SPEED_DATA = 6;
    public static final int TYPE_RAD_TELEM_DATA = 7;
    public static final int TYPE_HERCI_SCIENCE_HEADER = 8;
    public static final int TYPE_HERCI_HS_PACKET = 9;
    public static final int TYPE_WOD = 10;
    public static final int TYPE_WOD_EXP = 11;
    public static final int TYPE_WOD_EXP_TELEM_DATA = 12;
    public static final int TYPE_CAN_EXP = 13;
    public static final int TYPE_CAN_WOD_EXP = 14;
    public static final int TYPE_CAN_PACKET = 15;
    public static final int TYPE_CAN_WOD_PACKET = 16;
    public static final int TYPE_UW_EXPERIMENT = 13;
    public static final int TYPE_UW_CAN_PACKET = 14;
    public static final int TYPE_UW_WOD_EXPERIMENT = 15;
    public static final int TYPE_UW_WOD_CAN_PACKET = 16;
    public static final int TYPE_UW_CAN_PACKET_TELEM = 17;
    public static final int TYPE_RAG_TELEM = 18;
    public static final int TYPE_WOD_RAG = 19;
    public static final int TYPE_SLOW_SPEED_HEADER = 98;
    public static final int TYPE_SLOW_SPEED_TRAILER = 99;
    public static final int TYPE_HIGH_SPEED_HEADER = 100;
    public static final int TYPE_HIGH_SPEED_TRAILER = 101;
    public static final int TYPE_CAMERA_SCAN_LINE_COUNT = 102;
    public static final int TYPE_HERCI_LINE_COUNT = 103;
    public static final int TYPE_EXTENDED_HEADER = 104;
    public static final int TYPE_GOLF_HEADER = 105;
    public static final DateFormat reportDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public static final DateFormat fileDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final DateFormat dateFormat2 = new SimpleDateFormat("yyyyMMdd HHmmss", Locale.ENGLISH);
    public int id;
    public long uptime;
    public int resets;
    protected String reportDate;
    public int type;
    public int newMode = 0;
    public static final double NO_POSITION_DATA = -999.0;
    public static final double NO_T0 = -998.0;
    public static final double NO_TLE = -997.0;
    double satLatitude = -999.0;
    double satLongitude = -999.0;
    double satAltitude = -999.0;
    public static final String GPS_VALID = "UTCValid";
    public static final String GPS_SECONDS = "UTCSeconds";
    public static final String GPS_MINUTES = "UTCMinutes";
    public static final String GPS_HOURS = "UTCHours";
    public static final String GPS_DAY = "UTCDay";
    public static final String GPS_MONTH = "UTCMonth";
    public static final String GPS_YEAR = "UTCYear";
    public static final String GPS_SECS_IN_EPOCH = "secsInEpoch";

    public FramePart(int id, int resets, long uptime, int type, String date, StringTokenizer st, BitArrayLayout lay) {
        super(lay);
        this.type = type;
        this.id = id;
        this.resets = resets;
        this.uptime = uptime;
        this.reportDate = date;
        this.init();
        this.rawBits = null;
        this.load(st);
    }

    public FramePart(int id, int resets, long uptime, int type, String date, byte[] data, BitArrayLayout lay) {
        super(lay);
        this.type = type;
        this.id = id;
        this.resets = resets;
        this.uptime = uptime;
        this.reportDate = date;
        this.init();
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.addNext8Bits(b);
            ++n2;
        }
        this.copyBitsToFields();
    }

    public FramePart(int type, BitArrayLayout lay) {
        super(lay);
        this.type = type;
        this.init();
    }

    public FramePart(ResultSet results, int type, BitArrayLayout lay) throws SQLException {
        super(lay);
        this.type = type;
        this.id = results.getInt("id");
        this.resets = results.getInt("resets");
        this.uptime = results.getLong("uptime");
        this.reportDate = results.getString("captureDate");
        this.init();
        this.rawBits = null;
        int i = 0;
        while (i < this.fieldValue.length) {
            this.fieldValue[i] = results.getInt(this.layout.fieldName[i]);
            ++i;
        }
    }

    public void captureHeaderInfo(int id, long uptime, int resets) {
        this.id = id;
        this.uptime = uptime;
        this.resets = resets;
        if (this.reportDate == null) {
            this.reportDate = FramePart.fileDateStamp();
        }
    }

    protected abstract void init();

    public abstract boolean isValid();

    public double getSatLatitude() {
        return this.satLatitude;
    }

    public double getSatLongitude() {
        return this.satLongitude;
    }

    public double getSatAltitude() {
        return this.satAltitude;
    }

    public void setSatPosition(SatPos pos) {
        if (pos != null) {
            this.satLatitude = FramePart.latRadToDeg(pos.getLatitude());
            this.satLongitude = FramePart.lonRadToDeg(pos.getLongitude());
            this.satAltitude = pos.getAltitude();
        } else {
            this.satLatitude = -999.0;
            this.satLongitude = -999.0;
            this.satAltitude = -999.0;
        }
    }

    public String getSatLatitudeStr() {
        DecimalFormat d = new DecimalFormat("00.00");
        if (this.satLatitude == -999.0) {
            return "UNK";
        }
        if (this.satLatitude == -998.0) {
            return "T0 NOT SET";
        }
        if (this.satLatitude == -997.0) {
            return "NO TLE";
        }
        return d.format(this.satLatitude);
    }

    public String getSatLongitudeStr() {
        DecimalFormat d = new DecimalFormat("00.00");
        if (this.satLongitude == -999.0) {
            return "UNK";
        }
        if (this.satLongitude == -998.0) {
            return "T0 NOT SET";
        }
        if (this.satLongitude == -997.0) {
            return "NO TLE";
        }
        return d.format(this.satLongitude);
    }

    public static double radToDeg(Double rad) {
        return 180.0 * (rad / Math.PI);
    }

    public static double latRadToDeg(Double rad) {
        return FramePart.radToDeg(rad);
    }

    public static double lonRadToDeg(Double rad) {
        double lon = FramePart.radToDeg(rad);
        if (lon > 180.0) {
            return lon - 360.0;
        }
        return lon;
    }

    public int getFoxId() {
        return this.id;
    }

    public long getUptime() {
        return this.uptime;
    }

    public int getResets() {
        return this.resets;
    }

    public int getType() {
        return this.type;
    }

    public String getCaptureDate() {
        return this.reportDate;
    }

    public static String fileDateStamp() {
        Date today = Calendar.getInstance().getTime();
        fileDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String reportDate = fileDateFormat.format(today);
        return reportDate;
    }

    @Override
    public int compareTo(FramePart p) {
        if (this.resets == p.resets && this.uptime == p.uptime && this.type == p.type) {
            return 0;
        }
        if (this.resets < p.resets) {
            return -1;
        }
        if (this.resets > p.resets) {
            return 1;
        }
        if (this.resets == p.resets && this.uptime == p.uptime) {
            if (this.type < p.type) {
                return -1;
            }
            if (this.type > p.type) {
                return 1;
            }
        } else if (this.resets == p.resets) {
            if (this.uptime < p.uptime) {
                return -1;
            }
            if (this.uptime > p.uptime) {
                return 1;
            }
        }
        return 1;
    }

    public String toFile(boolean storeMode) {
        this.copyBitsToFields();
        String s = new String();
        s = String.valueOf(s) + this.reportDate + "," + this.id + "," + this.resets + "," + this.uptime + "," + this.type + ",";
        if (storeMode) {
            s = String.valueOf(s) + this.newMode + ",";
        }
        int i = 0;
        while (i < this.layout.fieldName.length - 1) {
            s = String.valueOf(s) + this.getRawValue(this.layout.fieldName[i]) + ",";
            ++i;
        }
        s = String.valueOf(s) + this.getRawValue(this.layout.fieldName[this.layout.fieldName.length - 1]);
        return s;
    }

    public String getInsertStmt() {
        this.copyBitsToFields();
        String s = new String();
        s = String.valueOf(s) + " (captureDate,  id, resets, uptime, type, \n";
        if (this.newMode != 0) {
            s = String.valueOf(s) + "newMode,";
        }
        int i = 0;
        while (i < this.layout.fieldName.length - 1) {
            s = String.valueOf(s) + this.layout.fieldName[i] + ",\n";
            ++i;
        }
        s = String.valueOf(s) + this.layout.fieldName[this.layout.fieldName.length - 1] + ")\n";
        s = String.valueOf(s) + "values ('" + this.reportDate + "', " + this.id + ", " + this.resets + ", " + this.uptime + ", " + this.type + ",\n";
        if (this.newMode != 0) {
            s = String.valueOf(s) + this.newMode + ",\n";
        }
        i = 0;
        while (i < this.fieldValue.length - 1) {
            s = String.valueOf(s) + this.fieldValue[i] + ",\n";
            ++i;
        }
        s = String.valueOf(s) + this.fieldValue[this.fieldValue.length - 1] + ")\n";
        return s;
    }

    public abstract String toString();

    protected void load(StringTokenizer st) {
        int i = 0;
        String s = null;
        try {
            while ((s = st.nextToken()) != null) {
                if (s.startsWith("0x")) {
                    s = s.replace("0x", "");
                    this.fieldValue[i++] = Integer.valueOf(s, 16);
                    continue;
                }
                this.fieldValue[i++] = Integer.valueOf(s);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.errorDialog("ERROR: Too many fields: Index out of bounds", "Layout: " + this.layout.name + "\n" + e + " Could not load field " + i + " SAT: " + this.id + " Reset:" + this.resets + " Up:" + this.uptime + " Type:" + this.type);
        }
        catch (NumberFormatException n) {
            Log.println("ERROR: Invalid number:  " + n.getMessage() + " Could not load frame " + this.id + " " + this.resets + " " + this.uptime + " " + this.type);
            Log.errorDialog("LOAD ERROR - DEBUG MESSAGE", "ERROR: Invalid number:  " + n.getMessage() + " Could not load frame " + this.id + " " + this.resets + " " + this.uptime + " " + this.type);
        }
    }

    public static FramePart makePayload(Header header, BitArrayLayout layout) {
        return FramePart.makePayload(header, layout.name);
    }

    public static FramePart makePayload(Header header, String layoutName) {
        return FramePart.makePayload(header.id, header.resets, header.uptime, layoutName);
    }

    public static FramePart makePayload(int id, int resets, long uptime, String layoutName) {
        BitArrayLayout layout = Config.satManager.getLayoutByName(id, layoutName);
        switch (layout.typeStr) {
            case "RT": {
                return new PayloadRtValues(layout);
            }
            case "MAX": {
                return new PayloadMaxValues(layout);
            }
            case "MIN": {
                return new PayloadMinValues(layout);
            }
            case "WOD": {
                return new PayloadWOD(layout);
            }
            case "EXP": {
                return new PayloadExperiment(layout, id, uptime, resets);
            }
            case "WOD_EXP": {
                return new PayloadWODExperiment(layout);
            }
            case "CAN_EXP": {
                return new PayloadCanExperiment(layout, id, uptime, resets);
            }
            case "CAN_WOD_EXP": {
                return new PayloadCanWODExperiment(layout, id, uptime, resets);
            }
            case "CAN_PKT": {
                return new CanPacket(layout, id, uptime, resets);
            }
            case "WOD_CAN_PKT": {
                return new CanPacket(layout, id, uptime, resets);
            }
        }
        return null;
    }

    @Deprecated
    public static FramePart makeLegacyPayload(Header header, BitArrayLayout layout) {
        return FramePart.makeLegacyPayload(header, layout.name);
    }

    @Deprecated
    public static FramePart makeLegacyPayload(Header header, String layoutName) {
        return FramePart.makeLegacyPayload(header.id, header.resets, header.uptime, layoutName);
    }

    @Deprecated
    public static FramePart makeLegacyPayload(int id, int resets, long uptime, String layoutName) {
        BitArrayLayout layout = Config.satManager.getLayoutByName(id, layoutName);
        switch (layoutName) {
            case "rttelemetry": {
                return new PayloadRtValues(layout);
            }
            case "maxtelemetry": {
                return new PayloadMaxValues(layout);
            }
            case "mintelemetry": {
                return new PayloadMinValues(layout);
            }
            case "radtelemetry": {
                return new PayloadRadExpData(layout);
            }
            case "wodtelemetry": {
                return new PayloadWOD(layout);
            }
            case "wodradtelemetry": {
                return new PayloadWODRad(layout);
            }
            case "wodcantelemetry": {
                return new PayloadWODUwExperiment(layout, id, uptime, resets);
            }
            case "cantelemetry": {
                return new PayloadUwExperiment(layout, id, uptime, resets);
            }
        }
        if (layout.isExperiment()) {
            return new PayloadExperiment(layout, id, uptime, resets);
        }
        if (layout.isWODExperiment()) {
            return new PayloadWODExperiment(layout);
        }
        return null;
    }

    public static FramePart makePayload(int id, int resets, long uptime, String date, StringTokenizer st, BitArrayLayout lay) {
        FramePart rt = null;
        if (lay.isRealTime()) {
            rt = new PayloadRtValues(id, resets, uptime, date, st, lay);
        } else if (lay.isMAX()) {
            rt = new PayloadMaxValues(id, resets, uptime, date, st, lay);
        } else if (lay.isMIN()) {
            rt = new PayloadMinValues(id, resets, uptime, date, st, lay);
        } else if (lay.isWOD()) {
            rt = new PayloadWOD(id, resets, uptime, date, st, lay);
        } else if (lay.isWODExperiment()) {
            rt = new PayloadWODExperiment(id, resets, uptime, date, st, lay);
        } else if (lay.isExperiment()) {
            rt = new PayloadExperiment(id, resets, uptime, date, st, lay);
        } else if (lay.isCanExperiment()) {
            rt = new PayloadCanExperiment(id, resets, uptime, date, st, lay);
        } else if (lay.isCanWodExperiment()) {
            rt = new PayloadCanWODExperiment(id, resets, uptime, date, st, lay);
        } else if (lay.isCanPkt()) {
            rt = new CanPacket(id, resets, uptime, date, st, lay);
        } else if (lay.isCanWodPkt()) {
            rt = new CanPacket(id, resets, uptime, date, st, lay);
        }
        return rt;
    }

    @Deprecated
    public static FramePart makeLegacyPayload(int id, int resets, long uptime, String date, StringTokenizer st, int type) {
        FramePart rt = null;
        if (type == 1) {
            rt = new PayloadRtValues(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "rttelemetry"));
        } else if (type == 10) {
            rt = new PayloadWOD(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "wodtelemetry"));
        } else if (type == 2) {
            rt = new PayloadMaxValues(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "maxtelemetry"));
        } else if (type == 3) {
            rt = new PayloadMinValues(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "mintelemetry"));
        } else if (type == 7 || type >= 700 && type < 800) {
            rt = new RadiationTelemetry(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "radtelemetry2"));
            rt.type = type;
        } else if (type == 12) {
            rt = new WodRadiationTelemetry(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "wodradtelemetry2"));
            rt.type = type;
        } else if (type == 4 || type >= 400 && type < 500) {
            rt = new PayloadRadExpData(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "radtelemetry"));
            rt.type = type;
            if (Config.generateSecondaryPayloads) {
                PayloadRadExpData f = (PayloadRadExpData)rt;
                RadiationTelemetry radiationTelemetry = f.calculateTelemetryPalyoad();
                radiationTelemetry.captureHeaderInfo(f.id, f.uptime, f.resets);
                if (f.type >= 400) {
                    radiationTelemetry.type = f.type + 300;
                }
                Config.payloadStore.add(f.id, f.uptime, f.resets, radiationTelemetry);
                Config.payloadStore.setUpdated(id, "radtelemetry", true);
            }
        } else if (type == 11) {
            rt = new PayloadWODRad(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "wodradtelemetry"));
            rt.type = type;
            if (Config.generateSecondaryPayloads) {
                PayloadWODRad f = (PayloadWODRad)rt;
                WodRadiationTelemetry radiationTelemetry = f.calculateTelemetryPalyoad();
                radiationTelemetry.captureHeaderInfo(f.id, f.uptime, f.resets);
                Config.payloadStore.add(f.id, f.uptime, f.resets, radiationTelemetry);
                Config.payloadStore.setUpdated(id, "wodradtelemetry", true);
            }
        } else if (type == 6 || type >= 600 && type < 700) {
            rt = new PayloadHERCIhighSpeed(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "herciHSdata"));
            rt.type = type;
            if (Config.generateSecondaryPayloads) {
                PayloadHERCIhighSpeed f = (PayloadHERCIhighSpeed)rt;
                HerciHighspeedHeader radiationTelemetry = f.calculateTelemetryPalyoad();
                radiationTelemetry.captureHeaderInfo(f.id, f.uptime, f.resets);
                if (f.type >= 600) {
                    radiationTelemetry.type = f.type + 200;
                }
                Config.payloadStore.add(f.id, f.uptime, f.resets, radiationTelemetry);
                ArrayList<HerciHighSpeedPacket> pkts = f.calculateTelemetryPackets();
                int i = 0;
                while (i < pkts.size()) {
                    HerciHighSpeedPacket pk = pkts.get(i);
                    pk.captureHeaderInfo(f.id, f.uptime, f.resets);
                    if (f.type >= 600) {
                        pk.type = f.type * 1000 + 900 + i;
                    }
                    Config.payloadStore.add(f.id, f.uptime, f.resets, pk);
                    ++i;
                }
            }
        } else if (type == 8 || type >= 800 && type < 900) {
            rt = new HerciHighspeedHeader(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "herciHSheader"));
            rt.type = type;
        } else if (type == 9 || type >= 600900 && type < 700000) {
            rt = new HerciHighSpeedPacket(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "herciHSpackets"));
            rt.type = type;
        } else if (type == 14 || type >= 1400 && type < 1500) {
            rt = new UwCanPacket(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "canpacket"));
            rt.type = type;
        } else if (type == 16 || type >= 1600 && type < 1700) {
            rt = new CanPacket(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "wodcanpacket"));
            rt.type = type;
        } else if (type == 13 || type >= 1300 && type < 1400) {
            rt = new PayloadUwExperiment(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "cantelemetry"));
            rt.type = type;
        } else if (type == 15 || type >= 1500 && type < 1600) {
            rt = new PayloadWODUwExperiment(id, resets, uptime, date, st, Config.satManager.getLayoutByName(id, "wodcantelemetry"));
            rt.type = type;
        }
        return rt;
    }

    public FramePart getSecondaryPayload() {
        if (this.layout.getSecondaryPayloadName() != null) {
            FramePart telem = FramePart.makePayload(this.id, this.resets, this.uptime, this.layout.getSecondaryPayloadName());
            int k = 0;
            while (k < telem.getMaxBytes()) {
                telem.addNext8Bits((byte)this.fieldValue[k]);
                ++k;
            }
            return telem;
        }
        return null;
    }

    public int getMaxBytes() {
        return this.layout.getMaxNumberOfBytes();
    }

    public int getMaxBits() {
        return this.layout.getMaxNumberOfBits();
    }

    @Deprecated
    public boolean isValidType(int t) {
        if (t == 0) {
            return true;
        }
        if (t == 1) {
            return true;
        }
        if (t == 2) {
            return true;
        }
        if (t == 3) {
            return true;
        }
        return t == 4;
    }

    public static String reportDate() {
        Date today = Calendar.getInstance().getTime();
        reportDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String reportDate = reportDateFormat.format(today);
        return reportDate;
    }

    @Override
    public String getStringValue(String name, Spacecraft fox) {
        int pos = -1;
        int i = 0;
        while (i < this.layout.fieldName.length) {
            if (name.equalsIgnoreCase(this.layout.fieldName[i])) {
                pos = i;
                break;
            }
            ++i;
        }
        String convName = this.layout.getConversionNameByPos(pos);
        double dvalue = this.getDoubleValue(name, fox);
        String s = "-----";
        if (pos != -1) {
            String lastConv = Conversion.getLastConversionInPipeline(convName);
            Conversion conv = fox.getConversionByName(lastConv);
            if (conv == null) {
                return s;
            }
            s = conv instanceof ConversionTimestamp ? ((ConversionTimestamp)conv).calculateTimeString(dvalue, this) : conv.calculateString(dvalue);
        }
        if (s.length() < 5) {
            int k = 0;
            while (k < 5 - s.length()) {
                s = " " + s;
                ++k;
            }
        }
        return s;
    }

    public static String intToBin(int word, int len) {
        boolean[] b = new boolean[len];
        int i = 0;
        while (i < len) {
            b[len - 1 - i] = (word >> i & 1) == 1;
            ++i;
        }
        String s = "";
        boolean[] blArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bit = blArray[n2];
            s = bit ? String.valueOf(s) + "1" : String.valueOf(s) + "0";
            ++n2;
        }
        return s;
    }

    public static String toHexString(long value, int len) {
        String s = "";
        int i = 0;
        while (i < len) {
            String digit = String.format("%1s", Long.toHexString(value & 0xFL)).replace(' ', '0');
            s = String.valueOf(digit) + s;
            value >>= 4;
            ++i;
        }
        return s;
    }

    public static String txByteString(long value, int len) {
        String s = "";
        int i = 0;
        while (i < len) {
            s = String.valueOf(FramePart.plainhex(value & 0xFFL)) + s;
            value >>= 8;
            ++i;
        }
        return s;
    }

    public static String plainhex(long l) {
        return String.format("%2s", Long.toHexString(l)).replace(' ', '0');
    }

    public double getDoubleValue(String name, Spacecraft fox) {
        String[] conversions;
        int pos = -1;
        int i = 0;
        while (i < this.layout.fieldName.length) {
            if (name.equalsIgnoreCase(this.layout.fieldName[i])) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos == -1) {
            return 9999.0;
        }
        int value = this.fieldValue[pos];
        double result = value;
        String convName = this.layout.getConversionNameByPos(pos);
        String[] stringArray = conversions = convName.split("\\|");
        int n = conversions.length;
        int n2 = 0;
        while (n2 < n) {
            String singleConv = stringArray[n2];
            Conversion conv = fox.getConversionByName(singleConv = singleConv.trim());
            if (conv == null) {
                return 9999.0;
            }
            result = this.convertCoeffRawValue(name, result, conv, fox);
            ++n2;
        }
        return result;
    }

    public double convertRawValue(String name, double value, Spacecraft fox) {
        String[] conversions;
        double result = value;
        String convName = this.layout.getConversionNameByName(name);
        String[] stringArray = conversions = convName.split("\\|");
        int n = conversions.length;
        int n2 = 0;
        while (n2 < n) {
            String singleConv = stringArray[n2];
            Conversion conv = fox.getConversionByName(singleConv = singleConv.trim());
            if (conv == null) {
                return 9999.0;
            }
            result = this.convertCoeffRawValue(name, result, conv, fox);
            ++n2;
        }
        return result;
    }

    public ZonedDateTime getGPSTime(Spacecraft fox) {
        if (!fox.hasGPSTime) {
            return null;
        }
        if (!this.layout.hasGPSTime) {
            return null;
        }
        int valid = (int)this.getDoubleValue(GPS_VALID, fox);
        if (valid == 0) {
            return null;
        }
        int sec = (int)this.getDoubleValue(GPS_SECONDS, fox);
        if (sec < 0 || sec > 59) {
            return null;
        }
        int min = (int)this.getDoubleValue(GPS_MINUTES, fox);
        if (min < 0 || min > 59) {
            return null;
        }
        int hrs = (int)this.getDoubleValue(GPS_HOURS, fox);
        if (hrs < 0 || hrs > 23) {
            return null;
        }
        int days = (int)this.getDoubleValue(GPS_DAY, fox);
        if (days < 1 || days > 31) {
            return null;
        }
        int mths = (int)this.getDoubleValue(GPS_MONTH, fox);
        if (mths < 1 || mths > 12) {
            return null;
        }
        int yrs = (int)this.getDoubleValue(GPS_YEAR, fox);
        ZonedDateTime dateTime = ZonedDateTime.of(yrs += 2000, mths, days, hrs, min, sec, 0, ZoneId.of("UTC"));
        return dateTime;
    }

    public long getSecsInEpochAtGPSTimestamp() {
        long secs = 0L;
        int pos = -1;
        int i = 0;
        while (i < this.layout.fieldName.length) {
            if (GPS_SECS_IN_EPOCH.equalsIgnoreCase(this.layout.fieldName[i])) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos == -1) {
            return 0L;
        }
        secs = this.fieldValue[pos];
        return secs;
    }

    protected double convertCoeffRawValue(String name, double rawValue, Conversion conversion, Spacecraft fox) {
        double x = 0.0;
        try {
            x = conversion instanceof ConversionMathExpression ? ((ConversionMathExpression)conversion).calculateExpression(rawValue, this) : (conversion instanceof ConversionLegacy ? ((ConversionLegacy)conversion).calculateLegacy(rawValue, this, name) : conversion.calculate(rawValue));
        }
        catch (RuntimeException e) {
            Log.errorDialog("Error with Conversion", "Error processing conversion for field " + name + "\n Using conversion - " + conversion.toString() + "\n Error is: " + e.getMessage());
        }
        return x;
    }
}

