/*
 * Decompiled with CFR 0.152.
 */
package telemetry.frames;

import common.Config;
import common.Log;
import java.io.BufferedReader;
import java.io.IOException;
import telemetry.FramePart;
import telemetry.frames.Frame;
import telemetry.frames.HighSpeedHeader;
import telemetry.frames.HighSpeedTrailer;
import telemetry.herci.PayloadHERCIhighSpeed;
import telemetry.herci.PayloadHerciLineCount;
import telemetry.legacyPayloads.PayloadCameraData;
import telemetry.legacyPayloads.PayloadCameraScanLineCount;
import telemetry.legacyPayloads.PayloadRadExpData;
import telemetry.payloads.PayloadMaxValues;
import telemetry.payloads.PayloadMinValues;
import telemetry.payloads.PayloadRtValues;

@Deprecated
public class HighSpeedFrame
extends Frame {
    public static final int MAX_FRAME_SIZE = 4600;
    public static final int MAX_HEADER_SIZE = 6;
    public static final int PAYLOAD_SIZE = 60;
    public static final int MAX_PAYLOAD_SIZE = 4594;
    public static final int MAX_CAMERA_PAYLOAD_SIZE = 4300;
    public static final int MAX_TRAILER_SIZE = 672;
    public static final int DEFAULT_RAD_EXP_PAYLOADS = 76;
    public static final int MAX_HERCI_PAYLOADS = 5;
    FramePart rtPayload = null;
    FramePart maxPayload = null;
    FramePart minPayload = null;
    PayloadRadExpData[] radExpPayload = new PayloadRadExpData[76];
    PayloadCameraScanLineCount cameraScanLineCount = null;
    PayloadCameraData cameraPayload = null;
    PayloadHerciLineCount herciLineCount = null;
    PayloadHERCIhighSpeed[] herciPayload = null;
    HighSpeedTrailer trailer = null;
    int[] radiationLookaheadBuffer = new int[20];
    int radiationPayloadSize = 20;
    boolean bufferedRadMode = true;
    int numberBytesAdded = 0;
    int radiationBytesAdded = 0;
    private boolean first20RadBytes = true;
    int radFrame = 0;
    private boolean firstNonHeaderByte = true;
    private boolean firstCameraByte = true;
    private boolean firstHERCIByte = true;

    public HighSpeedFrame() {
        this.header = new HighSpeedHeader();
        this.trailer = new HighSpeedTrailer();
        this.bytes = new byte[5272];
    }

    public HighSpeedFrame(BufferedReader input) throws IOException {
        super(input);
        this.header = new HighSpeedHeader();
        this.bytes = new byte[5272];
        this.load(input);
    }

    @Override
    public HighSpeedHeader getHeader() {
        return (HighSpeedHeader)this.header;
    }

    public PayloadRtValues getRtPayload() {
        return (PayloadRtValues)this.rtPayload;
    }

    public PayloadMaxValues getMaxPayload() {
        return (PayloadMaxValues)this.maxPayload;
    }

    public PayloadMinValues getMinPayload() {
        return (PayloadMinValues)this.minPayload;
    }

    public PayloadCameraData getCameraPayload() {
        return this.cameraPayload;
    }

    public PayloadHERCIhighSpeed[] getHerciPayloads() {
        return this.herciPayload;
    }

    public PayloadRadExpData[] getRadPayloads() {
        return this.radExpPayload;
    }

    @Override
    public void addNext8Bits(byte b) {
        if (this.corrupt) {
            return;
        }
        if (this.numberBytesAdded < 6) {
            this.header.addNext8Bits(b);
        } else if (this.numberBytesAdded < 66) {
            if (this.firstNonHeaderByte) {
                this.header.copyBitsToFields();
                this.fox = Config.satManager.getSpacecraft(this.header.id);
                if (this.fox != null) {
                    this.rtPayload = new PayloadRtValues(Config.satManager.getLayoutByName(this.header.id, "rttelemetry"));
                    this.maxPayload = new PayloadMaxValues(Config.satManager.getLayoutByName(this.header.id, "maxtelemetry"));
                    this.minPayload = new PayloadMinValues(Config.satManager.getLayoutByName(this.header.id, "mintelemetry"));
                    int i = 0;
                    while (i < 76) {
                        this.radExpPayload[i] = new PayloadRadExpData(Config.satManager.getLayoutByName(this.header.id, "radtelemetry"));
                        ++i;
                    }
                    if (Config.debugFrames) {
                        Log.println(this.header.toString());
                    }
                    if (this.fox.hasCamera()) {
                        this.cameraScanLineCount = new PayloadCameraScanLineCount();
                    }
                    if (this.fox.hasHerci()) {
                        this.herciLineCount = new PayloadHerciLineCount();
                    }
                } else {
                    Log.println("FOX ID: " + this.header.id + " is not configured in the spacecraft directory.  Decode not possible.");
                    this.corrupt = true;
                    return;
                }
                this.firstNonHeaderByte = false;
            }
            this.rtPayload.addNext8Bits(b);
        } else if (this.numberBytesAdded < 126) {
            this.maxPayload.addNext8Bits(b);
        } else if (this.numberBytesAdded < 186) {
            this.minPayload.addNext8Bits(b);
        } else if (this.fox.hasCamera() && !this.cameraScanLineCount.foundEndOfJpegData() && this.numberBytesAdded < 4306) {
            if (this.firstCameraByte) {
                this.cameraScanLineCount.addNext8Bits(b);
                if (!this.cameraScanLineCount.foundEndOfJpegData()) {
                    this.cameraPayload = new PayloadCameraData(this.cameraScanLineCount.getScanLineCount());
                }
                if (Config.debugHerciFrames) {
                    Log.println("CAMERA Lines to Decode: " + this.cameraScanLineCount.getScanLineCount());
                }
                this.firstCameraByte = false;
            } else {
                this.cameraPayload.addNext8Bits(b);
                if (this.cameraPayload.foundEndOfJpegData()) {
                    this.cameraScanLineCount.setFoundEndOfJpegData();
                    if (Config.debugFrames && this.fox.hasCamera()) {
                        Log.println(this.cameraPayload.toString());
                    }
                }
            }
        } else if (this.fox.hasHerci() && this.herciLineCount.hasData() && this.cameraScanLineCount.getScanLineCount() == 0 && this.numberBytesAdded < 4600 && this.radFrame < 5) {
            if (this.firstHERCIByte) {
                this.herciLineCount.addNext8Bits(b);
                if (Config.debugHerciFrames) {
                    Log.println("HERCI HS Frames to Decode: " + this.herciLineCount.getLineCount());
                }
                if (this.herciLineCount.getLineCount() <= 5) {
                    if (this.herciLineCount.hasData()) {
                        this.herciPayload = new PayloadHERCIhighSpeed[this.herciLineCount.getLineCount()];
                        int i = 0;
                        while (i < this.herciLineCount.getLineCount()) {
                            this.herciPayload[i] = new PayloadHERCIhighSpeed(Config.satManager.getLayoutByName(this.header.id, "herciHSdata"));
                            ++i;
                        }
                    }
                } else {
                    this.herciLineCount.zeroLineCount();
                }
                this.firstHERCIByte = false;
            } else {
                this.herciPayload[this.radFrame].addNext8Bits(b);
                ++this.radiationBytesAdded;
                if (this.radiationBytesAdded == 868) {
                    this.radiationBytesAdded = 0;
                    if (Config.debugHerciFrames) {
                        Log.println(this.herciPayload[this.radFrame].toString());
                    }
                    ++this.radFrame;
                }
                if (this.radFrame == this.herciLineCount.getLineCount()) {
                    this.radFrame = 5;
                    if (Config.debugFrames && this.fox.hasHerci()) {
                        Log.println("HERCI HIGH SPEED PAYLOADS DECODED [" + this.herciLineCount.getLineCount() + "]");
                    }
                }
            }
        } else if (!this.fox.hasHerci() && this.numberBytesAdded < 4600 && this.radFrame < 76) {
            this.radExpPayload[this.radFrame].addNext8Bits(b);
            if (this.first20RadBytes) {
                this.radiationLookaheadBuffer[this.radiationBytesAdded] = b;
            }
            ++this.radiationBytesAdded;
            if (this.first20RadBytes && this.radiationBytesAdded == 20) {
                this.first20RadBytes = false;
                boolean foundZero = false;
                boolean foundMarker = false;
                int j = 0;
                while (j < this.radiationLookaheadBuffer.length) {
                    if (this.radiationLookaheadBuffer[j] == 0) {
                        foundZero = true;
                    }
                    if (this.radiationLookaheadBuffer[j] == 126) {
                        foundMarker = true;
                    }
                    ++j;
                }
                this.bufferedRadMode = foundZero ? false : !foundZero && foundMarker;
            }
            if (!this.bufferedRadMode && this.radiationBytesAdded == 20 || this.bufferedRadMode && this.radiationBytesAdded == 58) {
                this.radiationBytesAdded = 0;
                ++this.radFrame;
            }
        } else if (this.numberBytesAdded >= 5272) {
            Log.println("ERROR: attempt to add byte past end of frame");
        }
        this.bytes[this.numberBytesAdded] = b;
        ++this.numberBytesAdded;
    }

    public static int getMaxDataBytes() {
        return 4606;
    }

    public static int getMaxBytes() {
        return 5272;
    }

    public String toString() {
        String s = "AMSAT FOX-1 High Speed Telemetry Captured at: " + this.getStpDate() + "\n";
        s = String.valueOf(s) + this.header.toString() + "\n\n" + this.rtPayload.toString() + "\n\n" + this.maxPayload.toString() + "\n\n" + this.minPayload.toString() + "\n\n" + this.cameraPayload.toString();
        s = String.valueOf(s) + "\n\n" + this.radExpPayload.length + " RADIATION FRAMES:\n\n";
        if (this.radExpPayload != null) {
            int i = 0;
            while (i < this.radExpPayload.length) {
                if (this.radExpPayload[i].hasData()) {
                    s = String.valueOf(s) + "\nRadation Payload [" + i + "]\n" + this.radExpPayload[i].toString() + "\n";
                }
                ++i;
            }
        }
        if (this.fox.hasHerci()) {
            s = String.valueOf(s) + "\n\n" + this.herciPayload.toString();
        }
        return s;
    }
}

