/*
 * Decompiled with CFR 0.152.
 */
package telemetry.frames;

import common.Config;
import common.Log;
import decoder.Decoder;
import java.io.BufferedReader;
import java.io.IOException;
import telemetry.FramePart;
import telemetry.frames.Frame;
import telemetry.frames.SlowSpeedHeader;
import telemetry.frames.SlowSpeedTrailer;
import telemetry.legacyPayloads.PayloadRadExpData;
import telemetry.payloads.PayloadMaxValues;
import telemetry.payloads.PayloadMinValues;
import telemetry.payloads.PayloadRtValues;

@Deprecated
public class SlowSpeedFrame
extends Frame {
    public static final int MAX_HEADER_SIZE = 6;
    public int EXTENDED_HEADER_BYTES = 0;
    public static final int MAX_PAYLOAD_SIZE = 58;
    public static final int MAX_TRAILER_SIZE = 32;
    FramePart payload = null;
    FramePart fecTrailer = null;
    int debugCount = 0;

    public SlowSpeedFrame() {
        this.header = new SlowSpeedHeader();
        this.fecTrailer = new SlowSpeedTrailer();
        this.bytes = new byte[96];
    }

    public SlowSpeedFrame(BufferedReader input) throws IOException {
        super(input);
        this.header = new SlowSpeedHeader();
        this.bytes = new byte[96];
        this.load(input);
    }

    public int getType() {
        return this.header.getType();
    }

    @Override
    public SlowSpeedHeader getHeader() {
        return (SlowSpeedHeader)this.header;
    }

    public FramePart getPayload() {
        return this.payload;
    }

    @Override
    public void addNext8Bits(byte b) {
        if (this.corrupt) {
            return;
        }
        if (this.numberBytesAdded < 6 + this.EXTENDED_HEADER_BYTES) {
            this.header.addNext8Bits(b);
        } else if (this.numberBytesAdded < 64) {
            this.payload.addNext8Bits(b);
        } else if (this.numberBytesAdded >= 96) {
            Log.println("ERROR: attempt to add byte past end of frame");
        }
        this.bytes[this.numberBytesAdded] = b;
        ++this.numberBytesAdded;
        if (this.numberBytesAdded == 6 + this.EXTENDED_HEADER_BYTES) {
            this.header.copyBitsToFields();
            int type = this.header.type;
            if (this.header.id == 8 && this.EXTENDED_HEADER_BYTES == 0) {
                this.EXTENDED_HEADER_BYTES = 1;
            } else {
                if (Config.debugFrames) {
                    Log.println(this.header.toString());
                }
                this.fox = Config.satManager.getSpacecraft(this.header.id);
                if (this.fox != null) {
                    if (type == 1) {
                        this.payload = new PayloadRtValues(Config.satManager.getLayoutByName(this.header.id, "rttelemetry"));
                    }
                    if (type == 2) {
                        this.payload = new PayloadMaxValues(Config.satManager.getLayoutByName(this.header.id, "maxtelemetry"));
                    }
                    if (type == 3) {
                        this.payload = new PayloadMinValues(Config.satManager.getLayoutByName(this.header.id, "mintelemetry"));
                    }
                    if (type == 4) {
                        this.payload = new PayloadRadExpData(Config.satManager.getLayoutByName(this.header.id, "radtelemetry"));
                    }
                    if (type == 0 || type > 4) {
                        Log.println("INVALID payload type:" + type + ", rejecting as corrupt");
                        this.corrupt = true;
                    }
                } else {
                    Log.println("FOX ID: " + this.header.id + " is not configured in the spacecraft directory.  Decode not possible.");
                    this.corrupt = true;
                }
            }
        }
        if (Config.debugBytes) {
            String debug = Decoder.plainhex(b);
            ++this.debugCount;
            Log.print("0x" + debug + ",");
            if (this.debugCount % 20 == 0) {
                Log.println("");
            }
        }
        if (this.numberBytesAdded == 64) {
            this.payload.copyBitsToFields();
        }
    }

    public static int getMaxBytes() {
        return 96;
    }

    public String toString() {
        String s = "AMSAT FOX-1 Telemetry Captured at: " + this.getStpDate() + "\n";
        return String.valueOf(s) + this.header.toString() + "\n\n" + this.payload.toString() + "\n";
    }
}

