/*
 * Decompiled with CFR 0.152.
 */
package telemetry.mesat;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;
import telemetry.payloads.CanPacket;

public class MesatImage
implements Comparable<MesatImage> {
    public static final String IMAGES_DIR = "images";
    public static final int NO_INDEX = -1;
    static final int BLOCK_MASK = 15;
    static final int CHANNEL_OFFSET = 4;
    static final int CHANNEL_MASK = 7;
    static final int INDEX_OFFSET = 7;
    static final int INDEX_MASK = 31;
    static final int XBYTE = 2;
    static final int YBYTE = 3;
    public static final int BLOCKS = 11;
    public static final int BLOCKS_FULL_LIMIT = 5956;
    public static final int CHANNELS = 5;
    static final int LEN = 8;
    static final int MAX_PKTS_IN_BLOCK = 24;
    static final int SIZE = 256;
    public int id;
    public int epoch;
    public long fromUptime;
    public String captureDate;
    BufferedImage image;
    int width = 256;
    int height = 256;
    public byte[] bytes;
    byte[] blockMap;
    String filename;
    Spacecraft sat;
    public int image_index = -1;
    public int image_channel = -1;
    String[] image_channels = new String[]{"c0", "c1", "c2", "c3", "c4"};
    public static String[] image_channels_desc = new String[]{"C0 - Red Cam1 (IR Filter) - 550-680nm", "C1 - Blue Cam2 (Yellow lens) - 480-600nm", "C2 - Blue Cam3 (Violet Lens) - 400-500nm", "C3 - Red Cam4 (Red Lens) - 600-1100nm", "C4 - Blue Cam4 (Red Lens) - 750-1100nm"};

    public MesatImage(int id, int epoch, long uptime, String date) {
        this.id = id;
        this.sat = Config.satManager.getSpacecraft(id);
        this.epoch = epoch;
        this.fromUptime = uptime;
        this.captureDate = date;
        this.bytes = new byte[this.width * this.height];
        this.blockMap = new byte[this.width * this.height];
    }

    public MesatImage(int id, CanPacket p, int epoch, long uptime, String date) {
        this.id = id;
        this.sat = Config.satManager.getSpacecraft(id);
        this.epoch = epoch;
        this.fromUptime = uptime;
        this.captureDate = date;
        this.bytes = new byte[this.width * this.height];
        this.blockMap = new byte[this.width * this.height];
    }

    public MesatImage(int id, int epoch, long fromUptime, int image_index, int image_channel, String date, String name) throws IOException {
        this.id = id;
        this.epoch = epoch;
        this.fromUptime = fromUptime;
        this.image_index = image_index;
        this.image_channel = image_channel;
        this.captureDate = date;
        this.filename = name;
        this.sat = Config.satManager.getSpacecraft(id);
        this.bytes = new byte[this.width * this.height];
        this.blockMap = new byte[this.width * this.height];
        if (this.fileExists()) {
            this.loadImage();
        }
    }

    public static BufferedImage getCompositeImage(MesatImage red_img, MesatImage green_img, MesatImage blue_img) {
        BufferedImage image = new BufferedImage(256, 256, 1);
        int x = 0;
        while (x < 256) {
            int y = 0;
            while (y < 256) {
                int pos = y * 256 + x;
                int r = 0;
                int g = 0;
                int b = 0;
                if (red_img != null) {
                    r = red_img.bytes[pos] & 0xFF;
                }
                if (green_img != null) {
                    g = green_img.bytes[pos] & 0xFF;
                }
                if (blue_img != null) {
                    b = blue_img.bytes[pos] & 0xFF;
                }
                Color pix = new Color(r, g, b);
                image.setRGB(x, y, pix.getRGB());
                ++y;
            }
            ++x;
        }
        return image;
    }

    public BufferedImage getImage() {
        this.makeGrayScaleImage();
        return this.image;
    }

    public String getFileName() {
        String toFileName = IMAGES_DIR + File.separator + this.sat.series + this.sat.foxId + "_" + this.image_index + "_" + this.image_channels[this.image_channel] + ".dat";
        return toFileName;
    }

    public boolean fileExists() {
        File toFile;
        String toFileName = this.filename;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            toFileName = String.valueOf(Config.logFileDirectory) + File.separator + this.filename;
        }
        return (toFile = new File(toFileName)).exists();
    }

    public int[] getBlockByteNumbers() {
        int[] blockCounts = new int[11];
        int i = 0;
        while (i < this.blockMap.length) {
            if (this.blockMap[i] > 0 && this.blockMap[i] <= 11) {
                int n = this.blockMap[i] - 1;
                blockCounts[n] = blockCounts[n] + 1;
            }
            ++i;
        }
        return blockCounts;
    }

    public boolean addPacket(CanPacket canPacket) {
        int canid = canPacket.getID();
        int len = canPacket.getLength();
        int block = canid & 0xF;
        int channel = canid >> 4 & 7;
        int index = canid >> 7 & 0x1F;
        if (this.image_index == -1 || index == this.image_index && channel == this.image_channel) {
            if (this.image_index == -1) {
                this.image_index = index;
                this.image_channel = channel;
            }
            if (len == 8 && block < 11 && channel < 5) {
                int x = canPacket.fieldValue[2];
                int y = canPacket.fieldValue[3];
                this.filename = this.getFileName();
                if (Config.debugCameraFrames) {
                    Log.println("Adding packet to image: " + index + ":" + channel + " for block " + block + " at pixel " + x + "." + y + "   -> " + this.filename);
                }
                int i = 4;
                while (i < 10) {
                    int pos = x * this.width + y;
                    this.bytes[pos] = (byte)canPacket.fieldValue[i];
                    this.blockMap[pos] = (byte)(block + 1);
                    if (++y >= this.width) {
                        x = (x + 1) % this.height;
                        y = 0;
                    }
                    ++i;
                }
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    public void makeGrayScaleImage() {
        this.image = new BufferedImage(this.width, this.height, 10);
        byte[] array = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
        int i = 0;
        while (i < array.length) {
            array[i] = this.bytes[i];
            ++i;
        }
    }

    public BufferedImage getThumbnail(int thumbX) {
        this.makeGrayScaleImage();
        return this.image;
    }

    public void saveImage() throws IOException {
        String toBlockFileName = String.valueOf(this.filename) + ".blk";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            toBlockFileName = String.valueOf(Config.logFileDirectory) + File.separator + toBlockFileName;
        }
        FileOutputStream blockSaveFile = null;
        try {
            blockSaveFile = new FileOutputStream(toBlockFileName);
            blockSaveFile.write(this.blockMap);
        }
        finally {
            try {
                if (blockSaveFile != null) {
                    blockSaveFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        String toFileName = this.filename;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            toFileName = String.valueOf(Config.logFileDirectory) + File.separator + toFileName;
        }
        FileOutputStream saveFile = null;
        try {
            saveFile = new FileOutputStream(toFileName);
            saveFile.write(this.bytes);
        }
        finally {
            try {
                if (saveFile != null) {
                    saveFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.saveAsBmp();
    }

    public void saveAsBmp() throws IOException {
        String toFileName = String.valueOf(this.filename) + ".bmp";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            toFileName = String.valueOf(Config.logFileDirectory) + File.separator + toFileName;
        }
        this.makeGrayScaleImage();
        File outputfile = new File(toFileName);
        ImageIO.write((RenderedImage)this.image, "bmp", outputfile);
    }

    public boolean hasBlockMap() {
        File blockFile;
        String toBlockFileName = String.valueOf(this.filename) + ".blk";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            toBlockFileName = String.valueOf(Config.logFileDirectory) + File.separator + toBlockFileName;
        }
        return (blockFile = new File(toBlockFileName)).exists();
    }

    private void loadImage() throws IOException {
        String toBlockFileName = String.valueOf(this.filename) + ".blk";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            toBlockFileName = String.valueOf(Config.logFileDirectory) + File.separator + toBlockFileName;
        }
        RandomAccessFile blockFileOnDisk = null;
        File blockFile = new File(toBlockFileName);
        if (blockFile.exists()) {
            try {
                blockFileOnDisk = new RandomAccessFile(toBlockFileName, "r");
                if (blockFileOnDisk.length() != 65536L) {
                    throw new IOException("Invalid Block file length\n");
                }
                blockFileOnDisk.read(this.blockMap);
            }
            finally {
                try {
                    if (blockFileOnDisk != null) {
                        blockFileOnDisk.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        String toFileName = this.filename;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            toFileName = String.valueOf(Config.logFileDirectory) + File.separator + toFileName;
        }
        RandomAccessFile fileOnDisk = null;
        try {
            fileOnDisk = new RandomAccessFile(toFileName, "r");
            if (fileOnDisk.length() != 65536L) {
                throw new IOException("Invalid Image file length\n");
            }
            fileOnDisk.read(this.bytes);
        }
        finally {
            try {
                if (fileOnDisk != null) {
                    fileOnDisk.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        String s = String.valueOf(this.captureDate) + "," + this.id + "," + this.epoch + "," + this.fromUptime + "," + this.image_index + "," + this.image_channel + "," + this.filename;
        return s;
    }

    @Override
    public int compareTo(MesatImage p) {
        if (this.epoch == p.epoch && this.fromUptime == p.fromUptime) {
            return 0;
        }
        if (this.epoch < p.epoch) {
            return -1;
        }
        if (this.epoch > p.epoch) {
            return 1;
        }
        if (this.epoch == p.epoch && this.fromUptime < p.fromUptime) {
            return -1;
        }
        return 1;
    }
}

