/*
 * Decompiled with CFR 0.152.
 */
package telemetry.uw;

import common.Config;
import common.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import telemetry.LayoutLoadException;

public class CanFrames {
    public int NUMBER_OF_FIELDS = 0;
    public static int ERROR_POSITION = -1;
    public String fileName;
    public String name;
    public static final String NONE = "NONE";
    public String[] frame = null;
    public int[] priority = null;
    public int[] canId = null;
    public int[] dataLength = null;
    public String[] groundClass = null;
    public String[] senders = null;
    public String[] description = null;
    public String[] notes = null;

    public CanFrames(String f) throws FileNotFoundException, LayoutLoadException {
        this.load(f);
    }

    public String getNameByCanId(int id) {
        int i = 0;
        while (i < this.canId.length) {
            if (id == this.canId[i]) {
                return this.frame[i];
            }
            ++i;
        }
        return null;
    }

    public String getGroundByCanId(int id) {
        int i = 0;
        while (i < this.canId.length) {
            if (id == this.canId[i]) {
                return this.groundClass[i];
            }
            ++i;
        }
        return null;
    }

    public String getSenderByCanId(int id) {
        int i = 0;
        while (i < this.canId.length) {
            if (id == this.canId[i]) {
                return this.senders[i];
            }
            ++i;
        }
        return null;
    }

    protected void load(String f) throws FileNotFoundException, LayoutLoadException {
        String[] values;
        this.fileName = String.valueOf(Config.spacecraftDir) + File.separator + f;
        Log.println("Loading Can Frames: " + this.fileName);
        ArrayList<String[]> lines = new ArrayList<String[]>();
        BufferedReader dis = new BufferedReader(new FileReader(this.fileName));
        int field = 0;
        try {
            String line = dis.readLine();
            while ((line = dis.readLine()) != null) {
                values = line.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                if (values.length != 12 || values[11].contains("descope")) continue;
                ++this.NUMBER_OF_FIELDS;
                lines.add(values);
            }
            this.frame = new String[this.NUMBER_OF_FIELDS];
            this.priority = new int[this.NUMBER_OF_FIELDS];
            this.canId = new int[this.NUMBER_OF_FIELDS];
            this.dataLength = new int[this.NUMBER_OF_FIELDS];
            this.senders = new String[this.NUMBER_OF_FIELDS];
            this.groundClass = new String[this.NUMBER_OF_FIELDS];
            this.description = new String[this.NUMBER_OF_FIELDS];
            this.notes = new String[this.NUMBER_OF_FIELDS];
            dis.close();
        }
        catch (IOException e) {
            Log.errorDialog("File Read Error", "In Can Frames " + e.getMessage());
            e.printStackTrace(Log.getWriter());
        }
        try {
            field = 0;
            field = 0;
            while (field < this.NUMBER_OF_FIELDS) {
                values = (String[])lines.get(field);
                if (values != null) {
                    this.frame[field] = values[0];
                    this.priority[field] = Integer.valueOf(values[1]);
                    String id = values[2];
                    String id_hex = values[3];
                    String msp_cat = values[4];
                    this.groundClass[field] = values[5];
                    this.canId[field] = Integer.valueOf(values[6]);
                    String canid_hex = values[7];
                    this.dataLength[field] = Integer.valueOf(values[8]);
                    this.senders[field] = values[9];
                    try {
                        this.description[field] = values[10];
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    try {
                        this.notes[field] = values[11];
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
                ++field;
            }
        }
        catch (NumberFormatException n) {
            Log.errorDialog("NUMBER FORMAT EXCEPTION", "In Can Frames at field: " + this.frame[field] + " - " + n.getMessage());
            n.printStackTrace(Log.getWriter());
        }
        catch (IndexOutOfBoundsException n) {
            Log.errorDialog("INDEX EXCEPTION", "Error loading Can Frames at Index: " + n.getMessage());
            n.printStackTrace(Log.getWriter());
        }
        catch (NoSuchElementException n) {
            Log.errorDialog("Missing Field in Can Frames File", "Halted loading at field: \"+ field + " + this.fileName);
            n.printStackTrace(Log.getWriter());
        }
        catch (NullPointerException nf) {
            nf.printStackTrace(Log.getWriter());
            Log.errorDialog("ERROR", "Missing data value at field: " + field + " - " + nf.getMessage() + "\nwhen processing Can Frames file: " + this.fileName);
            nf.printStackTrace(Log.getWriter());
        }
    }
}

