/*
 * Decompiled with CFR 0.152.
 */
package telemetry.uw;

import common.Config;
import common.Log;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import telemetry.BitArrayLayout;
import telemetry.FoxPayloadStore;
import telemetry.FramePart;
import telemetry.uw.PayloadUwExperiment;
import telemetry.uw.UwCanPacket;

@Deprecated
public class PayloadWODUwExperiment
extends FramePart {
    public ArrayList<UwCanPacket> canPackets = new ArrayList();
    protected UwCanPacket canPacket;
    public ArrayList<UwCanPacket> splitPackets;
    protected UwCanPacket rawCanPacket;
    public static final String WOD_RESETS = "WODTimestampReset";
    public static final String WOD_UPTIME = "WODTimestampUptime";
    public static final String CRC_ERROR = "crcError";
    int debugCount = 0;

    public PayloadWODUwExperiment(BitArrayLayout lay, int id, long uptime, int resets) {
        super(15, lay);
        this.splitPackets = new ArrayList();
        this.captureHeaderInfo(id, uptime, resets);
    }

    public PayloadWODUwExperiment(int id, int resets, long uptime, String date, StringTokenizer st, BitArrayLayout lay) {
        super(id, resets, uptime, 15, date, st, lay);
    }

    @Override
    protected void init() {
    }

    protected void addToCanPackets(byte b) {
        if (this.rawCanPacket == null) {
            this.rawCanPacket = new UwCanPacket(Config.satManager.getLayoutByName(this.id, "wodcanpacket"));
            this.rawCanPacket.setType(16);
            this.rawCanPacket.captureHeaderInfo(this.id, this.uptime, this.resets);
        }
        if (this.rawCanPacket.hasEndOfCanPacketsId()) {
            return;
        }
        this.rawCanPacket.addNext8Bits(b);
        if (this.rawCanPacket.isValid()) {
            this.canPackets.add(this.rawCanPacket);
            if (Config.splitCanPackets) {
                byte[] data = this.rawCanPacket.getBytes();
                BitArrayLayout canLayout = Config.satManager.getLayoutByCanId(this.id, this.rawCanPacket.getID());
                if (canLayout == null) {
                    Log.errorDialog("ERROR", "Missing CAN WOD Layout for CAN ID: " + this.rawCanPacket.getID());
                }
                UwCanPacket newPacket = new UwCanPacket(this.id, this.resets, this.uptime, this.reportDate, data, canLayout);
                newPacket.setType(17);
                this.splitPackets.add(newPacket);
            }
            this.rawCanPacket = new UwCanPacket(Config.satManager.getLayoutByName(this.id, "wodcanpacket"));
            this.rawCanPacket.setType(16);
            this.rawCanPacket.captureHeaderInfo(this.id, this.uptime, this.resets);
        }
    }

    @Override
    public void addNext8Bits(byte b) {
        if (this.numberBytesAdded < 1) {
            super.addNext8Bits(b);
        } else if (this.numberBytesAdded < 72) {
            this.addToCanPackets(b);
            super.addNext8Bits(b);
        } else {
            super.addNext8Bits(b);
        }
    }

    @Override
    public boolean isValid() {
        return false;
    }

    public boolean savePayloads(FoxPayloadStore payloadStore, int serial, boolean storeMode) {
        int p_type;
        this.type = this.type * 100 + serial;
        this.copyBitsToFields();
        if (!payloadStore.add(this.getFoxId(), this.getUptime(), this.getResets(), this)) {
            return false;
        }
        int j = 0;
        for (UwCanPacket p : this.canPackets) {
            p_type = p.getType();
            p_type = p_type * 100 + serial + j++;
            p.setType(p_type);
            if (storeMode) {
                p.newMode = this.newMode;
            }
            if (payloadStore.add(this.getFoxId(), this.getUptime(), this.getResets(), p)) continue;
            return false;
        }
        if (this.splitPackets != null && this.splitPackets.size() > 0) {
            j = 0;
            for (UwCanPacket p : this.splitPackets) {
                p_type = p.getType();
                p_type = p_type * 100 + serial + j++;
                p.setType(p_type);
                if (storeMode) {
                    p.newMode = this.newMode;
                }
                if (payloadStore.add(this.getFoxId(), this.getUptime(), this.getResets(), p)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void copyBitsToFields() {
        super.copyBitsToFields();
        this.resets = this.getRawValue(WOD_RESETS);
        this.uptime = this.getRawValue(WOD_UPTIME);
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = "UW WOD EXPERIMENT PAYLOAD - " + this.canPackets.size() + " CAN PACKETS\n";
        s = String.valueOf(s) + "RESET: " + this.getRawValue(WOD_RESETS);
        s = String.valueOf(s) + "  UPTIME: " + this.getRawValue(WOD_UPTIME);
        s = String.valueOf(s) + "  TYPE: " + this.type;
        s = String.valueOf(s) + "  OVERFLOW FLAG: " + this.getRawValue(CRC_ERROR) + "\n";
        return s;
    }

    public byte[][] getCANPacketBytes(Date createDate) {
        return PayloadUwExperiment.getCANPacketBytes(this.canPackets, createDate);
    }
}

