/*
 * Decompiled with CFR 0.152.
 */
package uk.me.g4dpz.satellite;

public class GroundStationPosition {
    private double latitude;
    private double longitude;
    private double heightAMSL;
    private double theta;
    private final int[] horizonElevations = new int[36];
    private String name;

    public GroundStationPosition(double latitude, double longitude, double heightAMSL) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.heightAMSL = heightAMSL;
        this.name = "";
    }

    public GroundStationPosition(double latitude, double longitude, double heightAMSL, String name) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.heightAMSL = heightAMSL;
        this.name = name;
    }

    public GroundStationPosition() {
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getHeightAMSL() {
        return this.heightAMSL;
    }

    public final double getTheta() {
        return this.theta;
    }

    public final void setTheta(double theta) {
        this.theta = theta;
    }

    public final int[] getHorizonElevations() {
        int[] horizonElevationsCopy = new int[this.horizonElevations.length];
        System.arraycopy(horizonElevationsCopy, 0, this.horizonElevations, 0, this.horizonElevations.length);
        return horizonElevationsCopy;
    }

    public final void setHorizonElevations(int[] theHorizonElevations) throws IllegalArgumentException {
        if (36 != theHorizonElevations.length) {
            throw new IllegalArgumentException("Expected 36 Horizon Elevations, got: " + theHorizonElevations.length);
        }
        System.arraycopy(this.horizonElevations, 0, theHorizonElevations, 0, theHorizonElevations.length);
    }

    public String getName() {
        return this.name;
    }
}

