/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.headless;

import com.install4j.api.Util;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.DummyWizardContext;
import com.install4j.runtime.installer.WizardContextInt;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.CommandSink;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.FinishCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.launcher.util.LauncherUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collections;
import javax.swing.JEditorPane;
import sun.font.FontUtilities;

public abstract class AbstractHeadlessScreenExecutor
implements ScreenExecutor {
    public static final String EMPTY_FONT_FILE_NAME = "i4jempty.ttf";
    private static volatile boolean exitCalled = false;
    private CommandSink commandSink;
    private ContextImpl contextImpl;
    private WizardContextInt dummyWizardContext = this.createWizardContext();
    private boolean fileInstallerProgressInterfaceSet;

    public static boolean isExitCalled() {
        return exitCalled;
    }

    public AbstractHeadlessScreenExecutor() {
        this.contextImpl = this.createContext();
    }

    protected abstract ContextImpl createContext();

    protected abstract ControllerCommand handleScreen(ScreenBeanConfig var1) throws UserCanceledException;

    protected DummyWizardContext createWizardContext() {
        return new DummyWizardContext();
    }

    protected void init(boolean headless) {
        if (headless) {
            InstallerUtil.setHeadlessProperty();
        }
        Policy.setPolicy(new AllowAllPolicy());
        VersionSpecificHelper.setSecurityManager(new CheckExitSecurityManager());
        if (!InstallerUtil.isInProcess()) {
            Runtime.getRuntime().addShutdownHook(new Thread("shutdown hook"){

                @Override
                public void run() {
                    if (!exitCalled && AbstractHeadlessScreenExecutor.this.commandSink != null) {
                        AbstractHeadlessScreenExecutor.this.cancelImmediately();
                    }
                }
            });
        }
        if (!HelperCommunication.getInstance().isElevatedHelper()) {
            GUIHelper.invokeOnEDT(() -> {
                if (!Util.isMacOS() && !Util.isWindows()) {
                    AbstractHeadlessScreenExecutor.initFontManager();
                }
                new FormPanel(Collections.emptyList(), this.getContext(), null, null, null);
                AbstractHeadlessScreenExecutor.createEditorPane();
            });
        }
    }

    @Override
    public void execute(ScreenBeanConfig screenConfig, CommandSink commandSink, boolean previousPossible, ControllerCommand lastCommand) {
        this.setCommandSink(commandSink);
        if (!this.fileInstallerProgressInterfaceSet) {
            FileInstaller.getInstance().setDefaultProgressInterface(this.getProgressInterface());
            this.fileInstallerProgressInterfaceSet = true;
        }
        try {
            ControllerCommand specialCommand = this.handleScreen(screenConfig);
            if (specialCommand != null) {
                commandSink.returnToController(specialCommand);
            } else {
                commandSink.returnToController(new GoForwardCommand(1, true, true, null));
            }
        }
        catch (UserCanceledException e) {
            commandSink.returnToController(ControllerCommand.CANCEL);
        }
        catch (Throwable e) {
            this.getContext().handleCriticalException(e);
        }
    }

    @Override
    public void setCommandSink(CommandSink commandSink) {
        this.commandSink = commandSink;
    }

    @Override
    public void cancelImmediately() {
        ConsoleImpl.getInstance().cancel();
        ContextImpl.setCancelling();
        this.commandSink.returnToController(ControllerCommand.CANCEL);
        this.commandSink.waitForFinish();
    }

    @Override
    public CommandSink getCommandSink() {
        return this.commandSink;
    }

    @Override
    public ProgressInterface getDefaultProgressInterface() {
        return this.getProgressInterface();
    }

    @Override
    public WizardContextInt getWizardContext() {
        return this.dummyWizardContext;
    }

    @Override
    public void setRollback() {
        this.getProgressInterface().setStatusMessage(Messages.getString(".StatusRollback"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ControllerCommand runValidationScript(ScreenBeanConfig screenConfig, Screen screen, Object ... scriptParameters) {
        ControllerCommand storedCommand;
        boolean validated;
        this.getCommandSink().startStoreCommand();
        try {
            validated = this.getContext().runBooleanScript(screenConfig.getValidationClassName(), screen, scriptParameters);
        }
        finally {
            storedCommand = this.getCommandSink().finishStoreCommand();
        }
        if (storedCommand != null) {
            return storedCommand;
        }
        if (!validated) {
            return ControllerCommand.CANCEL;
        }
        if (screenConfig.isFinishScreen()) {
            return new FinishCommand(null);
        }
        return null;
    }

    @Override
    public void closeWindows() {
    }

    @Override
    public ActionCallback getActionCallback() {
        return null;
    }

    @Override
    public void register(Screen screen, ScreenBeanConfig config) {
        this.getContext().applyToScreen(screen, config);
    }

    @Override
    public ContextImpl getContext() {
        return this.contextImpl;
    }

    @Override
    public void initializeLazilyLoadedScreens() {
    }

    private static void initFontManager() {
        AbstractHeadlessScreenExecutor.writeFontConfig();
        AbstractHeadlessScreenExecutor.createEditorPane();
    }

    private static void writeFontConfig() {
        File fontFile = InstallerUtil.getInstallerFile(EMPTY_FONT_FILE_NAME);
        if (fontFile.isFile()) {
            try {
                File tempFile = File.createTempFile("i4jfont", ".properties");
                tempFile.deleteOnExit();
                try (FileOutputStream out = new FileOutputStream(tempFile);){
                    String fontConfigContent = "Version=1\nsequence.allfonts=i4jempty\nsequence.fallback=i4jempty\nallfonts.i4jempty=i4jempty\nfilename.i4jempty=" + fontFile + "\n";
                    out.write(fontConfigContent.getBytes());
                }
                System.setProperty("sun.awt.fontconfig", tempFile.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!LauncherUtil.isJava9Plus()) {
                try {
                    Field instanceField = FontUtilities.class.getDeclaredField("isOpenJDK");
                    instanceField.set(null, Boolean.FALSE);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static void createEditorPane() {
        new JEditorPane("text/plain", "init text");
    }

    private static class CheckExitSecurityManager
    extends SecurityManager {
        private CheckExitSecurityManager() {
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        @Override
        public void checkCreateClassLoader() {
        }

        @Override
        public void checkAccess(Thread t) {
        }

        @Override
        public void checkAccess(ThreadGroup g) {
        }

        @Override
        public void checkExit(int status) {
            exitCalled = true;
        }

        @Override
        public void checkExec(String cmd) {
        }

        @Override
        public void checkLink(String lib) {
        }

        @Override
        public void checkRead(FileDescriptor fd) {
        }

        @Override
        public void checkRead(String file) {
        }

        @Override
        public void checkRead(String file, Object context) {
        }

        @Override
        public void checkWrite(FileDescriptor fd) {
        }

        @Override
        public void checkWrite(String file) {
        }

        @Override
        public void checkDelete(String file) {
        }

        @Override
        public void checkConnect(String host, int port) {
        }

        @Override
        public void checkConnect(String host, int port, Object context) {
        }

        @Override
        public void checkListen(int port) {
        }

        @Override
        public void checkAccept(String host, int port) {
        }

        @Override
        public void checkMulticast(InetAddress inetAddress) {
        }

        @Override
        @Deprecated
        public void checkMulticast(InetAddress inetAddress, byte ttl) {
        }

        @Override
        public void checkPropertiesAccess() {
        }

        @Override
        public void checkPropertyAccess(String key) {
        }

        @Deprecated
        public boolean checkTopLevelWindow(Object window) {
            return true;
        }

        @Override
        public void checkPrintJobAccess() {
        }

        @Deprecated
        public void checkSystemClipboardAccess() {
        }

        @Deprecated
        public void checkAwtEventQueueAccess() {
        }

        @Override
        public void checkPackageAccess(String pkg) {
        }

        @Override
        public void checkPackageDefinition(String pkg) {
        }

        @Override
        public void checkSetFactory() {
        }

        @Deprecated
        public void checkMemberAccess(Class clazz, int which) {
        }

        @Override
        public void checkSecurityAccess(String target) {
        }
    }

    private static class AllowAllPolicy
    extends Policy {
        private AllowAllPolicy() {
        }

        @Override
        public PermissionCollection getPermissions(CodeSource codesource) {
            Permissions permission = new Permissions();
            permission.add(new AllPermission());
            return permission;
        }

        @Override
        public PermissionCollection getPermissions(ProtectionDomain domain) {
            Permissions permission = new Permissions();
            permission.add(new AllPermission());
            return permission;
        }
    }
}

