/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import decoder.Listener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Broadcaster<T>
implements Listener<T> {
    private List<Listener<T>> mListeners = new CopyOnWriteArrayList<Listener<T>>();

    @Override
    public void receive(T t) {
        this.broadcast(t);
    }

    public void dispose() {
        this.mListeners.clear();
    }

    public boolean hasListeners() {
        return !this.mListeners.isEmpty();
    }

    public int getListenerCount() {
        return this.mListeners.size();
    }

    public List<Listener<T>> getListeners() {
        return this.mListeners;
    }

    public void addListener(Listener<T> listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(Listener<T> listener) {
        this.mListeners.remove(listener);
    }

    public void clear() {
        this.mListeners.clear();
    }

    public void broadcast(T t) {
        for (Listener<T> listener : this.mListeners) {
            listener.receive(t);
        }
    }
}

