/*
 * Decompiled with CFR 0.152.
 */
package decoder;

public abstract class DataMeasure
implements Runnable {
    private long lastAverageTime = 0L;
    protected long AVERAGE_PERIOD = 500L;
    double[] sum;
    double[] sumOfSquares;
    double[] avg;
    double[] sd;
    int[] numOf;
    boolean running = true;
    protected int MEASURES = 0;

    protected void init() {
        this.sum = new double[this.MEASURES];
        this.sumOfSquares = new double[this.MEASURES];
        this.avg = new double[this.MEASURES];
        this.sd = new double[this.MEASURES];
        this.numOf = new int[this.MEASURES];
    }

    public void stopProcessing() {
        this.running = false;
    }

    protected boolean readyToAverage() {
        long now = System.nanoTime() / 1000000L;
        long averageTime = now - this.lastAverageTime;
        if (averageTime > this.AVERAGE_PERIOD) {
            this.lastAverageTime = now;
            return true;
        }
        return false;
    }

    protected void runAverage() {
        int i = 0;
        while (i < this.MEASURES) {
            double a = this.sum[i] / (double)this.numOf[i];
            if (!Double.isNaN(a) && Double.isFinite(a)) {
                this.avg[i] = a;
                this.sd[i] = Math.sqrt((this.sumOfSquares[i] - this.sum[i] * this.sum[i] / (double)this.numOf[i]) / ((double)this.numOf[i] - 1.0));
            }
            if (!Double.isNaN(this.avg[i]) && Double.isFinite(this.avg[i])) {
                this.sum[i] = this.avg[i];
                this.numOf[i] = 1;
                this.sumOfSquares[i] = this.avg[i] * this.avg[i];
            }
            ++i;
        }
    }

    public double getAvg(int key) {
        return this.avg[key];
    }

    public double getStandardDeviation(int key) {
        return this.sd[key];
    }

    protected void setValue(int key, double value) {
        int n = key;
        this.numOf[n] = this.numOf[n] + 1;
        int n2 = key;
        this.sum[n2] = this.sum[n2] + value;
        int n3 = key;
        this.sumOfSquares[n3] = this.sumOfSquares[n3] + value * value;
    }

    public void reset() {
        this.readyToAverage();
        int i = 0;
        while (i < this.MEASURES) {
            this.sum[i] = 0.0;
            this.sumOfSquares[i] = 0.0;
            this.numOf[i] = 0;
            ++i;
        }
    }
}

