/*
 * Decompiled with CFR 0.152.
 */
package decoder.FoxBPSK;

import common.Config;
import common.Log;
import decoder.Decoder;
import decoder.HighSpeedBitStream;
import java.util.Date;
import telemetry.Format.FormatFrame;
import telemetry.Format.TelemFormat;
import telemetry.frames.Frame;
import telemetry.frames.FrameProcessException;
import telemetry.frames.HighSpeedFrame;
import telemetry.frames.SlowSpeedFrame;

public class FormatBitStream
extends HighSpeedBitStream {
    TelemFormat telemFormat;

    public FormatBitStream(Decoder dec, TelemFormat telemFormat, boolean use31bitSyncWord) {
        super(dec, telemFormat.getSyncWordDistance(), telemFormat.getInt("word_length"), telemFormat.getInt("sync_word_length"), telemFormat.getInt("bps"));
        this.telemFormat = telemFormat;
        SYNC_WORD_BIT_TOLERANCE = 10;
        this.maxBytes = telemFormat.getFrameLength();
        this.dataLength = telemFormat.getInt("data_length");
        this.numberOfRsCodeWords = telemFormat.getInt("rs_words");
        this.rsPadding = telemFormat.getPaddingArray();
        this.findFramesWithPRN = use31bitSyncWord;
    }

    @Override
    public Frame decodeFrame(int start, int end, int missedBits, int repairPosition, Date timeOfStartSync) {
        this.totalRsErrors = 0;
        this.totalRsErasures = 0;
        byte[] rawFrame = this.decodeBytes(start, end, missedBits, repairPosition);
        if (rawFrame == null) {
            return null;
        }
        if (Config.debugFrames) {
            Log.println("Decoding frame with Format: " + this.telemFormat);
        }
        Frame formatFrame = this.telemFormat.name.equalsIgnoreCase("FSK 200bps (Fox1)") ? new SlowSpeedFrame() : (this.telemFormat.name.equalsIgnoreCase("FSK 9600bps (Fox1)") ? new HighSpeedFrame() : new FormatFrame(this.telemFormat));
        try {
            formatFrame.addRawFrame(rawFrame);
            formatFrame.rsErrors = this.totalRsErrors;
            formatFrame.rsErasures = this.totalRsErasures;
            formatFrame.setStpDate(timeOfStartSync);
        }
        catch (FrameProcessException e) {
            return null;
        }
        return formatFrame;
    }
}

