/*
 * Decompiled with CFR 0.152.
 */
package decoder.FoxBPSK;

import common.Config;
import common.Log;
import decoder.FoxBPSK.FoxBPSKDecoder;
import decoder.SourceAudio;
import decoder.SourceIQ;
import filter.AGCFilter;
import filter.Complex;
import filter.ComplexOscillator;
import filter.DcRemoval;
import filter.IirFilter;
import filter.RaisedCosineFilter;
import filter.RootRaisedCosineFilter;
import telemetry.Format.TelemFormat;

public class FoxBPSKCostasDecoder
extends FoxBPSKDecoder {
    public static final int BITS_PER_SECOND_1200 = 1200;
    public static final int WORD_LENGTH = 10;
    private int samplePoint = 20;
    public static final int AUDIO_MODE = 0;
    public static final int PSK_MODE = 1;
    public int mode = 0;
    DcRemoval audioDcFilter;
    ComplexOscillator nco = new ComplexOscillator(this.currentSampleRate, 1200);
    RaisedCosineFilter dataFilter;
    IirFilter iFilter;
    IirFilter qFilter;
    IirFilter loopFilter;
    double[] pskAudioData;
    double[] pskQAudioData;
    double[] phasorData;
    double gain = 1.0;
    double alpha = 0.1;
    double beta = 64.0 * this.alpha * this.alpha / 4.0;
    double error;
    boolean lastPhase = false;
    double freq = 700.0;
    public double LOW_SWEEP_LIMIT = 1000.0;
    public double HIGH_SWEEP_LIMIT = 2000.0;
    double iMix;
    double qMix;
    double fi = 0.0;
    double fq = 0.0;
    double ri;
    double rq;
    double lockLevel;
    double avgLockLevel;
    public static final double LOCK_LEVEL_THRESHOLD = 3000.0;
    public static final double FREQ_SWEEP_INCREMENT = 0.04;
    int bitPosition = 0;
    int offset = 0;
    double YnMinus2Sample = 0.0;
    double YnSample = 0.0;
    double YnMinus1Sample;
    boolean delayClock = false;
    double psk;
    Complex c = new Complex(0.0, 0.0);
    double iFil;

    public FoxBPSKCostasDecoder(SourceAudio as, int chan, int mode, TelemFormat telemFormat) {
        super("1200bps BPSK", as, chan, telemFormat);
        this.mode = mode;
        this.init();
    }

    @Override
    protected void init() {
        if (!Config.iq && Config.use12kHzIfForBPSK) {
            this.LOW_SWEEP_LIMIT = 11000.0;
            this.HIGH_SWEEP_LIMIT = 13000.0;
        } else {
            this.LOW_SWEEP_LIMIT = 1000.0;
            this.HIGH_SWEEP_LIMIT = 1700.0;
        }
        Log.println("Initializing 1200bps Costas Loop BPSK decoder: ");
        this.BITS_PER_SECOND = 1200;
        this.SAMPLE_WINDOW_LENGTH = 40;
        this.bucketSize = this.currentSampleRate / this.BITS_PER_SECOND;
        this.samplePoint = this.bucketSize / 2;
        this.BUFFER_SIZE = this.SAMPLE_WINDOW_LENGTH * this.bucketSize;
        this.SAMPLE_WIDTH = 1;
        if (this.SAMPLE_WIDTH < 1) {
            this.SAMPLE_WIDTH = 1;
        }
        this.CLOCK_TOLERANCE = this.bucketSize / 2;
        this.CLOCK_REOVERY_ZERO_THRESHOLD = 20;
        this.initWindowData();
        this.audioDcFilter = new DcRemoval(0.9999);
        if (this.mode == 1) {
            this.filter = new AGCFilter(this.audioSource.audioFormat, this.BUFFER_SIZE);
            this.filter.init(this.currentSampleRate, 0.0, 0);
        } else {
            this.filter = new RootRaisedCosineFilter(this.audioSource.audioFormat, this.BUFFER_SIZE);
            this.filter.init(this.currentSampleRate, 1200.0, 512);
        }
        this.dataFilter = new RaisedCosineFilter(this.audioSource.audioFormat, 1);
        this.dataFilter.init(this.currentSampleRate, 6000.0, 256);
        double[] a = new double[]{1.504626E-5, 6.018503E-5, 9.027754E-5, 6.018503E-5, 1.504626E-5};
        double[] b = new double[]{1.0, 3.725385, -5.226004, 3.270902, -0.7705239};
        this.iFilter = new IirFilter(a, b);
        this.qFilter = new IirFilter(a, b);
        double x = 0.3678;
        double[] a2 = new double[]{1.0 - x};
        double[] b2 = new double[]{1.0, x};
        this.loopFilter = new IirFilter(a2, b2);
        this.pskAudioData = new double[this.BUFFER_SIZE];
        this.pskQAudioData = new double[this.BUFFER_SIZE];
        this.phasorData = new double[this.BUFFER_SIZE * 2];
    }

    @Override
    protected void resetWindowData() {
        super.resetWindowData();
    }

    @Override
    public double[] getBasebandData() {
        return this.pskAudioData;
    }

    @Override
    public double[] getBasebandQData() {
        return this.pskQAudioData;
    }

    @Override
    public double[] getPhasorData() {
        if (this.mode == 1) {
            return this.phasorData;
        }
        return ((SourceIQ)this.audioSource).getPhasorData();
    }

    @Override
    protected void sampleBuckets() {
        double maxValue = 0.0;
        double minValue = 0.0;
        double DESIRED_RANGE = 2.0;
        int sumLockLevel = 0;
        int i = 0;
        while (i < this.SAMPLE_WINDOW_LENGTH) {
            int s = 0;
            while (s < this.bucketSize) {
                double value = (double)this.dataValues[i][s] / 32767.0;
                if (value > maxValue) {
                    maxValue = value;
                }
                if (value < minValue) {
                    minValue = value;
                }
                value *= this.gain;
                if (this.mode == 1) {
                    this.psk = this.costasLoop(value, value, i, s);
                    sumLockLevel = (int)((double)sumLockLevel + this.lockLevel);
                } else {
                    this.psk = value;
                }
                int eyeValue = (int)(-1.0 * this.psk * 32767.0);
                if (this.mode == 1) {
                    this.nco.changePhase(this.alpha * this.error);
                    this.freq += this.beta * this.error;
                    if (this.avgLockLevel < 3000.0) {
                        this.freq += 0.04;
                        if (this.freq > this.HIGH_SWEEP_LIMIT) {
                            this.freq = this.LOW_SWEEP_LIMIT;
                        }
                    }
                    if (this.freq > this.HIGH_SWEEP_LIMIT) {
                        this.freq = this.HIGH_SWEEP_LIMIT;
                    }
                    if (this.freq < this.LOW_SWEEP_LIMIT) {
                        this.freq = this.LOW_SWEEP_LIMIT;
                    }
                    this.nco.setFrequency(this.freq);
                }
                if (this.bitPosition == 0) {
                    this.YnMinus1Sample = this.psk;
                }
                if (this.bitPosition == this.samplePoint) {
                    if (this.delayClock) {
                        this.delayClock = false;
                    } else {
                        double errThreshold;
                        double clockError;
                        this.YnMinus2Sample = this.YnSample;
                        this.YnSample = this.psk;
                        boolean thisPhase = false;
                        boolean thisSample = false;
                        if (this.YnSample > 0.0) {
                            thisPhase = true;
                        }
                        thisSample = thisPhase == this.lastPhase;
                        this.lastPhase = thisPhase;
                        this.bitStream.addBit(thisSample);
                        this.middleSample[i] = thisSample;
                        if (Config.debugValues) {
                            this.psk *= 1.5;
                        }
                        if ((clockError = (this.YnSample - this.YnMinus2Sample) * this.YnMinus1Sample) < -1.0 * (errThreshold = 0.1)) {
                            this.delayClock = true;
                            --this.bitPosition;
                        } else if (clockError > errThreshold) {
                            ++this.bitPosition;
                        }
                        if (!thisPhase) {
                            this.eyeData.setLow((int)(this.YnSample * 32767.0));
                        } else {
                            this.eyeData.setHigh((int)(this.YnSample * 32767.0));
                        }
                    }
                }
                this.pskAudioData[i * this.bucketSize + s] = this.psk;
                this.pskQAudioData[i * this.bucketSize + s] = this.fq;
                this.eyeData.setData(i, s, eyeValue);
                ++this.bitPosition;
                if (this.bitPosition == this.bucketSize) {
                    this.bitPosition = 0;
                }
                ++s;
            }
            ++i;
        }
        this.offset = -this.bitPosition;
        if (this.mode == 1) {
            this.avgLockLevel = sumLockLevel / this.SAMPLE_WINDOW_LENGTH * this.bucketSize;
        }
        if (maxValue - minValue != 0.0) {
            this.gain = DESIRED_RANGE / (1.0 * (maxValue - minValue));
        }
        if (this.gain < 1.0) {
            this.gain = 1.0;
        }
        this.eyeData.clockOffset = this.offset;
    }

    public void incFreq() {
        this.freq += 1.0;
    }

    public void incMiliFreq() {
        this.freq += 0.01;
    }

    public void decFreq() {
        this.freq -= 1.0;
    }

    public void decMiliFreq() {
        this.freq -= 0.01;
    }

    public static double average(double avg, double new_sample, int N) {
        avg -= avg / (double)N;
        return avg += new_sample / (double)N;
    }

    public double getError() {
        return this.error;
    }

    public double getFrequency() {
        return this.nco.getFrequency();
    }

    public double getLockLevel() {
        return this.avgLockLevel;
    }

    private double costasLoop(double i, double q, int bucketNumber, int sample) {
        this.nco.nextSample(this.c);
        this.c.normalize();
        this.iFil = this.dataFilter.filterDouble(i);
        this.iMix = this.iFil * this.c.geti();
        this.qMix = this.iFil * -1.0 * this.c.getq();
        this.fi = this.iFilter.filterDouble(this.iMix);
        this.fq = this.qFilter.filterDouble(this.qMix);
        int p = this.bucketSize * bucketNumber + sample;
        this.phasorData[2 * p] = this.fi;
        this.phasorData[2 * p + 1] = this.fq;
        this.ri = SourceIQ.fullwaveRectify(this.fi);
        this.rq = SourceIQ.fullwaveRectify(this.fq);
        this.lockLevel = 10.0 * (this.ri - this.rq);
        this.error = this.fi * this.fq;
        this.error = this.loopFilter.filterDouble(this.error);
        return this.fi;
    }
}

